/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.model;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.IRequest;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.viewers.model.ChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.ElementCompareRequest;
import org.eclipse.debug.internal.ui.viewers.model.ElementMementoRequest;
import org.eclipse.debug.internal.ui.viewers.model.FilterTransform;
import org.eclipse.debug.internal.ui.viewers.model.IMementoManager;
import org.eclipse.debug.internal.ui.viewers.model.TreeModelContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.ViewerUpdateMonitor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementCompareRequest;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementMementoProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementMementoRequest;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelChangedListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDeltaVisitor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxyFactory;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdateListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.progress.WorkbenchJob;

abstract class ModelContentProvider
implements IContentProvider,
IModelChangedListener {
    private Viewer fViewer;
    private Map fModelProxies = new HashMap();
    private FilterTransform fTransform = new FilterTransform();
    private ListenerList fModelListeners = new ListenerList();
    private ListenerList fUpdateListeners = new ListenerList();
    private Map fRequestsInProgress = new HashMap();
    private Map fWaitingRequests = new HashMap();
    private Map fViewerStates = new LRUMap(20);
    private ModelDelta fPendingState = null;
    private Set fPendingStateSaves = new HashSet();
    private Object fQueuedRestore = null;
    static final int UPDATE_SEQUENCE_BEGINS = 0;
    static final int UPDATE_SEQUENCE_COMPLETE = 1;
    static final int UPDATE_BEGINS = 2;
    static final int UPDATE_COMPLETE = 3;
    protected static final TreePath EMPTY_TREE_PATH = new TreePath(new Object[0]);
    public static boolean DEBUG_CONTENT_PROVIDER = false;
    public static boolean DEBUG_UPDATE_SEQUENCE = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        DEBUG_CONTENT_PROVIDER = DebugUIPlugin.DEBUG && "true".equals(Platform.getDebugOption((String)"org.eclipse.debug.ui/debug/viewers/contentProvider"));
        DEBUG_UPDATE_SEQUENCE = DebugUIPlugin.DEBUG && "true".equals(Platform.getDebugOption((String)"org.eclipse.debug.ui/debug/viewers/updateSequence"));
    }

    ModelContentProvider() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void dispose() {
        Map map = this.fRequestsInProgress;
        synchronized (map) {
            Iterator iterator = this.fRequestsInProgress.values().iterator();
            while (iterator.hasNext()) {
                List requests = (List)iterator.next();
                Iterator reqIter = requests.iterator();
                while (reqIter.hasNext()) {
                    ((IRequest)reqIter.next()).cancel();
                }
            }
            this.fWaitingRequests.clear();
        }
        this.fModelListeners.clear();
        this.fUpdateListeners.clear();
        this.disposeAllModelProxies();
        this.fViewer = null;
    }

    public synchronized boolean isDisposed() {
        return this.fViewer == null;
    }

    public synchronized void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.fViewer = viewer;
        if (oldInput != null) {
            this.saveViewerState(oldInput);
        }
        if (newInput != oldInput) {
            this.disposeAllModelProxies();
            this.fTransform.clear();
            if (newInput != null) {
                this.installModelProxy(newInput);
                this.restoreViewerState(newInput);
            }
        }
    }

    protected synchronized void restoreViewerState(Object input) {
        this.fPendingState = null;
        if (this.isSavingState()) {
            this.fQueuedRestore = input;
        } else {
            this.startRestoreViewerState(input);
        }
    }

    private synchronized void startRestoreViewerState(final Object input) {
        this.fPendingState = null;
        final IElementMementoProvider defaultProvider = this.getViewerStateAdapter(input);
        if (defaultProvider != null) {
            final ModelDelta delta = new ModelDelta(input, 0);
            XMLMemento inputMemento = XMLMemento.createWriteRoot((String)"VIEWER_INPUT_MEMENTO");
            IMementoManager manager = new IMementoManager(){
                private IElementMementoRequest fRequest;

                public synchronized void requestComplete(IElementMementoRequest request) {
                    if (!request.isCanceled() && (request.getStatus() == null || request.getStatus().isOK())) {
                        XMLMemento keyMemento = (XMLMemento)delta.getElement();
                        StringWriter writer = new StringWriter();
                        try {
                            keyMemento.save((Writer)writer);
                            ModelDelta stateDelta = (ModelDelta)ModelContentProvider.this.fViewerStates.remove(writer.toString());
                            if (stateDelta != null) {
                                if (DEBUG_CONTENT_PROVIDER) {
                                    System.out.println("RESTORE: " + stateDelta.toString());
                                }
                                stateDelta.setElement(input);
                                UIJob job = new UIJob(this, "restore state", input, stateDelta){
                                    final /* synthetic */ 1 this$1;
                                    private final /* synthetic */ Object val$input;
                                    private final /* synthetic */ ModelDelta val$stateDelta;
                                    {
                                        this.this$1 = var1_1;
                                        this.val$input = object;
                                        this.val$stateDelta = modelDelta;
                                    }

                                    public IStatus runInUIThread(IProgressMonitor monitor) {
                                        if (this.val$input.equals(1.access$0(this.this$1).getViewer().getInput())) {
                                            ModelContentProvider.access$1(1.access$0(this.this$1), this.val$stateDelta);
                                            1.access$0(this.this$1).doInitialRestore();
                                        }
                                        return Status.OK_STATUS;
                                    }
                                };
                                job.setSystem(true);
                                job.schedule();
                            }
                        }
                        catch (IOException e) {
                            DebugUIPlugin.log(e);
                        }
                    }
                }

                public void processReqeusts() {
                    defaultProvider.encodeElements(new IElementMementoRequest[]{this.fRequest});
                }

                public synchronized void addRequest(IElementMementoRequest req) {
                    this.fRequest = req;
                }

                static /* synthetic */ ModelContentProvider access$0(1 var0) {
                    return var0.ModelContentProvider.this;
                }
            };
            manager.addRequest(new ElementMementoRequest(this, manager, this.getPresentationContext(), delta.getElement(), this.getViewerTreePath(delta), (IMemento)inputMemento, delta));
            manager.processReqeusts();
        }
    }

    protected abstract void doInitialRestore();

    abstract void doRestore(ModelDelta var1);

    protected synchronized void doRestore(final TreePath path) {
        if (this.fPendingState == null) {
            return;
        }
        final IElementMementoProvider defaultProvider = this.getViewerStateAdapter(this.getViewer().getInput());
        IModelDeltaVisitor visitor = new IModelDeltaVisitor(){

            public boolean visit(IModelDelta delta, int depth) {
                if (delta.getParentDelta() == null) {
                    return true;
                }
                Object element = delta.getElement();
                Object potentialMatch = path.getSegment(depth - 1);
                if (element instanceof IMemento) {
                    if (defaultProvider != null) {
                        defaultProvider.compareElements(new IElementCompareRequest[]{new ElementCompareRequest(ModelContentProvider.this, potentialMatch, path, (IMemento)element, (ModelDelta)delta)});
                    }
                } else if (element.equals(potentialMatch)) {
                    return path.getSegmentCount() > depth;
                }
                return false;
            }
        };
        this.fPendingState.accept(visitor);
    }

    protected void saveViewerState(Object input) {
        IElementMementoProvider stateProvider = this.getViewerStateAdapter(input);
        if (stateProvider != null) {
            ModelDelta delta = new ModelDelta(input, 0);
            this.buildViewerState(delta);
            if (delta.getChildDeltas().length > 0) {
                this.encodeDelta(delta, stateProvider);
            }
        }
    }

    protected void encodeDelta(final ModelDelta rootDelta, final IElementMementoProvider defaultProvider) {
        final XMLMemento inputMemento = XMLMemento.createWriteRoot((String)"VIEWER_INPUT_MEMENTO");
        final XMLMemento childrenMemento = XMLMemento.createWriteRoot((String)"CHILDREN_MEMENTO");
        final IMementoManager manager = new IMementoManager(){
            private List requests = new ArrayList();
            private boolean abort = false;

            public synchronized void requestComplete(IElementMementoRequest request) {
                if (!this.abort) {
                    if (!request.isCanceled() && (request.getStatus() == null || request.getStatus().isOK())) {
                        this.requests.remove(request);
                        if (this.requests.isEmpty()) {
                            XMLMemento keyMemento = (XMLMemento)rootDelta.getElement();
                            StringWriter writer = new StringWriter();
                            try {
                                keyMemento.save((Writer)writer);
                                ModelContentProvider.this.fViewerStates.put(writer.toString(), rootDelta);
                            }
                            catch (IOException e) {
                                DebugUIPlugin.log(e);
                            }
                            ModelContentProvider.this.stateSaveComplete(this);
                        }
                    } else {
                        this.abort = true;
                        Iterator iterator = this.requests.iterator();
                        while (iterator.hasNext()) {
                            IElementMementoRequest req = (IElementMementoRequest)iterator.next();
                            req.cancel();
                        }
                        this.requests.clear();
                        ModelContentProvider.this.stateSaveComplete(this);
                    }
                }
            }

            public synchronized void processReqeusts() {
                defaultProvider.encodeElements(this.requests.toArray(new IElementMementoRequest[this.requests.size()]));
            }

            public synchronized void addRequest(IElementMementoRequest request) {
                this.requests.add(request);
            }
        };
        IModelDeltaVisitor visitor = new IModelDeltaVisitor(){

            public boolean visit(IModelDelta delta, int depth) {
                if (delta.getParentDelta() == null) {
                    manager.addRequest(new ElementMementoRequest(ModelContentProvider.this, manager, ModelContentProvider.this.getPresentationContext(), delta.getElement(), ModelContentProvider.this.getViewerTreePath(delta), (IMemento)inputMemento, (ModelDelta)delta));
                } else {
                    manager.addRequest(new ElementMementoRequest(ModelContentProvider.this, manager, ModelContentProvider.this.getPresentationContext(), delta.getElement(), ModelContentProvider.this.getViewerTreePath(delta), childrenMemento.createChild("CHILD_ELEMENT"), (ModelDelta)delta));
                }
                return true;
            }
        };
        rootDelta.accept(visitor);
        this.stateSaveStarted(manager);
        manager.processReqeusts();
    }

    private synchronized void stateSaveStarted(IMementoManager manager) {
        this.fPendingStateSaves.add(manager);
    }

    private synchronized void stateSaveComplete(IMementoManager manager) {
        this.fPendingStateSaves.remove(manager);
        if (this.fQueuedRestore != null) {
            Object temp = this.fQueuedRestore;
            this.fQueuedRestore = null;
            this.restoreViewerState(temp);
        }
    }

    private synchronized boolean isSavingState() {
        return !this.fPendingStateSaves.isEmpty();
    }

    protected abstract void buildViewerState(ModelDelta var1);

    protected synchronized void disposeModelProxy(Object element) {
        IModelProxy proxy = (IModelProxy)this.fModelProxies.remove(element);
        if (proxy != null) {
            proxy.dispose();
        }
    }

    protected synchronized void disposeAllModelProxies() {
        Iterator updatePolicies = this.fModelProxies.values().iterator();
        while (updatePolicies.hasNext()) {
            IModelProxy proxy = (IModelProxy)updatePolicies.next();
            proxy.dispose();
        }
        this.fModelProxies.clear();
    }

    protected synchronized void installModelProxy(Object element) {
        IModelProxy proxy;
        IModelProxyFactory modelProxyFactory;
        if (!this.fModelProxies.containsKey(element) && (modelProxyFactory = this.getModelProxyFactoryAdapter(element)) != null && (proxy = modelProxyFactory.createModelProxy(element, this.getPresentationContext())) != null) {
            this.fModelProxies.put(element, proxy);
            Job job = new Job("Model Proxy installed notification job"){

                protected IStatus run(IProgressMonitor monitor) {
                    if (!monitor.isCanceled()) {
                        proxy.init(ModelContentProvider.this.getPresentationContext());
                        Object[] mcls = ModelContentProvider.this.fModelListeners.getListeners();
                        int i = 0;
                        while (i < mcls.length) {
                            proxy.addModelChangedListener((IModelChangedListener)mcls[i]);
                            ++i;
                        }
                        proxy.addModelChangedListener(ModelContentProvider.this);
                        proxy.installed(ModelContentProvider.this.getViewer());
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }
    }

    protected IModelProxyFactory getModelProxyFactoryAdapter(Object element) {
        IModelProxyFactory adapter = null;
        if (element instanceof IModelProxyFactory) {
            adapter = (IModelProxyFactory)element;
        } else if (element instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)element;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxyFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            adapter = (IModelProxyFactory)adaptable.getAdapter((Class)clazz);
        }
        return adapter;
    }

    protected IElementMementoProvider getViewerStateAdapter(Object element) {
        IElementMementoProvider adapter = null;
        if (element instanceof IElementMementoProvider) {
            adapter = (IElementMementoProvider)element;
        } else if (element instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)element;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.debug.internal.ui.viewers.model.provisional.IElementMementoProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            adapter = (IElementMementoProvider)adaptable.getAdapter((Class)clazz);
        }
        return adapter;
    }

    protected abstract IPresentationContext getPresentationContext();

    public void modelChanged(final IModelDelta delta, final IModelProxy proxy) {
        WorkbenchJob job = new WorkbenchJob("process model delta"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (!proxy.isDisposed()) {
                    ModelContentProvider.this.updateNodes(new IModelDelta[]{delta});
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    protected void updateNodes(IModelDelta[] nodes) {
        int i = 0;
        while (i < nodes.length) {
            IModelDelta node = nodes[i];
            int flags = node.getFlags();
            if ((flags & 1) != 0) {
                this.handleAdd(node);
            }
            if ((flags & 2) != 0) {
                this.handleRemove(node);
            }
            if ((flags & 0x400) != 0) {
                this.handleContent(node);
            }
            if ((flags & 0x100000) != 0) {
                this.handleExpand(node);
            }
            if ((flags & 0x2000000) != 0) {
                this.handleCollapse(node);
            }
            if ((flags & 0x200000) != 0) {
                this.handleSelect(node);
            }
            if ((flags & 0x800) != 0) {
                this.handleState(node);
            }
            if ((flags & 0x10) != 0) {
                this.handleInsert(node);
            }
            if ((flags & 8) != 0) {
                this.handleReplace(node);
            }
            if ((flags & 0x400000) != 0) {
                this.handleInstall(node);
            }
            if ((flags & 0x800000) != 0) {
                this.handleUninstall(node);
            }
            if ((flags & 0x1000000) != 0) {
                this.handleReveal(node);
            }
            this.updateNodes(node.getChildDeltas());
            ++i;
        }
    }

    protected IElementContentProvider getContentAdapter(Object element) {
        IElementContentProvider adapter = null;
        if (element instanceof IElementContentProvider) {
            adapter = (IElementContentProvider)element;
        } else if (element instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)element;
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.debug.internal.ui.viewers.model.provisional.IElementContentProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            adapter = (IElementContentProvider)adaptable.getAdapter((Class)clazz);
        }
        return adapter;
    }

    protected abstract void handleState(IModelDelta var1);

    protected abstract void handleSelect(IModelDelta var1);

    protected abstract void handleExpand(IModelDelta var1);

    protected abstract void handleCollapse(IModelDelta var1);

    protected abstract void handleContent(IModelDelta var1);

    protected abstract void handleRemove(IModelDelta var1);

    protected abstract void handleAdd(IModelDelta var1);

    protected abstract void handleInsert(IModelDelta var1);

    protected abstract void handleReplace(IModelDelta var1);

    protected abstract void handleReveal(IModelDelta var1);

    protected void handleInstall(IModelDelta delta) {
        this.installModelProxy(delta.getElement());
    }

    protected void handleUninstall(IModelDelta delta) {
        this.disposeModelProxy(delta.getElement());
    }

    protected TreePath getViewerTreePath(IModelDelta node) {
        ArrayList<Object> list = new ArrayList<Object>();
        IModelDelta parentDelta = node.getParentDelta();
        while (parentDelta != null) {
            list.add(0, node.getElement());
            node = parentDelta;
            parentDelta = node.getParentDelta();
        }
        return new TreePath(list.toArray());
    }

    protected Viewer getViewer() {
        return this.fViewer;
    }

    public int viewToModelIndex(TreePath parentPath, int index) {
        return this.fTransform.viewToModelIndex(parentPath, index);
    }

    public int viewToModelCount(TreePath parentPath, int count) {
        return this.fTransform.viewToModelCount(parentPath, count);
    }

    protected int modelToViewIndex(TreePath parentPath, int index) {
        return this.fTransform.modelToViewIndex(parentPath, index);
    }

    protected int modelToViewChildCount(TreePath parentPath, int count) {
        return this.fTransform.modelToViewCount(parentPath, count);
    }

    protected boolean addFilteredIndex(TreePath parentPath, int index, Object element) {
        return this.fTransform.addFilteredIndex(parentPath, index, element);
    }

    protected void removeElementFromFilters(TreePath parentPath, int index) {
        this.fTransform.removeElementFromFilters(parentPath, index);
    }

    protected boolean removeElementFromFilters(TreePath parentPath, Object element) {
        return this.fTransform.removeElementFromFilters(parentPath, element);
    }

    protected void setModelChildCount(TreePath parentPath, int childCount) {
        this.fTransform.setModelChildCount(parentPath, childCount);
    }

    protected boolean shouldFilter(Object parentElementOrTreePath, Object element) {
        ViewerFilter[] filters = ((StructuredViewer)this.fViewer).getFilters();
        if (filters.length > 0) {
            int j = 0;
            while (j < filters.length) {
                if (!filters[j].select(this.fViewer, parentElementOrTreePath, element)) {
                    return true;
                }
                ++j;
            }
        }
        return false;
    }

    protected boolean isFiltered(TreePath parentPath, int index) {
        return this.fTransform.isFiltered(parentPath, index);
    }

    protected void unmapPath(TreePath path) {
        this.fTransform.clear(path);
        this.cancelSubtreeUpdates(path);
    }

    protected int[] getFilteredChildren(TreePath parent) {
        return this.fTransform.getFilteredChildren(parent);
    }

    protected void clearFilteredChild(TreePath parent, int modelIndex) {
        this.fTransform.clear(parent, modelIndex);
    }

    protected void clearFilters(TreePath parent) {
        this.fTransform.clear(parent);
    }

    protected synchronized IModelDelta checkIfRestoreComplete() {
        if (this.fPendingState == null) {
            return null;
        }
        CheckState state = new CheckState();
        this.fPendingState.accept(state);
        if (state.isComplete()) {
            this.fPendingState = null;
            if (DEBUG_CONTENT_PROVIDER) {
                System.out.println("RESTORE COMPELTE");
            }
            return state.getTopItemDelta();
        }
        return null;
    }

    void addViewerUpdateListener(IViewerUpdateListener listener) {
        this.fUpdateListeners.add((Object)listener);
    }

    void removeViewerUpdateListener(IViewerUpdateListener listener) {
        this.fUpdateListeners.remove((Object)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateStarted(ViewerUpdateMonitor update) {
        boolean begin = false;
        Map map = this.fRequestsInProgress;
        synchronized (map) {
            begin = this.fRequestsInProgress.isEmpty();
            ArrayList<ViewerUpdateMonitor> requests = (ArrayList<ViewerUpdateMonitor>)this.fRequestsInProgress.get(update.getSchedulingPath());
            if (requests == null) {
                requests = new ArrayList<ViewerUpdateMonitor>();
                this.fRequestsInProgress.put(update.getSchedulingPath(), requests);
            }
            requests.add(update);
        }
        if (begin) {
            if (DEBUG_UPDATE_SEQUENCE) {
                System.out.println("MODEL SEQUENCE BEGINS");
            }
            this.notifyUpdate(0, null);
        }
        if (DEBUG_UPDATE_SEQUENCE) {
            System.out.println("\tBEGIN - " + update);
        }
        this.notifyUpdate(2, update);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateComplete(ViewerUpdateMonitor update) {
        boolean end = false;
        Map map = this.fRequestsInProgress;
        synchronized (map) {
            List requests = (List)this.fRequestsInProgress.get(update.getSchedulingPath());
            if (requests != null) {
                requests.remove(update);
                this.trigger(update);
                if (requests.isEmpty()) {
                    this.fRequestsInProgress.remove(update.getSchedulingPath());
                }
            }
            end = this.fRequestsInProgress.isEmpty();
        }
        this.notifyUpdate(3, update);
        if (DEBUG_UPDATE_SEQUENCE) {
            System.out.println("\tEND - " + update);
        }
        if (end) {
            if (DEBUG_UPDATE_SEQUENCE) {
                System.out.println("MODEL SEQUENCE ENDS");
            }
            this.notifyUpdate(1, null);
        }
    }

    protected void notifyUpdate(final int type, final IViewerUpdate update) {
        if (!this.fUpdateListeners.isEmpty()) {
            Object[] listeners = this.fUpdateListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                final IViewerUpdateListener listener = (IViewerUpdateListener)listeners[i];
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() throws Exception {
                        switch (type) {
                            case 0: {
                                listener.viewerUpdatesBegin();
                                break;
                            }
                            case 1: {
                                listener.viewerUpdatesComplete();
                                break;
                            }
                            case 2: {
                                listener.updateStarted(update);
                                break;
                            }
                            case 3: {
                                listener.updateComplete(update);
                            }
                        }
                    }

                    public void handleException(Throwable exception) {
                        DebugUIPlugin.log(exception);
                    }
                });
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancelSubtreeUpdates(TreePath path) {
        Map map = this.fRequestsInProgress;
        synchronized (map) {
            TreePath entryPath;
            Iterator iterator = this.fRequestsInProgress.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                entryPath = (TreePath)entry.getKey();
                if (!entryPath.startsWith(path, null)) continue;
                List requests = (List)entry.getValue();
                Iterator reqIter = requests.iterator();
                while (reqIter.hasNext()) {
                    ((IRequest)reqIter.next()).cancel();
                }
            }
            ArrayList<TreePath> purge = new ArrayList<TreePath>();
            iterator = this.fWaitingRequests.keySet().iterator();
            while (iterator.hasNext()) {
                entryPath = (TreePath)iterator.next();
                if (!entryPath.startsWith(path, null)) continue;
                purge.add(entryPath);
            }
            iterator = purge.iterator();
            while (iterator.hasNext()) {
                this.fWaitingRequests.remove(iterator.next());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void schedule(ViewerUpdateMonitor update) {
        Map map = this.fRequestsInProgress;
        synchronized (map) {
            TreePath schedulingPath = update.getSchedulingPath();
            ArrayList<ViewerUpdateMonitor> requests = (ArrayList<ViewerUpdateMonitor>)this.fWaitingRequests.get(schedulingPath);
            if (requests == null) {
                TreePath parentPath = schedulingPath;
                while (this.fRequestsInProgress.get(parentPath) == null) {
                    if ((parentPath = parentPath.getParentPath()) != null) continue;
                    update.start();
                    return;
                }
            } else {
                Iterator reqIter = requests.iterator();
                while (reqIter.hasNext()) {
                    ViewerUpdateMonitor waiting = (ViewerUpdateMonitor)reqIter.next();
                    if (!waiting.coalesce(update)) continue;
                    return;
                }
                requests.add(update);
                return;
            }
            requests = new ArrayList<ViewerUpdateMonitor>();
            requests.add(update);
            this.fWaitingRequests.put(schedulingPath, requests);
        }
    }

    void trigger(ViewerUpdateMonitor request) {
        if (this.fWaitingRequests.isEmpty()) {
            return;
        }
        TreePath schedulingPath = request.getSchedulingPath();
        List waiting = (List)this.fWaitingRequests.get(schedulingPath);
        if (waiting == null) {
            int length = Integer.MAX_VALUE;
            Iterator entries = this.fWaitingRequests.entrySet().iterator();
            Map.Entry candidate = null;
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                TreePath key = (TreePath)entry.getKey();
                if (key.getSegmentCount() >= length) continue;
                candidate = entry;
                length = key.getSegmentCount();
            }
            if (candidate != null) {
                this.startHighestPriorityRequest((TreePath)candidate.getKey(), (List)candidate.getValue());
            }
        } else {
            this.startHighestPriorityRequest(schedulingPath, waiting);
        }
    }

    private void startHighestPriorityRequest(TreePath key, List waiting) {
        int priority = 4;
        ViewerUpdateMonitor next = null;
        Iterator requests = waiting.iterator();
        while (requests.hasNext()) {
            ViewerUpdateMonitor vu = (ViewerUpdateMonitor)requests.next();
            if (vu.getPriority() >= priority) continue;
            next = vu;
            priority = next.getPriority();
        }
        waiting.remove(next);
        if (waiting.isEmpty()) {
            this.fWaitingRequests.remove(key);
        }
        next.start();
    }

    void addModelChangedListener(IModelChangedListener listener) {
        this.fModelListeners.add((Object)listener);
        Iterator proxies = this.fModelProxies.values().iterator();
        while (proxies.hasNext()) {
            IModelProxy proxy = (IModelProxy)proxies.next();
            proxy.addModelChangedListener(listener);
        }
    }

    void removeModelChangedListener(IModelChangedListener listener) {
        this.fModelListeners.remove((Object)listener);
        Iterator proxies = this.fModelProxies.values().iterator();
        while (proxies.hasNext()) {
            IModelProxy proxy = (IModelProxy)proxies.next();
            proxy.removeModelChangedListener(listener);
        }
    }

    protected Object getElement(TreePath path) {
        if (path.getSegmentCount() > 0) {
            return path.getLastSegment();
        }
        return this.getViewer().getInput();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rescheduleUpdates(TreePath parentPath, int modelIndex) {
        Map map = this.fRequestsInProgress;
        synchronized (map) {
            IChildrenUpdate childrenUpdate;
            IViewerUpdate update;
            Iterator iterator;
            List requests = (List)this.fRequestsInProgress.get(parentPath);
            ArrayList<IChildrenUpdate> reCreate = null;
            if (requests != null) {
                iterator = requests.iterator();
                while (iterator.hasNext()) {
                    update = (IViewerUpdate)iterator.next();
                    if (!(update instanceof IChildrenUpdate) || (childrenUpdate = (IChildrenUpdate)update).getOffset() <= modelIndex) continue;
                    childrenUpdate.cancel();
                    if (reCreate == null) {
                        reCreate = new ArrayList<IChildrenUpdate>();
                    }
                    reCreate.add(childrenUpdate);
                    if (!DEBUG_CONTENT_PROVIDER) continue;
                    System.out.println("canceled update in progress handling REMOVE: " + childrenUpdate);
                }
            }
            if ((requests = (List)this.fWaitingRequests.get(parentPath)) != null) {
                iterator = requests.iterator();
                while (iterator.hasNext()) {
                    update = (IViewerUpdate)iterator.next();
                    if (!(update instanceof IChildrenUpdate) || (childrenUpdate = (IChildrenUpdate)update).getOffset() <= modelIndex) continue;
                    ((ChildrenUpdate)childrenUpdate).setOffset(childrenUpdate.getOffset() - 1);
                    if (!DEBUG_CONTENT_PROVIDER) continue;
                    System.out.println("modified waiting update handling REMOVE: " + childrenUpdate);
                }
            }
            if (reCreate != null) {
                iterator = reCreate.iterator();
                while (iterator.hasNext()) {
                    IChildrenUpdate childrenUpdate2 = (IChildrenUpdate)iterator.next();
                    int start = childrenUpdate2.getOffset() - 1;
                    int end = start + childrenUpdate2.getLength();
                    int i = start;
                    while (i < end) {
                        ((TreeModelContentProvider)this).doUpdateElement(parentPath, i);
                        ++i;
                    }
                }
            }
        }
    }

    static /* synthetic */ void access$1(ModelContentProvider modelContentProvider, ModelDelta modelDelta) {
        modelContentProvider.fPendingState = modelDelta;
    }

    class CheckState
    implements IModelDeltaVisitor {
        private boolean complete = true;
        private IModelDelta topDelta = null;

        CheckState() {
        }

        public boolean visit(IModelDelta delta, int depth) {
            if (delta.getFlags() != 0) {
                if (delta.getFlags() == 0x1000000 && !(delta.getElement() instanceof IMemento)) {
                    this.topDelta = delta;
                } else {
                    this.complete = false;
                    return false;
                }
            }
            return true;
        }

        public boolean isComplete() {
            return this.complete;
        }

        public IModelDelta getTopItemDelta() {
            return this.topDelta;
        }
    }

    class LRUMap
    extends LinkedHashMap {
        private static final long serialVersionUID = 1L;
        private int fMaxSize;

        LRUMap(int maxSize) {
            this.fMaxSize = maxSize;
        }

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > this.fMaxSize;
        }
    }
}

