/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.converter.util;

import org.eclipse.emf.common.ui.DiagnosticComposite;
import org.eclipse.emf.common.ui.dialogs.DiagnosticDialog;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.converter.ConverterPlugin;
import org.eclipse.emf.converter.util.ConverterUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class ConverterUIUtil {

    public static class TreeCheckStateManager
    implements Listener {
        protected Tree tree;
        protected boolean internalChange = false;

        public TreeCheckStateManager(Tree tree) {
            this.tree = tree;
            tree.addListener(13, (Listener)this);
            tree.addListener(12, (Listener)this);
        }

        public void handleEvent(Event event) {
            if (!this.internalChange && event.widget == this.tree && event.detail == 32) {
                switch (event.type) {
                    case 13: {
                        try {
                            this.internalChange = true;
                            this.checkStateChanged((TreeItem)event.item, true);
                            break;
                        }
                        finally {
                            this.internalChange = false;
                        }
                    }
                    case 12: {
                        this.treeDisposed();
                    }
                }
            }
        }

        protected void checkStateChanged(TreeItem item, boolean changeChildren) {
            this.setGray(item, false);
            TreeItem[] sibilings = item.getParentItem() != null ? item.getParentItem().getItems() : item.getParent().getItems();
            boolean checked = item.getChecked();
            if (changeChildren) {
                this.checkChildren(item, checked);
            }
            boolean grayParent = false;
            int i = 0;
            while (i < sibilings.length) {
                TreeItem sibiling = sibilings[i];
                if (checked ? !sibiling.getChecked() : sibiling.getChecked()) {
                    grayParent = true;
                    break;
                }
                ++i;
            }
            if (grayParent) {
                this.grayParents(item);
            } else {
                TreeItem parent = item.getParentItem();
                if (parent != null) {
                    this.setCheck(parent, checked);
                    this.setGray(parent, false);
                    this.checkStateChanged(parent, false);
                }
            }
        }

        protected void treeDisposed() {
            if (!this.tree.isDisposed()) {
                this.tree.removeListener(13, (Listener)this);
                this.tree.removeListener(12, (Listener)this);
            }
            this.tree = null;
        }

        protected void grayParents(TreeItem item) {
            item = item.getParentItem();
            while (item != null) {
                this.setCheck(item, true);
                this.setGray(item, true);
                item = item.getParentItem();
            }
        }

        protected void checkChildren(TreeItem item, boolean check) {
            TreeItem[] items = item.getItems();
            int i = 0;
            while (i < items.length) {
                TreeItem child = items[i];
                this.setCheck(child, check);
                this.setGray(child, false);
                this.checkChildren(child, check);
                ++i;
            }
        }

        protected void setCheck(TreeItem item, boolean check) {
            if (item.getChecked() != check) {
                item.setChecked(check);
                this.tree.notifyListeners(13, this.createCheckEvent(item));
            }
        }

        protected Event createCheckEvent(TreeItem item) {
            Event event = new Event();
            event.type = 13;
            event.widget = item.getParent();
            event.item = item;
            event.detail = 32;
            event.display = item.getDisplay();
            return event;
        }

        protected void setGray(TreeItem item, boolean gray) {
            if (item.getGrayed() != gray) {
                item.setGrayed(gray);
            }
        }
    }

    public static class DiagnosticHandler {
        public void handleDiagnostic(Diagnostic diagnostic) {
            this.handleDiagnostic(diagnostic, null, null, null);
        }

        public void handleDiagnostic(Diagnostic diagnostic, String message, String dialogTitle, String dialogMessage) {
            if (diagnostic.getSeverity() == 0) {
                this.handleOKDiagnostic(diagnostic, message, dialogTitle, dialogMessage);
            } else {
                this.handleNotOKDiagnostic(diagnostic, this.decodeAction(diagnostic), message, dialogTitle, dialogMessage);
            }
        }

        protected boolean doMessages() {
            return false;
        }

        protected void setMessage(String message) {
        }

        protected void setMessage(String message, int messageType) {
        }

        protected void setErrorMessage(String message) {
        }

        protected boolean doDialog() {
            return true;
        }

        protected Shell getShell() {
            return (Shell)ConverterUtil.ShellFinder.getActiveShell();
        }

        protected ConverterUtil.DecodedAction decodeAction(Diagnostic diagnostic) {
            int actionCode = ConverterUtil.computeActionCode(diagnostic);
            return ConverterUtil.decodeAction(actionCode);
        }

        protected void handleOKDiagnostic(Diagnostic diagnostic, String message, String dialogTitle, String dialogMessage) {
            this.setMessage(null);
            this.setErrorMessage(null);
        }

        protected void handleNotOKDiagnostic(Diagnostic diagnostic, ConverterUtil.DecodedAction decodedAction, String message, String dialogTitle, String dialogMessage) {
            int messageType = 0;
            switch (diagnostic.getSeverity()) {
                case 1: {
                    messageType = 1;
                    if (dialogTitle != null) break;
                    dialogTitle = ConverterPlugin.INSTANCE.getString("_UI_DialogInformation_title");
                    break;
                }
                case 2: {
                    messageType = 2;
                    if (dialogTitle != null) break;
                    dialogTitle = ConverterPlugin.INSTANCE.getString("_UI_DialogWarning_title");
                    break;
                }
                case 4: {
                    messageType = 3;
                    if (dialogTitle != null) break;
                    dialogTitle = ConverterPlugin.INSTANCE.getString("_UI_DialogError_title");
                }
            }
            if (this.doMessages()) {
                if (message == null) {
                    message = diagnostic.getMessage();
                }
                this.setErrorMessage(null);
                this.setMessage(null);
                switch (decodedAction.message) {
                    case 2: {
                        this.setMessage(message);
                        break;
                    }
                    case 0: 
                    case 4: {
                        if (messageType == 3) {
                            this.setErrorMessage(message);
                            break;
                        }
                        this.setMessage(message, messageType);
                        break;
                    }
                    case 8: {
                        this.setErrorMessage(message);
                    }
                }
            }
            if (this.doDialog()) {
                switch (decodedAction.dialog) {
                    case 0: 
                    case 512: {
                        if (diagnostic.getChildren().isEmpty()) break;
                        DiagnosticDialog.openProblem((Shell)this.getShell(), (String)dialogTitle, (String)dialogMessage, (Diagnostic)diagnostic);
                        break;
                    }
                    case 1024: {
                        DiagnosticDialog.openProblem((Shell)this.getShell(), (String)dialogTitle, (String)dialogMessage, (Diagnostic)diagnostic);
                        break;
                    }
                    case 2048: {
                        new DiagnosticDialog(this.getShell(), dialogTitle, dialogMessage, diagnostic, DiagnosticComposite.ERROR_WARNING_MASK){

                            protected Image getImage() {
                                return this.getErrorImage();
                            }
                        }.open();
                    }
                }
            }
        }
    }
}

