/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.contentmodel.util;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.util.CMDocumentCacheListener;

public class CMDocumentCache {
    public static final int STATUS_NOT_LOADED = 0;
    public static final int STATUS_LOADING = 2;
    public static final int STATUS_LOADED = 3;
    public static final int STATUS_ERROR = 4;
    static final boolean DEBUG_CACHE = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.wst.xml.core/debug/cmdocumentcache"));
    private static CMDocumentCache SHARED_INSTANCE = new CMDocumentCache();
    Map fSavedDocuments = new HashMap();
    protected Hashtable fCachetable;
    protected List listenerList = new ArrayList();

    public static CMDocumentCache getInstance() {
        return SHARED_INSTANCE;
    }

    private CMDocumentCache() {
        this.fCachetable = new Hashtable();
    }

    public void addListener(CMDocumentCacheListener listener) {
        this.listenerList.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Hashtable hashtable = this.fCachetable;
        synchronized (hashtable) {
            this.fCachetable.clear();
        }
        this.notifyCacheCleared();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMDocument getCMDocument(String grammarURI) {
        CMDocument result = null;
        boolean cachedDocumentWasRemoved = false;
        if (grammarURI != null) {
            CacheEntry entry = null;
            Hashtable hashtable = this.fCachetable;
            synchronized (hashtable) {
                entry = (CacheEntry)this.fCachetable.get(grammarURI);
                if (entry != null) {
                    result = entry.getCMDocument();
                    cachedDocumentWasRemoved = entry.status == 3 && result == null;
                }
            }
            if (cachedDocumentWasRemoved) {
                if (DEBUG_CACHE) {
                    System.out.println("CMDocumentCache hit on reclaimed document " + grammarURI);
                }
                this.notifyCacheUpdated(grammarURI, entry.status, 0, result);
                hashtable = this.fCachetable;
                synchronized (hashtable) {
                    this.fCachetable.remove(grammarURI);
                }
            } else if (DEBUG_CACHE && entry != null) {
                System.out.println("CMDocumentCache hit on " + grammarURI);
            }
        } else if (DEBUG_CACHE) {
            System.out.println("CMDocumentCache miss on " + grammarURI);
        }
        return result;
    }

    public synchronized List getCMDocuments() {
        ArrayList<CMDocument> list = new ArrayList<CMDocument>();
        Iterator i = this.fCachetable.values().iterator();
        while (i.hasNext()) {
            CacheEntry entry = (CacheEntry)i.next();
            CMDocument document = entry.getCMDocument();
            if (document == null) continue;
            list.add(document);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStatus(String grammarURI) {
        int result = 0;
        boolean cacheDocumentWasRemoved = false;
        if (grammarURI != null) {
            CacheEntry entry = null;
            Hashtable hashtable = this.fCachetable;
            synchronized (hashtable) {
                entry = (CacheEntry)this.fCachetable.get(grammarURI);
                if (entry != null) {
                    cacheDocumentWasRemoved = entry.status == 3 && entry.getCMDocument() == null;
                }
            }
            if (cacheDocumentWasRemoved) {
                this.notifyCacheUpdated(grammarURI, entry.status, 0, null);
                entry.status = 0;
            }
            if (entry != null) {
                result = entry.status;
            }
        }
        return result;
    }

    CacheEntry lookupOrCreate(String grammarURI) {
        CacheEntry entry = null;
        entry = (CacheEntry)this.fCachetable.get(grammarURI);
        if (entry == null) {
            entry = new CacheEntry(grammarURI);
            this.fCachetable.put(grammarURI, entry);
        }
        return entry;
    }

    protected void notifyCacheCleared() {
        CMDocumentCacheListener[] listeners = this.listenerList.toArray(new CMDocumentCacheListener[0]);
        int i = 0;
        while (i < listeners.length) {
            listeners[i].cacheCleared(this);
            ++i;
        }
    }

    protected void notifyCacheUpdated(String uri, int oldStatus, int newStatus, CMDocument cmDocument) {
        CMDocumentCacheListener[] listeners = this.listenerList.toArray(new CMDocumentCacheListener[0]);
        int i = 0;
        while (i < listeners.length) {
            listeners[i].cacheUpdated(this, uri, oldStatus, newStatus, cmDocument);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putCMDocument(String grammarURI, CMDocument cmDocument) {
        if (grammarURI != null && cmDocument != null) {
            CacheEntry entry = null;
            int oldStatus = 0;
            Hashtable hashtable = this.fCachetable;
            synchronized (hashtable) {
                entry = this.lookupOrCreate(grammarURI);
                oldStatus = entry.status;
                entry.status = 3;
                entry.setCMDocument(cmDocument);
            }
            this.notifyCacheUpdated(grammarURI, oldStatus, entry.status, cmDocument);
        }
    }

    public void removeListener(CMDocumentCacheListener listener) {
        this.listenerList.remove(listener);
    }

    public void setStatus(String grammarURI, int status) {
        if (grammarURI != null) {
            CacheEntry entry = this.lookupOrCreate(grammarURI);
            int oldStatus = entry.status;
            entry.status = status;
            this.notifyCacheUpdated(grammarURI, oldStatus, entry.status, entry.getCMDocument());
        }
    }

    class CacheEntry {
        String uri;
        int status = 0;
        float progress;
        private SoftReference cmDocumentReference;

        CacheEntry(String uri) {
            this.uri = uri;
        }

        CacheEntry(String uri, int status, CMDocument document) {
            this.uri = uri;
            this.status = status;
            this.cmDocumentReference = new SoftReference<CMDocument>(document);
        }

        CMDocument getCMDocument() {
            if (this.cmDocumentReference == null) {
                return null;
            }
            return (CMDocument)this.cmDocumentReference.get();
        }

        public void setCMDocument(CMDocument document) {
            this.cmDocumentReference = new SoftReference<CMDocument>(document);
        }
    }
}

