/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.fe.internal.ui.wizards;

import org.eclipse.datatools.connectivity.sqm.fe.internal.ui.util.ResourceLoader;
import org.eclipse.datatools.connectivity.sqm.fe.internal.ui.wizards.FESummaryProperty;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.help.WorkbenchHelp;

public class FESummaryWizardPage
extends WizardPage {
    private Table summaryTable;
    private FESummaryProperty[] properties;
    private boolean visible = false;

    public FESummaryWizardPage(String name) {
        super(name);
        this.setTitle(ResourceLoader.INSTANCE.queryString("FEWizard.SummaryPage.title"));
        this.setDescription(ResourceLoader.INSTANCE.queryString("FEWizard.SummaryPage.description"));
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.wst.rdb.fe.ui.infopop.genddl_wiz_summary");
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        this.summaryTable = new Table(composite, 68352);
        GridData gd = new GridData();
        gd.widthHint = 1;
        gd.heightHint = 1;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.summaryTable.setLayoutData((Object)gd);
        this.summaryTable.setLayout((Layout)layout);
        this.summaryTable.setLinesVisible(true);
        this.summaryTable.setHeaderVisible(true);
        this.summaryTable.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                int[] weights = new int[]{2, 4};
                int weightsum = 0;
                for (int i = 0; i < weights.length; ++i) {
                    weightsum += weights[i];
                }
                TableColumn[] cols = FESummaryWizardPage.this.summaryTable.getColumns();
                int count = Math.min(weights.length, cols.length);
                int tablewidth = ((FESummaryWizardPage)FESummaryWizardPage.this).summaryTable.getSize().x;
                for (int i = 0; i < count; ++i) {
                    cols[i].setWidth(tablewidth * weights[i] / weightsum);
                }
            }
        });
        TableLayout tblLayout = new TableLayout();
        tblLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        TableColumn colSetting = new TableColumn(this.summaryTable, 0);
        colSetting.setText(ResourceLoader.INSTANCE.queryString("FEWizard.SummaryPage.settingColumnHeader"));
        tblLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(3, true));
        TableColumn colValue = new TableColumn(this.summaryTable, 0);
        colValue.setText(ResourceLoader.INSTANCE.queryString("FEWizard.SummaryPage.valueColumnHeader"));
        this.setControl((Control)composite);
    }

    public void setProperties(FESummaryProperty[] properties) {
        this.properties = properties;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        if (visible) {
            this.loadProperties();
        }
        super.setVisible(visible);
    }

    public boolean isVisible() {
        return this.visible;
    }

    private void loadProperties() {
        this.summaryTable.removeAll();
        if (this.properties != null) {
            int propertyCount = this.properties.length;
            for (int index = 0; index < propertyCount; ++index) {
                new TableItem(this.summaryTable, 0).setText(new String[]{this.properties[index].getPropertyName(), this.properties[index].getValue()});
            }
        }
    }
}

