/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.db.internal;

import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IManagedConnection;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.profile.ProfileUtil;
import org.eclipse.jpt.db.internal.Catalog;
import org.eclipse.jpt.db.internal.Connection;
import org.eclipse.jpt.db.internal.ConnectionListener;
import org.eclipse.jpt.db.internal.ConnectionProfile;
import org.eclipse.jpt.db.internal.ConnectionProfileRepository;
import org.eclipse.jpt.db.internal.Database;
import org.eclipse.jpt.db.internal.NullDatabase;
import org.eclipse.jpt.db.internal.ProfileListener;
import org.eclipse.jpt.db.internal.Schema;
import org.eclipse.jpt.db.internal.Table;

public final class DTPConnectionProfileWrapper
extends ConnectionProfile {
    private final IConnectionProfile dtpConnectionProfile;
    public static final String CONNECTION_TYPE = "java.sql.Connection";
    public static final String CONNECTION_PROFILE_TYPE = "org.eclipse.datatools.connectivity.db.generic.connectionProfile";
    public static final String DATABASE_PRODUCT_PROPERTY = "org.eclipse.datatools.connectivity.server.version";
    public static final String DATABASE_SAVE_PWD_PROP_ID = "org.eclipse.datatools.connectivity.db.savePWD";
    public static final String DRIVER_DEFINITION_PROP_ID = "org.eclipse.datatools.connectivity.driverDefinitionID";
    public static final String DRIVER_DEFINITION_TYPE_PROP_ID = "org.eclipse.datatools.connectivity.drivers.defnType";
    public static final String DRIVER_JAR_LIST_PROP_ID = "jarList";

    DTPConnectionProfileWrapper(ConnectionProfileRepository profileRepository, IConnectionProfile dtpConnectionProfile) {
        super(profileRepository);
        this.dtpConnectionProfile = dtpConnectionProfile;
    }

    public void addProfileListener(ProfileListener listener) {
        this.getProfileRepository().addProfileListener(listener);
    }

    public void removeProfileListener(ProfileListener listener) {
        this.getProfileRepository().removeProfileListener(listener);
    }

    public void addConnectionListener(ConnectionListener listener) {
        this.getConnection().addConnectionListener(listener);
    }

    public void removeConnectionListener(ConnectionListener listener) {
        this.getConnection().removeConnectionListener(listener);
    }

    private IManagedConnection buildDtpManagedConnection(IConnectionProfile dtpProfile) {
        return dtpProfile.getManagedConnection(CONNECTION_TYPE);
    }

    public void connect() {
        IStatus status;
        if (!this.dtpConnectionProfile.isConnected() && !(status = this.dtpConnectionProfile.connect()).isOK()) {
            if (status.isMultiStatus()) {
                IStatus[] statusChildren = status.getChildren();
                throw new RuntimeException(statusChildren[0].getMessage(), statusChildren[0].getException());
            }
            throw new RuntimeException(status.getMessage(), status.getException());
        }
    }

    public void disconnect() {
        IStatus status = this.dtpConnectionProfile.disconnect();
        if (!status.isOK()) {
            if (status.isMultiStatus()) {
                IStatus[] statusChildren = status.getChildren();
                throw new RuntimeException(statusChildren[0].getMessage(), statusChildren[0].getException());
            }
            throw new RuntimeException(status.getMessage(), status.getException());
        }
    }

    void databaseChanged(Database database, int eventType) {
        this.getConnection().databaseChanged(database, eventType);
    }

    void catalogChanged(Catalog catalog, Database database, int eventType) {
    }

    void schemaChanged(Schema schema, Database database, int eventType) {
        this.getConnection().schemaChanged(schema, database, eventType);
    }

    void tableChanged(Table table, Schema schema, Database database, int eventType) {
        this.getConnection().tableChanged(table, schema, database, eventType);
    }

    public boolean isConnected() {
        return this.getConnection().isConnected();
    }

    public boolean isNull() {
        return false;
    }

    public String getName() {
        return this.dtpConnectionProfile.getName();
    }

    public String getDatabaseName() {
        return this.getProperties().getProperty("org.eclipse.datatools.connectivity.db.databaseName");
    }

    public String getDatabaseProduct() {
        return this.getProperties().getProperty(DATABASE_PRODUCT_PROPERTY);
    }

    public String getDatabaseVendor() {
        return this.getProperties().getProperty("org.eclipse.datatools.connectivity.db.vendor");
    }

    public String getDatabaseVersion() {
        return this.getProperties().getProperty("org.eclipse.datatools.connectivity.db.version");
    }

    public String getUserName() {
        return this.getProperties().getProperty("org.eclipse.datatools.connectivity.db.username");
    }

    public String getUserPassword() {
        return this.getProperties().getProperty("org.eclipse.datatools.connectivity.db.password");
    }

    public String getDriverClass() {
        return this.getProperties().getProperty("org.eclipse.datatools.connectivity.db.driverClass");
    }

    public String getUrl() {
        return this.getProperties().getProperty("org.eclipse.datatools.connectivity.db.URL");
    }

    public String getInstanceId() {
        return this.dtpConnectionProfile.getInstanceID();
    }

    public String getProviderId() {
        return this.dtpConnectionProfile.getProviderId();
    }

    private Properties getProperties() {
        return this.dtpConnectionProfile.getBaseProperties();
    }

    protected Connection buildConnection() {
        Connection connection = Connection.createConnection(this.buildDtpManagedConnection(this.dtpConnectionProfile));
        return connection;
    }

    protected Database buildDatabase() {
        if (this.isConnected()) {
            org.eclipse.datatools.modelbase.sql.schema.Database dtpDatabase = ProfileUtil.getDatabase((DatabaseIdentifier)new DatabaseIdentifier(this.getName(), this.getDatabaseName()), (boolean)false);
            return Database.createDatabase(this, dtpDatabase);
        }
        return NullDatabase.instance();
    }

    boolean wraps(IConnectionProfile dtpProfile) {
        return this.dtpConnectionProfile == dtpProfile;
    }
}

