/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.el;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.jsf.common.internal.types.StringLiteralType;
import org.eclipse.jst.jsf.common.internal.types.ValueType;
import org.eclipse.jst.jsf.context.symbol.IBoundedTypeDescriptor;
import org.eclipse.jst.jsf.context.symbol.IObjectSymbol;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.context.symbol.ITypeDescriptor;
import org.eclipse.jst.jsf.designtime.el.AbstractDTPropertyResolver;

public class DefaultDTPropertyResolver
extends AbstractDTPropertyResolver {
    public ISymbol getProperty(ISymbol base, Object propertyId) {
        ISymbol matchedSymbol;
        ITypeDescriptor typeDesc = null;
        Object[] factoredProperties = new Object[]{propertyId};
        if (base instanceof IObjectSymbol) {
            IObjectSymbol objSymbol = (IObjectSymbol)base;
            typeDesc = objSymbol.getTypeDescriptor();
            if (objSymbol.supportsCoercion("Ljava.util.List;")) {
                typeDesc = null;
            } else if (objSymbol.supportsCoercion("Ljava.util.Map;")) {
                BasicEList args = new BasicEList();
                args.add((Object)new StringLiteralType(propertyId.toString()));
                ISymbol prop = objSymbol.call("get", (EList)args, propertyId.toString());
                if (prop != null) {
                    return prop;
                }
                typeDesc = objSymbol.coerce("Ljava.util.Map;");
                if (propertyId instanceof String && ((String)propertyId).indexOf(46) > -1) {
                    factoredProperties = this.factorKey(propertyId);
                }
            }
            if (typeDesc instanceof IBoundedTypeDescriptor && ((IBoundedTypeDescriptor)typeDesc).isUnboundedForType("Ljava.lang.Object;")) {
                return ((IBoundedTypeDescriptor)typeDesc).getUnboundedProperty(propertyId, "Ljava.lang.Object;");
            }
        }
        int i = 0;
        block0: do {
            matchedSymbol = null;
            Iterator it = this.getIterator(typeDesc);
            while (it.hasNext()) {
                ISymbol element = (ISymbol)it.next();
                if (!element.getName().equals(factoredProperties[i]) || !(element instanceof IObjectSymbol)) continue;
                matchedSymbol = element;
                typeDesc = ((IObjectSymbol)matchedSymbol).getTypeDescriptor();
                continue block0;
            }
        } while (++i < factoredProperties.length && matchedSymbol != null);
        return matchedSymbol;
    }

    public ISymbol[] getAllProperties(ISymbol base) {
        List symbolsList = Collections.EMPTY_LIST;
        if (base instanceof IObjectSymbol) {
            Object typeDesc = null;
            typeDesc = ((IObjectSymbol)base).supportsCoercion("Ljava.util.Map;") ? ((IObjectSymbol)base).coerce("Ljava.util.Map;") : (((IObjectSymbol)base).supportsCoercion("Ljava.util.List;") ? null : ((IObjectSymbol)base).getTypeDescriptor());
            if (typeDesc != null) {
                symbolsList = typeDesc.getProperties();
            }
        }
        return symbolsList.toArray(ISymbol.EMPTY_SYMBOL_ARRAY);
    }

    public ISymbol getProperty(ISymbol base, int offset) {
        ITypeDescriptor typeDesc = null;
        if (offset < 0) {
            throw new AssertionError((Object)"offsets must be >=0 to be valid");
        }
        if (base instanceof IObjectSymbol) {
            IObjectSymbol objSymbol = (IObjectSymbol)base;
            typeDesc = objSymbol.getTypeDescriptor();
            if (typeDesc.isArray()) {
                IObjectSymbol arrayElement = typeDesc.getArrayElement();
                arrayElement.setName(String.valueOf(base.getName()) + "[" + offset + "]");
                return arrayElement;
            }
            if (objSymbol.supportsCoercion("Ljava.util.List;")) {
                BasicEList args = new BasicEList();
                args.add((Object)new ValueType("I", 2));
                return objSymbol.call("get", (EList)args, String.valueOf(base.getName()) + "[" + offset + "]");
            }
        }
        return null;
    }

    private Iterator getIterator(ITypeDescriptor typeDesc) {
        if (typeDesc != null) {
            return typeDesc.getProperties().iterator();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    private Object[] factorKey(Object key) {
        if (key instanceof String) {
            ArrayList<String> segments = new ArrayList<String>();
            String stringKey = (String)key;
            int nextPos = -1;
            while ((nextPos = stringKey.indexOf(46)) > -1) {
                segments.add(stringKey.substring(0, nextPos));
                stringKey = stringKey.substring(nextPos + 1);
            }
            if (stringKey != null && stringKey.length() > 0) {
                segments.add(stringKey);
            }
            return segments.toArray();
        }
        return new Object[]{key};
    }
}

