/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.internal.jsp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsf.common.JSFCommonPlugin;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.internal.TraitValueHelper;
import org.eclipse.jst.jsf.common.metadata.query.IMetaDataModelContext;
import org.eclipse.jst.jsf.common.metadata.query.MetaDataQueryHelper;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.resolver.structureddocument.ITaglibContextResolver;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContextFactory;
import org.eclipse.jst.jsf.context.symbol.IComponentSymbol;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.context.symbol.SymbolFactory;
import org.eclipse.jst.jsf.context.symbol.source.AbstractContextSymbolFactory;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.designtime.DesignTimeApplicationManager;
import org.eclipse.jst.jsf.designtime.context.DTFacesContext;
import org.eclipse.jst.jsf.designtime.internal.jsp.SymbolMap;
import org.eclipse.jst.jsp.core.internal.domdocument.DOMModelForJSP;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.model.ModelLifecycleEvent;
import org.eclipse.wst.sse.core.internal.provisional.IModelLifecycleListener;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.osgi.framework.Bundle;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JSPModelProcessor {
    private static final String SESSION_PROPERTY_QUALIFIER = "net.eclipse.jst.jsf.jsp";
    private static final String SESSION_PROPERTY_NAME_JSPMODELPROCESSOR = "JSPModelProcessor";
    private static final QualifiedName SESSION_PROPERTY_JSPMODELPROCESSOR_KEY = new QualifiedName("net.eclipse.jst.jsf.jsp", "JSPModelProcessor");
    private final IFile _file;
    private final DOMModelForJSP _model;
    private final ModelListener _modelListener;
    private boolean isDisposed;
    private Map _requestMap;
    private Map _sessionMap;
    private Map _applicationMap;
    private Map _noneMap;
    private long _lastModificationStamp;
    private final CountingMutex _lastModificationStampMonitor = new CountingMutex();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSPModelProcessor get(IFile file) throws CoreException, IOException {
        IFile iFile = file;
        synchronized (iFile) {
            JSPModelProcessor processor = (JSPModelProcessor)file.getSessionProperty(SESSION_PROPERTY_JSPMODELPROCESSOR_KEY);
            if (processor == null) {
                processor = new JSPModelProcessor(file);
                file.setSessionProperty(SESSION_PROPERTY_JSPMODELPROCESSOR_KEY, (Object)processor);
            }
            return processor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dispose(IFile file) {
        try {
            IFile iFile = file;
            synchronized (iFile) {
                JSPModelProcessor processor;
                if (file.isAccessible() && (processor = JSPModelProcessor.get(file)) != null && !processor.isDisposed) {
                    file.setSessionProperty(SESSION_PROPERTY_JSPMODELPROCESSOR_KEY, null);
                    processor.dispose();
                }
            }
        }
        catch (CoreException ce) {
            Platform.getLog((Bundle)JSFCorePlugin.getDefault().getBundle()).log((IStatus)new Status(4, JSFCorePlugin.getDefault().getBundle().getSymbolicName(), 0, "Problem disposing JSPModelProcessor", new Throwable(ce)));
        }
        catch (IOException ioe) {
            Platform.getLog((Bundle)JSFCorePlugin.getDefault().getBundle()).log((IStatus)new Status(4, JSFCorePlugin.getDefault().getBundle().getSymbolicName(), 0, "Problem disposing JSPModelProcessor", new Throwable(ioe)));
        }
    }

    private JSPModelProcessor(IFile file) throws CoreException, IOException {
        this._model = this.getModelForFile(file);
        this._modelListener = new ModelListener();
        this._model.addModelLifecycleListener((IModelLifecycleListener)this._modelListener);
        this._file = file;
        this._lastModificationStamp = -1L;
    }

    private DOMModelForJSP getModelForFile(IFile file) throws CoreException, IOException {
        IModelManager modelManager = StructuredModelManager.getModelManager();
        IStructuredModel model = modelManager.getModelForRead(file);
        if (model instanceof DOMModelForJSP) {
            return (DOMModelForJSP)model;
        }
        model.releaseFromRead();
        throw new CoreException((IStatus)new Status(4, "org.eclipse.blah", 0, "model not of expected type", new Throwable()));
    }

    private void dispose() {
        if (!this.isDisposed) {
            this._model.releaseFromRead();
            this._model.removeModelLifecycleListener((IModelLifecycleListener)this._modelListener);
            if (this._requestMap != null) {
                this._requestMap.clear();
                this._requestMap = null;
            }
            if (this._sessionMap != null) {
                this._sessionMap.clear();
                this._sessionMap = null;
            }
            if (this._applicationMap != null) {
                this._applicationMap.clear();
                this._applicationMap = null;
            }
            if (this._noneMap != null) {
                this._noneMap.clear();
                this._noneMap = null;
            }
            this.isDisposed = true;
        }
    }

    boolean isDisposed() {
        return this.isDisposed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(boolean forceRefresh) {
        CountingMutex countingMutex = this._lastModificationStampMonitor;
        synchronized (countingMutex) {
            if (this._lastModificationStampMonitor.isSignalled()) {
                return;
            }
            try {
                this._lastModificationStampMonitor.setSignalled(true);
                long currentModificationStamp = this._file.getModificationStamp();
                if (forceRefresh || this._lastModificationStamp != currentModificationStamp) {
                    this.refreshInternal();
                    this._lastModificationStamp = this._file.getModificationStamp();
                }
            }
            finally {
                this._lastModificationStampMonitor.setSignalled(false);
            }
        }
    }

    private void refreshInternal() {
        IStructuredDocumentContext context = IStructuredDocumentContextFactory.INSTANCE.getContext((IDocument)this._model.getStructuredDocument(), -1);
        ITaglibContextResolver taglibResolver = IStructuredDocumentContextResolverFactory.INSTANCE.getTaglibContextResolver(context);
        IDOMDocument document = this._model.getDocument();
        this.getApplicationMap().clear();
        this.getRequestMap().clear();
        this.getSessionMap().clear();
        this.recurseChildNodes(document.getChildNodes(), taglibResolver);
    }

    private void recurseChildNodes(NodeList nodes, ITaglibContextResolver taglibResolver) {
        int i = 0;
        while (i < nodes.getLength()) {
            Node child = nodes.item(i);
            this.processAttributes(child, taglibResolver);
            this.recurseChildNodes(child.getChildNodes(), taglibResolver);
            ++i;
        }
    }

    private void processAttributes(Node node, ITaglibContextResolver taglibResolver) {
        if (taglibResolver.hasTag(node)) {
            String uri = taglibResolver.getTagURIForNodeName(node);
            String elementName = node.getLocalName();
            int i = 0;
            while (i < node.getAttributes().getLength()) {
                Node attribute = node.getAttributes().item(i);
                this.processSymbolContrib(uri, elementName, attribute);
                this.processSetsLocale(uri, elementName, attribute);
                ++i;
            }
        }
    }

    private void processSymbolContrib(String uri, String elementName, Node attribute) {
        SymbolContribAggregator aggregator = SymbolContribAggregator.create(this._file.getProject(), uri, elementName, attribute.getLocalName());
        if (aggregator != null) {
            AbstractContextSymbolFactory factory = aggregator.getFactory();
            String symbolName = attribute.getNodeValue();
            if (factory != null) {
                ArrayList problems = new ArrayList();
                ISymbol symbol = factory.create(symbolName, 1, (IAdaptable)IStructuredDocumentContextFactory.INSTANCE.getContext((IDocument)this._model.getStructuredDocument(), attribute), problems);
                if (symbol != null) {
                    this.updateMap(symbol, aggregator.getScope());
                }
            } else {
                IComponentSymbol componentSymbol = SymbolFactory.eINSTANCE.createIComponentSymbol();
                componentSymbol.setName(symbolName);
                this.updateMap((ISymbol)componentSymbol, aggregator.getScope());
            }
        }
    }

    private void processSetsLocale(String uri, String elementName, Node attribute) {
        DesignTimeApplicationManager dtAppMgr;
        DTFacesContext facesContext;
        LocaleSetAggregator aggregator = LocaleSetAggregator.create(this._file.getProject(), uri, elementName, attribute.getLocalName());
        if (aggregator != null && (facesContext = (dtAppMgr = DesignTimeApplicationManager.getInstance(this._file.getProject())).getFacesContext(this._file)) != null) {
            facesContext.setLocaleString(attribute.getNodeValue());
        }
    }

    public Map getMapForScope(String scopeName) {
        Map map = this.getMapForScopeInternal(scopeName);
        if (map != null) {
            return Collections.unmodifiableMap(map);
        }
        return Collections.EMPTY_MAP;
    }

    private void updateMap(ISymbol symbol, String scopeName) {
        Map map = this.getMapForScopeInternal(scopeName);
        if (map != null) {
            map.put(symbol.getName(), symbol);
        } else {
            Platform.getLog((Bundle)JSFCorePlugin.getDefault().getBundle()).log((IStatus)new Status(4, "org.eclipse.jst.jsf.core", 0, "Scope not found: " + scopeName, new Throwable()));
        }
    }

    private Map getMapForScopeInternal(String scopeName) {
        if ("request".equals(scopeName)) {
            return this.getRequestMap();
        }
        if ("session".equals(scopeName)) {
            return this.getSessionMap();
        }
        if ("application".equals(scopeName)) {
            return this.getApplicationMap();
        }
        if ("none".equals(scopeName)) {
            return this.getNoneMap();
        }
        Platform.getLog((Bundle)JSFCorePlugin.getDefault().getBundle()).log((IStatus)new Status(4, "org.eclipse.jst.jsf.core", 0, "Scope not found: " + scopeName, new Throwable()));
        return null;
    }

    private Map getRequestMap() {
        if (this._requestMap == null) {
            this._requestMap = new SymbolMap();
        }
        return this._requestMap;
    }

    private Map getSessionMap() {
        if (this._sessionMap == null) {
            this._sessionMap = new SymbolMap();
        }
        return this._sessionMap;
    }

    private Map getApplicationMap() {
        if (this._applicationMap == null) {
            this._applicationMap = new SymbolMap();
        }
        return this._applicationMap;
    }

    private Map getNoneMap() {
        if (this._noneMap == null) {
            this._noneMap = new SymbolMap();
        }
        return this._noneMap;
    }

    private static class CountingMutex {
        private boolean _signalled = false;

        private CountingMutex() {
        }

        public synchronized boolean isSignalled() {
            return this._signalled;
        }

        public synchronized void setSignalled(boolean signalled) {
            this._signalled = signalled;
        }
    }

    private static class LocaleSetAggregator {
        private static final String SETS_LOCALE = "sets-locale";

        private LocaleSetAggregator() {
        }

        static LocaleSetAggregator create(IProject project, String uri, String elementName, String attributeName) {
            IMetaDataModelContext mdContext = MetaDataQueryHelper.createTagLibraryDomainMetaDataModelContext((IProject)project, (String)uri);
            Trait trait = MetaDataQueryHelper.getTrait((IMetaDataModelContext)mdContext, (String)(String.valueOf(elementName) + "/" + attributeName), (String)SETS_LOCALE);
            if (TraitValueHelper.getValueAsBoolean((Trait)trait)) {
                return new LocaleSetAggregator();
            }
            return null;
        }
    }

    private class ModelListener
    implements IModelLifecycleListener {
        private ModelListener() {
        }

        public void processPostModelEvent(ModelLifecycleEvent event) {
            if ((event.getType() & 4) != 0 && !JSPModelProcessor.this._model.isDirty()) {
                JSPModelProcessor.this.refresh(false);
            }
        }

        public void processPreModelEvent(ModelLifecycleEvent arg0) {
        }
    }

    private static class SymbolContribAggregator {
        private static final String CONTRIBUTES_VALUE_BINDING = "contributes-value-binding";
        private static final String VALUE_BINDING_SCOPE = "value-binding-scope";
        private static final String VALUE_BINDING_SYMBOL_FACTORY = "value-binding-symbol-factory";
        private final Map _metadata = new HashMap(4);

        static SymbolContribAggregator create(IProject project, String uri, String elementName, String attributeName) {
            String entityKey = String.valueOf(elementName) + "/" + attributeName;
            IMetaDataModelContext mdContext = MetaDataQueryHelper.createTagLibraryDomainMetaDataModelContext((IProject)project, (String)uri);
            Trait trait = MetaDataQueryHelper.getTrait((IMetaDataModelContext)mdContext, (String)entityKey, (String)CONTRIBUTES_VALUE_BINDING);
            boolean contribsValueBindings = TraitValueHelper.getValueAsBoolean((Trait)trait);
            if (contribsValueBindings) {
                String scope = null;
                String symbolFactory = null;
                trait = MetaDataQueryHelper.getTrait((IMetaDataModelContext)mdContext, (String)entityKey, (String)VALUE_BINDING_SCOPE);
                scope = TraitValueHelper.getValueAsString((Trait)trait);
                if (scope != null & !scope.equals("")) {
                    trait = MetaDataQueryHelper.getTrait((IMetaDataModelContext)mdContext, (String)entityKey, (String)VALUE_BINDING_SYMBOL_FACTORY);
                    symbolFactory = TraitValueHelper.getValueAsString((Trait)trait);
                }
                return new SymbolContribAggregator(scope, symbolFactory);
            }
            return null;
        }

        SymbolContribAggregator(String scope, String factory) {
            this._metadata.put("scope", scope);
            this._metadata.put("factory", factory);
        }

        public String getScope() {
            return (String)this._metadata.get("scope");
        }

        public AbstractContextSymbolFactory getFactory() {
            return (AbstractContextSymbolFactory)JSFCommonPlugin.getSymbolFactories().get(this._metadata.get("factory"));
        }
    }
}

