/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.internal.symbols;

import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.internal.tld.LoadBundleUtil;

class ResourceBundleMapSource
extends AbstractMap {
    private static final String PROPERTY_QUALIFIER = "org.eclipse.jst.jsf.designtime.internal.jsp";
    private static final String SESSION_PROPERTY_NAME_PROJECT = "ResourceBundleMapSource";
    private static final QualifiedName SESSION_PROPERTY_KEY_PROJECT = new QualifiedName("org.eclipse.jst.jsf.designtime.internal.jsp", "ResourceBundleMapSource");
    private Properties _resourceBundle;
    private final IFile _bundleFile;
    private long _lastModificationStamp;

    private static IFile getCachedBundleFile(IProject project, String baseName) {
        if (project != null) {
            return (IFile)ResourceBundleMapSource.getBundleFileCache(project).get(baseName);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map getBundleFileCache(IProject project) {
        IProject iProject = project;
        synchronized (iProject) {
            HashMap bundleFileCache = null;
            try {
                bundleFileCache = (HashMap)project.getSessionProperty(SESSION_PROPERTY_KEY_PROJECT);
                if (bundleFileCache == null) {
                    bundleFileCache = new HashMap();
                    project.setSessionProperty(SESSION_PROPERTY_KEY_PROJECT, bundleFileCache);
                }
            }
            catch (CoreException ce) {
                JSFCorePlugin.log("Error creating bundle file cache", ce);
            }
            return bundleFileCache;
        }
    }

    private static IFile createCachedBundleFile(IProject project, String resourcePathStr) throws IOException, JavaModelException, CoreException {
        IStorage storage = LoadBundleUtil.getLoadBundleResource(project, resourcePathStr);
        IFile bundleRes = null;
        if (storage != null && storage.getAdapter(IFile.class) != null) {
            bundleRes = (IFile)storage.getAdapter(IFile.class);
            ResourceBundleMapSource.getBundleFileCache(project).put(resourcePathStr, bundleRes);
            return bundleRes;
        }
        throw new IOException("Bundle " + resourcePathStr + " not found in classpath for project: " + project.getName());
    }

    ResourceBundleMapSource(IProject context, String resourcePathStr) throws IOException, JavaModelException, CoreException {
        IFile cachedBundleFile = ResourceBundleMapSource.getCachedBundleFile(context, resourcePathStr);
        if (cachedBundleFile == null) {
            cachedBundleFile = ResourceBundleMapSource.createCachedBundleFile(context, resourcePathStr);
        }
        this._bundleFile = cachedBundleFile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkAndRefreshBundle() {
        if (this._resourceBundle != null && this._bundleFile.getModificationStamp() == this._lastModificationStamp) return;
        InputStream bundleStream = null;
        try {
            try {
                bundleStream = this._bundleFile.getContents();
                this._resourceBundle = new Properties();
                this._resourceBundle.load(bundleStream);
                this._lastModificationStamp = this._bundleFile.getModificationStamp();
                return;
            }
            catch (CoreException ce) {
                JSFCorePlugin.log("Error refreshing bundle", ce);
                if (bundleStream == null) return;
                try {
                    bundleStream.close();
                    return;
                }
                catch (IOException ioe) {
                    JSFCorePlugin.log("Error closing bundle", ioe);
                }
                return;
            }
            catch (IOException ioe) {
                JSFCorePlugin.log("Error refreshing bundle", ioe);
                if (bundleStream == null) return;
                try {
                    bundleStream.close();
                    return;
                }
                catch (IOException ioe2) {
                    JSFCorePlugin.log("Error closing bundle", ioe2);
                }
                return;
            }
        }
        finally {
            if (bundleStream != null) {
                try {
                    bundleStream.close();
                }
                catch (IOException ioe) {
                    JSFCorePlugin.log("Error closing bundle", ioe);
                }
            }
        }
    }

    public Set entrySet() {
        this.checkAndRefreshBundle();
        return this._resourceBundle.entrySet();
    }

    public Object get(Object key) {
        this.checkAndRefreshBundle();
        return this._resourceBundle.get(key);
    }
}

