/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.internal;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jst.jsf.common.dom.TagIdentifier;
import org.eclipse.jst.jsf.common.internal.types.CompositeType;
import org.eclipse.jst.jsf.common.internal.types.TypeComparator;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.internal.MetaDataModelContextImpl;
import org.eclipse.jst.jsf.common.metadata.query.IMetaDataModelContext;
import org.eclipse.jst.jsf.common.metadata.query.MetaDataQueryHelper;
import org.eclipse.jst.jsf.common.sets.AxiomaticSet;
import org.eclipse.jst.jsf.common.sets.ConcreteAxiomaticSet;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IDOMContextResolver;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.resolver.structureddocument.ITaglibContextResolver;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContextFactory;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.internal.tld.TagIdentifierFactory;
import org.eclipse.jst.jsf.core.set.constraint.MemberConstraint;
import org.eclipse.jst.jsf.core.set.mapping.ElementToTagIdentifierMapping;
import org.eclipse.jst.jsf.core.tagmatcher.EvaluationException;
import org.eclipse.jst.jsf.core.tagmatcher.InvalidExpressionException;
import org.eclipse.jst.jsf.core.tagmatcher.XPathMatchingAlgorithm;
import org.eclipse.jst.jsf.metadataprocessors.MetaDataEnabledProcessingFactory;
import org.eclipse.jst.jsf.metadataprocessors.features.ELIsNotValidException;
import org.eclipse.jst.jsf.metadataprocessors.features.IValidELValues;
import org.eclipse.jst.jsf.metadataprocessors.features.IValidValues;
import org.eclipse.jst.jsf.metadataprocessors.features.IValidationMessage;
import org.eclipse.jst.jsf.validation.internal.ValidationPreferences;
import org.eclipse.jst.jsf.validation.internal.constraints.ContainsTagConstraint;
import org.eclipse.jst.jsf.validation.internal.constraints.TagId;
import org.eclipse.jst.jsf.validation.internal.constraints.TagSet;
import org.eclipse.jst.jsf.validation.internal.el.ELExpressionValidator;
import org.eclipse.jst.jsf.validation.internal.el.diagnostics.DiagnosticFactory;
import org.eclipse.jst.jsf.validation.internal.el.diagnostics.ValidationMessageFactory;
import org.eclipse.jst.jsp.core.internal.domdocument.DOMModelForJSP;
import org.eclipse.jst.jsp.core.internal.validation.JSPValidator;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionCollection;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.ISourceValidator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JSPSemanticsValidator
extends JSPValidator
implements ISourceValidator {
    static final boolean DEBUG;
    private static final ElementToTagIdentifierMapping elem2TagIdMapper;
    private IDocument fDocument;

    static {
        String value = Platform.getDebugOption((String)"org.eclipse.jst.jsf.validation.internal.el/debug/jspsemanticsvalidator");
        DEBUG = value != null && value.equalsIgnoreCase("true");
        elem2TagIdMapper = new ElementToTagIdentifierMapping();
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void validateFile(IFile file, IReporter reporter) {
        model = null;
        if (JSPSemanticsValidator.DEBUG) {
            System.out.println("executing JSPSemanticsValidator.validateFile");
        }
        try {
            try {
                model = StructuredModelManager.getModelManager().getModelForRead(file);
                jspModel = (DOMModelForJSP)model;
                structuredDoc = jspModel.getStructuredDocument();
                curNode = structuredDoc.getFirstStructuredDocumentRegion();
                if (true) ** GOTO lbl15
                do {
                    if (curNode.getFirstRegion().getType() == "XML_TAG_OPEN") {
                        this.validateTag((ITextRegionCollection)curNode, reporter, file, false);
                    }
                    curNode = curNode.getNext();
lbl15:
                    // 2 sources

                    if (curNode == null) return;
                } while (!reporter.isCancelled());
                return;
            }
            catch (CoreException e) {
                JSFCorePlugin.log("Error validating JSF", e);
                if (model == null) return;
                model.releaseFromRead();
                return;
            }
            catch (IOException e) {
                JSFCorePlugin.log("Error validating JSF", e);
                if (model == null) return;
                model.releaseFromRead();
                return;
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    public void validate(IRegion dirtyRegion, IValidationContext helper, IReporter reporter) {
        IStructuredDocument sDoc;
        IStructuredDocumentRegion[] regions;
        if (DEBUG) {
            System.out.println("exec JSPSemanticsValidator.validateRegion");
        }
        if (this.fDocument instanceof IStructuredDocument && (regions = (sDoc = (IStructuredDocument)this.fDocument).getStructuredDocumentRegions(dirtyRegion.getOffset(), dirtyRegion.getLength())) != null) {
            this.validateTag((ITextRegionCollection)regions[0], reporter, this.getFile(helper), true);
        }
    }

    private IFile getFile(IValidationContext helper) {
        String[] uris = helper.getURIs();
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        if (uris.length > 0) {
            return wsRoot.getFile((IPath)new Path(uris[0]));
        }
        return null;
    }

    private void validateTag(ITextRegionCollection container, IReporter reporter, IFile file, boolean isIncremental) {
        ITextRegionCollection containerRegion = container;
        Iterator regions = containerRegion.getRegions().iterator();
        ITextRegion region = null;
        String uri = null;
        String tagName = null;
        String attrName = null;
        while (regions.hasNext() && !reporter.isCancelled()) {
            String attributeVal;
            region = (ITextRegion)regions.next();
            String type = region.getType();
            IDOMContextResolver resolver = null;
            ITaglibContextResolver tagLibResolver = null;
            if (type == null || type != "XML_TAG_NAME" && type != "XML_TAG_ATTRIBUTE_NAME" && type != "XML_TAG_ATTRIBUTE_VALUE") continue;
            IStructuredDocumentContext context = IStructuredDocumentContextFactory.INSTANCE.getContext((IDocument)((IStructuredDocumentRegion)containerRegion).getParentDocument(), containerRegion.getStartOffset() + region.getStart());
            resolver = IStructuredDocumentContextResolverFactory.INSTANCE.getDOMContextResolver(context);
            if (type == "XML_TAG_NAME") {
                tagLibResolver = IStructuredDocumentContextResolverFactory.INSTANCE.getTaglibContextResolver(context);
                Node node = resolver.getNode();
                tagName = resolver.getNode().getLocalName();
                uri = tagLibResolver.getTagURIForNodeName(resolver.getNode());
                if (node instanceof Element && uri != null) {
                    this.validateContainment((Element)node, uri, tagName, reporter, file, context);
                }
                if (!DEBUG) continue;
                System.out.println(String.valueOf(this.addDebugSpacer(1)) + "tagName= " + (tagName != null ? tagName : "null") + ": uri= " + (uri != null ? uri : "null"));
                continue;
            }
            if (type == "XML_TAG_ATTRIBUTE_NAME") {
                attrName = resolver.getNode().getNodeName();
                if (DEBUG) {
                    System.out.println(String.valueOf(this.addDebugSpacer(2)) + "attrName= " + (attrName != null ? attrName : "null"));
                }
                if (uri == null) continue;
                continue;
            }
            if (type != "XML_TAG_ATTRIBUTE_VALUE" || this.checkIfELAndValidate(region, context, uri, tagName, attrName, attributeVal = resolver.getNode().getNodeValue(), isIncremental, reporter, file)) continue;
            if (DEBUG) {
                System.out.println(String.valueOf(this.addDebugSpacer(3)) + "attrVal= " + (attributeVal != null ? attributeVal : "null"));
            }
            if (uri == null || tagName == null || attrName == null) continue;
            this.validateAttributeValue(context, uri, tagName, attrName, attributeVal, reporter, file);
        }
    }

    private boolean checkIfELAndValidate(ITextRegion region, IStructuredDocumentContext context, String uri, String tagName, String attrName, String attrValue, boolean isIncremental, IReporter reporter, IFile file) {
        ITextRegionList regionList;
        ITextRegionCollection parentRegion;
        if (region instanceof ITextRegionCollection && (parentRegion = (ITextRegionCollection)region).getType() == "XML_TAG_ATTRIBUTE_VALUE" && (regionList = parentRegion.getRegions()).size() >= 4) {
            ITextRegion openQuote = regionList.get(0);
            ITextRegion openVBLQuote = regionList.get(1);
            if ((openQuote.getType() == "XML_TAG_ATTRIBUTE_VALUE_DQUOTE" || openQuote.getType() == "XML_TAG_ATTRIBUTE_VALUE_SQUOTE") && openVBLQuote.getType() == "JSP_VBL_OPEN") {
                ITextRegion content = regionList.get(2);
                if (content.getType() == "JSP_VBL_CONTENT") {
                    int contentStart = parentRegion.getStartOffset(content);
                    IStructuredDocumentContext elContext = IStructuredDocumentContextFactory.INSTANCE.getContext(context.getStructuredDocument(), contentStart);
                    String elText = parentRegion.getText(content);
                    if (DEBUG) {
                        System.out.println(String.valueOf(this.addDebugSpacer(3)) + "EL attrVal= " + elText);
                    }
                    if (this.checkShouldValidateEL(isIncremental)) {
                        List elVals = MetaDataEnabledProcessingFactory.getInstance().getAttributeValueRuntimeTypeFeatureProcessors(IValidELValues.class, elContext, uri, tagName, attrName);
                        this.validateELExpression(context, elContext, elVals, attrValue, elText, reporter, file);
                    }
                } else if (content.getType() == "JSP_VBL_CLOSE") {
                    int offset = parentRegion.getStartOffset(openVBLQuote) + 1;
                    reporter.addMessage((IValidator)this, (IMessage)ValidationMessageFactory.createFromDiagnostic(DiagnosticFactory.create_EMPTY_EL_EXPRESSION(), offset, 2, file));
                }
                boolean foundClosingQuote = false;
                int i = 2;
                while (!foundClosingQuote && i < regionList.size()) {
                    ITextRegion searchRegion = regionList.get(i);
                    if (searchRegion.getType() == "JSP_VBL_CLOSE") {
                        foundClosingQuote = true;
                    }
                    ++i;
                }
                if (!foundClosingQuote) {
                    int offset = context.getDocumentPosition() + 1;
                    int length = parentRegion.getText().length();
                    reporter.addMessage((IValidator)this, (IMessage)ValidationMessageFactory.createFromDiagnostic(DiagnosticFactory.create_MISSING_CLOSING_EXPR_BRACKET(), offset, length, file));
                }
                return true;
            }
        }
        return false;
    }

    private void validateELExpression(IStructuredDocumentContext context, IStructuredDocumentContext elContext, List elVals, String attributeVal, String elText, IReporter reporter, IFile file) {
        ELExpressionValidator elValidator = new ELExpressionValidator(elContext, elText, file);
        elValidator.validateXMLNode();
        elValidator.reportFindings((IValidator)this, reporter);
        CompositeType exprType = elValidator.getExpressionType();
        if (exprType != null) {
            for (IValidELValues elval : elVals) {
                IMessage message = null;
                try {
                    Diagnostic status;
                    CompositeType expectedType = elval.getExpectedRuntimeType();
                    if (expectedType != null && (status = TypeComparator.calculateTypeCompatibility((CompositeType)expectedType, (CompositeType)exprType)).getSeverity() != 0) {
                        message = this.createValidationMessage(context, attributeVal, this.getSeverity(status.getSeverity()), status.getMessage(), file);
                    }
                }
                catch (ELIsNotValidException e) {
                    message = this.createValidationMessage(context, attributeVal, 2, e.getMessage(), file);
                }
                if (message == null) continue;
                reporter.addMessage((IValidator)this, message);
            }
        }
    }

    private void validateAttributeValue(IStructuredDocumentContext context, String uri, String tagName, String attrName, String attributeVal, IReporter reporter, IFile file) {
        List vv = MetaDataEnabledProcessingFactory.getInstance().getAttributeValueRuntimeTypeFeatureProcessors(IValidValues.class, context, uri, tagName, attrName);
        if (!vv.isEmpty()) {
            for (IValidValues v : vv) {
                if (attributeVal == null) {
                    attributeVal = "";
                }
                if (!v.isValidValue(attributeVal.trim())) {
                    if (DEBUG) {
                        System.out.println(String.valueOf(this.addDebugSpacer(4)) + "NOT VALID ");
                    }
                    for (IValidationMessage msg : v.getValidationMessages()) {
                        IMessage message = this.createValidationMessage(context, attributeVal, this.getSeverity(msg.getSeverity()), msg.getMessage(), file);
                        if (message == null) continue;
                        reporter.addMessage((IValidator)this, message);
                    }
                    continue;
                }
                if (!DEBUG) continue;
                System.out.println(String.valueOf(this.addDebugSpacer(5)) + "VALID ");
            }
        } else if (DEBUG) {
            System.out.println(String.valueOf(this.addDebugSpacer(4)) + "NO META DATA ");
        }
    }

    private IMessage createValidationMessage(IStructuredDocumentContext context, String attributeValue, int severity, String msg, IFile file) {
        JSPValidator.LocalizedMessage message = new JSPValidator.LocalizedMessage((JSPValidator)this, severity, msg, (IResource)file);
        if (message != null) {
            int start = context.getDocumentPosition() + 1;
            int length = attributeValue.length();
            int lineNo = 0;
            try {
                lineNo = context.getStructuredDocument().getLineOfOffset(start);
            }
            catch (BadLocationException badLocationException) {}
            message.setLineNo(lineNo);
            message.setOffset(start);
            message.setLength(length);
        }
        return message;
    }

    private int getSeverity(int severity) {
        switch (severity) {
            case 4: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 1: {
                return 4;
            }
        }
        return 2;
    }

    public void connect(IDocument document) {
        this.fDocument = document;
    }

    public void disconnect(IDocument document) {
    }

    private String addDebugSpacer(int count) {
        String TAB = "\t";
        StringBuffer ret = new StringBuffer("");
        int i = 0;
        while (i <= count) {
            ret.append(TAB);
            ++i;
        }
        return ret.toString();
    }

    private boolean checkShouldValidateEL(boolean isIncremental) {
        ValidationPreferences prefs = new ValidationPreferences();
        prefs.load();
        if (isIncremental) {
            return prefs.getElPrefs().isEnableIncrementalValidation();
        }
        return prefs.getElPrefs().isEnableBuildValidation();
    }

    private void validateContainment(Element node, String uri, String tagName, IReporter reporter, IFile file, IStructuredDocumentContext context) {
        Trait trait;
        MetaDataModelContextImpl modelContext = new MetaDataModelContextImpl(file.getProject(), "TagLibraryDomain", uri);
        Entity entity = MetaDataQueryHelper.getEntity((IMetaDataModelContext)modelContext, (String)tagName);
        if (entity != null && (trait = MetaDataQueryHelper.getTrait((Entity)entity, (String)"containment-constraint")) != null) {
            ContainsTagConstraint tagConstraint = (ContainsTagConstraint)trait.getValue();
            String algorithm = tagConstraint.getSetGenerator().getAlgorithm();
            if (!"xpath".equals(algorithm)) {
                return;
            }
            String expr = tagConstraint.getSetGenerator().getExpression();
            XPathMatchingAlgorithm xpathAlg = new XPathMatchingAlgorithm(expr);
            AxiomaticSet set = null;
            try {
                set = xpathAlg.evaluate(node);
                set = elem2TagIdMapper.map(set);
            }
            catch (InvalidExpressionException e) {
                JSFCorePlugin.log(e, "Problem with expression: " + expr + " on node " + node);
                return;
            }
            catch (EvaluationException e) {
                JSFCorePlugin.log(e, "Problem evaluating expression: " + expr + " on node " + node);
                return;
            }
            TagSet constraintData = tagConstraint.getSatisfiesSet();
            ConcreteAxiomaticSet constraintSet = new ConcreteAxiomaticSet();
            for (TagId tagId : constraintData.getTags()) {
                constraintSet.add((Object)TagIdentifierFactory.createJSPTagWrapper(tagId.getUri(), tagId.getName()));
            }
            MemberConstraint memberConstraint = new MemberConstraint((AxiomaticSet)constraintSet);
            Diagnostic diag = memberConstraint.isSatisfied(set);
            if (diag.getSeverity() != 0) {
                List data = diag.getData();
                for (TagIdentifier missingParent : data) {
                    IMessage message = this.createTagValidationMessage(context, node.getNodeName(), 2, MessageFormat.format("Tag {0} is missing required parent tag \"{1}\" ({2})", node.getNodeName(), missingParent.getTagName(), missingParent.getUri()), file);
                    reporter.addMessage((IValidator)this, message);
                }
            }
        }
    }

    private IMessage createTagValidationMessage(IStructuredDocumentContext context, String attributeValue, int severity, String msg, IFile file) {
        JSPValidator.LocalizedMessage message = new JSPValidator.LocalizedMessage((JSPValidator)this, severity, msg, (IResource)file);
        int start = context.getDocumentPosition();
        int length = attributeValue.length();
        message.setOffset(start);
        message.setLength(length);
        return message;
    }
}

