/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.internal.el.operators;

import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jst.jsf.common.internal.types.ValueType;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IWorkspaceContextResolver;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.core.jsfappconfig.JSFAppConfigUtils;
import org.eclipse.jst.jsf.validation.internal.el.operators.AddArithmeticBinaryOperator;
import org.eclipse.jst.jsf.validation.internal.el.operators.AndBinaryOperator;
import org.eclipse.jst.jsf.validation.internal.el.operators.DivArithmeticBinaryOperator;
import org.eclipse.jst.jsf.validation.internal.el.operators.EqualsBinaryRelationalOperator;
import org.eclipse.jst.jsf.validation.internal.el.operators.GreaterThanEqRelationalBinaryOperator;
import org.eclipse.jst.jsf.validation.internal.el.operators.GreaterThanRelationalBinaryOperator;
import org.eclipse.jst.jsf.validation.internal.el.operators.LessThanEqRelationalBinaryOperator;
import org.eclipse.jst.jsf.validation.internal.el.operators.LessThanRelationalBinaryOperator;
import org.eclipse.jst.jsf.validation.internal.el.operators.ModArithmeticBinaryOperator;
import org.eclipse.jst.jsf.validation.internal.el.operators.MultiplyArithmeticBinaryOperator;
import org.eclipse.jst.jsf.validation.internal.el.operators.NotEqualsBinaryRelationalOperator;
import org.eclipse.jst.jsf.validation.internal.el.operators.OrBinaryOperator;
import org.eclipse.jst.jsf.validation.internal.el.operators.SubtractArithmeticBinaryOperator;
import org.eclipse.jst.jsp.core.internal.java.jspel.Token;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public abstract class BinaryOperator {
    public static BinaryOperator getBinaryOperator(Token operatorToken, IStructuredDocumentContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Context must not be null");
        }
        String facetVersion = BinaryOperator.determineJSFVersion(context);
        switch (operatorToken.kind) {
            case 41: 
            case 42: {
                return new AndBinaryOperator();
            }
            case 43: 
            case 44: {
                return new OrBinaryOperator();
            }
            case 18: 
            case 19: {
                return new EqualsBinaryRelationalOperator(facetVersion);
            }
            case 24: 
            case 25: {
                return new NotEqualsBinaryRelationalOperator(facetVersion);
            }
            case 14: 
            case 15: {
                return new GreaterThanRelationalBinaryOperator(facetVersion);
            }
            case 22: 
            case 23: {
                return new GreaterThanEqRelationalBinaryOperator(facetVersion);
            }
            case 16: 
            case 17: {
                return new LessThanRelationalBinaryOperator(facetVersion);
            }
            case 20: 
            case 21: {
                return new LessThanEqRelationalBinaryOperator(facetVersion);
            }
            case 32: {
                return new AddArithmeticBinaryOperator();
            }
            case 33: {
                return new SubtractArithmeticBinaryOperator();
            }
            case 34: {
                return new MultiplyArithmeticBinaryOperator();
            }
            case 35: 
            case 36: {
                return new DivArithmeticBinaryOperator();
            }
            case 37: 
            case 38: {
                return new ModArithmeticBinaryOperator();
            }
        }
        throw new IllegalArgumentException("Unknown binary operator: " + operatorToken.image);
    }

    BinaryOperator() {
    }

    public abstract ValueType performOperation(ValueType var1, ValueType var2);

    public abstract Diagnostic validate(ValueType var1, ValueType var2);

    private static String determineJSFVersion(IStructuredDocumentContext context) {
        IWorkspaceContextResolver wkResolver = IStructuredDocumentContextResolverFactory.INSTANCE.getWorkspaceContextResolver(context);
        IProject project = wkResolver.getProject();
        IProjectFacetVersion projectVersion = JSFAppConfigUtils.getProjectFacet(project);
        if (projectVersion != null) {
            return projectVersion.getVersionString();
        }
        return null;
    }
}

