/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.webservice;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.j2ee.internal.webservice.NewProjectsListener;
import org.eclipse.jst.j2ee.internal.webservice.WebServiceNavigatorGroup;
import org.eclipse.jst.j2ee.internal.webservice.WebServiceNavigatorGroupType;
import org.eclipse.jst.j2ee.internal.webservice.WebServiceViewerSynchronization;
import org.eclipse.jst.j2ee.internal.webservice.helper.WebServicesManager;
import org.eclipse.jst.j2ee.internal.webservices.WSDLServiceExtManager;
import org.eclipse.jst.j2ee.webservice.wsclient.ServiceRef;
import org.eclipse.jst.j2ee.webservice.wsdd.Handler;
import org.eclipse.jst.j2ee.webservice.wsdd.PortComponent;
import org.eclipse.wst.common.internal.emfworkbench.integration.DynamicAdapterFactory;

public class WebServicesNavigatorContentProvider
extends AdapterFactoryContentProvider {
    private static final Object[] NO_CHILDREN = new Object[0];
    private WebServicesManager webServicesManager = null;
    private WebServiceNavigatorGroup webServiceNavigatorGroup;
    private WebServiceNavigatorGroupType SERVICES = null;
    private WebServiceNavigatorGroupType CLIENTS = null;
    private HashMap HANDLERS = new HashMap();
    private TreeViewer viewer = null;
    private WebServiceViewerSynchronization viewerSynchronization = new WebServiceViewerSynchronization(this);
    private NewProjectsListener projectListener = new NewProjectsListener(this.viewerSynchronization);

    public WebServicesNavigatorContentProvider() {
        super(WebServicesNavigatorContentProvider.createAdapterFactory());
    }

    public void dispose() {
        super.dispose();
        this.projectListener.dispose();
    }

    public static AdapterFactory createAdapterFactory() {
        return new DynamicAdapterFactory("org.eclipse.ui.navigator.ProjectExplorer");
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IWorkspaceRoot) {
            this.viewerSynchronization.setNavigatorGroupAdded(true);
            return new Object[]{this.getNavigatorGroup()};
        }
        if (parentElement instanceof WebServiceNavigatorGroup) {
            if (!this.viewerSynchronization.hasIndexJobBeenScheduled()) {
                this.viewerSynchronization.startIndexJob();
            }
            return new Object[]{this.getServicesGroup(), this.getClientsGroup()};
        }
        if (parentElement instanceof WebServiceNavigatorGroupType) {
            if (!this.viewerSynchronization.hasIndexJobBeenScheduled()) {
                this.viewerSynchronization.startIndexJob();
            }
            WebServiceNavigatorGroupType wsGroupType = (WebServiceNavigatorGroupType)parentElement;
            return wsGroupType.getChildren();
        }
        if (WSDLServiceExtManager.getServiceHelper().isService(parentElement)) {
            return this.getServiceLevelNodes(parentElement).toArray();
        }
        if (parentElement instanceof ServiceRef) {
            return new Object[]{this.getHandlersGroup(parentElement)};
        }
        if (parentElement instanceof Handler || parentElement instanceof org.eclipse.jst.j2ee.webservice.wsclient.Handler || WSDLServiceExtManager.getServiceHelper().isWSDLResource(parentElement)) {
            return NO_CHILDREN;
        }
        return super.getChildren(parentElement);
    }

    private List getServiceLevelNodes(Object parentElement) {
        Resource wsdl;
        ArrayList<Object> result = new ArrayList<Object>();
        if (this.getWebServicesManager().isServiceInternal((EObject)parentElement) && this.getWebServicesManager().getServiceImplBean((EObject)parentElement) != null) {
            result.add(this.getWebServicesManager().getServiceImplBean((EObject)parentElement));
        }
        if (this.getWebServicesManager().isServiceInternal((EObject)parentElement)) {
            result.add(this.getHandlersGroup(parentElement));
        }
        if ((wsdl = this.getWebServicesManager().getWSDLResource((EObject)parentElement)) != null) {
            result.add(wsdl);
        }
        return result;
    }

    public Object getParent(Object element) {
        if (element instanceof IWorkspaceRoot) {
            return null;
        }
        if (element instanceof WebServiceNavigatorGroup) {
            return ((WebServiceNavigatorGroup)element).getRoot();
        }
        return super.getParent(element);
    }

    public boolean hasChildren(Object element) {
        return true;
    }

    public void inputChanged(Viewer aViewer, Object oldInput, Object newInput) {
        if (aViewer != null && aViewer instanceof TreeViewer) {
            this.viewer = (TreeViewer)aViewer;
        }
        super.inputChanged(aViewer, oldInput, newInput);
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public WebServiceNavigatorGroup getNavigatorGroup() {
        if (this.webServiceNavigatorGroup == null) {
            this.webServiceNavigatorGroup = new WebServiceNavigatorGroup(ResourcesPlugin.getWorkspace().getRoot());
        }
        return this.webServiceNavigatorGroup;
    }

    protected WebServicesManager getWebServicesManager() {
        if (this.webServicesManager == null) {
            this.webServicesManager = WebServicesManager.getInstance();
        }
        return this.webServicesManager;
    }

    private WebServiceNavigatorGroupType getServicesGroup() {
        if (this.SERVICES == null) {
            this.SERVICES = new WebServiceNavigatorGroupType(0, this.getAdapterFactory());
        }
        return this.SERVICES;
    }

    private WebServiceNavigatorGroupType getClientsGroup() {
        if (this.CLIENTS == null) {
            this.CLIENTS = new WebServiceNavigatorGroupType(2, this.getAdapterFactory());
        }
        return this.CLIENTS;
    }

    private WebServiceNavigatorGroupType getHandlersGroup(Object key) {
        if (key == null) {
            return null;
        }
        WebServiceNavigatorGroupType handler = null;
        handler = (WebServiceNavigatorGroupType)this.HANDLERS.get(key);
        if (handler == null) {
            if (WSDLServiceExtManager.getServiceHelper().isService(key)) {
                handler = new WebServiceNavigatorGroupType(3, (EObject)key, this.getAdapterFactory());
            } else if (key instanceof ServiceRef) {
                handler = new WebServiceNavigatorGroupType(3, (ServiceRef)key, this.getAdapterFactory());
            }
            if (handler != null) {
                this.HANDLERS.put(key, handler);
            }
        }
        return handler;
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public void notifyChanged(Notification notification) {
        if (notification.getNotifier() instanceof ServiceRef) {
            switch (notification.getFeatureID(ServiceRef.class)) {
                case 12: {
                    WebServiceNavigatorGroupType handlersGroup = this.getHandlersGroup(notification.getNotifier());
                    if (handlersGroup != null) {
                        switch (notification.getEventType()) {
                            case 3: {
                                this.viewer.add((Object)handlersGroup, notification.getNewValue());
                                break;
                            }
                            case 5: {
                                this.viewer.add((Object)handlersGroup, ((Collection)notification.getNewValue()).toArray());
                                break;
                            }
                            case 4: {
                                this.viewer.remove(notification.getOldValue());
                                break;
                            }
                            case 6: {
                                this.viewer.remove(((Collection)notification.getOldValue()).toArray());
                            }
                        }
                    }
                    return;
                }
            }
        } else if (notification.getNotifier() instanceof PortComponent) {
            switch (notification.getFeatureID(PortComponent.class)) {
                case 8: {
                    WebServiceNavigatorGroupType handlersGroup;
                    PortComponent pComp = (PortComponent)notification.getNotifier();
                    EObject service = this.getWebServicesManager().getService(pComp);
                    if (service != null && (handlersGroup = this.getHandlersGroup(service)) != null) {
                        switch (notification.getEventType()) {
                            case 3: {
                                this.viewer.add((Object)handlersGroup, notification.getNewValue());
                                break;
                            }
                            case 5: {
                                this.viewer.add((Object)handlersGroup, ((Collection)notification.getNewValue()).toArray());
                                break;
                            }
                            case 4: {
                                this.viewer.remove(notification.getOldValue());
                                break;
                            }
                            case 6: {
                                this.viewer.remove(((Collection)notification.getOldValue()).toArray());
                            }
                        }
                    }
                    return;
                }
            }
        }
        super.notifyChanged(notification);
    }
}

