/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.archive;

import java.io.IOException;
import java.util.List;
import org.eclipse.jst.jee.archive.AbstractArchiveAdapter;
import org.eclipse.jst.jee.archive.ArchiveSaveFailureException;
import org.eclipse.jst.jee.archive.IArchiveResource;
import org.eclipse.jst.jee.archive.IArchiveSaveAdapter;

public abstract class AbstractArchiveSaveAdapter
extends AbstractArchiveAdapter
implements IArchiveSaveAdapter {
    public void close() throws IOException {
    }

    public void finish() throws IOException {
    }

    public void save() throws ArchiveSaveFailureException {
        try {
            List<IArchiveResource> files = this.getArchive().getArchiveResources();
            IArchiveResource file = null;
            int i = 0;
            while (i < files.size()) {
                file = files.get(i);
                if (this.shouldSave(file)) {
                    this.save(file);
                }
                ++i;
            }
        }
        finally {
            try {
                this.finish();
            }
            catch (IOException e) {
                throw new ArchiveSaveFailureException(e);
            }
        }
    }

    protected abstract void save(IArchiveResource var1) throws ArchiveSaveFailureException;

    protected boolean shouldSave(IArchiveResource file) {
        return true;
    }
}

