/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.application.internal.operations;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.application.internal.operations.ClasspathElement;
import org.eclipse.jst.j2ee.classpathdep.ClasspathDependencyUtil;
import org.eclipse.jst.j2ee.classpathdep.IClasspathDependencyConstants;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Container;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ManifestException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.CommonarchiveFactoryImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.ZipFileLoadStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.componentcore.J2EEModuleVirtualComponent;
import org.eclipse.jst.j2ee.componentcore.util.EARArtifactEdit;
import org.eclipse.jst.j2ee.internal.archive.operations.ComponentLoadStrategyImpl;
import org.eclipse.jst.j2ee.internal.archive.operations.EARComponentLoadStrategyImpl;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.UnresolveableURIException;
import org.eclipse.wst.common.componentcore.internal.impl.ModuleURIUtil;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualArchiveComponent;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public class ClassPathSelection {
    protected Archive archive;
    protected IProject earProject;
    protected IVirtualComponent earComponent;
    protected List classpathElements;
    protected Map urisToElements;
    protected boolean modified;
    private String targetProjectName;
    protected Map ejbToClientJARs = null;
    protected Map clientToEJBJARs = null;
    public static final int FILTER_EJB_SERVER_JARS = 0;
    public static final int FILTER_EJB_CLIENT_JARS = 1;
    public static final int FILTER_NONE = 2;
    protected int filterLevel = 2;
    protected static Comparator comparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            Archive a1 = (Archive)o1;
            Archive a2 = (Archive)o2;
            return a1.getURI().compareTo(a2.getURI());
        }
    };

    public ClassPathSelection(Archive anArchive, String targetProjectName, EARFile earFile) {
        this.archive = anArchive;
        this.targetProjectName = targetProjectName;
        this.initializeEARProject(earFile);
        this.initializeElements();
    }

    public ClassPathSelection(Archive anArchive, EARFile earFile) {
        this.archive = anArchive;
        this.initializeEARProject(earFile);
        this.initializeElements();
    }

    public ClassPathSelection() {
    }

    protected ClasspathElement createElement(Archive referencingArchive, Archive referencedArchive, String cpEntry) {
        ClasspathElement element = new ClasspathElement(referencingArchive);
        element.setValid(true);
        String uriString = referencedArchive.getURI();
        URI uri = URI.createURI((String)uriString);
        boolean hasAbsolutePath = uri.hasAbsolutePath();
        if (hasAbsolutePath) {
            uriString = uri.lastSegment();
        }
        element.setText(uriString);
        element.setTargetArchive(referencedArchive);
        element.setEarProject(this.earProject);
        if (this.earComponent != null) {
            IContainer earConentFolder = this.earComponent.getRootFolder().getUnderlyingFolder();
            if (earConentFolder.getType() == 2) {
                element.setEarContentFolder(earConentFolder.getName());
            } else {
                element.setEarContentFolder("");
            }
        }
        this.setProjectValues(element, referencedArchive);
        if (cpEntry != null) {
            element.setValuesSelected(cpEntry);
        }
        this.setType(element, referencedArchive);
        return element;
    }

    protected ClasspathElement createInvalidElement(String cpEntry) {
        ClasspathElement element = new ClasspathElement(this.archive);
        element.setValid(false);
        element.setSelected(true);
        element.setRelativeText(cpEntry);
        element.setText(cpEntry);
        element.setEarProject(this.earProject);
        this.setInvalidProject(element);
        return element;
    }

    public ClasspathElement createProjectElement(IProject project) {
        ClasspathElement element = new ClasspathElement(project);
        element.setValid(true);
        element.setSelected(true);
        element.setText(project.getName());
        element.setProject(project);
        this.addClasspathElement(element, element.getProjectName());
        return element;
    }

    public ClasspathElement createProjectElement(IProject project, boolean existingEntry) {
        ClasspathElement element = new ClasspathElement(project);
        element.setValid(true);
        element.setSelected(existingEntry);
        element.setText(project.getName());
        element.setProject(project);
        this.addClasspathElement(element, element.getProjectName());
        return element;
    }

    public ClasspathElement createArchiveElement(URI uri, String name, String cpEntry) {
        ClasspathElement element = new ClasspathElement(uri);
        element.setValid(false);
        element.setRelativeText(name);
        if (cpEntry != null) {
            element.setValuesSelected(cpEntry);
        }
        element.setText(name);
        element.setEarProject(this.earProject);
        return element;
    }

    public void buildClasspathComponentDependencyMap(IVirtualComponent comp, Map pathToComp) {
        if (comp != null && comp instanceof J2EEModuleVirtualComponent) {
            J2EEModuleVirtualComponent j2eeComp = (J2EEModuleVirtualComponent)comp;
            IVirtualReference[] cpRefs = j2eeComp.getJavaClasspathReferences();
            int i = 0;
            while (i < cpRefs.length) {
                if (cpRefs[i].getRuntimePath().equals((Object)IClasspathDependencyConstants.RUNTIME_MAPPING_INTO_CONTAINER_PATH)) {
                    IVirtualComponent referencedComponent = cpRefs[i].getReferencedComponent();
                    IPath path = ClasspathDependencyUtil.getClasspathVirtualReferenceLocation(cpRefs[i]);
                    IVirtualComponent existingComp = (IVirtualComponent)pathToComp.get(path);
                    if (existingComp != null) {
                        if (existingComp instanceof VirtualArchiveComponent) {
                            VirtualArchiveComponent oldComp = (VirtualArchiveComponent)existingComp;
                            VirtualArchiveComponent newComp = ClassPathSelection.updateDisplayVirtualArchiveComponent(oldComp, cpRefs[i]);
                            pathToComp.put(path, newComp);
                        }
                    } else {
                        pathToComp.put(path, referencedComponent);
                    }
                }
                ++i;
            }
        }
    }

    public static VirtualArchiveComponent updateDisplayVirtualArchiveComponent(VirtualArchiveComponent oldComp, IVirtualReference newRef) {
        String newProjName = String.valueOf(oldComp.getProject().getName()) + " " + newRef.getReferencedComponent().getProject().getName();
        IProject newProj = ResourcesPlugin.getWorkspace().getRoot().getProject(newProjName);
        VirtualArchiveComponent newComponent = (VirtualArchiveComponent)ComponentCore.createArchiveComponent((IProject)newProj, (String)oldComp.getName());
        return newComponent;
    }

    public ClasspathElement[] createClasspathEntryElements(IVirtualComponent comp, IPath targetRuntimePath) throws CoreException {
        IProject project;
        ArrayList elements = new ArrayList();
        if (comp != null && comp.getProject().isAccessible() && (project = comp.getProject()).hasNature("org.eclipse.jdt.core.javanature")) {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            boolean isWebApp = J2EEProjectUtilities.isDynamicWebProject(project);
            Map taggedEntries = ClasspathDependencyUtil.getRawComponentClasspathDependencies(javaProject);
            for (IClasspathEntry entry : taggedEntries.keySet()) {
                IClasspathAttribute attrib = (IClasspathAttribute)taggedEntries.get(entry);
                IPath runtimePath = ClasspathDependencyUtil.getRuntimePath(attrib, isWebApp);
                if (runtimePath != null && !runtimePath.equals((Object)targetRuntimePath)) continue;
                ClasspathElement element = this.createClasspathElementForEntry(project, entry);
                element.setSelected(true);
                this.addClasspathElement(element, element.getArchiveURI().toString());
            }
            List potentialEntries = ClasspathDependencyUtil.getPotentialComponentClasspathDependencies(javaProject);
            for (IClasspathEntry entry : potentialEntries) {
                ClasspathElement element = this.createClasspathElementForEntry(project, entry);
                element.setSelected(false);
                this.addClasspathElement(element, element.getArchiveURI().toString());
            }
        }
        return elements.toArray(new ClasspathElement[elements.size()]);
    }

    private ClasspathElement createClasspathElementForEntry(IProject project, IClasspathEntry entry) {
        IPath entryPath = entry.getPath();
        URI archiveURI = URI.createURI((String)entryPath.toString());
        int kind = entry.getEntryKind();
        String elementName = entryPath.toString();
        if (kind == 5) {
            try {
                IClasspathContainer container = JavaCore.getClasspathContainer((IPath)entryPath, (IJavaProject)JavaCore.create((IProject)project));
                if (container != null) {
                    elementName = container.getDescription();
                }
            }
            catch (CoreException coreException) {}
        }
        ClasspathElement element = this.createClasspathEntryElement(project, archiveURI, elementName, entry);
        return element;
    }

    private void setInvalidProject(ClasspathElement element) {
        IProject earProj = element.getEarProject();
        IVirtualComponent component = ComponentUtilities.getComponent((String)earProj.getName());
        EARArtifactEdit edit = null;
        try {
            IVirtualComponent modComponent;
            String moduleName;
            edit = EARArtifactEdit.getEARArtifactEditForRead(component);
            if (edit != null && (moduleName = element.getRelativeText()) != null && (modComponent = edit.getModule(moduleName)) != null) {
                IProject mappedProject = modComponent.getProject();
                element.setProject(mappedProject);
            }
        }
        finally {
            if (edit != null) {
                edit.dispose();
                edit = null;
            }
        }
    }

    public List getClasspathElements() {
        if (this.classpathElements == null) {
            this.classpathElements = new ArrayList();
        }
        return this.classpathElements;
    }

    public List getSelectedClasspathElements() {
        ArrayList<ClasspathElement> list = new ArrayList<ClasspathElement>();
        for (ClasspathElement element : this.getClasspathElements()) {
            if (!element.isSelected()) continue;
            list.add(element);
        }
        return list;
    }

    protected IClasspathEntry[] getClasspathEntries(boolean filterSelected) {
        ArrayList<IClasspathEntry> result = new ArrayList<IClasspathEntry>();
        IClasspathEntry[] array = null;
        ClasspathElement element = null;
        if (this.classpathElements != null) {
            int i = 0;
            while (i < this.classpathElements.size()) {
                element = (ClasspathElement)this.classpathElements.get(i);
                if ((!filterSelected || element.isSelected()) && (array = ((ClasspathElement)this.classpathElements.get(i)).newClasspathEntries()) != null) {
                    int j = 0;
                    while (j < array.length) {
                        if (!result.contains(array[j])) {
                            result.add(array[j]);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            return result.toArray(new IClasspathEntry[result.size()]);
        }
        return null;
    }

    public IClasspathEntry[] getClasspathEntriesForAll() {
        return this.getClasspathEntries(false);
    }

    public IClasspathEntry[] getClasspathEntriesForSelected() {
        return this.getClasspathEntries(true);
    }

    protected EARFile getEARFile() {
        if (this.archive == null) {
            return null;
        }
        Container parent = this.archive.getContainer();
        if (parent != null && parent.isEARFile()) {
            return (EARFile)parent;
        }
        return null;
    }

    protected static IProject getEARProject(Archive anArchive) {
        Container c = anArchive.getContainer();
        if (!c.isEARFile()) {
            return null;
        }
        EARFile ear = (EARFile)c;
        LoadStrategy loader = ear.getLoadStrategy();
        if (!(loader instanceof EARComponentLoadStrategyImpl)) {
            return null;
        }
        return ((EARComponentLoadStrategyImpl)loader).getComponent().getProject();
    }

    public Archive getArchive() {
        return this.archive;
    }

    protected IProject getProject(Archive anArchive) {
        IVirtualComponent comp = this.getComponent(anArchive);
        if (comp != null) {
            return comp.getProject();
        }
        return null;
    }

    protected IVirtualComponent getComponent(Archive anArchive) {
        LoadStrategy loader = anArchive.getLoadStrategy();
        if (loader instanceof ComponentLoadStrategyImpl) {
            return ((ComponentLoadStrategyImpl)loader).getComponent();
        }
        return null;
    }

    public String getText() {
        return this.archive.getURI();
    }

    protected Archive getArchive(String uri, List archives) {
        int i = 0;
        while (i < archives.size()) {
            Archive anArchive = (Archive)archives.get(i);
            String archiveURIString = anArchive.getURI();
            URI archiveURI = URI.createURI((String)archiveURIString);
            boolean hasAbsolutePath = archiveURI.hasAbsolutePath();
            if (hasAbsolutePath) {
                archiveURIString = archiveURI.lastSegment();
            }
            if (archiveURIString.equals(uri)) {
                return anArchive;
            }
            ++i;
        }
        return null;
    }

    protected void initializeElements() {
        this.ejbToClientJARs = J2EEProjectUtilities.collectEJBClientJARs(this.getEARFile());
        this.clientToEJBJARs = this.reverse(this.ejbToClientJARs);
        this.classpathElements = new ArrayList();
        this.urisToElements = new HashMap();
        String[] cp = new String[]{};
        try {
            cp = this.archive.getManifest().getClassPathTokenized();
        }
        catch (ManifestException ex) {
            Logger.getLogger().logError((Throwable)ex);
        }
        List archives = this.getEARFile().getArchiveFiles();
        ClasspathElement element = null;
        Archive other = null;
        int i = 0;
        while (i < cp.length) {
            String cpEntry = cp[i];
            String uri = ArchiveUtil.deriveEARRelativeURI((String)cpEntry, (Archive)this.archive);
            other = this.getArchive(uri, archives);
            if (other != null && ArchiveUtil.isValidDependency((Archive)other, (Archive)this.archive)) {
                element = this.createElement(this.archive, other, cpEntry);
                archives.remove(other);
            } else {
                String projectName;
                IProject project;
                int index;
                element = this.createInvalidElement(cpEntry);
                if (element.representsImportedJar()) {
                    element.setValid(true);
                    element.setProject(this.getProject(this.archive));
                }
                if (other != null) {
                    element.setProject(this.getProject(other));
                }
                if (other == null && element.getProject() == null && (index = cpEntry.indexOf(".jar")) > 0 && (project = ProjectUtilities.getProject((String)(projectName = cpEntry.substring(0, index)))) != null && project.exists()) {
                    element.setProject(project);
                }
            }
            this.addClasspathElement(element, uri);
            ++i;
        }
        IVirtualComponent comp = this.getComponent(this.archive);
        try {
            this.createClasspathEntryElements(comp, IClasspathDependencyConstants.RUNTIME_MAPPING_INTO_CONTAINER_PATH);
        }
        catch (CoreException ce) {
            Logger.getLogger((String)"org.eclipse.jst.j2ee").logError((Throwable)ce);
        }
        Collections.sort(archives, comparator);
        int i2 = 0;
        while (i2 < archives.size()) {
            other = (Archive)archives.get(i2);
            if (other != this.archive && ArchiveUtil.isValidDependency((Archive)other, (Archive)this.archive)) {
                IProject project = this.getProject(other);
                if (this.targetProjectName == null || project == null || !project.getName().equals(this.targetProjectName)) {
                    element = this.createElement(this.archive, other, null);
                    element.setProject(this.getProject(other));
                    this.addClasspathElement(element, other.getURI());
                }
            }
            ++i2;
        }
        if (this.earComponent != null) {
            IVirtualReference[] newrefs = this.earComponent.getReferences();
            int i3 = 0;
            while (i3 < newrefs.length) {
                IVirtualReference ref = newrefs[i3];
                IVirtualComponent referencedComponent = ref.getReferencedComponent();
                boolean isBinary = referencedComponent.isBinary();
                if (isBinary) {
                    String unresolvedURI = ref.getArchiveName();
                    if (unresolvedURI == null) {
                        try {
                            unresolvedURI = ModuleURIUtil.getArchiveName((URI)URI.createURI((String)ModuleURIUtil.getHandleString((IVirtualComponent)referencedComponent)));
                        }
                        catch (UnresolveableURIException e) {
                            e.printStackTrace();
                        }
                    }
                    if (unresolvedURI != null) {
                        URI archiveURI = URI.createURI((String)unresolvedURI);
                        boolean alreadyInList = false;
                        for (ClasspathElement tmpelement : this.getClasspathElements()) {
                            if (!unresolvedURI.endsWith(tmpelement.getText())) continue;
                            alreadyInList = true;
                            break;
                        }
                        if (!alreadyInList) {
                            if (this.inManifest(cp, archiveURI.lastSegment())) {
                                element = this.createArchiveElement(URI.createURI((String)ModuleURIUtil.getHandleString((IVirtualComponent)referencedComponent)), archiveURI.lastSegment(), archiveURI.lastSegment());
                                this.addClasspathElement(element, unresolvedURI);
                            } else {
                                element = this.createArchiveElement(URI.createURI((String)ModuleURIUtil.getHandleString((IVirtualComponent)referencedComponent)), archiveURI.lastSegment(), null);
                                this.addClasspathElement(element, unresolvedURI);
                            }
                        }
                    }
                }
                ++i3;
            }
        }
    }

    public ClasspathElement createClasspathArchiveElement(IProject project, URI archiveURI, String unresolvedURI) {
        ClasspathElement element = this.createArchiveElement(archiveURI, archiveURI.lastSegment(), archiveURI.lastSegment());
        element.setProject(project);
        element.setClasspathDependency(true);
        return element;
    }

    public ClasspathElement createClasspathEntryElement(IProject project, URI archiveURI, String elementName, IClasspathEntry entry) {
        ClasspathElement element = this.createArchiveElement(archiveURI, elementName, elementName);
        element.setProject(project);
        element.setClasspathEntry(true, entry);
        element.setValid(true);
        return element;
    }

    boolean inManifest(String[] cp, String archiveName) {
        boolean result = false;
        String cpEntry = "";
        int i = 0;
        while (i < cp.length) {
            cpEntry = cp[i];
            if (archiveName.equals(cpEntry)) {
                result = true;
            }
            ++i;
        }
        return result;
    }

    protected List loadClassPathArchives() {
        ArrayList<Archive> archives = new ArrayList<Archive>();
        if (this.earComponent != null) {
            IVirtualReference[] newrefs = this.earComponent.getReferences();
            int i = 0;
            while (i < newrefs.length) {
                IVirtualReference ref = newrefs[i];
                IVirtualComponent referencedComponent = ref.getReferencedComponent();
                boolean isBinary = referencedComponent.isBinary();
                if (isBinary) {
                    String uri = J2EEProjectUtilities.getResolvedPathForArchiveComponent(referencedComponent.getName()).toString();
                    try {
                        ZipFileLoadStrategyImpl strat = this.createLoadStrategy(uri);
                        Archive archive = null;
                        try {
                            archive = CommonarchiveFactoryImpl.getActiveFactory().primOpenArchive((LoadStrategy)strat, uri);
                        }
                        catch (OpenFailureException e) {
                            Logger.getLogger().logError((Throwable)e);
                        }
                        archives.add(archive);
                    }
                    catch (FileNotFoundException e) {
                        Logger.getLogger().logError((Throwable)e);
                    }
                    catch (IOException e) {
                        Logger.getLogger().logError((Throwable)e);
                    }
                }
                ++i;
            }
        }
        return archives;
    }

    Archive getClassPathArchive(String uri, List archives) {
        int i = 0;
        while (i < archives.size()) {
            Archive anArchive = (Archive)archives.get(i);
            String archiveURIString = anArchive.getURI();
            URI archiveURI = URI.createURI((String)archiveURIString);
            boolean hasAbsolutePath = archiveURI.hasAbsolutePath();
            if (hasAbsolutePath) {
                archiveURIString = archiveURI.lastSegment();
            }
            if (archiveURIString.equals(uri)) {
                return anArchive;
            }
            ++i;
        }
        return null;
    }

    boolean isClassPathArchive(String uri, List archives) {
        int i = 0;
        while (i < archives.size()) {
            Archive anArchive = (Archive)archives.get(i);
            String archiveURIString = anArchive.getURI();
            URI archiveURI = URI.createURI((String)archiveURIString);
            if (archiveURI.lastSegment().equals(uri)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public ZipFileLoadStrategyImpl createLoadStrategy(String uri) throws FileNotFoundException, IOException {
        String filename = uri.replace('/', File.separatorChar);
        File file = new File(filename);
        if (!file.exists()) {
            throw new FileNotFoundException(CommonArchiveResourceHandler.getString((String)CommonArchiveResourceHandler.file_not_found_EXC_, (Object[])new Object[]{uri, file.getAbsolutePath()}));
        }
        if (file.isDirectory()) {
            throw new FileNotFoundException(CommonArchiveResourceHandler.getString((String)CommonArchiveResourceHandler.file_not_found_EXC_, (Object[])new Object[]{uri, file.getAbsolutePath()}));
        }
        return new ZipFileLoadStrategyImpl(file);
    }

    private void initializeEARProject(EARFile earFile) {
        LoadStrategy loadStrat = earFile.getLoadStrategy();
        if (loadStrat instanceof EARComponentLoadStrategyImpl) {
            this.earComponent = ((EARComponentLoadStrategyImpl)loadStrat).getComponent();
            this.earProject = ((EARComponentLoadStrategyImpl)loadStrat).getComponent().getProject();
        }
    }

    private void setType(ClasspathElement element, Archive other) {
        if (other == null) {
            return;
        }
        if (this.clientToEJBJARs.containsKey(other)) {
            element.setJarType(2);
        } else if (other.isEJBJarFile()) {
            element.setJarType(1);
        }
    }

    private Map reverse(Map localejbToClientJARs) {
        if (localejbToClientJARs == null || localejbToClientJARs.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        HashMap result = new HashMap();
        for (Map.Entry entry : localejbToClientJARs.entrySet()) {
            result.put(entry.getValue(), entry.getKey());
        }
        return result;
    }

    public void addClasspathElement(ClasspathElement element, String uri) {
        this.getClasspathElements().add(element);
        this.getUrisToElements().put(uri, element);
        element.setParentSelection(this);
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean newModified) {
        this.modified = newModified;
    }

    protected void setProjectValues(ClasspathElement element, Archive referencedArchive) {
        IProject p = this.getProject(referencedArchive);
        if (p == null) {
            return;
        }
        element.setProject(p);
        String[] cp = null;
        try {
            cp = referencedArchive.getManifest().getClassPathTokenized();
        }
        catch (ManifestException mfEx) {
            Logger.getLogger().logError((Throwable)mfEx);
            cp = new String[]{};
        }
        ArrayList<IPath> paths = new ArrayList<IPath>(cp.length);
        int i = 0;
        while (i < cp.length) {
            block8: {
                IFile file = null;
                try {
                    file = p.getFile(cp[i]);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    break block8;
                }
                if (file.exists()) {
                    paths.add(file.getFullPath());
                }
            }
            ++i;
        }
        if (!paths.isEmpty()) {
            element.setImportedJarPaths(paths);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.classpathElements.size()) {
            ClasspathElement element = (ClasspathElement)this.classpathElements.get(i);
            if (element.isSelected() && !element.isClasspathDependency() && !element.isClasspathEntry()) {
                sb.append(element.getRelativeText());
                sb.append(" ");
            }
            ++i;
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public void setAllSelected(boolean selected) {
        this.setAllSelected(this.classpathElements, selected);
    }

    public void setAllSelected(List elements, boolean selected) {
        int i = 0;
        while (i < elements.size()) {
            ClasspathElement elmt = (ClasspathElement)elements.get(i);
            elmt.setSelected(selected);
            ++i;
        }
    }

    protected List moveUp(List elements, List move) {
        int nElements = elements.size();
        ArrayList res = new ArrayList(nElements);
        Object floating = null;
        int i = 0;
        while (i < nElements) {
            Object curr = elements.get(i);
            if (move.contains(curr)) {
                res.add(curr);
            } else {
                if (floating != null) {
                    res.add(floating);
                }
                floating = curr;
            }
            ++i;
        }
        if (floating != null) {
            res.add(floating);
        }
        return res;
    }

    public void moveUp(List toMoveUp) {
        this.setModifiedIfAnySelected(toMoveUp);
        if (toMoveUp.size() > 0) {
            this.classpathElements = this.moveUp(this.classpathElements, toMoveUp);
        }
    }

    public void moveDown(List toMoveDown) {
        this.setModifiedIfAnySelected(toMoveDown);
        if (toMoveDown.size() > 0) {
            this.classpathElements = this.reverse(this.moveUp(this.reverse(this.classpathElements), toMoveDown));
        }
    }

    protected List reverse(List p) {
        ArrayList reverse = new ArrayList(p.size());
        int i = p.size() - 1;
        while (i >= 0) {
            reverse.add(p.get(i));
            --i;
        }
        return reverse;
    }

    public ClasspathElement getClasspathElement(String uri) {
        if (this.urisToElements == null) {
            return null;
        }
        return (ClasspathElement)this.urisToElements.get(uri);
    }

    public ClasspathElement getClasspathElement(IProject archiveProject) {
        if (archiveProject != null) {
            int i = 0;
            while (i < this.classpathElements.size()) {
                ClasspathElement elmnt = (ClasspathElement)this.classpathElements.get(i);
                if (archiveProject.equals((Object)elmnt.getProject())) {
                    return elmnt;
                }
                ++i;
            }
        }
        return null;
    }

    public boolean hasDirectOrIndirectDependencyTo(IProject archiveProject) {
        ClasspathElement element = this.getClasspathElement(archiveProject);
        if (element == null) {
            return false;
        }
        Archive anArchive = null;
        if (element.isValid()) {
            try {
                anArchive = (Archive)this.getEARFile().getFile(element.getText());
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        return anArchive != null && this.archive.hasClasspathVisibilityTo(anArchive);
    }

    public boolean hasDirectOrIndirectDependencyTo(String jarName) {
        ClasspathElement element = this.getClasspathElement(jarName);
        if (element == null) {
            return false;
        }
        Archive anArchive = null;
        if (element.isValid()) {
            try {
                anArchive = (Archive)this.getEARFile().getFile(element.getText());
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        return anArchive != null && this.archive.hasClasspathVisibilityTo(anArchive);
    }

    public boolean isAnyJarSelected(int type) {
        if (this.classpathElements != null) {
            int i = 0;
            while (i < this.classpathElements.size()) {
                ClasspathElement element = (ClasspathElement)this.classpathElements.get(i);
                if (element.getJarType() == type && element.isSelected()) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean isAnyEJBJarSelected() {
        return this.isAnyJarSelected(1);
    }

    public boolean isAnyEJBClientJARSelected() {
        return this.isAnyJarSelected(2);
    }

    public int getFilterLevel() {
        return this.filterLevel;
    }

    public void setFilterLevel(int i) {
        this.filterLevel = i;
    }

    public void selectFilterLevel(int level) {
        this.setFilterLevel(level);
        switch (level) {
            case 1: {
                this.invertClientJARSelections(2);
                break;
            }
            case 0: {
                this.invertClientJARSelections(1);
                break;
            }
        }
    }

    public void invertClientJARSelection(IProject aProject, IProject opposite) {
        ClasspathElement oppositeElement;
        ClasspathElement element = this.getClasspathElement(aProject);
        ClasspathElement classpathElement = oppositeElement = opposite == null ? null : this.getClasspathElement(opposite);
        if (element.isSelected()) {
            this.invertSelectionIfPossible(element, oppositeElement);
        }
    }

    private void invertClientJARSelections(int elementType) {
        if (this.classpathElements == null) {
            return;
        }
        int i = 0;
        while (i < this.classpathElements.size()) {
            ClasspathElement element = (ClasspathElement)this.classpathElements.get(i);
            if (element.getJarType() == elementType && element.isSelected()) {
                this.invertSelectionIfPossible(element, null);
            }
            ++i;
        }
    }

    private void invertSelectionIfPossible(ClasspathElement element, ClasspathElement opposite) {
        if (element == null) {
            return;
        }
        if (opposite == null) {
            opposite = this.getOppositeElement(element);
        }
        if (opposite != null) {
            opposite.setSelected(true);
            element.setSelected(false);
        }
    }

    public ClasspathElement getOppositeElement(ClasspathElement element) {
        String uri = element.getText();
        Archive target = element.getTargetArchive();
        if (uri == null || target == null) {
            return null;
        }
        Archive oppositeJAR = null;
        switch (element.getJarType()) {
            case 2: {
                oppositeJAR = (Archive)this.clientToEJBJARs.get(target);
                break;
            }
            case 1: {
                oppositeJAR = (Archive)this.ejbToClientJARs.get(target);
                break;
            }
        }
        if (oppositeJAR != null) {
            return this.getClasspathElement(oppositeJAR.getURI());
        }
        return null;
    }

    private void setModifiedIfAnySelected(List elements) {
        int i = 0;
        while (i < elements.size()) {
            ClasspathElement element = (ClasspathElement)elements.get(i);
            if (element.isSelected()) {
                this.setModified(true);
            }
            ++i;
        }
    }

    public boolean isMyClientJAR(ClasspathElement element) {
        if (element == null || this.ejbToClientJARs == null) {
            return false;
        }
        Archive myClientJar = (Archive)this.ejbToClientJARs.get(this.archive);
        return myClientJar != null && myClientJar == element.getTargetArchive();
    }

    public Map getUrisToElements() {
        if (this.urisToElements == null) {
            this.urisToElements = new HashMap();
        }
        return this.urisToElements;
    }
}

