/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.archive.operations;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.SaveStrategy;
import org.eclipse.jst.j2ee.internal.archive.operations.ComponentSaveStrategyImpl;
import org.eclipse.jst.j2ee.internal.archive.operations.EJBArchiveOpsResourceHandler;
import org.eclipse.jst.j2ee.internal.archive.operations.IOverwriteHandler;
import org.eclipse.jst.j2ee.internal.archive.operations.OverwriteHandlerException;
import org.eclipse.jst.j2ee.internal.common.classpath.J2EEComponentClasspathUpdater;
import org.eclipse.jst.j2ee.internal.project.ProjectSupportResourceHandler;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.enablement.nonui.WFTWrappedException;

public abstract class J2EEArtifactImportOperation
extends AbstractDataModelOperation {
    protected Archive moduleFile;
    protected IVirtualComponent virtualComponent;
    protected IAdaptable info;
    protected final int PROJECT_CREATION_WORK = 30;

    public J2EEArtifactImportOperation(IDataModel model) {
        super(model);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable anInfo) throws ExecutionException {
        try {
            J2EEComponentClasspathUpdater.getInstance().pauseUpdates();
            this.info = anInfo;
            this.moduleFile = (Archive)this.model.getProperty("IJ2EEArtifactImportDataModelProperties.FILE");
            monitor.beginTask(ProjectSupportResourceHandler.getString(ProjectSupportResourceHandler.Importing_archive, new Object[]{this.moduleFile.getURI()}), this.computeTotalWork());
            this.doExecute(monitor);
            IStatus iStatus = OK_STATUS;
            return iStatus;
        }
        finally {
            try {
                if (this.virtualComponent != null) {
                    J2EEComponentClasspathUpdater.getInstance().queueUpdate(this.virtualComponent.getProject());
                }
            }
            finally {
                J2EEComponentClasspathUpdater.getInstance().resumeUpdates();
                this.model.dispose();
                monitor.done();
            }
        }
    }

    protected int computeTotalWork() {
        return 30 + this.moduleFile.getFiles().size();
    }

    protected void doExecute(IProgressMonitor monitor) throws ExecutionException {
        this.virtualComponent = this.createVirtualComponent(this.model.getNestedModel("IJ2EEArtifactImportDataModelProperties.NESTED_MODEL_J2EE_COMPONENT_CREATION"), (IProgressMonitor)new SubProgressMonitor(monitor, 30));
        try {
            this.importModuleFile((IProgressMonitor)new SubProgressMonitor(monitor, this.moduleFile.getFiles().size()));
        }
        catch (InvocationTargetException e) {
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    protected IVirtualComponent createVirtualComponent(IDataModel aModel, IProgressMonitor monitor) throws ExecutionException {
        try {
            aModel.getDefaultOperation().execute(monitor, this.info);
            String projectName = aModel.getStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME");
            IProject project = ProjectUtilities.getProject((String)projectName);
            IVirtualComponent iVirtualComponent = ComponentCore.createComponent((IProject)project);
            return iVirtualComponent;
        }
        finally {
            monitor.done();
        }
    }

    protected abstract SaveStrategy createSaveStrategy(IVirtualComponent var1);

    protected void modifyStrategy(SaveStrategy saveStrat) {
    }

    protected void importModuleFile(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            try {
                monitor.beginTask(null, this.moduleFile.getFiles().size());
                ComponentSaveStrategyImpl aStrategy = (ComponentSaveStrategyImpl)this.createSaveStrategy(this.virtualComponent);
                aStrategy.setProgressMonitor(monitor);
                aStrategy.setOverwriteHandler((IOverwriteHandler)this.model.getProperty("IJ2EEArtifactImportDataModelProperties.OVERWRITE_HANDLER"));
                aStrategy.setDataModel(this.model);
                this.modifyStrategy((SaveStrategy)aStrategy);
                this.moduleFile.save((SaveStrategy)aStrategy);
            }
            catch (OverwriteHandlerException overwriteHandlerException) {
                throw new InterruptedException();
            }
            catch (Exception ex) {
                throw new WFTWrappedException((Throwable)ex, EJBArchiveOpsResourceHandler.ERROR_IMPORTING_MODULE_FILE);
            }
        }
        finally {
            monitor.done();
        }
    }
}

