/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.common.classpath;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.common.jdt.internal.classpath.FlexibleProjectContainer;
import org.eclipse.jst.j2ee.componentcore.J2EEModuleVirtualComponent;
import org.eclipse.jst.j2ee.componentcore.util.EARVirtualComponent;
import org.eclipse.jst.j2ee.internal.common.classpath.J2EEComponentClasspathContainer;
import org.eclipse.jst.j2ee.internal.componentcore.EnterpriseBinaryComponentHelper;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.eclipse.wst.common.componentcore.internal.impl.ResourceTreeRootAdapter;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.internal.emf.utilities.ExtendedEcoreUtil;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;

public class J2EEComponentClasspathUpdater
implements IResourceChangeListener,
IResourceDeltaVisitor {
    private static J2EEComponentClasspathUpdater instance = null;
    private int pauseCount = 0;
    private IPath WEB_APP_LIBS_PATH = new Path("org.eclipse.jst.j2ee.internal.web.container");
    private boolean forceUpdateOnNextRun = false;
    private static final int MODULE_UPDATE_DELAY = 30;
    public static final String MODULE_UPDATE_JOB_NAME = "EAR Libraries Update Job";
    private final ModuleUpdateJob moduleUpdateJob = new ModuleUpdateJob();
    private Set knownProjects = new HashSet();

    public static J2EEComponentClasspathUpdater getInstance() {
        if (instance == null) {
            J2EEComponentClasspathUpdater.init();
        }
        return instance;
    }

    private static void init() {
        if (instance == null) {
            instance = new J2EEComponentClasspathUpdater();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseUpdates() {
        J2EEComponentClasspathUpdater j2EEComponentClasspathUpdater = this;
        synchronized (j2EEComponentClasspathUpdater) {
            ++this.pauseCount;
        }
    }

    public void resumeUpdates() {
        this.resumeUpdates(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resumeUpdates(boolean scheduleJob) {
        J2EEComponentClasspathUpdater j2EEComponentClasspathUpdater = this;
        synchronized (j2EEComponentClasspathUpdater) {
            if (this.pauseCount > 0) {
                --this.pauseCount;
            }
            if (this.pauseCount > 0) {
                return;
            }
        }
        if (scheduleJob) {
            this.moduleUpdateJob.schedule(30L);
        }
    }

    public void forceUpdate(Collection projects) {
        this.forceUpdate(projects, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceUpdate(Collection projects, boolean runAsJob) {
        try {
            this.pauseUpdates();
            Iterator iterator = projects.iterator();
            while (iterator.hasNext()) {
                this.queueUpdate((IProject)iterator.next());
            }
        }
        catch (Throwable throwable) {
            this.forceUpdateOnNextRun = true;
            J2EEComponentClasspathUpdater j2EEComponentClasspathUpdater = this;
            synchronized (j2EEComponentClasspathUpdater) {
                if (this.pauseCount > 0) {
                    --this.pauseCount;
                }
            }
            if (runAsJob) {
                this.moduleUpdateJob.schedule(0L);
            } else {
                this.moduleUpdateJob.run((IProgressMonitor)new NullProgressMonitor());
            }
            throw throwable;
        }
        this.forceUpdateOnNextRun = true;
        J2EEComponentClasspathUpdater j2EEComponentClasspathUpdater = this;
        synchronized (j2EEComponentClasspathUpdater) {
            if (this.pauseCount > 0) {
                --this.pauseCount;
            }
        }
        if (runAsJob) {
            this.moduleUpdateJob.schedule(0L);
        } else {
            this.moduleUpdateJob.run((IProgressMonitor)new NullProgressMonitor());
        }
    }

    public void queueUpdate(IProject project) {
        if (J2EEProjectUtilities.isEARProject(project)) {
            this.queueUpdateEAR(project);
        } else if (J2EEProjectUtilities.isApplicationClientProject(project) || J2EEProjectUtilities.isEJBProject(project) || J2EEProjectUtilities.isDynamicWebProject(project) || J2EEProjectUtilities.isJCAProject(project) || J2EEProjectUtilities.isUtilityProject(project)) {
            this.queueUpdateModule(project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueUpdateModule(IProject project) {
        this.moduleUpdateJob.queueModule(project);
        if (!this.isKnown(project)) {
            IProject[] earProjects = J2EEProjectUtilities.getReferencingEARProjects(project);
            int i = 0;
            while (i < earProjects.length) {
                this.moduleUpdateJob.queueEAR(earProjects[i]);
                ++i;
            }
        }
        J2EEComponentClasspathUpdater j2EEComponentClasspathUpdater = this;
        synchronized (j2EEComponentClasspathUpdater) {
            if (this.pauseCount > 0) {
                return;
            }
        }
        this.moduleUpdateJob.schedule(30L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueUpdateEAR(IProject earProject) {
        this.moduleUpdateJob.queueEAR(earProject);
        J2EEComponentClasspathUpdater j2EEComponentClasspathUpdater = this;
        synchronized (j2EEComponentClasspathUpdater) {
            if (this.pauseCount > 0) {
                return;
            }
        }
        this.moduleUpdateJob.schedule(30L);
    }

    public boolean projectsQueued() {
        return this.moduleUpdateJob.projectsQueued() || this.moduleUpdateJob.getState() != 0;
    }

    public IClasspathContainer getWebAppLibrariesContainer(IProject webProject, boolean create) {
        IClasspathEntry entry;
        IJavaProject jproj = JavaCore.create((IProject)webProject);
        IClasspathContainer container = null;
        IClasspathEntry iClasspathEntry = entry = create ? null : this.getExistingContainer(jproj, this.WEB_APP_LIBS_PATH);
        if (entry != null || create) {
            try {
                container = JavaCore.getClasspathContainer((IPath)this.WEB_APP_LIBS_PATH, (IJavaProject)jproj);
            }
            catch (JavaModelException e) {
                J2EEPlugin.getDefault().getLogger().logError((Throwable)e);
            }
        }
        return container;
    }

    private IClasspathContainer addContainerToModuleIfNecessary(IProject moduleProject) {
        IJavaProject jproj = JavaCore.create((IProject)moduleProject);
        IClasspathEntry entry = this.getExistingContainer(jproj, J2EEComponentClasspathContainer.CONTAINER_PATH);
        if (entry == null) {
            try {
                entry = JavaCore.newContainerEntry((IPath)J2EEComponentClasspathContainer.CONTAINER_PATH, (boolean)true);
                this.addToClasspath(jproj, entry);
            }
            catch (CoreException e) {
                J2EEPlugin.getDefault().getLogger().logError((Throwable)e);
            }
        }
        IClasspathContainer container = null;
        try {
            container = JavaCore.getClasspathContainer((IPath)J2EEComponentClasspathContainer.CONTAINER_PATH, (IJavaProject)jproj);
        }
        catch (JavaModelException e) {
            J2EEPlugin.getDefault().getLogger().logError((Throwable)e);
        }
        return container;
    }

    private void removeContainerFromModuleIfNecessary(IProject moduleProject) {
        IJavaProject jproj = JavaCore.create((IProject)moduleProject);
        IClasspathEntry entry = this.getExistingContainer(jproj, J2EEComponentClasspathContainer.CONTAINER_PATH);
        if (entry != null) {
            try {
                this.removeFromClasspath(jproj, entry);
            }
            catch (CoreException e) {
                J2EEPlugin.getDefault().getLogger().logError((Throwable)e);
            }
        }
    }

    private void addToClasspath(IJavaProject jproj, IClasspathEntry entry) throws CoreException {
        IClasspathEntry[] current = jproj.getRawClasspath();
        IClasspathEntry[] updated = new IClasspathEntry[current.length + 1];
        System.arraycopy(current, 0, updated, 0, current.length);
        updated[current.length] = entry;
        jproj.setRawClasspath(updated, null);
    }

    private void removeFromClasspath(IJavaProject jproj, IClasspathEntry entry) throws CoreException {
        IClasspathEntry[] current = jproj.getRawClasspath();
        IClasspathEntry[] updated = new IClasspathEntry[current.length - 1];
        boolean removed = false;
        int i = 0;
        while (i < current.length) {
            if (!removed) {
                if (current[i] == entry) {
                    removed = true;
                } else {
                    updated[i] = current[i];
                }
            } else {
                updated[i - 1] = current[i];
            }
            ++i;
        }
        jproj.setRawClasspath(updated, null);
    }

    public IClasspathEntry getExistingContainer(IJavaProject jproj, IPath classpathContainerPath) {
        try {
            IClasspathEntry[] cpes = jproj.getRawClasspath();
            int j = 0;
            while (j < cpes.length) {
                IClasspathEntry cpe = cpes[j];
                if (cpe.getEntryKind() == 5 && cpe.getPath().equals((Object)classpathContainerPath)) {
                    return cpe;
                }
                ++j;
            }
        }
        catch (JavaModelException e) {
            J2EEPlugin.getDefault().getLogger().logError((Throwable)e);
        }
        return null;
    }

    private boolean isKnown(IProject project) {
        return !this.knownProjects.add(project.getName());
    }

    private void forgetProject(IProject project) {
        this.knownProjects.remove(project.getName());
    }

    public void resourceChanged(IResourceChangeEvent event) {
        boolean scheduleJob = false;
        try {
            try {
                this.pauseUpdates();
                switch (event.getType()) {
                    case 2: 
                    case 4: {
                        IResource resource = event.getResource();
                        if (resource.getType() != 4) break;
                        if (ModuleCoreNature.isFlexibleProject((IProject)((IProject)resource))) {
                            if (J2EEProjectUtilities.isEARProject((IProject)resource)) {
                                IProject earProject = (IProject)resource;
                                IVirtualReference[] refs = J2EEProjectUtilities.getComponentReferences(ComponentCore.createComponent((IProject)earProject));
                                IVirtualComponent comp = null;
                                int j = 0;
                                while (j < refs.length) {
                                    comp = refs[j].getReferencedComponent();
                                    if (!comp.isBinary()) {
                                        this.queueUpdateModule(comp.getProject());
                                    }
                                    ++j;
                                }
                            } else {
                                IProject[] earProjects = J2EEProjectUtilities.getReferencingEARProjects((IProject)resource);
                                int i = 0;
                                while (i < earProjects.length) {
                                    this.queueUpdateEAR(earProjects[i]);
                                    ++i;
                                }
                            }
                            this.forgetProject((IProject)resource);
                        }
                        EnterpriseBinaryComponentHelper.ArchiveCache.getInstance().clearAllArchivesInProject((IProject)resource);
                        break;
                    }
                    case 1: {
                        scheduleJob = true;
                        event.getDelta().accept((IResourceDeltaVisitor)this);
                        IResourceDelta[] d = event.getDelta().getAffectedChildren();
                        this.findNode(d);
                    }
                }
            }
            catch (CoreException e) {
                J2EEPlugin.getDefault().getLogger().logError((Throwable)e);
                this.resumeUpdates(scheduleJob);
            }
        }
        finally {
            this.resumeUpdates(scheduleJob);
        }
    }

    public static void clearResourceTreeRootCache(WorkbenchComponent aModule) {
        ResourceTreeRootAdapter resourceTreeAdapter = (ResourceTreeRootAdapter)ExtendedEcoreUtil.getAdapter((EObject)aModule, (List)aModule.eAdapters(), (Object)ResourceTreeRootAdapter.DEPLOY_ADAPTER_TYPE);
        if (resourceTreeAdapter != null) {
            resourceTreeAdapter.setResourceTreeRoot(null);
        }
        if ((resourceTreeAdapter = (ResourceTreeRootAdapter)ExtendedEcoreUtil.getAdapter((EObject)aModule, (List)aModule.eAdapters(), (Object)ResourceTreeRootAdapter.SOURCE_ADAPTER_TYPE)) != null) {
            resourceTreeAdapter.setResourceTreeRoot(null);
        }
    }

    public boolean findNode(IResourceDelta[] delta) {
        int i = 0;
        while (i < delta.length) {
            if (delta[i].toString().indexOf(".component") != -1) {
                WorkbenchComponent component;
                StructureEdit core = StructureEdit.getStructureEditForRead((IProject)delta[i].getResource().getProject());
                if (core != null && (component = core.getComponent()) != null) {
                    J2EEComponentClasspathUpdater.clearResourceTreeRootCache(component);
                }
            } else {
                this.findNode(delta[i].getAffectedChildren());
            }
            ++i;
        }
        return true;
    }

    public boolean visit(IResourceDelta delta) {
        IResource resource = delta.getResource();
        switch (resource.getType()) {
            case 8: {
                return true;
            }
            case 4: {
                return ModuleCoreNature.isFlexibleProject((IProject)((IProject)resource));
            }
            case 2: {
                if (resource.getName().equals(".settings")) {
                    return true;
                }
                IVirtualComponent comp = ComponentCore.createComponent((IProject)resource.getProject());
                if (comp instanceof J2EEModuleVirtualComponent || comp instanceof EARVirtualComponent) {
                    IVirtualFolder rootFolder = comp.getRootFolder();
                    if (comp instanceof EARVirtualComponent) {
                        return J2EEComponentClasspathUpdater.isRootAncester(resource, rootFolder);
                    }
                    return J2EEComponentClasspathUpdater.isRootAncester(resource, rootFolder) || J2EEComponentClasspathUpdater.isFolder(resource, rootFolder.getFolder("META-INF"));
                }
                return false;
            }
            case 1: {
                String name = resource.getName();
                if (name.equals("org.eclipse.wst.common.component") || name.equals(".classpath")) {
                    this.queueUpdate(resource.getProject());
                    break;
                }
                if (name.equals("MANIFEST.MF")) {
                    IFile manifestFile = J2EEProjectUtilities.getManifestFile(resource.getProject(), false);
                    if (manifestFile != null && !resource.equals((Object)manifestFile)) break;
                    this.queueUpdateModule(resource.getProject());
                    break;
                }
                if (!J2EEComponentClasspathUpdater.endsWithIgnoreCase(name, ".jar")) break;
                try {
                    if (!FacetedProjectFramework.hasProjectFacet((IProject)resource.getProject(), (String)"jst.ear")) break;
                    IVirtualComponent comp = ComponentCore.createComponent((IProject)resource.getProject());
                    if (!J2EEComponentClasspathUpdater.isFolder((IResource)resource.getParent(), comp.getRootFolder())) break;
                    this.queueUpdateEAR(resource.getProject());
                    break;
                }
                catch (CoreException e) {
                    J2EEPlugin.getDefault().getLogger().logError((Throwable)e);
                }
            }
        }
        return false;
    }

    public static boolean endsWithIgnoreCase(String str, String sfx) {
        return str.regionMatches(true, str.length() - sfx.length(), sfx, 0, sfx.length());
    }

    public static boolean isFolder(IResource resource, IVirtualFolder folder) {
        IContainer[] realFolders = folder.getUnderlyingFolders();
        int i = 0;
        while (i < realFolders.length) {
            if (realFolders[i].equals((Object)resource)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isRootAncester(IResource resource, IVirtualFolder rootFolder) {
        IContainer[] realRoots = rootFolder.getUnderlyingFolders();
        IPath currentResourcePath = resource.getFullPath();
        int i = 0;
        while (i < realRoots.length) {
            if (currentResourcePath.isPrefixOf(realRoots[i].getFullPath())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public class ModuleUpdateJob
    extends Job {
        private Queue moduleQueue;
        private Queue earQueue;

        public boolean belongsTo(Object family) {
            if (family == J2EEComponentClasspathUpdater.MODULE_UPDATE_JOB_NAME) {
                return true;
            }
            return super.belongsTo(family);
        }

        public ModuleUpdateJob() {
            super(J2EEComponentClasspathUpdater.MODULE_UPDATE_JOB_NAME);
            this.moduleQueue = new Queue();
            this.earQueue = new Queue();
            this.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
            this.setSystem(true);
        }

        public void queueEAR(IProject ear) {
            this.earQueue.add(ear);
        }

        public void queueModule(IProject project) {
            this.moduleQueue.add(project);
        }

        public boolean projectsQueued() {
            return !this.earQueue.isEmpty() || !this.moduleQueue.isEmpty();
        }

        private void processEars() {
            Object[] earProjects = this.earQueue.getListeners();
            int i = 0;
            while (i < earProjects.length) {
                IProject earProject = (IProject)earProjects[i];
                IVirtualComponent earComponent = ComponentCore.createComponent((IProject)earProject);
                IVirtualReference[] refs = J2EEProjectUtilities.getComponentReferences(earComponent);
                IVirtualComponent comp = null;
                int j = 0;
                while (j < refs.length) {
                    comp = refs[j].getReferencedComponent();
                    if (!comp.isBinary()) {
                        this.queueModule(comp.getProject());
                    }
                    ++j;
                }
                if (earComponent != null) {
                    EnterpriseBinaryComponentHelper.ArchiveCache.getInstance().clearDisconnectedArchivesInEAR(earComponent);
                }
                ++i;
            }
        }

        private void processModules() {
            Object[] projects = this.moduleQueue.getListeners();
            int i = 0;
            while (i < projects.length) {
                IProject[] earProjects;
                IProject project = (IProject)projects[i];
                IClasspathContainer container = J2EEComponentClasspathUpdater.this.getWebAppLibrariesContainer(project, false);
                if (container != null && container instanceof FlexibleProjectContainer) {
                    ((FlexibleProjectContainer)container).refresh();
                }
                if ((earProjects = J2EEProjectUtilities.getReferencingEARProjects(project)).length == 0) {
                    J2EEComponentClasspathUpdater.this.removeContainerFromModuleIfNecessary(project);
                    return;
                }
                container = J2EEComponentClasspathUpdater.this.addContainerToModuleIfNecessary(project);
                if (container != null && container instanceof J2EEComponentClasspathContainer) {
                    ((J2EEComponentClasspathContainer)container).refresh(J2EEComponentClasspathUpdater.this.forceUpdateOnNextRun);
                }
                ++i;
            }
        }

        protected IStatus run(IProgressMonitor monitor) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable e) {
                    J2EEPlugin.getDefault().getLogger().logError(e);
                }

                public void run() throws Exception {
                    try {
                        ModuleUpdateJob.this.processEars();
                        ModuleUpdateJob.this.processModules();
                    }
                    finally {
                        J2EEComponentClasspathUpdater.this.forceUpdateOnNextRun = false;
                    }
                }
            });
            return Status.OK_STATUS;
        }

        private class Queue
        extends ListenerList {
            private Queue() {
            }

            public synchronized Object[] getListeners() {
                Object[] data = super.getListeners();
                this.clear();
                return data;
            }
        }
    }
}

