/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.ui.dse.dnd;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.ConnectionProfileException;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IManagedConnection;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.internal.ConnectionProfileProvider;
import org.eclipse.datatools.connectivity.internal.repository.IConnectionProfileRepository;
import org.eclipse.datatools.connectivity.internal.repository.IConnectionProfileRepositoryConstants;
import org.eclipse.datatools.connectivity.internal.ui.LocalRepositoryNode;
import org.eclipse.datatools.connectivity.internal.ui.refactoring.ConnectionProfileCopyProcessor;
import org.eclipse.datatools.connectivity.internal.ui.refactoring.ConnectionProfileMoveProcessor;
import org.eclipse.datatools.connectivity.ui.RefreshProfileJob;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ltk.core.refactoring.PerformRefactoringOperation;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.participants.CopyProcessor;
import org.eclipse.ltk.core.refactoring.participants.CopyRefactoring;
import org.eclipse.ltk.core.refactoring.participants.MoveProcessor;
import org.eclipse.ltk.core.refactoring.participants.MoveRefactoring;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonDropAdapter;
import org.eclipse.ui.navigator.CommonDropAdapterAssistant;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

public class ConnectionProfileDropAssistant
extends CommonDropAdapterAssistant {
    private List mElements;

    public IStatus handleDrop(CommonDropAdapter dropAdapter, DropTargetEvent dropTargetEvent, Object target) {
        if (LocalSelectionTransfer.getInstance().isSupportedType(dropAdapter.getCurrentTransfer())) {
            try {
                switch (dropAdapter.getCurrentOperation()) {
                    case 1: {
                        this.handleDropCopy(target);
                        break;
                    }
                    case 2: {
                        this.handleDropMove(target);
                    }
                }
            }
            catch (ConnectionProfileException e) {
                e.printStackTrace();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return Status.CANCEL_STATUS;
    }

    private void handleDropMove(Object target) throws ConnectionProfileException, CoreException {
        if (target instanceof LocalRepositoryNode) {
            PerformRefactoringOperation refOperation = new PerformRefactoringOperation((Refactoring)new MoveRefactoring((MoveProcessor)new ConnectionProfileMoveProcessor(this.mElements.toArray(new IConnectionProfile[this.mElements.size()]), (Object)ProfileManager.getInstance())), 6);
            ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)refOperation, null);
        } else if (target instanceof IConnectionProfile) {
            PerformRefactoringOperation refOperation = new PerformRefactoringOperation((Refactoring)new MoveRefactoring((MoveProcessor)new ConnectionProfileMoveProcessor(this.mElements.toArray(new IConnectionProfile[this.mElements.size()]), target)), 6);
            ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)refOperation, null);
        }
    }

    private void handleDropCopy(Object target) throws ConnectionProfileException, CoreException {
        if (target instanceof LocalRepositoryNode) {
            PerformRefactoringOperation refOperation = new PerformRefactoringOperation((Refactoring)new CopyRefactoring((CopyProcessor)new ConnectionProfileCopyProcessor(this.mElements.toArray(new IConnectionProfile[this.mElements.size()]), (Object)ProfileManager.getInstance())), 6);
            ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)refOperation, null);
        } else if (target instanceof IConnectionProfile) {
            PerformRefactoringOperation refOperation = new PerformRefactoringOperation((Refactoring)new CopyRefactoring((CopyProcessor)new ConnectionProfileCopyProcessor(this.mElements.toArray(new IConnectionProfile[this.mElements.size()]), target)), 6);
            ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)refOperation, null);
        }
    }

    public IStatus validateDrop(Object target, int operation, TransferData transferType) {
        IStatus result = Status.OK_STATUS;
        if (LocalSelectionTransfer.getInstance().isSupportedType(transferType)) {
            this.initializeSelection();
            result = this.handleValidate(target);
        }
        return result;
    }

    private IStatus handleValidate(Object target) {
        block8: {
            block7: {
                if (!(target instanceof LocalRepositoryNode)) break block7;
                Iterator iter = this.mElements.iterator();
                while (iter.hasNext()) {
                    Object data = iter.next();
                    if (data instanceof IConnectionProfile) {
                        IConnectionProfile profile = (IConnectionProfile)data;
                        if (profile.getParentProfile() != null) continue;
                        return Status.CANCEL_STATUS;
                    }
                    return Status.CANCEL_STATUS;
                }
                break block8;
            }
            if (!(target instanceof IConnectionProfile)) break block8;
            IManagedConnection imc = ((IConnectionProfile)target).getManagedConnection(IConnectionProfileRepositoryConstants.REPOSITORY_CONNECTION_FACTORY_ID);
            if (imc == null || !imc.isConnected() || imc.getConnection() == null) {
                return Status.CANCEL_STATUS;
            }
            IConnectionProfileRepository repo = (IConnectionProfileRepository)imc.getConnection().getRawConnection();
            if (repo == null || repo.isReadOnly()) {
                return Status.CANCEL_STATUS;
            }
            Iterator iter = this.mElements.iterator();
            while (iter.hasNext()) {
                Object data = iter.next();
                if (data instanceof IConnectionProfile) {
                    IConnectionProfile profile = (IConnectionProfile)data;
                    if (target.equals(profile.getParentProfile())) {
                        return Status.CANCEL_STATUS;
                    }
                    if (((ConnectionProfileProvider)profile.getProvider()).compatibleWithRepository((IConnectionProfile)target) && repo.supportsProfileType(profile.getProviderId())) continue;
                    return Status.CANCEL_STATUS;
                }
                return Status.CANCEL_STATUS;
            }
        }
        return Status.OK_STATUS;
    }

    protected void initializeSelection() {
        ISelection s = LocalSelectionTransfer.getInstance().getSelection();
        if (!(s instanceof IStructuredSelection)) {
            return;
        }
        this.mElements = ((IStructuredSelection)s).toList();
    }

    protected void refreshViewer(Object object, boolean expand) {
        IViewPart view = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.datatools.connectivity.DataSourceExplorerNavigator");
        final CommonViewer viewer = ((CommonNavigator)view).getCommonViewer();
        if (viewer instanceof TreeViewer && object instanceof IConnectionProfile) {
            RefreshProfileJob.scheduleRefreshProfileJob((IConnectionProfile)((IConnectionProfile)object), (TreeViewer)viewer);
        } else {
            Runnable runner = new Runnable(){

                public void run() {
                    viewer.refresh();
                }
            };
            viewer.getControl().getDisplay().syncExec(runner);
        }
    }
}

