/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.core.rte.jdbc;

import com.ibm.icu.util.StringTokenizer;
import java.lang.ref.SoftReference;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.connectivity.sqm.core.rte.jdbc.JDBCTable;
import org.eclipse.datatools.connectivity.sqm.core.rte.jdbc.JDBCView;
import org.eclipse.datatools.connectivity.sqm.core.util.CatalogLoaderOverrideManager;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionFilter;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionFilterListener;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.DatabaseConnectionRegistry;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCBaseLoader;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCRoutineLoader;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCTableLoader;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCUserDefinedTypeLoader;
import org.eclipse.datatools.modelbase.sql.datatypes.SQLDataTypesPackage;
import org.eclipse.datatools.modelbase.sql.routines.SQLRoutinesPackage;
import org.eclipse.datatools.modelbase.sql.schema.Catalog;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.schema.impl.SchemaImpl;
import org.eclipse.datatools.modelbase.sql.tables.SQLTablesPackage;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;

public class JDBCSchema
extends SchemaImpl
implements ICatalogObject {
    private static final long serialVersionUID = -8922854918009851012L;
    private Boolean tablesLoaded = Boolean.FALSE;
    private SoftReference tableLoaderRef;
    private Boolean routinesLoaded = Boolean.FALSE;
    private SoftReference routineLoaderRef;
    private Boolean udtsLoaded = Boolean.FALSE;
    private SoftReference udtLoaderRef;
    private transient ConnectionFilterListener filterListener = new ConnectionFilterListener(){

        public void connectionFilterAdded(String filterKey) {
            JDBCSchema.this.handleFilterChanged(filterKey);
        }

        public void connectionFilterRemoved(String filterKey) {
            JDBCSchema.this.handleFilterChanged(filterKey);
        }
    };

    public Database getCatalogDatabase() {
        return this.getCatalog().getDatabase();
    }

    public Connection getConnection() {
        Database db = this.getCatalogDatabase();
        if (db instanceof ICatalogObject) {
            return ((ICatalogObject)db).getConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Boolean bl = this.tablesLoaded;
        synchronized (bl) {
            if (this.tablesLoaded.booleanValue()) {
                this.tablesLoaded = Boolean.FALSE;
            }
        }
        bl = this.routinesLoaded;
        synchronized (bl) {
            if (this.routinesLoaded.booleanValue()) {
                this.routinesLoaded = Boolean.FALSE;
            }
        }
        bl = this.udtsLoaded;
        synchronized (bl) {
            if (this.udtsLoaded.booleanValue()) {
                this.udtsLoaded = Boolean.FALSE;
            }
        }
        RefreshManager.getInstance().referesh(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getTables() {
        Boolean bl = this.tablesLoaded;
        synchronized (bl) {
            if (!this.tablesLoaded.booleanValue()) {
                this.loadTables();
            }
        }
        return super.getTables();
    }

    protected JDBCTableLoader createTableLoader() {
        DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.getCatalogDatabase());
        JDBCBaseLoader loader = CatalogLoaderOverrideManager.INSTANCE.getLoaderForDatabase(databaseDefinition, SQLTablesPackage.eINSTANCE.getTable().getInstanceClassName());
        if (loader != null) {
            JDBCTableLoader tableLoader = (JDBCTableLoader)loader;
            tableLoader.setCatalogObject(this);
            return tableLoader;
        }
        return new JDBCTableLoader(this);
    }

    protected final JDBCTableLoader getTableLoader() {
        if (this.tableLoaderRef == null || this.tableLoaderRef.get() == null) {
            this.tableLoaderRef = new SoftReference<JDBCTableLoader>(this.createTableLoader());
        }
        return (JDBCTableLoader)this.tableLoaderRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTables() {
        Boolean bl = this.tablesLoaded;
        synchronized (bl) {
            boolean deliver = this.eDeliver();
            try {
                EList container = super.getTables();
                ArrayList existingTables = new ArrayList(container);
                this.eSetDeliver(false);
                container.clear();
                this.getTableLoader().loadTables((List)container, existingTables);
                this.getTableLoader().clearTables(existingTables);
                this.tablesLoaded = Boolean.TRUE;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.eSetDeliver(deliver);
            }
        }
    }

    private String getTableFilterKey() {
        return this.getCatalog().getName() + "::" + this.getName() + "::" + "DatatoolsTableFilterPredicate";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getRoutines() {
        Boolean bl = this.routinesLoaded;
        synchronized (bl) {
            if (!this.routinesLoaded.booleanValue()) {
                this.loadRoutines();
            }
        }
        return super.getRoutines();
    }

    protected JDBCRoutineLoader createRoutineLoader() {
        DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.getCatalogDatabase());
        JDBCBaseLoader loader = CatalogLoaderOverrideManager.INSTANCE.getLoaderForDatabase(databaseDefinition, SQLRoutinesPackage.eINSTANCE.getRoutine().getInstanceClassName());
        if (loader != null) {
            JDBCRoutineLoader routineLoader = (JDBCRoutineLoader)loader;
            routineLoader.setCatalogObject(this);
            return routineLoader;
        }
        return new JDBCRoutineLoader(this);
    }

    protected final JDBCRoutineLoader getRoutineLoader() {
        if (this.routineLoaderRef == null || this.routineLoaderRef.get() == null) {
            this.routineLoaderRef = new SoftReference<JDBCRoutineLoader>(this.createRoutineLoader());
        }
        return (JDBCRoutineLoader)this.routineLoaderRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadRoutines() {
        Boolean bl = this.routinesLoaded;
        synchronized (bl) {
            boolean deliver = this.eDeliver();
            try {
                EList container = super.getRoutines();
                ArrayList existingRoutines = new ArrayList(container);
                this.eSetDeliver(false);
                container.clear();
                this.getRoutineLoader().loadRoutines((List)container, existingRoutines);
                this.getRoutineLoader().clearRoutines(existingRoutines);
                this.routinesLoaded = Boolean.TRUE;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.eSetDeliver(deliver);
            }
        }
    }

    private String getRoutineFilterKey() {
        return this.getCatalog().getName() + "::" + this.getName() + "::" + "DatatoolsSPFilterPredicate";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getUserDefinedTypes() {
        Boolean bl = this.udtsLoaded;
        synchronized (bl) {
            if (!this.routinesLoaded.booleanValue()) {
                this.loadUDTs();
            }
        }
        return super.getUserDefinedTypes();
    }

    protected JDBCUserDefinedTypeLoader createUDTLoader() {
        DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.getCatalogDatabase());
        JDBCBaseLoader loader = CatalogLoaderOverrideManager.INSTANCE.getLoaderForDatabase(databaseDefinition, SQLDataTypesPackage.eINSTANCE.getUserDefinedType().getInstanceClassName());
        if (loader != null) {
            JDBCUserDefinedTypeLoader udtLoader = (JDBCUserDefinedTypeLoader)loader;
            udtLoader.setCatalogObject(this);
            return udtLoader;
        }
        return new JDBCUserDefinedTypeLoader(this);
    }

    protected final JDBCUserDefinedTypeLoader getUDTLoader() {
        if (this.udtLoaderRef == null || this.udtLoaderRef.get() == null) {
            this.udtLoaderRef = new SoftReference<JDBCUserDefinedTypeLoader>(this.createUDTLoader());
        }
        return (JDBCUserDefinedTypeLoader)this.udtLoaderRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadUDTs() {
        Boolean bl = this.routinesLoaded;
        synchronized (bl) {
            boolean deliver = this.eDeliver();
            try {
                EList container = super.getUserDefinedTypes();
                ArrayList existingUDTs = new ArrayList(container);
                this.eSetDeliver(false);
                container.clear();
                this.getUDTLoader().loadUDTs((List)container, existingUDTs);
                this.getUDTLoader().clearUDTs(existingUDTs);
                this.udtsLoaded = Boolean.TRUE;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.eSetDeliver(deliver);
            }
        }
    }

    private String getUDTFilterKey() {
        return this.getCatalog().getName() + "::" + this.getName() + "::" + "DatatoolsUDTFilterPredicate";
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 8: {
                this.getTables();
                break;
            }
            case 15: {
                this.getRoutines();
                break;
            }
            case 13: {
                this.getUserDefinedTypes();
            }
        }
        return super.eIsSet(eFeature);
    }

    public NotificationChain basicSetCatalog(Catalog newCatalog, NotificationChain msgs) {
        ConnectionInfo connectionInfo;
        if (this.catalog != null && this.catalog.getDatabase() != null) {
            connectionInfo = DatabaseConnectionRegistry.getInstance().getConnectionForDatabase(this.catalog.getDatabase());
            connectionInfo.removeFilterListener(this.filterListener);
        }
        if (newCatalog != null && newCatalog.getDatabase() != null) {
            connectionInfo = DatabaseConnectionRegistry.getInstance().getConnectionForDatabase(newCatalog.getDatabase());
            connectionInfo.addFilterListener(this.filterListener);
        }
        return super.basicSetCatalog(newCatalog, msgs);
    }

    private void handleFilterChanged(String filterKey) {
        boolean refresh = false;
        ConnectionInfo conInf = DatabaseConnectionRegistry.getInstance().getConnectionForDatabase(this.getCatalogDatabase());
        if (this.tablesLoaded.booleanValue() && filterKey.equals(this.getTableFilterKey()) || conInf != null && conInf.getFilter(this.getTableFilterKey()) == null && ("DatatoolsTableFilterPredicate".equals(filterKey) || filterKey.equals(this.getCatalog().getName() + "::" + "DatatoolsTableFilterPredicate"))) {
            this.tablesLoaded = Boolean.FALSE;
            this.getTableLoader().clearTables((List)super.getTables());
            refresh = true;
        }
        if (this.routinesLoaded.booleanValue() && filterKey.equals(this.getRoutineFilterKey()) || conInf != null && conInf.getFilter(this.getRoutineFilterKey()) == null && ("DatatoolsSPFilterPredicate".equals(filterKey) || filterKey.equals(this.getCatalog().getName() + "::" + "DatatoolsSPFilterPredicate"))) {
            this.routinesLoaded = Boolean.FALSE;
            this.getRoutineLoader().clearRoutines((List)super.getRoutines());
            refresh = true;
        }
        if (this.udtsLoaded.booleanValue() && filterKey.equals(this.getUDTFilterKey()) || conInf != null && conInf.getFilter(this.getUDTFilterKey()) == null && ("DatatoolsUDTFilterPredicate".equals(filterKey) || filterKey.equals(this.getCatalog().getName() + "::" + "DatatoolsUDTFilterPredicate"))) {
            this.udtsLoaded = Boolean.FALSE;
            this.getUDTLoader().clearUDTs((List)super.getUserDefinedTypes());
            refresh = true;
        }
        if (refresh) {
            RefreshManager.getInstance().referesh(this);
        }
    }

    public static void loadTables(Connection connection, EList tableList, Schema schema) throws SQLException {
        Object[] oldList = tableList.toArray();
        tableList.clear();
        try {
            ConnectionInfo connectionInfo;
            ConnectionFilter filter;
            String catalogName = null;
            DatabaseMetaData metaData = connection.getMetaData();
            if (metaData.supportsCatalogsInTableDefinitions()) {
                catalogName = connection.getCatalog();
            }
            if ((filter = (connectionInfo = DatabaseConnectionRegistry.getInstance().getConnectionForDatabase(schema.getDatabase())).getFilter(schema.getName() + "::" + "DatatoolsTableFilterPredicate")) == null) {
                filter = connectionInfo.getFilter("DatatoolsTableFilterPredicate");
            }
            String[] tableAry = null;
            String pattern = null;
            if (filter != null) {
                String tableFilter = filter.getPredicate();
                if ((tableFilter = tableFilter.replaceAll(" ", "")).startsWith("IN(")) {
                    tableFilter = tableFilter.substring(3, tableFilter.length() - 1);
                    tableFilter = tableFilter.replaceAll(",", "");
                    tableAry = JDBCSchema.parseINClause(tableFilter);
                }
                if (tableFilter.startsWith("LIKE")) {
                    pattern = JDBCSchema.parseLikeClause(filter.getPredicate());
                }
            }
            ResultSet r = null;
            r = pattern != null ? metaData.getTables(catalogName, schema.getName(), pattern, new String[]{"TABLE", "VIEW", "SYSTEM TABLE"}) : metaData.getTables(catalogName, schema.getName(), null, new String[]{"TABLE", "VIEW", "TABLE_VIEW", "SYSTEM TABLE"});
            while (r.next()) {
                Object table;
                String tableName = r.getString(3);
                String type = r.getString(4);
                String remarks = r.getString(5);
                if (tableAry != null) {
                    boolean found = false;
                    for (int i = 0; i < tableAry.length; ++i) {
                        if (!tableName.equals(tableAry[i])) continue;
                        found = true;
                        break;
                    }
                    if (!found) continue;
                }
                EClass metaclass = null;
                if (type.equals("TABLE") || type.equals("SYSTEM TABLE")) {
                    metaclass = SQLTablesPackage.eINSTANCE.getPersistentTable();
                } else if (type.equals("VIEW")) {
                    metaclass = SQLTablesPackage.eINSTANCE.getViewTable();
                }
                Object element = JDBCSchema.findElement(oldList, tableName, metaclass);
                if (element != null) {
                    table = (Table)element;
                    ((ICatalogObject)table).refresh();
                } else {
                    if (type.equals("TABLE") || type.equals("SYSTEM TABLE")) {
                        table = new JDBCTable();
                    } else {
                        if (!type.equals("VIEW")) continue;
                        table = new JDBCView();
                    }
                    table.setName(tableName);
                }
                table.setDescription(remarks);
                tableList.add(table);
            }
            r.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Object findElement(Object[] list, String name, EClass metaclass) {
        Object object = null;
        for (int i = 0; i < list.length; ++i) {
            SQLObject sqlObject = (SQLObject)list[i];
            if (!sqlObject.getName().equals(name) || sqlObject.eClass() != metaclass) continue;
            object = list[i];
            break;
        }
        return object;
    }

    protected static String[] parseINClause(String toParse) {
        StringTokenizer tokenizer = new StringTokenizer(toParse, "'");
        Vector<String> list = new Vector<String>();
        Object result = null;
        if (tokenizer.countTokens() >= 1) {
            while (tokenizer.hasMoreTokens()) {
                list.add(tokenizer.nextToken());
            }
        }
        String[] retStrList = null;
        if (list.size() > 0) {
            retStrList = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                retStrList[i] = (String)list.get(i);
            }
        }
        return retStrList;
    }

    protected static String parseLikeClause(String toParse) {
        String retString = toParse.substring(toParse.indexOf("'") + 1, toParse.length() - 1);
        return retString;
    }
}

