/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.core.rte.jdbc;

import java.lang.ref.SoftReference;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.connectivity.sqm.core.util.CatalogLoaderOverrideManager;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCBaseLoader;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCUDFColumnLoader;
import org.eclipse.datatools.modelbase.sql.routines.Parameter;
import org.eclipse.datatools.modelbase.sql.routines.ParameterMode;
import org.eclipse.datatools.modelbase.sql.routines.RoutineResultTable;
import org.eclipse.datatools.modelbase.sql.routines.impl.UserDefinedFunctionImpl;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.tables.SQLTablesFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class JDBCUserDefinedFunction
extends UserDefinedFunctionImpl
implements ICatalogObject {
    private static final long serialVersionUID = -6800525292996291562L;
    private Boolean parametersLoaded = Boolean.FALSE;
    private Boolean resultTableLoaded = Boolean.FALSE;
    private SoftReference paremeterLoaderRef;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Boolean bl = this.parametersLoaded;
        synchronized (bl) {
            if (this.parametersLoaded.booleanValue()) {
                this.setReturnScalar(null);
                this.parametersLoaded = Boolean.FALSE;
            }
        }
        bl = this.resultTableLoaded;
        synchronized (bl) {
            if (this.resultTableLoaded.booleanValue()) {
                this.setReturnTable(null);
                this.resultTableLoaded = Boolean.FALSE;
            }
        }
        RefreshManager.getInstance().referesh(this);
    }

    public Connection getConnection() {
        Database db = this.getCatalogDatabase();
        if (db instanceof ICatalogObject) {
            return ((ICatalogObject)db).getConnection();
        }
        return null;
    }

    public Database getCatalogDatabase() {
        return this.getSchema().getCatalog().getDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getParameters() {
        Boolean bl = this.parametersLoaded;
        synchronized (bl) {
            if (!this.parametersLoaded.booleanValue()) {
                this.loadParameters();
            }
        }
        return super.getParameters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Parameter getReturnScalar() {
        Boolean bl = this.parametersLoaded;
        synchronized (bl) {
            if (!this.parametersLoaded.booleanValue()) {
                this.loadParameters();
            }
        }
        return super.getReturnScalar();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RoutineResultTable getReturnTable() {
        Boolean bl = this.resultTableLoaded;
        synchronized (bl) {
            if (!this.resultTableLoaded.booleanValue()) {
                this.loadResultTable();
            }
        }
        return super.getReturnTable();
    }

    protected JDBCUDFColumnLoader createParameterLoader() {
        DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.getCatalogDatabase());
        JDBCBaseLoader loader = CatalogLoaderOverrideManager.INSTANCE.getLoaderForDatabase(databaseDefinition, SQLTablesFactory.eINSTANCE.createColumn().eClass().getInstanceClassName());
        if (loader != null) {
            JDBCUDFColumnLoader udfColumnLoader = (JDBCUDFColumnLoader)loader;
            udfColumnLoader.setCatalogObject(this);
            return udfColumnLoader;
        }
        return new JDBCUDFColumnLoader(this);
    }

    protected final JDBCUDFColumnLoader getParameterLoader() {
        if (this.paremeterLoaderRef == null || this.paremeterLoaderRef.get() == null) {
            this.paremeterLoaderRef = new SoftReference<JDBCUDFColumnLoader>(this.createParameterLoader());
        }
        return (JDBCUDFColumnLoader)this.paremeterLoaderRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadParameters() {
        boolean deliver = this.eDeliver();
        try {
            EList parametersContainer = super.getParameters();
            ArrayList existingParameters = new ArrayList(parametersContainer);
            this.eSetDeliver(false);
            parametersContainer.clear();
            this.setReturnScalar(null);
            this.getParameterLoader().loadParameters((List)parametersContainer, existingParameters);
            this.getParameterLoader().clearColumns(existingParameters);
            Iterator it = parametersContainer.iterator();
            while (it.hasNext()) {
                Parameter p = (Parameter)it.next();
                if (p.getMode() != ParameterMode.OUT_LITERAL) continue;
                this.setReturnScalar(p);
                it.remove();
                break;
            }
            this.parametersLoaded = Boolean.TRUE;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.eSetDeliver(deliver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadResultTable() {
        boolean deliver = this.eDeliver();
        try {
            this.eSetDeliver(false);
            List returnTableList = this.getParameterLoader().loadRoutineResultTables();
            if (returnTableList.size() > 0) {
                this.setReturnTable((RoutineResultTable)returnTableList.get(0));
            }
            this.resultTableLoaded = Boolean.TRUE;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.eSetDeliver(deliver);
        }
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 16: {
                this.getParameters();
                break;
            }
            case 24: {
                this.getReturnTable();
                break;
            }
            case 25: {
                this.getReturnScalar();
            }
        }
        return super.eIsSet(eFeature);
    }
}

