/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.metadata.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jst.jsf.common.JSFCommonPlugin;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataLocator;

public class MetaDataLocatorFactory {
    private static MetaDataLocatorFactory INSTANCE = null;
    private HashMap _locators;

    public static synchronized MetaDataLocatorFactory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MetaDataLocatorFactory();
        }
        return INSTANCE;
    }

    private Map getLocators() {
        if (this._locators == null) {
            this._locators = new HashMap();
        }
        return this._locators;
    }

    public IMetaDataLocator getLocator(String locatorClassName, String bundleId) {
        String key = this.getKey(locatorClassName, bundleId);
        IMetaDataLocator locator = (IMetaDataLocator)this.getLocators().get(key);
        if (locator == null) {
            Class klass = JSFCommonPlugin.loadClass(locatorClassName, bundleId);
            try {
                locator = (IMetaDataLocator)klass.newInstance();
                if (locator != null) {
                    this.getLocators().put(key, locator);
                    locator.startLocating();
                }
            }
            catch (InstantiationException e) {
                JSFCommonPlugin.log(4, "Could not instantiate IMetaDataLocator: " + key, e);
            }
            catch (IllegalAccessException e) {
                JSFCommonPlugin.log(4, "IllegalAccessException while creating IMetaDataLocator: " + key, e);
            }
        }
        return locator;
    }

    private String getKey(String locatorClassName, String bundleId) {
        StringBuffer buf = new StringBuffer(bundleId);
        buf.append(":");
        buf.append(locatorClassName);
        return buf.toString();
    }

    public void dispose() {
        for (IMetaDataLocator locator : this.getLocators().values()) {
            locator.stopLocating();
        }
        this.getLocators().clear();
    }
}

