/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jpt.ui.internal.details.BaseJpaController;
import org.eclipse.jpt.ui.internal.widgets.CComboViewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class EnumComboViewer
extends BaseJpaController {
    private EnumHolder enumHolder;
    private Adapter enumListener;
    private CComboViewer comboViewer;

    public EnumComboViewer(Composite parent, CommandStack theCommandStack, TabbedPropertySheetWidgetFactory widgetFactory) {
        super(parent, theCommandStack, widgetFactory);
        this.buildListener();
    }

    private void buildListener() {
        this.enumListener = new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                EnumComboViewer.this.modelChanged(notification);
            }
        };
    }

    protected void buildWidget(Composite parent) {
        CCombo combo = this.getWidgetFactory().createCCombo(parent);
        this.comboViewer = new CComboViewer(combo);
        this.comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EnumComboViewer.this.selectionChanged(event.getSelection());
            }
        });
    }

    void selectionChanged(ISelection sel) {
        if (sel instanceof IStructuredSelection) {
            Object selection = ((IStructuredSelection)sel).getFirstElement();
            if (!this.enumHolder.get().equals(selection)) {
                this.enumHolder.set(selection);
            }
        }
    }

    private void modelChanged(Notification notification) {
        if (notification.getFeatureID(this.enumHolder.featureClass()) == this.enumHolder.featureId()) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    EnumComboViewer.this.populate();
                }
            });
        }
    }

    protected void engageListeners() {
        if (this.enumHolder != null && this.enumHolder.wrappedObject() != null) {
            this.enumHolder.wrappedObject().eAdapters().add((Object)this.enumListener);
        }
    }

    protected void disengageListeners() {
        if (this.enumHolder != null && this.enumHolder.wrappedObject() != null) {
            this.enumHolder.wrappedObject().eAdapters().remove((Object)this.enumListener);
        }
    }

    public final void populate(EnumHolder enumHolder) {
        super.populate(enumHolder);
    }

    public void doPopulate(EObject obj) {
        this.enumHolder = (EnumHolder)obj;
        this.populateCombo();
    }

    protected void doPopulate() {
        this.populateCombo();
    }

    private void populateCombo() {
        this.comboViewer.getCombo().removeAll();
        if (this.enumHolder.wrappedObject() == null) {
            return;
        }
        this.comboViewer.add(this.enumHolder.enumValues());
        Object modelSetting = this.enumHolder.get();
        if (((IStructuredSelection)this.comboViewer.getSelection()).getFirstElement() != modelSetting) {
            this.comboViewer.setSelection((ISelection)new StructuredSelection(modelSetting));
        }
    }

    public Control getControl() {
        return this.comboViewer.getCombo();
    }

    public static interface EnumHolder
    extends EObject {
        public Object get();

        public void set(Object var1);

        public Class featureClass();

        public int featureId();

        public EObject wrappedObject();

        public Object[] enumValues();
    }
}

