/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import java.util.Iterator;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jpt.core.internal.mappings.DefaultTrueBoolean;
import org.eclipse.jpt.core.internal.mappings.IAbstractColumn;
import org.eclipse.jpt.core.internal.mappings.IAbstractJoinColumn;
import org.eclipse.jpt.core.internal.mappings.IJoinColumn;
import org.eclipse.jpt.core.internal.mappings.INamedColumn;
import org.eclipse.jpt.core.internal.mappings.ISingleRelationshipMapping;
import org.eclipse.jpt.ui.internal.details.BaseJpaComposite;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.ui.internal.mappings.details.JoinColumnDialog;
import org.eclipse.jpt.ui.internal.mappings.details.JoinColumnInRelationshipMappingDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class JoinColumnComposite
extends BaseJpaComposite {
    private ISingleRelationshipMapping singleRelationshipMapping;
    private final Adapter singleRelationshipMappingListener = this.buildSingleRelationshipMappingListener();
    private final Adapter joinColumnListener = this.buildJoinColumnListener();
    private Group joinColumnsGroup;
    Button overrideDefaultJoinColumnsCheckBox;
    ListViewer joinColumnsListViewer;
    private Button joinColumnsRemoveButton;
    private Button joinColumnsEditButton;

    public JoinColumnComposite(Composite parent, CommandStack commandStack, TabbedPropertySheetWidgetFactory widgetFactory) {
        super(parent, 0, commandStack, widgetFactory);
    }

    private Adapter buildSingleRelationshipMappingListener() {
        return new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                JoinColumnComposite.this.singleRelationshipMappingChanged(notification);
            }
        };
    }

    private Adapter buildJoinColumnListener() {
        return new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                JoinColumnComposite.this.joinColumnChanged(notification);
            }
        };
    }

    protected void initializeLayout(Composite composite) {
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        this.overrideDefaultJoinColumnsCheckBox = this.getWidgetFactory().createButton(composite, JptUiMappingsMessages.JoinColumnComposite_overrideDefaultJoinColumns, 32);
        this.overrideDefaultJoinColumnsCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (JoinColumnComposite.this.overrideDefaultJoinColumnsCheckBox.getSelection()) {
                    IJoinColumn defaultJoinColumn = (IJoinColumn)JoinColumnComposite.this.singleRelationshipMapping.getDefaultJoinColumns().get(0);
                    String columnName = defaultJoinColumn.getDefaultName();
                    String referencedColumnName = defaultJoinColumn.getDefaultReferencedColumnName();
                    IJoinColumn joinColumn = JoinColumnComposite.this.singleRelationshipMapping.createJoinColumn(0);
                    JoinColumnComposite.this.singleRelationshipMapping.getSpecifiedJoinColumns().add((Object)joinColumn);
                    joinColumn.setSpecifiedName(columnName);
                    joinColumn.setSpecifiedReferencedColumnName(referencedColumnName);
                } else {
                    JoinColumnComposite.this.singleRelationshipMapping.getSpecifiedJoinColumns().clear();
                }
            }
        });
        this.joinColumnsGroup = this.getWidgetFactory().createGroup(composite, JptUiMappingsMessages.JoinColumnComposite_joinColumn);
        this.joinColumnsGroup.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 2;
        this.joinColumnsGroup.setLayoutData((Object)gridData);
        this.joinColumnsListViewer = new ListViewer((Composite)this.joinColumnsGroup, 2050);
        this.joinColumnsListViewer.setContentProvider(this.buildJoinColumnsListContentProvider());
        this.joinColumnsListViewer.setLabelProvider((IBaseLabelProvider)this.buildJoinColumnsListLabelProvider());
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.verticalSpan = 3;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.joinColumnsListViewer.getList().setLayoutData((Object)gridData);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.joinColumnsListViewer.getList(), "org.eclipse.jpt.ui.mapping_joinTableJoinColumns");
        Button addJoinColumnButton = this.getWidgetFactory().createButton((Composite)this.joinColumnsGroup, JptUiMappingsMessages.JoinColumnComposite_add, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        addJoinColumnButton.setLayoutData((Object)gridData);
        addJoinColumnButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                JoinColumnComposite.this.addJoinColumn();
            }
        });
        this.joinColumnsEditButton = this.getWidgetFactory().createButton((Composite)this.joinColumnsGroup, JptUiMappingsMessages.JoinColumnComposite_edit, 0);
        this.joinColumnsEditButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                JoinColumnComposite.this.editJoinColumn();
            }
        });
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.joinColumnsEditButton.setLayoutData((Object)gridData);
        this.joinColumnsRemoveButton = this.getWidgetFactory().createButton((Composite)this.joinColumnsGroup, JptUiMappingsMessages.JoinColumnComposite_remove, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        this.joinColumnsRemoveButton.setLayoutData((Object)gridData);
        this.joinColumnsRemoveButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                JoinColumnComposite.this.removeJoinColumn();
            }
        });
        this.joinColumnsListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                JoinColumnComposite.this.updateEnablement();
            }
        });
    }

    private IContentProvider buildJoinColumnsListContentProvider() {
        return new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return ((ISingleRelationshipMapping)inputElement).getJoinColumns().toArray();
            }
        };
    }

    private ILabelProvider buildJoinColumnsListLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                IJoinColumn joinColumn = (IJoinColumn)element;
                return JoinColumnComposite.this.singleRelationshipMapping.getSpecifiedJoinColumns().size() == 0 ? JoinColumnComposite.this.buildDefaultJoinColumnLabel(joinColumn) : JoinColumnComposite.this.buildJoinColumnLabel(joinColumn);
            }
        };
    }

    String buildDefaultJoinColumnLabel(IJoinColumn joinColumn) {
        return NLS.bind((String)JptUiMappingsMessages.JoinColumnComposite_mappingBetweenTwoParamsDefault, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
    }

    String buildJoinColumnLabel(IJoinColumn joinColumn) {
        if (joinColumn.getSpecifiedName() == null) {
            if (joinColumn.getSpecifiedReferencedColumnName() == null) {
                return NLS.bind((String)JptUiMappingsMessages.JoinColumnComposite_mappingBetweenTwoParamsBothDefault, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
            }
            return NLS.bind((String)JptUiMappingsMessages.JoinColumnComposite_mappingBetweenTwoParamsFirstDefault, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
        }
        if (joinColumn.getSpecifiedReferencedColumnName() == null) {
            return NLS.bind((String)JptUiMappingsMessages.JoinColumnComposite_mappingBetweenTwoParamsSecDefault, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
        }
        return NLS.bind((String)JptUiMappingsMessages.JoinColumnComposite_mappingBetweenTwoParams, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
    }

    protected void joinColumnChanged(Notification notification) {
        if (notification.getFeatureID(INamedColumn.class) == 1 || notification.getFeatureID(INamedColumn.class) == 2 || notification.getFeatureID(IAbstractColumn.class) == 9 || notification.getFeatureID(IAbstractColumn.class) == 10 || notification.getFeatureID(IAbstractJoinColumn.class) == 5 || notification.getFeatureID(IAbstractJoinColumn.class) == 6) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (JoinColumnComposite.this.getControl().isDisposed()) {
                        return;
                    }
                    JoinColumnComposite.this.joinColumnsListViewer.refresh();
                }
            });
        }
    }

    void addJoinColumn() {
        JoinColumnInRelationshipMappingDialog dialog = new JoinColumnInRelationshipMappingDialog(this.getControl().getShell(), this.singleRelationshipMapping);
        this.addJoinColumnFromDialog(dialog);
    }

    private void addJoinColumnFromDialog(JoinColumnDialog dialog) {
        if (dialog.open() != 0) {
            return;
        }
        int index = this.singleRelationshipMapping.getJoinColumns().size();
        IJoinColumn joinColumn = this.singleRelationshipMapping.createJoinColumn(index);
        this.singleRelationshipMapping.getSpecifiedJoinColumns().add((Object)joinColumn);
        joinColumn.setSpecifiedName(dialog.getSelectedName());
        joinColumn.setSpecifiedReferencedColumnName(dialog.getReferencedColumnName());
        joinColumn.setSpecifiedTable(dialog.getSelectedTable());
    }

    void editJoinColumn() {
        IJoinColumn joinColumn = this.getSelectedJoinColumn();
        JoinColumnInRelationshipMappingDialog dialog = new JoinColumnInRelationshipMappingDialog(this.getControl().getShell(), joinColumn);
        this.editJoinColumnFromDialog(dialog, joinColumn);
    }

    private IJoinColumn getSelectedJoinColumn() {
        return (IJoinColumn)((StructuredSelection)this.joinColumnsListViewer.getSelection()).getFirstElement();
    }

    private void editJoinColumnFromDialog(JoinColumnDialog dialog, IJoinColumn joinColumn) {
        if (dialog.open() == 0) {
            this.editJoinColumnDialogOkd(dialog, joinColumn);
        }
    }

    private void editJoinColumnDialogOkd(JoinColumnDialog dialog, IJoinColumn joinColumn) {
        String name = dialog.getSelectedName();
        String referencedColumnName = dialog.getReferencedColumnName();
        String table = dialog.getSelectedTable();
        if (dialog.isDefaultNameSelected()) {
            if (joinColumn.getSpecifiedName() != null) {
                joinColumn.setSpecifiedName(null);
            }
        } else if (joinColumn.getSpecifiedName() == null || !joinColumn.getSpecifiedName().equals(name)) {
            joinColumn.setSpecifiedName(name);
        }
        if (dialog.isDefaultReferencedColumnNameSelected()) {
            if (joinColumn.getSpecifiedReferencedColumnName() != null) {
                joinColumn.setSpecifiedReferencedColumnName(null);
            }
        } else if (joinColumn.getSpecifiedReferencedColumnName() == null || !joinColumn.getSpecifiedReferencedColumnName().equals(referencedColumnName)) {
            joinColumn.setSpecifiedReferencedColumnName(referencedColumnName);
        }
        if (dialog.isDefaultTableSelected()) {
            if (joinColumn.getSpecifiedTable() != null) {
                joinColumn.setSpecifiedTable(null);
            }
        } else if (joinColumn.getSpecifiedTable() == null || !joinColumn.getSpecifiedTable().equals(table)) {
            joinColumn.setSpecifiedTable(table);
        }
        DefaultTrueBoolean insertable = dialog.getInsertable();
        if (joinColumn.getInsertable() != insertable) {
            joinColumn.setInsertable(insertable);
        }
        DefaultTrueBoolean updatable = dialog.getUpdatable();
        if (joinColumn.getUpdatable() != updatable) {
            joinColumn.setUpdatable(updatable);
        }
    }

    void removeJoinColumn() {
        ISelection selection = this.joinColumnsListViewer.getSelection();
        if (selection instanceof StructuredSelection) {
            Iterator stream = ((StructuredSelection)selection).iterator();
            while (stream.hasNext()) {
                this.singleRelationshipMapping.getJoinColumns().remove(stream.next());
            }
        }
    }

    protected void singleRelationshipMappingChanged(Notification notification) {
        if (notification.getFeatureID(ISingleRelationshipMapping.class) == 7) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (JoinColumnComposite.this.getControl().isDisposed()) {
                        return;
                    }
                    JoinColumnComposite.this.joinColumnsListViewer.refresh();
                    JoinColumnComposite.this.overrideDefaultJoinColumnsCheckBox.setSelection(JoinColumnComposite.this.singleRelationshipMapping.containsSpecifiedJoinColumns());
                    JoinColumnComposite.this.updateEnablement();
                }
            });
            if (notification.getEventType() == 3) {
                ((IJoinColumn)notification.getNewValue()).eAdapters().add((Object)this.joinColumnListener);
            } else if (notification.getEventType() == 4) {
                ((IJoinColumn)notification.getOldValue()).eAdapters().remove((Object)this.joinColumnListener);
            }
        }
    }

    private void enableGroup(Group group, boolean enabled) {
        group.setEnabled(enabled);
        int i = 0;
        while (i < group.getChildren().length) {
            group.getChildren()[i].setEnabled(enabled);
            ++i;
        }
    }

    protected void engageListeners() {
        if (this.singleRelationshipMapping != null) {
            this.singleRelationshipMapping.eAdapters().add((Object)this.singleRelationshipMappingListener);
            Iterator i = this.singleRelationshipMapping.getJoinColumns().iterator();
            while (i.hasNext()) {
                ((IJoinColumn)i.next()).eAdapters().add((Object)this.joinColumnListener);
            }
        }
    }

    protected void disengageListeners() {
        if (this.singleRelationshipMapping != null) {
            Iterator i = this.singleRelationshipMapping.getJoinColumns().iterator();
            while (i.hasNext()) {
                ((IJoinColumn)i.next()).eAdapters().remove((Object)this.joinColumnListener);
            }
            this.singleRelationshipMapping.eAdapters().remove((Object)this.singleRelationshipMappingListener);
        }
    }

    public void doPopulate(EObject obj) {
        this.singleRelationshipMapping = (ISingleRelationshipMapping)obj;
        if (this.singleRelationshipMapping == null) {
            this.joinColumnsListViewer.setInput(null);
            return;
        }
        this.joinColumnsListViewer.setInput((Object)this.singleRelationshipMapping);
        this.updateEnablement();
        this.overrideDefaultJoinColumnsCheckBox.setSelection(this.singleRelationshipMapping.containsSpecifiedJoinColumns());
    }

    protected void doPopulate() {
        this.joinColumnsListViewer.setInput((Object)this.singleRelationshipMapping);
    }

    void updateEnablement() {
        boolean groupEnabledState = this.singleRelationshipMapping.containsSpecifiedJoinColumns();
        this.enableGroup(this.joinColumnsGroup, groupEnabledState);
        this.joinColumnsRemoveButton.setEnabled(groupEnabledState && !((StructuredSelection)this.joinColumnsListViewer.getSelection()).isEmpty());
        this.joinColumnsEditButton.setEnabled(groupEnabledState && ((StructuredSelection)this.joinColumnsListViewer.getSelection()).size() == 1);
    }

    public void dispose() {
        this.disengageListeners();
        super.dispose();
    }
}

