/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.impl;

import java.io.IOException;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jem.util.RegistryReader;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.UnresolveableURIException;
import org.eclipse.wst.common.componentcore.internal.ModulecorePlugin;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.impl.IResourceFactoryExtPtConstants;
import org.eclipse.wst.common.componentcore.internal.impl.ModuleURIUtil;
import org.eclipse.wst.common.componentcore.internal.impl.PlatformURLModuleConnection;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.internal.emf.resource.FileNameResourceFactoryRegistry;
import org.eclipse.wst.common.internal.emf.resource.ResourceFactoryDescriptor;
import org.eclipse.wst.common.internal.emf.utilities.DefaultOverridableResourceFactoryRegistry;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;

public class WTPResourceFactoryRegistry
extends FileNameResourceFactoryRegistry {
    public static final WTPResourceFactoryRegistry INSTANCE = new WTPResourceFactoryRegistry();
    private static final boolean LOG_WARNINGS = false;

    private WTPResourceFactoryRegistry() {
        new ResourceFactoryRegistryReader().readRegistry();
    }

    public Resource.Factory delegatedGetFactory(URI uri) {
        if (INSTANCE == this) {
            return super.delegatedGetFactory(uri);
        }
        return INSTANCE.getFactory(uri);
    }

    public synchronized Resource.Factory getFactory(URI uri, IContentDescription description) {
        Resource.Factory resourceFactory = null;
        if (uri != null && uri.lastSegment() != null) {
            ResourceFactoryDescriptor descriptor = null;
            descriptor = description == null ? this.getDescriptor(uri) : this.getDescriptor(uri, description);
            if (descriptor != null) {
                resourceFactory = this.getFactory(descriptor);
            }
        }
        if (resourceFactory == null) {
            resourceFactory = super.getFactory(uri);
        }
        return resourceFactory;
    }

    public synchronized Resource.Factory getFactory(URI uri) {
        return this.getFactory(uri, null);
    }

    public synchronized void registerLastFileSegment(String aSimpleFileName, Resource.Factory aFactory) {
        super.registerLastFileSegment(aSimpleFileName, aFactory);
    }

    private WTPResourceFactoryRegistryKey getKey(ResourceFactoryDescriptor descriptor) {
        WTPResourceFactoryRegistryKey key = new WTPResourceFactoryRegistryKey();
        key.shortName = descriptor.getShortSegment();
        key.type = descriptor.getContentType();
        key.isDefault = descriptor.isDefault();
        return key;
    }

    protected void addDescriptor(ResourceFactoryDescriptor descriptor) {
        this.getDescriptors().put(this.getKey(descriptor), descriptor);
    }

    protected synchronized ResourceFactoryDescriptor getDescriptor(URI uri, IContentDescription description) {
        Set keys = this.getDescriptors().keySet();
        ResourceFactoryDescriptor defaultDesc = null;
        for (WTPResourceFactoryRegistryKey key : keys) {
            if (!key.shortName.equals(uri.lastSegment())) continue;
            ResourceFactoryDescriptor desc = (ResourceFactoryDescriptor)this.getDescriptors().get(key);
            if (description == null) {
                if (key.type == null) {
                    return desc;
                }
                if (desc.isDefault()) {
                    return desc;
                }
            }
            if (key.type != null && description != null && description.getContentType().equals(key.type)) {
                return desc;
            }
            if (description == null || !desc.isDefault()) continue;
            defaultDesc = desc;
        }
        return defaultDesc;
    }

    private URI newPlatformURI(URI aNewURI, IProject project) {
        if (project == null) {
            return ModuleURIUtil.trimToDeployPathSegment(aNewURI);
        }
        try {
            IVirtualComponent component = ComponentCore.createComponent(project);
            URI deployPathSegment = ModuleURIUtil.trimToDeployPathSegment(aNewURI);
            IVirtualFolder rootFolder = component.getRootFolder();
            IVirtualFile newFile = rootFolder.getFile((IPath)new Path(deployPathSegment.path()));
            return URI.createPlatformResourceURI((String)newFile.getWorkspaceRelativePath().toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private IContentDescription getDescriptionFromURI(URI uri) {
        String contentTypeIdentifier = ModuleURIUtil.getContentTypeName(uri);
        if (contentTypeIdentifier != null) {
            return Platform.getContentTypeManager().getContentType(contentTypeIdentifier).getDefaultDescription();
        }
        return null;
    }

    protected synchronized ResourceFactoryDescriptor getDescriptor(URI uri) {
        ResourceFactoryDescriptor defaultDesc;
        IContentDescription description;
        block9: {
            IFile file = WorkbenchResourceHelper.getPlatformFile((URI)uri);
            description = null;
            if (file != null && file.exists()) {
                try {
                    description = file.getContentDescription();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            if (description == null) {
                description = this.getDescriptionFromURI(uri);
                try {
                    if (description == null) break block9;
                    IProject componentProject = null;
                    try {
                        componentProject = StructureEdit.getContainingProject(uri);
                    }
                    catch (UnresolveableURIException e) {
                        e.printStackTrace();
                    }
                    uri = PlatformURLModuleConnection.resolve(uri);
                    uri = this.newPlatformURI(uri, componentProject);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if ((defaultDesc = this.getDescriptor(uri, description)) != null) {
            return defaultDesc;
        }
        return super.getDescriptor(uri);
    }

    static /* synthetic */ Resource.Factory access$0() {
        return DefaultOverridableResourceFactoryRegistry.GLOBAL_FACTORY;
    }

    private class ConfigurationResourceFactoryDescriptor
    extends ResourceFactoryDescriptor
    implements IResourceFactoryExtPtConstants {
        private String shortSegment;
        private IContentType contentType;
        private boolean isDefault = true;
        private final IConfigurationElement element;

        public ConfigurationResourceFactoryDescriptor(IConfigurationElement ext) throws CoreException {
            Assert.isNotNull((Object)ext);
            this.element = ext;
            this.init();
        }

        private void init() throws CoreException {
            IConfigurationElement[] bindings;
            this.shortSegment = this.element.getAttribute("shortSegment");
            if (this.shortSegment == null || this.shortSegment.trim().length() == 0) {
                throw new CoreException(ModulecorePlugin.createErrorStatus(0, "The shortSegment attribute of resourceFactory must specify a valid, non-null, non-empty value in " + this.element.getNamespaceIdentifier(), null));
            }
            if ("false".equals(this.element.getAttribute("isDefault"))) {
                this.isDefault = false;
            }
            if ((bindings = this.element.getChildren("contentTypeBinding")).length > 0) {
                String contentTypeId = null;
                contentTypeId = bindings[0].getAttribute("contentTypeId");
                if (contentTypeId != null) {
                    this.contentType = Platform.getContentTypeManager().getContentType(contentTypeId);
                }
            }
        }

        public boolean isEnabledFor(URI fileURI) {
            if (fileURI != null && fileURI.lastSegment() != null) {
                return this.shortSegment.equals(fileURI.lastSegment());
            }
            return false;
        }

        public Resource.Factory createFactory() {
            final Resource.Factory[] factory = new Resource.Factory[1];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    factory[0] = (Resource.Factory)ConfigurationResourceFactoryDescriptor.this.element.createExecutableExtension("class");
                }

                public void handleException(Throwable exception) {
                    ModulecorePlugin.log(ModulecorePlugin.createErrorStatus(0, exception.getMessage(), exception));
                }
            });
            return factory[0] != null ? factory[0] : WTPResourceFactoryRegistry.access$0();
        }

        public String getShortSegment() {
            return this.shortSegment;
        }

        public IContentType getContentType() {
            return this.contentType;
        }

        public boolean isDefault() {
            return this.isDefault;
        }

        public int hashCode() {
            if (this.getContentType() != null) {
                return this.getShortSegment().hashCode() & this.getContentType().hashCode();
            }
            return super.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof ResourceFactoryDescriptor && this.getContentType() != null) {
                return this.getShortSegment().equals(((ResourceFactoryDescriptor)o).getShortSegment()) && this.getContentType().equals(((ResourceFactoryDescriptor)o).getContentType());
            }
            if (((ResourceFactoryDescriptor)o).getContentType() != null) {
                return false;
            }
            return super.equals(o);
        }
    }

    private class ResourceFactoryRegistryReader
    extends RegistryReader
    implements IResourceFactoryExtPtConstants {
        public ResourceFactoryRegistryReader() {
            super(Platform.getPluginRegistry(), "org.eclipse.wst.common.modulecore", "resourceFactories");
        }

        public boolean readElement(final IConfigurationElement element) {
            if (element != null && "resourceFactory".equals(element.getName())) {
                final boolean[] success = new boolean[]{true};
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() throws Exception {
                        WTPResourceFactoryRegistry.this.addDescriptor(new ConfigurationResourceFactoryDescriptor(element));
                    }

                    public void handleException(Throwable exception) {
                        ModulecorePlugin.log(ModulecorePlugin.createErrorStatus(0, exception.getMessage(), exception));
                        success[0] = false;
                    }
                });
                return success[0];
            }
            return false;
        }
    }

    private class WTPResourceFactoryRegistryKey {
        public String shortName;
        public IContentType type;
        public boolean isDefault = true;
    }
}

