/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.contextlaunching;

import com.ibm.icu.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.ILaunchHistoryChangedListener;
import org.eclipse.debug.internal.ui.ILaunchLabelChangedListener;
import org.eclipse.debug.internal.ui.contextlaunching.ContextMessages;
import org.eclipse.debug.internal.ui.contextlaunching.ContextRunner;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.debug.internal.ui.stringsubstitution.SelectedResourceManager;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.jface.action.CoolBarManager;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchWindow;

public class LaunchingResourceManager
implements IPropertyChangeListener,
IWindowListener,
ISelectionListener,
ILaunchHistoryChangedListener,
ILaunchesListener2 {
    private ListenerList fLabelListeners = new ListenerList();
    private HashMap fToolbars = new HashMap();
    private HashMap fCurrentLabels = new HashMap();
    private boolean fUpdateLabel = true;
    private HashSet fWindows = new HashSet();
    private HashMap fConfigCache = new HashMap();
    private HashMap fExtCache = new HashMap();
    private static final String EMPTY_STRING = "";
    private MouseTrackAdapter fMouseListener = new MouseTrackAdapter(){

        public void mouseEnter(MouseEvent e) {
            if (LaunchingResourceManager.this.fUpdateLabel) {
                LaunchingResourceManager.this.fUpdateLabel = false;
                LaunchingResourceManager.this.fCurrentLabels.clear();
                Job job = new Job(this, "Compute launch button tooltip"){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    protected IStatus run(IProgressMonitor monitor) {
                        1.access$0(this.this$1).computeLabels();
                        LaunchingResourceManager.access$3(1.access$0(this.this$1)).clear();
                        LaunchingResourceManager.access$4(1.access$0(this.this$1)).clear();
                        return Status.OK_STATUS;
                    }
                };
                job.setSystem(true);
                job.schedule();
            }
        }

        static /* synthetic */ LaunchingResourceManager access$0(1 var0) {
            return var0.LaunchingResourceManager.this;
        }
    };

    public static boolean isContextLaunchEnabled() {
        return DebugUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.debug.ui.UseContextualLaunch");
    }

    public void addLaunchLabelUpdateListener(ILaunchLabelChangedListener listener) {
        this.fLabelListeners.add((Object)listener);
    }

    public void removeLaunchLabelChangedListener(ILaunchLabelChangedListener listener) {
        this.fLabelListeners.remove((Object)listener);
    }

    public String getLaunchLabel(ILaunchGroup group) {
        return (String)this.fCurrentLabels.get(group);
    }

    protected boolean shouldCheckParent() {
        return DebugUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.debug.ui.LaunchParentProject");
    }

    protected boolean shouldLaunchLast() {
        return DebugUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.debug.ui.LaunchLastIfNotLaunchable");
    }

    protected void computeLabels() {
        ILaunchGroup group = null;
        ILaunchConfiguration config = null;
        String label = null;
        Object[] listeners = this.fLabelListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            group = ((ILaunchLabelChangedListener)listeners[i]).getLaunchGroup();
            if (group != null) {
                if (LaunchingResourceManager.isContextLaunchEnabled() && !group.getIdentifier().equals("org.eclipse.ui.externaltools.launchGroup")) {
                    label = this.getResourceLabel(SelectedResourceManager.getDefault().getSelectedResource(), group);
                } else {
                    config = DebugUIPlugin.getDefault().getLaunchConfigurationManager().getFilteredLastLaunch(group.getIdentifier());
                    if (config != null) {
                        label = this.appendLaunched(config);
                    }
                }
                this.fCurrentLabels.put(group, label);
                label = null;
            }
            ++i;
        }
        this.notifyLabelChanged();
    }

    protected void notifyLabelChanged() {
        Object[] listeners = this.fLabelListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ILaunchLabelChangedListener)listeners[i]).labelChanged();
            ++i;
        }
    }

    private String appendLaunched(ILaunchConfiguration config) {
        ILaunch[] launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        boolean launched = false;
        ILaunchConfiguration tmp = null;
        int i = 0;
        while (i < launches.length) {
            tmp = launches[i].getLaunchConfiguration();
            if (tmp != null && !launches[i].isTerminated() && tmp.equals(config)) {
                launched = true;
                break;
            }
            ++i;
        }
        if (launched) {
            return MessageFormat.format((String)ContextMessages.LaunchingResourceManager_0, (Object[])new String[]{config.getName()});
        }
        return config.getName();
    }

    protected String getlastLaunchedLabel(ILaunchGroup group) {
        ILaunchConfiguration config = DebugUIPlugin.getDefault().getLaunchConfigurationManager().getFilteredLastLaunch(group.getIdentifier());
        if (config != null) {
            return this.appendLaunched(config);
        }
        return EMPTY_STRING;
    }

    protected String getResourceLabel(IResource resource, ILaunchGroup group) {
        int esize;
        int csize;
        if (resource == null) {
            String label;
            if (group != null && !EMPTY_STRING.equals(label = this.getlastLaunchedLabel(group))) {
                return label;
            }
            List shortcuts = ContextRunner.getDefault().getLaunchShortcutsForEmptySelection();
            if (!shortcuts.isEmpty()) {
                return ContextMessages.ContextRunner_14;
            }
            return EMPTY_STRING;
        }
        LaunchConfigurationManager lcm = DebugUIPlugin.getDefault().getLaunchConfigurationManager();
        ILaunchConfiguration config = lcm.isSharedConfig(resource);
        if (config != null) {
            return this.appendLaunched(config);
        }
        List configs = (List)this.fConfigCache.get(resource);
        if (configs == null) {
            configs = lcm.getApplicableLaunchConfigurations(resource);
            this.fConfigCache.put(resource, configs);
        }
        if ((csize = configs.size()) == 1) {
            return this.appendLaunched((ILaunchConfiguration)configs.get(0));
        }
        if (csize > 1) {
            config = lcm.getMRUConfiguration(configs, group, resource);
            if (config != null) {
                return this.appendLaunched(config);
            }
            return ContextMessages.ContextRunner_14;
        }
        List exts = (List)this.fExtCache.get(resource);
        if (exts == null) {
            exts = lcm.getLaunchShortcuts(resource);
            this.fExtCache.put(resource, exts);
        }
        if ((esize = exts.size()) == 0) {
            if (this.shouldCheckParent()) {
                IProject project = resource.getProject();
                if (project != null && !project.equals((Object)resource)) {
                    return this.getResourceLabel((IResource)project, group);
                }
            } else {
                if (this.shouldLaunchLast()) {
                    return this.getlastLaunchedLabel(group);
                }
                return ContextMessages.ContextRunner_15;
            }
        }
        if (esize == 1) {
            return resource.getName();
        }
        return ContextMessages.ContextRunner_14;
    }

    public void startup() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null) {
            workbench.addWindowListener((IWindowListener)this);
        }
        DebugUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        DebugUIPlugin.getDefault().getLaunchConfigurationManager().addLaunchHistoryListener(this);
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this);
    }

    public void shutdown() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null) {
            workbench.removeWindowListener((IWindowListener)this);
        }
        DebugUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        DebugUIPlugin.getDefault().getLaunchConfigurationManager().removeLaunchHistoryListener(this);
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)this);
        IWorkbenchWindow window = null;
        ToolBar bar = null;
        Iterator<Object> iter = this.fToolbars.keySet().iterator();
        while (iter.hasNext()) {
            window = (IWorkbenchWindow)iter.next();
            bar = (ToolBar)this.fToolbars.remove(window);
            if (bar == null || bar.isDisposed()) continue;
            bar.removeMouseTrackListener((MouseTrackListener)this.fMouseListener);
        }
        iter = this.fWindows.iterator();
        while (iter.hasNext()) {
            ((IWorkbenchWindow)iter.next()).getSelectionService().removeSelectionListener((ISelectionListener)this);
        }
        this.fWindows.clear();
        this.fToolbars.clear();
        this.fLabelListeners.clear();
        this.fCurrentLabels.clear();
    }

    public void windowActivated(IWorkbenchWindow window) {
        if (!this.fToolbars.containsKey(window)) {
            this.addMouseListener(window);
        }
    }

    public void windowClosed(IWorkbenchWindow window) {
        ToolBar bar = (ToolBar)this.fToolbars.remove(window);
        if (bar != null && !bar.isDisposed()) {
            bar.removeMouseTrackListener((MouseTrackListener)this.fMouseListener);
        }
        if (this.fWindows.remove(window)) {
            window.getSelectionService().removeSelectionListener((ISelectionListener)this);
        }
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    public void windowOpened(IWorkbenchWindow window) {
        if (this.fWindows.add(window)) {
            window.getSelectionService().addSelectionListener((ISelectionListener)this);
        }
    }

    private void addMouseListener(IWorkbenchWindow window) {
        ToolBarManager tmgr;
        ToolBar bar;
        IContributionItem item;
        CoolBarManager cmgr = ((WorkbenchWindow)window).getCoolBarManager();
        if (cmgr != null && (item = cmgr.find("org.eclipse.debug.ui.launchActionSet")) instanceof ToolBarContributionItem && (bar = (tmgr = (ToolBarManager)((ToolBarContributionItem)item).getToolBarManager()).getControl()) != null && !bar.isDisposed()) {
            bar.addMouseTrackListener((MouseTrackListener)this.fMouseListener);
            this.fToolbars.put(window, bar);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("org.eclipse.debug.ui.UseContextualLaunch") || event.getProperty().equals("org.eclipse.debug.ui.LaunchLastIfNotLaunchable")) {
            if (LaunchingResourceManager.isContextLaunchEnabled()) {
                this.windowActivated(DebugUIPlugin.getActiveWorkbenchWindow());
            }
            this.fUpdateLabel = true;
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        this.fUpdateLabel = LaunchingResourceManager.isContextLaunchEnabled();
    }

    public void launchHistoryChanged() {
        this.fUpdateLabel = true;
    }

    public void launchesTerminated(ILaunch[] launches) {
        this.fUpdateLabel = true;
    }

    public void launchesAdded(ILaunch[] launches) {
        this.fUpdateLabel = true;
    }

    public void launchesChanged(ILaunch[] launches) {
    }

    public void launchesRemoved(ILaunch[] launches) {
    }

    static /* synthetic */ HashMap access$3(LaunchingResourceManager launchingResourceManager) {
        return launchingResourceManager.fConfigCache;
    }

    static /* synthetic */ HashMap access$4(LaunchingResourceManager launchingResourceManager) {
        return launchingResourceManager.fExtCache;
    }
}

