/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.model;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.internal.ui.viewers.model.ILabelUpdateListener;
import org.eclipse.debug.internal.ui.viewers.model.LabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.ModelContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.TreeModelContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.TreeModelLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IColumnPresentation;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IColumnPresentationFactory;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementEditor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelChangedListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelSelectionPolicy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelSelectionPolicyFactory;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdateListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.PresentationContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILazyTreePathContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IMemento;

public class InternalTreeModelViewer
extends TreeViewer {
    private IPresentationContext fContext;
    private IColumnPresentation fColumnPresentation = null;
    private Map fVisibleColumns = new HashMap();
    private Map fColumnSizes = new HashMap();
    private Map fColumnOrder = new HashMap();
    private Map fShowColumns = new HashMap();
    private static final String TREE_PATH_KEY = "TREE_PATH_KEY";
    private static final String COLUMN_SIZES = "COLUMN_SIZES";
    private static final String COLUMN_ORDER = "COLUMN_ORDER";
    private static final String VISIBLE_COLUMNS = "VISIBLE_COLUMNS";
    private static final String SHOW_COLUMNS = "SHOW_COLUMNS";
    private static final String SIZE = "SIZE";
    private static final String COLUMN = "COLUMN";
    private boolean fInserting = false;
    private boolean fNotifyUnmap = true;
    private ColumnListener fListener = new ColumnListener();
    private CellModifierProxy fCellModifier;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public InternalTreeModelViewer(Composite parent, int style, IPresentationContext context) {
        super(parent, style);
        if ((style & 0x10000000) == 0) {
            throw new IllegalArgumentException("style must include SWT.VIRTUAL");
        }
        this.setUseHashlookup(true);
        this.fCellModifier = new CellModifierProxy();
        this.fContext = context;
        this.setContentProvider(this.createContentProvider());
        this.setLabelProvider((IBaseLabelProvider)this.createLabelProvider());
    }

    protected TreeModelContentProvider createContentProvider() {
        return new TreeModelContentProvider();
    }

    protected TreeModelLabelProvider createLabelProvider() {
        return new TreeModelLabelProvider(this);
    }

    protected void hookControl(Control control) {
        Tree treeControl = (Tree)control;
        treeControl.addListener(36, new Listener(){

            public void handleEvent(Event event) {
                TreeItem item = (TreeItem)event.item;
                InternalTreeModelViewer.this.preserveItem(item);
            }
        });
        super.hookControl(control);
    }

    private void preserveItem(TreeItem item) {
        Object[] backgrounds;
        Object[] foregrounds;
        Object[] fonts;
        Object[] images;
        Object[] labels = (Object[])item.getData(LabelUpdate.PREV_LABEL_KEY);
        if (labels != null) {
            int i = 0;
            while (i < labels.length) {
                if (labels[i] != null) {
                    item.setText(i, (String)labels[i]);
                }
                ++i;
            }
        }
        if ((images = (Object[])item.getData(LabelUpdate.PREV_IMAGE_KEY)) != null) {
            int i = 0;
            while (i < images.length) {
                item.setImage(i, (Image)images[i]);
                ++i;
            }
        }
        if ((fonts = (Object[])item.getData(LabelUpdate.PREV_FONT_KEY)) != null) {
            int i = 0;
            while (i < fonts.length) {
                item.setFont(i, (Font)fonts[i]);
                ++i;
            }
        }
        if ((foregrounds = (Object[])item.getData(LabelUpdate.PREV_FOREGROUND_KEY)) != null) {
            int i = 0;
            while (i < foregrounds.length) {
                item.setForeground(i, (Color)foregrounds[i]);
                ++i;
            }
        }
        if ((backgrounds = (Object[])item.getData(LabelUpdate.PREV_BACKGROUND_KEY)) != null) {
            int i = 0;
            while (i < backgrounds.length) {
                item.setBackground(i, (Color)backgrounds[i]);
                ++i;
            }
        }
    }

    protected void handleInvalidSelection(ISelection selection, ISelection newSelection) {
        ISelection temp;
        IModelSelectionPolicy selectionPolicy = this.getSelectionPolicy(selection);
        if (selectionPolicy != null && (temp = newSelection) != (newSelection = selectionPolicy.replaceInvalidSelection(selection, newSelection))) {
            if (newSelection == null) {
                newSelection = new StructuredSelection();
            }
            super.setSelection(newSelection, false);
            return;
        }
        super.handleInvalidSelection(selection, newSelection);
    }

    protected void handleDispose(DisposeEvent event) {
        if (this.fColumnPresentation != null) {
            this.fColumnPresentation.dispose();
        }
        this.fCellModifier.dispose();
        this.fContext.dispose();
        super.handleDispose(event);
    }

    public IPresentationContext getPresentationContext() {
        return this.fContext;
    }

    protected void unmapElement(Object element, Widget widget) {
        IContentProvider provider;
        if (this.fNotifyUnmap && (provider = this.getContentProvider()) instanceof ModelContentProvider) {
            ((ModelContentProvider)provider).unmapPath((TreePath)widget.getData(TREE_PATH_KEY));
        }
        super.unmapElement(element, widget);
    }

    protected void associate(Object element, Item item) {
        Object data = item.getData();
        if (data != null && data != element && this.equals(data, element)) {
            try {
                this.fNotifyUnmap = false;
                super.associate(element, item);
            }
            finally {
                this.fNotifyUnmap = true;
            }
        } else {
            super.associate(element, item);
        }
    }

    protected void mapElement(Object element, Widget widget) {
        super.mapElement(element, widget);
        if (widget instanceof Item) {
            widget.setData(TREE_PATH_KEY, (Object)this.getTreePathFromItem((Item)widget));
        } else {
            widget.setData(TREE_PATH_KEY, (Object)ModelContentProvider.EMPTY_TREE_PATH);
        }
    }

    public void insert(Object parentElementOrTreePath, Object element, int position) {
        try {
            this.fInserting = true;
            super.insert(parentElementOrTreePath, element, position);
        }
        finally {
            this.fInserting = false;
        }
    }

    protected boolean hasFilters() {
        if (this.fInserting) {
            return false;
        }
        return super.hasFilters();
    }

    protected void inputChanged(Object input, Object oldInput) {
        super.inputChanged(input, oldInput);
        this.resetColumns(input);
    }

    protected void resetColumns(Object input) {
        if (input != null) {
            IColumnPresentationFactory factory = this.getColumnPresenetationFactoryAdapter(input);
            PresentationContext context = (PresentationContext)this.getPresentationContext();
            String type = null;
            if (factory != null) {
                type = factory.getColumnPresentationId(context, input);
            }
            if (type != null) {
                if (this.fColumnPresentation != null && !this.fColumnPresentation.getId().equals(type)) {
                    this.fColumnPresentation.dispose();
                    this.fColumnPresentation = null;
                }
                if (this.fColumnPresentation == null) {
                    this.fColumnPresentation = factory.createColumnPresentation(context, input);
                    if (this.fColumnPresentation != null) {
                        this.fColumnPresentation.init(context);
                        this.configureColumns();
                    }
                }
            } else if (this.fColumnPresentation != null) {
                this.fColumnPresentation.dispose();
                this.fColumnPresentation = null;
                this.configureColumns();
            }
        }
    }

    protected IColumnPresentationFactory getColumnPresenetationFactoryAdapter(Object input) {
        if (input instanceof IColumnPresentationFactory) {
            return (IColumnPresentationFactory)input;
        }
        if (input instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)input;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.debug.internal.ui.viewers.model.provisional.IColumnPresentationFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (IColumnPresentationFactory)adaptable.getAdapter((Class)clazz);
        }
        return null;
    }

    protected void configureColumns() {
        if (this.fColumnPresentation != null) {
            IColumnPresentation build = null;
            if (this.isShowColumns(this.fColumnPresentation.getId())) {
                build = this.fColumnPresentation;
            }
            this.buildColumns(build);
        } else {
            this.buildColumns(null);
        }
    }

    public void setShowColumns(boolean show) {
        if (show) {
            if (!this.isShowColumns()) {
                this.fShowColumns.remove(this.fColumnPresentation.getId());
            }
        } else if (this.isShowColumns()) {
            this.fShowColumns.put(this.fColumnPresentation.getId(), Boolean.FALSE);
        }
        this.refreshColumns();
    }

    public void resetColumnSizes(String[] columnIds) {
        int i = 0;
        while (i < columnIds.length) {
            this.fColumnSizes.remove(columnIds[i]);
            ++i;
        }
    }

    public void setVisibleColumns(String[] ids) {
        IColumnPresentation presentation;
        if (ids != null && ids.length == 0) {
            ids = null;
        }
        if ((presentation = this.getColumnPresentation()) != null) {
            this.fColumnOrder.remove(presentation.getId());
            this.fVisibleColumns.remove(presentation.getId());
            if (ids != null) {
                String[] columns = presentation.getInitialColumns();
                if (columns.length == ids.length) {
                    int i = 0;
                    while (i < columns.length) {
                        if (!ids[i].equals(columns[i])) {
                            this.fVisibleColumns.put(presentation.getId(), ids);
                            break;
                        }
                        ++i;
                    }
                } else {
                    this.fVisibleColumns.put(presentation.getId(), ids);
                }
            }
            PresentationContext presentationContext = (PresentationContext)this.getPresentationContext();
            presentationContext.setColumns(this.getVisibleColumns());
            this.refreshColumns();
        }
    }

    protected void refreshColumns() {
        this.configureColumns();
        this.refresh();
    }

    public boolean isShowColumns() {
        if (this.fColumnPresentation != null) {
            return this.isShowColumns(this.fColumnPresentation.getId());
        }
        return false;
    }

    public boolean canToggleColumns() {
        return this.fColumnPresentation != null && this.fColumnPresentation.isOptional();
    }

    protected boolean isShowColumns(String columnPresentationId) {
        Boolean bool = (Boolean)this.fShowColumns.get(columnPresentationId);
        if (bool == null) {
            return true;
        }
        return bool;
    }

    protected void buildColumns(IColumnPresentation presentation) {
        Tree tree = this.getTree();
        TreeColumn[] columns = tree.getColumns();
        String[] visibleColumnIds = this.getVisibleColumns();
        int i = 0;
        while (i < columns.length) {
            TreeColumn treeColumn = columns[i];
            treeColumn.removeControlListener((ControlListener)this.fListener);
            treeColumn.dispose();
            ++i;
        }
        PresentationContext presentationContext = (PresentationContext)this.getPresentationContext();
        if (presentation != null) {
            int i2 = 0;
            while (i2 < visibleColumnIds.length) {
                String id = visibleColumnIds[i2];
                String header = presentation.getHeader(id);
                TreeColumn column = new TreeColumn(tree, 16384, i2);
                column.setMoveable(true);
                column.setText(header);
                column.setWidth(1);
                ImageDescriptor image = presentation.getImageDescriptor(id);
                if (image != null) {
                    column.setImage(((TreeModelLabelProvider)this.getLabelProvider()).getImage(image));
                }
                column.setData((Object)id);
                ++i2;
            }
            int[] order = (int[])this.fColumnOrder.get(presentation.getId());
            if (order != null) {
                tree.setColumnOrder(order);
            }
            tree.setHeaderVisible(true);
            tree.setLinesVisible(true);
            presentationContext.setColumns(this.getVisibleColumns());
            this.setColumnProperties(this.getVisibleColumns());
            this.setCellModifier(this.fCellModifier);
        } else {
            tree.setHeaderVisible(false);
            tree.setLinesVisible(false);
            presentationContext.setColumns(null);
            this.setCellModifier(null);
            this.setColumnProperties(null);
        }
        int avg = tree.getSize().x;
        if (visibleColumnIds != null) {
            avg /= visibleColumnIds.length;
        }
        if (avg == 0) {
            tree.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    Tree tree2 = InternalTreeModelViewer.this.getTree();
                    String[] visibleColumns = InternalTreeModelViewer.this.getVisibleColumns();
                    if (visibleColumns != null) {
                        int avg1 = tree2.getSize().x / visibleColumns.length;
                        InternalTreeModelViewer.this.initColumns(avg1);
                    }
                    tree2.removePaintListener((PaintListener)this);
                }
            });
        } else {
            this.initColumns(avg);
        }
    }

    private void initColumns(int widthHint) {
        TreeColumn[] columns = this.getTree().getColumns();
        int i = 0;
        while (i < columns.length) {
            TreeColumn treeColumn = columns[i];
            Integer width = (Integer)this.fColumnSizes.get(treeColumn.getData());
            if (width == null) {
                treeColumn.setWidth(widthHint);
            } else {
                treeColumn.setWidth(width.intValue());
            }
            treeColumn.addControlListener((ControlListener)this.fListener);
            ++i;
        }
    }

    public IColumnPresentation getColumnPresentation() {
        return this.fColumnPresentation;
    }

    public String[] getVisibleColumns() {
        IColumnPresentation presentation;
        if (this.isShowColumns() && (presentation = this.getColumnPresentation()) != null) {
            String[] columns = (String[])this.fVisibleColumns.get(presentation.getId());
            if (columns == null) {
                return presentation.getInitialColumns();
            }
            return columns;
        }
        return null;
    }

    protected void persistColumnSizes() {
        Tree tree = this.getTree();
        TreeColumn[] columns = tree.getColumns();
        int i = 0;
        while (i < columns.length) {
            TreeColumn treeColumn = columns[i];
            Object id = treeColumn.getData();
            this.fColumnSizes.put(id, new Integer(treeColumn.getWidth()));
            ++i;
        }
    }

    protected void persistColumnOrder() {
        IColumnPresentation presentation = this.getColumnPresentation();
        if (presentation != null) {
            Tree tree = this.getTree();
            int[] order = tree.getColumnOrder();
            if (order.length > 0) {
                int i = 0;
                while (i < order.length) {
                    if (i != order[i]) {
                        this.fColumnOrder.put(presentation.getId(), order);
                        return;
                    }
                    ++i;
                }
            }
            this.fColumnOrder.remove(presentation.getId());
        }
    }

    public void saveState(IMemento memento) {
        int i;
        String id;
        IMemento sizes;
        Map.Entry entry;
        Iterator iterator;
        if (!this.fColumnSizes.isEmpty()) {
            iterator = this.fColumnSizes.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                sizes = memento.createChild(COLUMN_SIZES, (String)entry.getKey());
                sizes.putInteger(SIZE, ((Integer)entry.getValue()).intValue());
            }
        }
        if (!this.fShowColumns.isEmpty()) {
            iterator = this.fShowColumns.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                sizes = memento.createChild(SHOW_COLUMNS, (String)entry.getKey());
                sizes.putString(SHOW_COLUMNS, ((Boolean)entry.getValue()).toString());
            }
        }
        if (!this.fVisibleColumns.isEmpty()) {
            iterator = this.fVisibleColumns.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                id = (String)entry.getKey();
                IMemento visible = memento.createChild(VISIBLE_COLUMNS, id);
                String[] columns = (String[])entry.getValue();
                visible.putInteger(SIZE, columns.length);
                i = 0;
                while (i < columns.length) {
                    visible.putString(COLUMN + Integer.toString(i), columns[i]);
                    ++i;
                }
            }
        }
        if (!this.fColumnOrder.isEmpty()) {
            iterator = this.fColumnOrder.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                id = (String)entry.getKey();
                IMemento orderMemento = memento.createChild(COLUMN_ORDER, id);
                int[] order = (int[])entry.getValue();
                orderMemento.putInteger(SIZE, order.length);
                i = 0;
                while (i < order.length) {
                    orderMemento.putInteger(COLUMN + Integer.toString(i), order[i]);
                    ++i;
                }
            }
        }
    }

    public void initState(IMemento memento) {
        int j;
        int length;
        Integer integer;
        String id;
        IMemento child;
        IMemento[] mementos = memento.getChildren(COLUMN_SIZES);
        int i = 0;
        while (i < mementos.length) {
            child = mementos[i];
            id = child.getID();
            Integer size = child.getInteger(SIZE);
            if (size != null) {
                this.fColumnSizes.put(id, size);
            }
            ++i;
        }
        mementos = memento.getChildren(SHOW_COLUMNS);
        i = 0;
        while (i < mementos.length) {
            child = mementos[i];
            id = child.getID();
            Boolean bool = Boolean.valueOf(child.getString(SHOW_COLUMNS));
            if (!bool.booleanValue()) {
                this.fShowColumns.put(id, bool);
            }
            ++i;
        }
        mementos = memento.getChildren(VISIBLE_COLUMNS);
        i = 0;
        while (i < mementos.length) {
            child = mementos[i];
            id = child.getID();
            integer = child.getInteger(SIZE);
            if (integer != null) {
                length = integer;
                String[] columns = new String[length];
                j = 0;
                while (j < length) {
                    columns[j] = child.getString(COLUMN + Integer.toString(j));
                    ++j;
                }
                this.fVisibleColumns.put(id, columns);
            }
            ++i;
        }
        mementos = memento.getChildren(COLUMN_ORDER);
        i = 0;
        while (i < mementos.length) {
            child = mementos[i];
            id = child.getID();
            integer = child.getInteger(SIZE);
            if (integer != null) {
                length = integer;
                int[] order = new int[length];
                j = 0;
                while (j < length) {
                    order[j] = child.getInteger(COLUMN + Integer.toString(j));
                    ++j;
                }
                this.fColumnOrder.put(id, order);
            }
            ++i;
        }
    }

    protected boolean overrideSelection(ISelection current, ISelection candidate) {
        IModelSelectionPolicy selectionPolicy = this.getSelectionPolicy(current);
        if (selectionPolicy == null) {
            return true;
        }
        if (selectionPolicy.contains(candidate, this.getPresentationContext())) {
            return selectionPolicy.overrides(current, candidate, this.getPresentationContext());
        }
        return !selectionPolicy.isSticky(current, this.getPresentationContext());
    }

    protected IModelSelectionPolicy getSelectionPolicy(ISelection selection) {
        IStructuredSelection ss;
        Object element;
        if (selection instanceof IStructuredSelection && (element = (ss = (IStructuredSelection)selection).getFirstElement()) instanceof IAdaptable) {
            IModelSelectionPolicyFactory factory;
            IAdaptable adaptable = (IAdaptable)element;
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.debug.internal.ui.viewers.model.provisional.IModelSelectionPolicyFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((factory = (IModelSelectionPolicyFactory)adaptable.getAdapter((Class)clazz)) != null) {
                return factory.createModelSelectionPolicyAdapter(adaptable, this.getPresentationContext());
            }
        }
        return null;
    }

    public void setSelection(ISelection selection, boolean reveal) {
        if (!this.overrideSelection(this.getSelection(), selection)) {
            return;
        }
        super.setSelection(selection, reveal);
    }

    public void setSelection(ISelection selection, boolean reveal, boolean force) {
        if (force) {
            super.setSelection(selection, reveal);
        } else {
            this.setSelection(selection, reveal);
        }
    }

    public void addViewerUpdateListener(IViewerUpdateListener listener) {
        ((ModelContentProvider)this.getContentProvider()).addViewerUpdateListener(listener);
    }

    public void removeViewerUpdateListener(IViewerUpdateListener listener) {
        ModelContentProvider cp = (ModelContentProvider)this.getContentProvider();
        if (cp != null) {
            cp.removeViewerUpdateListener(listener);
        }
    }

    public void addModelChangedListener(IModelChangedListener listener) {
        ((ModelContentProvider)this.getContentProvider()).addModelChangedListener(listener);
    }

    public void removeModelChangedListener(IModelChangedListener listener) {
        ModelContentProvider cp = (ModelContentProvider)this.getContentProvider();
        if (cp != null) {
            cp.removeModelChangedListener(listener);
        }
    }

    protected void doUpdateItem(Item item, Object element) {
        if (!(item instanceof TreeItem)) {
            return;
        }
        TreeItem treeItem = (TreeItem)item;
        if (treeItem.isDisposed()) {
            this.unmapElement(element, (Widget)treeItem);
            return;
        }
        ((TreeModelLabelProvider)this.getLabelProvider()).update(this.getTreePathFromItem(item), this.getViewerRowFromItem((Widget)treeItem));
        if (item.isDisposed()) {
            this.unmapElement(element, (Widget)item);
        }
    }

    boolean populateVitrualItems() {
        Tree tree = this.getTree();
        return this.populateVitrualItems(TreePath.EMPTY, tree.getItems());
    }

    private boolean populateVitrualItems(TreePath parentPath, TreeItem[] items) {
        boolean queued = false;
        int i = 0;
        while (i < items.length) {
            TreeItem treeItem = items[i];
            if (treeItem.getData() == null) {
                queued = true;
                ((ILazyTreePathContentProvider)this.getContentProvider()).updateElement(parentPath, i);
            }
            if (treeItem.getExpanded()) {
                queued = this.populateVitrualItems(parentPath.createChildPath(treeItem.getData()), treeItem.getItems()) | queued;
            }
            ++i;
        }
        return queued;
    }

    void addLabelUpdateListener(ILabelUpdateListener listener) {
        ((TreeModelLabelProvider)this.getLabelProvider()).addLabelUpdateListener(listener);
    }

    void removeLabelUpdateListener(ILabelUpdateListener listener) {
        ((TreeModelLabelProvider)this.getLabelProvider()).removeLabelUpdateListener(listener);
    }

    Widget findItem(TreePath path) {
        if (path.getSegmentCount() == 0) {
            return this.getTree();
        }
        Widget[] items = super.findItems(path.getLastSegment());
        if (items.length == 1) {
            return items[0];
        }
        int i = 0;
        while (i < items.length) {
            if (this.getTreePathFromItem((Item)items[i]).equals((Object)path)) {
                return items[i];
            }
            ++i;
        }
        return null;
    }

    public Item[] getChildren(Widget widget) {
        return super.getChildren(widget);
    }

    protected TreePath getTreePathFromItem(Item item) {
        return super.getTreePathFromItem(item);
    }

    protected void internalRefreshStruct(Widget widget, Object element, boolean updateLabels) {
        if (widget instanceof Tree) {
            ((Tree)widget).clearAll(true);
        } else if (widget instanceof TreeItem) {
            ((TreeItem)widget).clearAll(true);
        }
        int index = 0;
        TreeItem parent = null;
        if (widget instanceof TreeItem) {
            TreeItem treeItem = (TreeItem)widget;
            parent = treeItem.getParentItem();
            if (parent == null) {
                parent = treeItem.getParent();
            }
            index = parent instanceof Tree ? ((Tree)parent).indexOf(treeItem) : parent.indexOf(treeItem);
        }
        this.virtualRefreshExpandedItems((Widget)parent, widget, element, index);
    }

    private void virtualRefreshExpandedItems(Widget parent, Widget widget, Object element, int index) {
        if (widget instanceof Tree) {
            if (element == null) {
                ((Tree)widget).setItemCount(0);
                return;
            }
            this.virtualLazyUpdateChildCount(widget, this.getChildren(widget).length);
        } else if (((TreeItem)widget).getExpanded()) {
            this.preserveItem((TreeItem)widget);
            this.virtualLazyUpdateWidget(parent, index);
        } else {
            return;
        }
        Item[] items = this.getChildren(widget);
        int i = 0;
        while (i < items.length) {
            Item item = items[i];
            Object data = item.getData();
            this.virtualRefreshExpandedItems(widget, (Widget)item, data, i);
            ++i;
        }
    }

    private void virtualLazyUpdateChildCount(Widget widget, int currentChildCount) {
        TreePath treePath = widget instanceof Item ? this.getTreePathFromItem((Item)widget) : TreePath.EMPTY;
        ((ILazyTreePathContentProvider)this.getContentProvider()).updateChildCount(treePath, currentChildCount);
    }

    private void virtualLazyUpdateWidget(Widget widget, int index) {
        TreePath treePath;
        if (widget instanceof Item) {
            if (widget.getData() == null) {
                return;
            }
            treePath = this.getTreePathFromItem((Item)widget);
        } else {
            treePath = TreePath.EMPTY;
        }
        ((ILazyTreePathContentProvider)this.getContentProvider()).updateElement(treePath, index);
    }

    class CellModifierProxy
    implements ICellModifier {
        private ICellModifier fModifier;

        CellModifierProxy() {
        }

        public boolean canModify(Object element, String property) {
            IElementEditor editor = this.getElementEditorAdapter(element);
            if (editor != null) {
                CellEditor cellEditor;
                this.fModifier = editor.getCellModifier(InternalTreeModelViewer.this.getPresentationContext(), element);
                if (this.fModifier != null && this.fModifier.canModify(element, property) && (cellEditor = editor.getCellEditor(InternalTreeModelViewer.this.getPresentationContext(), property, element, (Composite)InternalTreeModelViewer.this.getControl())) != null) {
                    this.disposeCellEditors();
                    CellEditor[] newEditors = new CellEditor[InternalTreeModelViewer.this.getVisibleColumns().length];
                    int i = 0;
                    while (i < newEditors.length) {
                        newEditors[i] = cellEditor;
                        ++i;
                    }
                    InternalTreeModelViewer.this.setCellEditors(newEditors);
                    return true;
                }
            }
            return false;
        }

        public Object getValue(Object element, String property) {
            if (this.fModifier != null) {
                return this.fModifier.getValue(element, property);
            }
            return null;
        }

        public void modify(Object element, String property, Object value) {
            if (this.fModifier != null) {
                if (element instanceof Item) {
                    element = ((Item)element).getData();
                }
                this.fModifier.modify(element, property, value);
            }
        }

        protected void dispose() {
            this.fModifier = null;
            this.disposeCellEditors();
            InternalTreeModelViewer.this.setCellEditors(null);
        }

        protected void disposeCellEditors() {
            CellEditor[] cellEditors = InternalTreeModelViewer.this.getCellEditors();
            if (cellEditors != null) {
                int i = 0;
                while (i < cellEditors.length) {
                    CellEditor editor = cellEditors[i];
                    if (editor != null) {
                        editor.dispose();
                    }
                    ++i;
                }
            }
        }

        protected IElementEditor getElementEditorAdapter(Object input) {
            if (input instanceof IElementEditor) {
                return (IElementEditor)input;
            }
            if (input instanceof IAdaptable) {
                IAdaptable adaptable = (IAdaptable)input;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.debug.internal.ui.viewers.model.provisional.IElementEditor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return (IElementEditor)adaptable.getAdapter((Class)clazz);
            }
            return null;
        }
    }

    class ColumnListener
    implements ControlListener {
        ColumnListener() {
        }

        public void controlMoved(ControlEvent e) {
            InternalTreeModelViewer.this.persistColumnOrder();
        }

        public void controlResized(ControlEvent e) {
            InternalTreeModelViewer.this.persistColumnSizes();
        }
    }
}

