/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.servlet.ui.internal.wizard;

import java.util.Arrays;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPage;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPageExtension;
import org.eclipse.jdt.ui.wizards.NewElementWizardPage;
import org.eclipse.jst.j2ee.web.project.facet.WebFacetUtils;
import org.eclipse.jst.servlet.ui.internal.plugin.ServletUIPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class WebAppLibrariesContainerPage
extends NewElementWizardPage
implements IClasspathContainerPage,
IClasspathContainerPageExtension {
    private IProject ownerProject;
    private String libsProjectName;
    private Combo projectsCombo;

    public WebAppLibrariesContainerPage() {
        super("WebAppLibrariesContainerPage");
        this.setTitle(Resources.pageTitle);
        this.setDescription(Resources.pageDescription);
    }

    public IClasspathEntry getSelection() {
        Path path = new Path("org.eclipse.jst.j2ee.internal.web.container");
        int index = this.projectsCombo.getSelectionIndex();
        String selectedProjectName = this.projectsCombo.getItem(index);
        if (this.ownerProject == null || !selectedProjectName.equals(this.ownerProject.getName())) {
            path = path.append(selectedProjectName);
        }
        return JavaCore.newContainerEntry((IPath)path);
    }

    public void setSelection(IClasspathEntry cpentry) {
        IPath path;
        IPath iPath = path = cpentry == null ? null : cpentry.getPath();
        if (path == null || path.segmentCount() == 1) {
            if (this.ownerProject != null) {
                this.libsProjectName = this.ownerProject.getName();
            }
        } else {
            this.libsProjectName = path.segment(1);
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(composite, 0);
        label.setText(Resources.projectsLabel);
        String[] webProjects = WebAppLibrariesContainerPage.getWebProjects();
        this.projectsCombo = new Combo(composite, 8);
        this.projectsCombo.setItems(webProjects);
        int index = this.ownerProject != null ? WebAppLibrariesContainerPage.indexOf(webProjects, this.libsProjectName) : (this.projectsCombo.getItemCount() > 0 ? 0 : -1);
        if (index != -1) {
            this.projectsCombo.select(index);
        }
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.minimumWidth = 100;
        this.projectsCombo.setLayoutData((Object)gd);
        this.setControl((Control)composite);
    }

    public boolean finish() {
        return true;
    }

    public void initialize(IJavaProject project, IClasspathEntry[] currentEntries) {
        this.ownerProject = project == null ? null : project.getProject();
    }

    private static String[] getWebProjects() {
        try {
            Set projects = ProjectFacetsManager.getFacetedProjects((IProjectFacet)WebFacetUtils.WEB_FACET);
            Object[] names = new String[projects.size()];
            int i = 0;
            for (IFacetedProject fproj : projects) {
                names[i] = fproj.getProject().getName();
                ++i;
            }
            Arrays.sort(names);
            return names;
        }
        catch (CoreException e) {
            ServletUIPlugin.log(e.getStatus());
            return new String[0];
        }
    }

    private static int indexOf(String[] array, String str) {
        int i = 0;
        while (i < array.length) {
            if (array[i].equals(str)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static final class Resources
    extends NLS {
        public static String pageTitle;
        public static String pageDescription;
        public static String projectsLabel;

        static {
            Resources.initializeMessages((String)WebAppLibrariesContainerPage.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

