/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.importer.rose.ui;

import java.util.Collection;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.common.ui.celleditor.ExtendedTableEditor;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.converter.util.ConverterUtil;
import org.eclipse.emf.edit.provider.ItemProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.importer.ModelImporter;
import org.eclipse.emf.importer.rose.RoseImporter;
import org.eclipse.emf.importer.rose.RoseImporterPlugin;
import org.eclipse.emf.importer.ui.contribution.base.ModelImporterDetailPage;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class RoseDetailPage
extends ModelImporterDetailPage {
    protected Button loadPathMapSymbolsButton;
    protected Button browsePathMapLocationButton;
    protected Table pathMapTable;
    protected TableViewer pathMapTableViewer;
    protected boolean isCellEditing = false;

    public RoseDetailPage(ModelImporter modelImporter, String pageName) {
        super(modelImporter, pageName);
        this.setTitle(RoseImporterPlugin.INSTANCE.getString("_UI_RoseModelImport_title"));
        this.setDescription(RoseImporterPlugin.INSTANCE.getString(this.showGenModel() ? "_UI_RoseModelImportNewProject_description" : "_UI_RoseModelImportFile_description"));
    }

    public void dispose() {
        if (this.loadPathMapSymbolsButton != null) {
            this.loadPathMapSymbolsButton.removeListener(13, (Listener)this);
            this.loadPathMapSymbolsButton = null;
        }
        if (this.browsePathMapLocationButton != null) {
            this.browsePathMapLocationButton.removeListener(13, (Listener)this);
            this.browsePathMapLocationButton = null;
        }
        if (this.pathMapTable != null) {
            this.pathMapTable.removeListener(13, (Listener)this);
            this.pathMapTable = null;
        }
        if (this.pathMapTableViewer != null) {
            this.pathMapTableViewer = null;
        }
        super.dispose();
    }

    protected boolean supportMultipleURIs() {
        return false;
    }

    public RoseImporter getRoseImporter() {
        return (RoseImporter)this.getModelImporter();
    }

    protected void addDetailControl(Composite parent) {
        Group pathMapGroup = new Group(parent, 16);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 12;
        pathMapGroup.setLayout((Layout)layout);
        pathMapGroup.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        pathMapGroup.setText(RoseImporterPlugin.INSTANCE.getString("_UI_PathMap_label"));
        Composite buttonComposite = new Composite((Composite)pathMapGroup, 0);
        GridData data = new GridData(128);
        data.horizontalSpan = 2;
        buttonComposite.setLayoutData((Object)data);
        GridLayout layout2 = new GridLayout(2, true);
        layout2.marginLeft = -5;
        layout2.marginRight = -5;
        layout2.marginTop = -5;
        layout2.marginBottom = -5;
        buttonComposite.setLayout((Layout)layout2);
        this.loadPathMapSymbolsButton = new Button(buttonComposite, 8);
        this.loadPathMapSymbolsButton.setLayoutData((Object)new GridData(768));
        this.loadPathMapSymbolsButton.setText(RoseImporterPlugin.INSTANCE.getString("_UI_LoadSymbols_label"));
        this.loadPathMapSymbolsButton.addListener(13, (Listener)this);
        this.browsePathMapLocationButton = new Button(buttonComposite, 8);
        this.browsePathMapLocationButton.setLayoutData((Object)new GridData(768));
        this.browsePathMapLocationButton.setText(RoseImporterPlugin.INSTANCE.getString("_UI_Browse_label"));
        this.browsePathMapLocationButton.setEnabled(false);
        this.browsePathMapLocationButton.addListener(13, (Listener)this);
        this.pathMapTable = new Table((Composite)pathMapGroup, 2048);
        this.pathMapTable.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.pathMapTableViewer = new TableViewer(this.pathMapTable);
        this.pathMapTable.setHeaderVisible(true);
        this.pathMapTable.setLinesVisible(true);
        TableLayout layout3 = new TableLayout();
        TableColumn variableNameColumn = new TableColumn(this.pathMapTable, 0);
        layout3.addColumnData((ColumnLayoutData)new ColumnWeightData(2, true));
        variableNameColumn.setText(RoseImporterPlugin.INSTANCE.getString("_UI_SymbolName_label"));
        variableNameColumn.setResizable(true);
        TableColumn locationColumn = new TableColumn(this.pathMapTable, 0);
        layout3.addColumnData((ColumnLayoutData)new ColumnWeightData(3, true));
        locationColumn.setText(RoseImporterPlugin.INSTANCE.getString("_UI_ActualLocation_label"));
        locationColumn.setResizable(true);
        this.pathMapTable.setLayout((Layout)layout3);
        this.pathMapTable.addListener(13, (Listener)this);
        new ExtendedTableEditor(this.pathMapTable){

            protected void editItem(final TableItem tableItem, final int column) {
                switch (column) {
                    case 1: {
                        String string = tableItem.getText(column);
                        this.horizontalAlignment = 16384;
                        this.minimumWidth = Math.max(50, tableItem.getBounds((int)column).width);
                        final Text text = new Text((Composite)this.table, 0);
                        this.setEditor((Control)text, tableItem, column);
                        text.setFocus();
                        text.setText(string);
                        text.setSelection(0, string.length());
                        text.addFocusListener((FocusListener)new FocusAdapter(){

                            public void focusLost(FocusEvent event) {
                                this.modify(tableItem, column, text);
                            }
                        });
                        text.addKeyListener((KeyListener)new KeyAdapter(){

                            public void keyPressed(KeyEvent event) {
                                if (event.character == '\r' || event.character == '\n') {
                                    this.modify(tableItem, column, text);
                                    this.setEditor(null);
                                    text.dispose();
                                } else if (event.character == '\u001b') {
                                    this.setEditor(null);
                                    text.dispose();
                                }
                            }
                        });
                        RoseDetailPage.this.isCellEditing = true;
                        RoseDetailPage.this.setPageComplete(false);
                    }
                }
            }

            protected void modify(TableItem tableItem, int column, Text text) {
                tableItem.setText(column, text.getText());
                String key = tableItem.getText();
                String value = tableItem.getText(column);
                text.setVisible(false);
                if ("".equals(value)) {
                    value = null;
                }
                RoseDetailPage.this.getRoseImporter().getPathMap().put(key, value);
                RoseDetailPage.this.isCellEditing = false;
                RoseDetailPage.this.setErrorMessage(null);
                RoseDetailPage.this.setMessage(null);
                RoseDetailPage.this.setPageComplete(RoseDetailPage.this.isPageComplete());
            }
        };
        AdapterFactoryImpl adapterFactory = new AdapterFactoryImpl();
        this.pathMapTableViewer.setColumnProperties(new String[]{"a", "b"});
        this.pathMapTableViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)adapterFactory));
        this.pathMapTableViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory){

            public Image getColumnImage(Object o, int columnIndex) {
                return null;
            }

            public String getColumnText(Object o, int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return (String)o;
                    }
                }
                String result = RoseDetailPage.this.getRoseImporter().getPathMap().get(o);
                return result == null ? "" : result;
            }
        });
    }

    protected void doHandleEvent(Event event) {
        if (event.type == 13 && event.widget == this.loadPathMapSymbolsButton) {
            if (this.uriText.getText().trim().length() > 0) {
                this.getControl().getDisplay().syncExec(new Runnable(){

                    public void run() {
                        RoseDetailPage.this.loadPathMapSymbols();
                    }
                });
            }
        } else if (event.type == 13 && event.widget == this.pathMapTable) {
            this.browsePathMapLocationButton.setEnabled(this.pathMapTable.getSelectionIndex() != -1);
        } else if (event.type == 13 && event.widget == this.browsePathMapLocationButton) {
            int index = this.pathMapTable.getSelectionIndex();
            String symbol = this.pathMapTable.getItem(index).getText();
            DirectoryDialog directoryDialog = new DirectoryDialog(this.getShell());
            directoryDialog.setMessage(RoseImporterPlugin.INSTANCE.getString("_UI_PathMapDirectoryDialog_message", new Object[]{symbol}));
            String path = directoryDialog.open();
            if (path != null && path.length() > 0) {
                this.getRoseImporter().getPathMap().put(symbol, path);
                this.setPageComplete(false);
                this.pathMapTableViewer.refresh();
                if (++index < this.pathMapTable.getItemCount()) {
                    this.pathMapTable.select(index);
                }
            }
        } else {
            super.doHandleEvent(event);
        }
        this.getContainer().updateButtons();
    }

    public boolean isPageComplete() {
        return !this.isCellEditing && super.isPageComplete();
    }

    protected void adjustLoadButton() {
        super.adjustLoadButton();
        this.loadPathMapSymbolsButton.setEnabled(this.loadButton.isEnabled());
    }

    protected void refreshModel() {
        super.refreshModel();
        this.pathMapTableViewer.setInput((Object)new ItemProvider((Collection)this.getRoseImporter().getPathMap().keySet()));
    }

    protected void loadPathMapSymbols() {
        Diagnostic diagnostic = null;
        try {
            diagnostic = this.getRoseImporter().loadPathMap((Monitor)new BasicMonitor());
        }
        catch (Exception exception) {
            diagnostic = ConverterUtil.createErrorDiagnostic((Throwable)exception, (boolean)false);
        }
        this.internalSetGenModelFileName(diagnostic.getSeverity() == 0 ? this.getRoseImporter().getGenModelFileName() : this.getRoseImporter().computeDefaultGenModelFileName());
        Diagnostic nameDiagnostic = this.getRoseImporter().checkGenModelFileName();
        if (nameDiagnostic.getSeverity() != 0) {
            diagnostic = diagnostic.getSeverity() == 0 ? nameDiagnostic : ConverterUtil.mergeDiagnostic((Diagnostic)diagnostic, (Diagnostic)nameDiagnostic);
        }
        if (diagnostic.getSeverity() == 0 && this.getRoseImporter().getPathMap().isEmpty()) {
            diagnostic = new BasicDiagnostic(1, "org.eclipse.emf.converter", 0, RoseImporterPlugin.INSTANCE.getString("_UI_NoPathMap_message"), null);
        }
        this.pathMapTableViewer.setInput((Object)new ItemProvider((Collection)this.getRoseImporter().getPathMap().keySet()));
        this.handleDiagnostic(diagnostic, null, RoseImporterPlugin.INSTANCE.getString("_UI_LoadProblem_title"), RoseImporterPlugin.INSTANCE.getString("_UI_RoseLoadFailed_message"));
    }
}

