/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.WebBrowser;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.carbon.CFRange;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Point;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.internal.cocoa.Cocoa;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

class Safari
extends WebBrowser {
    int delegate;
    int webViewHandle;
    int windowBoundsHandler;
    boolean changingLocation;
    String lastHoveredLinkURL;
    String html;
    int identifier;
    int resourceCount;
    String url = "";
    org.eclipse.swt.graphics.Point location;
    org.eclipse.swt.graphics.Point size;
    boolean statusBar = true;
    boolean toolBar = true;
    boolean ignoreDispose;
    static Callback Callback3;
    static Callback Callback7;
    static final int MIN_SIZE = 16;
    static final int MAX_PROGRESS = 100;
    static final String WebElementLinkURLKey = "WebElementLinkURL";
    static final String URI_FROMMEMORY = "file:///";
    static final String ABOUT_BLANK = "about:blank";
    static final String ADD_WIDGET_KEY = "org.eclipse.swt.internal.addWidget";
    static final String BROWSER_WINDOW = "org.eclipse.swt.browser.Browser.Window";

    static {
        NativeClearSessions = new Runnable(){

            public void run() {
                int storage = Cocoa.objc_msgSend(Cocoa.C_NSHTTPCookieStorage, Cocoa.S_sharedHTTPCookieStorage);
                int cookies = Cocoa.objc_msgSend(storage, Cocoa.S_cookies);
                int count = Cocoa.objc_msgSend(cookies, Cocoa.S_count);
                int i = 0;
                while (i < count) {
                    boolean isSession;
                    int cookie = Cocoa.objc_msgSend(cookies, Cocoa.S_objectAtIndex, i);
                    boolean bl = isSession = Cocoa.objc_msgSend(cookie, Cocoa.S_isSessionOnly) != 0;
                    if (isSession) {
                        Cocoa.objc_msgSend(storage, Cocoa.S_deleteCookie, cookie);
                    }
                    ++i;
                }
            }
        };
    }

    Safari() {
    }

    public void create(Composite parent, int style) {
        int callback7Address;
        int callback3Address;
        if (OS.VERSION < 4144) {
            this.browser.dispose();
            SWT.error(2);
        }
        int[] outControl = new int[1];
        try {
            Cocoa.HIWebViewCreate(outControl);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.browser.dispose();
            SWT.error(2);
        }
        this.webViewHandle = outControl[0];
        if (this.webViewHandle == 0) {
            this.browser.dispose();
            SWT.error(2);
        }
        Display display = this.browser.getDisplay();
        display.setData(ADD_WIDGET_KEY, new Object[]{new Integer(this.webViewHandle), this.browser});
        if (display.getData(BROWSER_WINDOW) == null) {
            Rect bounds = new Rect();
            OS.SetRect(bounds, (short)0, (short)0, (short)1, (short)1);
            final int[] outWindow = new int[1];
            OS.CreateNewWindow(14, 0, bounds, outWindow);
            OS.ShowWindow(outWindow[0]);
            display.disposeExec(new Runnable(){

                public void run() {
                    if (outWindow[0] != 0) {
                        OS.DisposeWindow(outWindow[0]);
                    }
                    outWindow[0] = 0;
                }
            });
            display.setData(BROWSER_WINDOW, outWindow);
        }
        int window = OS.GetControlOwner(this.browser.handle);
        int[] contentView = new int[1];
        OS.HIViewFindByID(OS.HIViewGetRoot(window), OS.kHIViewWindowContentID(), contentView);
        OS.HIViewAddSubview(contentView[0], this.webViewHandle);
        OS.HIViewChangeFeatures(this.webViewHandle, 0x2000000, 0);
        OS.HIViewSetVisible(this.webViewHandle, true);
        if (this.browser.getShell().isVisible()) {
            int[] showEvent = new int[1];
            OS.CreateEvent(0, 2003398244, 24, 0.0, 1, showEvent);
            OS.SetEventParameter(showEvent[0], 0x2D2D2D2D, 2003398244, 4, new int[]{OS.GetControlOwner(this.browser.handle)});
            OS.SendEventToEventTarget(showEvent[0], OS.GetWindowEventTarget(window));
            if (showEvent[0] != 0) {
                OS.ReleaseEvent(showEvent[0]);
            }
        }
        final int webView = Cocoa.HIWebViewGetWebView(this.webViewHandle);
        final int notificationCenter = Cocoa.objc_msgSend(Cocoa.C_NSNotificationCenter, Cocoa.S_defaultCenter);
        Listener listener = new Listener(){

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 12: {
                        if (Safari.this.ignoreDispose) {
                            Safari.this.ignoreDispose = false;
                            break;
                        }
                        Safari.this.ignoreDispose = true;
                        Safari.this.browser.notifyListeners(e.type, e);
                        e.type = 0;
                        OS.RemoveEventHandler(Safari.this.windowBoundsHandler);
                        Safari.this.windowBoundsHandler = 0;
                        Object[] objectArray = new Object[2];
                        objectArray[0] = new Integer(Safari.this.webViewHandle);
                        e.display.setData(Safari.ADD_WIDGET_KEY, objectArray);
                        Cocoa.objc_msgSend(webView, Cocoa.S_setFrameLoadDelegate, 0);
                        Cocoa.objc_msgSend(webView, Cocoa.S_setResourceLoadDelegate, 0);
                        Cocoa.objc_msgSend(webView, Cocoa.S_setUIDelegate, 0);
                        Cocoa.objc_msgSend(webView, Cocoa.S_setPolicyDelegate, 0);
                        Cocoa.objc_msgSend(notificationCenter, Cocoa.S_removeObserver, Safari.this.delegate);
                        Cocoa.objc_msgSend(Safari.this.delegate, Cocoa.S_release);
                        OS.DisposeControl(Safari.this.webViewHandle);
                        Safari.this.html = null;
                        Safari.this.lastHoveredLinkURL = null;
                    }
                }
            }
        };
        this.browser.addListener(12, listener);
        if (Callback3 == null) {
            Callback3 = new Callback(this.getClass(), "eventProc3", 3);
        }
        if ((callback3Address = Callback3.getAddress()) == 0) {
            SWT.error(3);
        }
        int[] mask = new int[]{1801812322, 1, 1668183148, 4, 1668183148, 11, 1952807028, 2};
        OS.InstallEventHandler(OS.GetControlEventTarget(this.webViewHandle), callback3Address, mask.length / 2, mask, this.webViewHandle, null);
        int[] mask1 = new int[]{1668183148, 154, 1668183148, 157, 1668183148, 159};
        OS.InstallEventHandler(OS.GetControlEventTarget(this.browser.handle), callback3Address, mask1.length / 2, mask1, this.browser.handle, null);
        int[] mask2 = new int[]{2003398244, 27};
        int[] outRef = new int[1];
        OS.InstallEventHandler(OS.GetWindowEventTarget(window), callback3Address, mask2.length / 2, mask2, this.browser.handle, outRef);
        this.windowBoundsHandler = outRef[0];
        if (Callback7 == null) {
            Callback7 = new Callback(this.getClass(), "eventProc7", 7);
        }
        if ((callback7Address = Callback7.getAddress()) == 0) {
            SWT.error(3);
        }
        this.delegate = Cocoa.objc_msgSend(Cocoa.C_WebKitDelegate, Cocoa.S_alloc);
        this.delegate = Cocoa.objc_msgSend(this.delegate, Cocoa.S_initWithProc, callback7Address, this.webViewHandle);
        Cocoa.objc_msgSend(webView, Cocoa.S_setFrameLoadDelegate, this.delegate);
        Cocoa.objc_msgSend(webView, Cocoa.S_setResourceLoadDelegate, this.delegate);
        Cocoa.objc_msgSend(webView, Cocoa.S_setUIDelegate, this.delegate);
        Cocoa.objc_msgSend(notificationCenter, Cocoa.S_addObserver_selector_name_object, this.delegate, Cocoa.S_handleNotification, 0, webView);
        Cocoa.objc_msgSend(webView, Cocoa.S_setPolicyDelegate, this.delegate);
        Cocoa.objc_msgSend(webView, Cocoa.S_setDownloadDelegate, this.delegate);
    }

    static int eventProc3(int nextHandler, int theEvent, int userData) {
        Widget widget = Display.getCurrent().findWidget(userData);
        if (widget instanceof Browser) {
            return ((Safari)((Browser)widget).webBrowser).handleCallback(nextHandler, theEvent);
        }
        return -9874;
    }

    static int eventProc7(int webview, int userData, int selector, int arg0, int arg1, int arg2, int arg3) {
        Widget widget = Display.getCurrent().findWidget(userData);
        if (widget instanceof Browser) {
            return ((Safari)((Browser)widget).webBrowser).handleCallback(selector, arg0, arg1, arg2, arg3);
        }
        return 0;
    }

    public boolean back() {
        this.html = null;
        int webView = Cocoa.HIWebViewGetWebView(this.webViewHandle);
        return Cocoa.objc_msgSend(webView, Cocoa.S_goBack) != 0;
    }

    public boolean execute(String script) {
        int length = script.length();
        char[] buffer = new char[length];
        script.getChars(0, length, buffer, 0);
        int string = OS.CFStringCreateWithCharacters(0, buffer, length);
        int webView = Cocoa.HIWebViewGetWebView(this.webViewHandle);
        int value = Cocoa.objc_msgSend(webView, Cocoa.S_stringByEvaluatingJavaScriptFromString, string);
        OS.CFRelease(string);
        return value != 0;
    }

    public boolean forward() {
        this.html = null;
        int webView = Cocoa.HIWebViewGetWebView(this.webViewHandle);
        return Cocoa.objc_msgSend(webView, Cocoa.S_goForward) != 0;
    }

    public String getUrl() {
        return this.url;
    }

    int handleCallback(int nextHandler, int theEvent) {
        int eventKind = OS.GetEventKind(theEvent);
        switch (OS.GetEventClass(theEvent)) {
            case 1668183148: {
                switch (eventKind) {
                    case 11: {
                        return 0;
                    }
                    case 4: {
                        if (this.browser.isVisible()) break;
                        return 0;
                    }
                    case 159: {
                        int window = OS.GetControlOwner(this.browser.handle);
                        int[] contentView = new int[1];
                        OS.HIViewFindByID(OS.HIViewGetRoot(window), OS.kHIViewWindowContentID(), contentView);
                        OS.HIViewAddSubview(contentView[0], this.webViewHandle);
                        OS.RemoveEventHandler(this.windowBoundsHandler);
                        int[] mask2 = new int[]{2003398244, 27};
                        int[] outRef = new int[1];
                        OS.InstallEventHandler(OS.GetWindowEventTarget(window), Callback3.getAddress(), mask2.length / 2, mask2, this.browser.handle, outRef);
                        this.windowBoundsHandler = outRef[0];
                        break;
                    }
                    case 154: 
                    case 157: {
                        CGRect bounds = new CGRect();
                        if (!this.browser.isVisible()) {
                            bounds.y = -16.0f;
                            bounds.x = -16.0f;
                            bounds.height = 16.0f;
                            bounds.width = 16.0f;
                            OS.HIViewSetFrame(this.webViewHandle, bounds);
                            break;
                        }
                        OS.HIViewGetBounds(this.browser.handle, bounds);
                        int[] contentView = new int[1];
                        OS.HIViewFindByID(OS.HIViewGetRoot(OS.GetControlOwner(this.browser.handle)), OS.kHIViewWindowContentID(), contentView);
                        OS.HIViewConvertRect(bounds, this.browser.handle, contentView[0]);
                        if (bounds.width <= 16.0f) {
                            bounds.width = 16.0f;
                        }
                        if (bounds.height <= 16.0f) {
                            bounds.height = 16.0f;
                        }
                        OS.HIViewSetFrame(this.webViewHandle, bounds);
                    }
                }
            }
            case 2003398244: {
                switch (eventKind) {
                    case 27: {
                        if (!this.browser.isVisible()) break;
                        CGRect oldBounds = new CGRect();
                        OS.GetEventParameter(theEvent, 1869767540, 1751741027, null, 16, null, oldBounds);
                        CGRect bounds = new CGRect();
                        OS.GetEventParameter(theEvent, 1668440948, 1751741027, null, 16, null, bounds);
                        if (oldBounds.height == bounds.height) break;
                        OS.HIViewGetBounds(this.browser.handle, bounds);
                        int[] contentView = new int[1];
                        OS.HIViewFindByID(OS.HIViewGetRoot(OS.GetControlOwner(this.browser.handle)), OS.kHIViewWindowContentID(), contentView);
                        OS.HIViewConvertRect(bounds, this.browser.handle, contentView[0]);
                        if (bounds.width <= 16.0f) {
                            bounds.width = 16.0f;
                        }
                        if (bounds.height <= 16.0f) {
                            bounds.height = 16.0f;
                        }
                        bounds.x += 1.0f;
                        OS.HIViewSetFrame(this.webViewHandle, bounds);
                        bounds.x -= 1.0f;
                        OS.HIViewSetFrame(this.webViewHandle, bounds);
                    }
                }
            }
            case 1801812322: {
                switch (eventKind) {
                    case 1: {
                        int[] length = new int[1];
                        int status = OS.GetEventParameter(theEvent, 1802858089, 1970567284, null, 4, length, null);
                        if (status != 0 || length[0] == 0) break;
                        int[] modifiers = new int[1];
                        OS.GetEventParameter(theEvent, 1802334052, 1835100014, null, 4, null, modifiers);
                        char[] chars = new char[1];
                        OS.GetEventParameter(theEvent, 1802858089, 1970567284, null, 2, null, chars);
                        if ((modifiers[0] & 0x100) == 0) break;
                        switch (chars[0]) {
                            case 'v': {
                                int webView = Cocoa.HIWebViewGetWebView(this.webViewHandle);
                                Cocoa.objc_msgSend(webView, Cocoa.S_paste);
                                return 0;
                            }
                            case 'c': {
                                int webView = Cocoa.HIWebViewGetWebView(this.webViewHandle);
                                Cocoa.objc_msgSend(webView, Cocoa.S_copy);
                                return 0;
                            }
                            case 'x': {
                                int webView = Cocoa.HIWebViewGetWebView(this.webViewHandle);
                                Cocoa.objc_msgSend(webView, Cocoa.S_cut);
                                return 0;
                            }
                        }
                    }
                }
            }
            case 1952807028: {
                switch (eventKind) {
                    default: 
                }
            }
        }
        return -9874;
    }

    int handleCallback(int selector, int arg0, int arg1, int arg2, int arg3) {
        int ret = 0;
        switch (selector) {
            case 1: {
                this.didFailProvisionalLoadWithError(arg0, arg1);
                break;
            }
            case 2: {
                this.didFinishLoadForFrame(arg0);
                break;
            }
            case 3: {
                this.didReceiveTitle(arg0, arg1);
                break;
            }
            case 4: {
                this.didStartProvisionalLoadForFrame(arg0);
                break;
            }
            case 5: {
                this.didFinishLoadingFromDataSource(arg0, arg1);
                break;
            }
            case 6: {
                this.didFailLoadingWithError(arg0, arg1, arg2);
                break;
            }
            case 7: {
                ret = this.identifierForInitialRequest(arg0, arg1);
                break;
            }
            case 8: {
                ret = this.willSendRequest(arg0, arg1, arg2, arg3);
                break;
            }
            case 9: {
                this.handleNotification(arg0);
                break;
            }
            case 10: {
                this.didCommitLoadForFrame(arg0);
                break;
            }
            case 11: {
                ret = this.createWebViewWithRequest(arg0);
                break;
            }
            case 12: {
                this.webViewShow(arg0);
                break;
            }
            case 13: {
                this.setFrame(arg0);
                break;
            }
            case 14: {
                this.webViewClose();
                break;
            }
            case 15: {
                ret = this.contextMenuItemsForElement(arg0, arg1);
                break;
            }
            case 16: {
                this.setStatusBarVisible(arg0);
                break;
            }
            case 17: {
                this.setResizable(arg0);
                break;
            }
            case 18: {
                this.setToolbarsVisible(arg0);
                break;
            }
            case 19: {
                this.decidePolicyForMIMEType(arg0, arg1, arg2, arg3);
                break;
            }
            case 20: {
                this.decidePolicyForNavigationAction(arg0, arg1, arg2, arg3);
                break;
            }
            case 21: {
                this.decidePolicyForNewWindowAction(arg0, arg1, arg2, arg3);
                break;
            }
            case 22: {
                this.unableToImplementPolicyWithError(arg0, arg1);
                break;
            }
            case 23: {
                this.setStatusText(arg0);
                break;
            }
            case 24: {
                this.webViewFocus();
                break;
            }
            case 25: {
                this.webViewUnfocus();
                break;
            }
            case 26: {
                this.runJavaScriptAlertPanelWithMessage(arg0);
                break;
            }
            case 27: {
                ret = this.runJavaScriptConfirmPanelWithMessage(arg0);
                break;
            }
            case 28: {
                this.runOpenPanelForFileButtonWithResultListener(arg0);
                break;
            }
            case 29: {
                this.decideDestinationWithSuggestedFilename(arg0, arg1);
                break;
            }
            case 30: {
                this.mouseDidMoveOverElement(arg0, arg1);
            }
        }
        return ret;
    }

    public boolean isBackEnabled() {
        int webView = Cocoa.HIWebViewGetWebView(this.webViewHandle);
        return Cocoa.objc_msgSend(webView, Cocoa.S_canGoBack) != 0;
    }

    public boolean isForwardEnabled() {
        int webView = Cocoa.HIWebViewGetWebView(this.webViewHandle);
        return Cocoa.objc_msgSend(webView, Cocoa.S_canGoForward) != 0;
    }

    public void refresh() {
        int webView = Cocoa.HIWebViewGetWebView(this.webViewHandle);
        Cocoa.objc_msgSend(webView, Cocoa.S_reload, 0);
    }

    public boolean setText(String html) {
        if (this.changingLocation) {
            this.html = html;
        } else {
            this._setText(html);
        }
        return true;
    }

    void _setText(String html) {
        int length = html.length();
        char[] buffer = new char[length];
        html.getChars(0, length, buffer, 0);
        int string = OS.CFStringCreateWithCharacters(0, buffer, length);
        length = URI_FROMMEMORY.length();
        buffer = new char[length];
        URI_FROMMEMORY.getChars(0, length, buffer, 0);
        int URLString = OS.CFStringCreateWithCharacters(0, buffer, length);
        int URL2 = Cocoa.objc_msgSend(Cocoa.C_NSURL, Cocoa.S_URLWithString, URLString);
        OS.CFRelease(URLString);
        int webView = Cocoa.HIWebViewGetWebView(this.webViewHandle);
        int mainFrame = Cocoa.objc_msgSend(webView, Cocoa.S_mainFrame);
        Cocoa.objc_msgSend(mainFrame, Cocoa.S_loadHTMLStringbaseURL, string, URL2);
        OS.CFRelease(string);
    }

    public boolean setUrl(String url) {
        this.html = null;
        StringBuffer buffer = new StringBuffer();
        if (url.indexOf(47) == 0) {
            buffer.append("file://");
        } else if (url.indexOf(58) == -1) {
            buffer.append("http://");
        }
        int i = 0;
        while (i < url.length()) {
            char c = url.charAt(i);
            if (c == ' ') {
                buffer.append("%20");
            } else {
                buffer.append(c);
            }
            ++i;
        }
        int length = buffer.length();
        char[] chars = new char[length];
        buffer.getChars(0, length, chars, 0);
        int sHandle = OS.CFStringCreateWithCharacters(0, chars, length);
        int inURL = Cocoa.objc_msgSend(Cocoa.C_NSURL, Cocoa.S_URLWithString, sHandle);
        OS.CFRelease(sHandle);
        int request = Cocoa.objc_msgSend(Cocoa.C_NSURLRequest, Cocoa.S_requestWithURL, inURL);
        int webView = Cocoa.HIWebViewGetWebView(this.webViewHandle);
        int mainFrame = Cocoa.objc_msgSend(webView, Cocoa.S_mainFrame);
        Cocoa.objc_msgSend(mainFrame, Cocoa.S_loadRequest, request);
        return true;
    }

    public void stop() {
        this.html = null;
        int webView = Cocoa.HIWebViewGetWebView(this.webViewHandle);
        Cocoa.objc_msgSend(webView, Cocoa.S_stopLoading, 0);
    }

    void didFailProvisionalLoadWithError(int error, int frame) {
        int webView = Cocoa.HIWebViewGetWebView(this.webViewHandle);
        if (frame == Cocoa.objc_msgSend(webView, Cocoa.S_mainFrame)) {
            this.identifier = 0;
        }
    }

    void didFinishLoadForFrame(int frame) {
        int webView = Cocoa.HIWebViewGetWebView(this.webViewHandle);
        if (frame == Cocoa.objc_msgSend(webView, Cocoa.S_mainFrame)) {
            int title;
            final Display display = this.browser.getDisplay();
            int dataSource = Cocoa.objc_msgSend(frame, Cocoa.S_dataSource);
            if (dataSource != 0 && (title = Cocoa.objc_msgSend(dataSource, Cocoa.S_pageTitle)) == 0) {
                final TitleEvent newEvent = new TitleEvent(this.browser);
                newEvent.display = display;
                newEvent.widget = this.browser;
                newEvent.title = this.url;
                int i = 0;
                while (i < this.titleListeners.length) {
                    final TitleListener listener = this.titleListeners[i];
                    display.asyncExec(new Runnable(){

                        public void run() {
                            if (!display.isDisposed() && !Safari.this.browser.isDisposed()) {
                                listener.changed(newEvent);
                            }
                        }
                    });
                    ++i;
                }
            }
            final ProgressEvent progress = new ProgressEvent(this.browser);
            progress.display = display;
            progress.widget = this.browser;
            progress.current = 100;
            progress.total = 100;
            int i = 0;
            while (i < this.progressListeners.length) {
                final ProgressListener listener = this.progressListeners[i];
                display.asyncExec(new Runnable(){

                    public void run() {
                        if (!display.isDisposed() && !Safari.this.browser.isDisposed()) {
                            listener.completed(progress);
                        }
                    }
                });
                ++i;
            }
            this.identifier = 0;
        }
    }

    void didReceiveTitle(int title, int frame) {
        int webView = Cocoa.HIWebViewGetWebView(this.webViewHandle);
        if (frame == Cocoa.objc_msgSend(webView, Cocoa.S_mainFrame)) {
            int length = OS.CFStringGetLength(title);
            char[] buffer = new char[length];
            CFRange range = new CFRange();
            range.length = length;
            OS.CFStringGetCharacters(title, range, buffer);
            String newTitle = new String(buffer);
            TitleEvent newEvent = new TitleEvent(this.browser);
            newEvent.display = this.browser.getDisplay();
            newEvent.widget = this.browser;
            newEvent.title = newTitle;
            int i = 0;
            while (i < this.titleListeners.length) {
                this.titleListeners[i].changed(newEvent);
                ++i;
            }
        }
    }

    void didStartProvisionalLoadForFrame(int frame) {
    }

    void didCommitLoadForFrame(int frame) {
        boolean top;
        int webView = Cocoa.HIWebViewGetWebView(this.webViewHandle);
        int dataSource = Cocoa.objc_msgSend(frame, Cocoa.S_dataSource);
        int request = Cocoa.objc_msgSend(dataSource, Cocoa.S_request);
        int url = Cocoa.objc_msgSend(request, Cocoa.S_URL);
        int s = Cocoa.objc_msgSend(url, Cocoa.S_absoluteString);
        int length = OS.CFStringGetLength(s);
        if (length == 0) {
            return;
        }
        char[] buffer = new char[length];
        CFRange range = new CFRange();
        range.length = length;
        OS.CFStringGetCharacters(s, range, buffer);
        String url2 = new String(buffer);
        if (url2.equals(URI_FROMMEMORY)) {
            url2 = ABOUT_BLANK;
        }
        final Display display = this.browser.getDisplay();
        boolean bl = top = frame == Cocoa.objc_msgSend(webView, Cocoa.S_mainFrame);
        if (top) {
            this.resourceCount = 0;
            this.url = url2;
            final ProgressEvent progress = new ProgressEvent(this.browser);
            progress.display = display;
            progress.widget = this.browser;
            progress.current = 1;
            progress.total = 100;
            int i = 0;
            while (i < this.progressListeners.length) {
                final ProgressListener listener = this.progressListeners[i];
                display.asyncExec(new Runnable(){

                    public void run() {
                        if (!display.isDisposed() && !Safari.this.browser.isDisposed()) {
                            listener.changed(progress);
                        }
                    }
                });
                ++i;
            }
            StatusTextEvent statusText = new StatusTextEvent(this.browser);
            statusText.display = display;
            statusText.widget = this.browser;
            statusText.text = url2;
            int i2 = 0;
            while (i2 < this.statusTextListeners.length) {
                this.statusTextListeners[i2].changed(statusText);
                ++i2;
            }
        }
        LocationEvent location = new LocationEvent(this.browser);
        location.display = display;
        location.widget = this.browser;
        location.location = url2;
        location.top = top;
        int i = 0;
        while (i < this.locationListeners.length) {
            this.locationListeners[i].changed(location);
            ++i;
        }
    }

    void didFinishLoadingFromDataSource(int identifier, int dataSource) {
    }

    void didFailLoadingWithError(int identifier, int error, int dataSource) {
    }

    int identifierForInitialRequest(int request, int dataSource) {
        final Display display = this.browser.getDisplay();
        final ProgressEvent progress = new ProgressEvent(this.browser);
        progress.display = display;
        progress.widget = this.browser;
        progress.current = this.resourceCount;
        progress.total = Math.max(this.resourceCount, 100);
        int i = 0;
        while (i < this.progressListeners.length) {
            final ProgressListener listener = this.progressListeners[i];
            display.asyncExec(new Runnable(){

                public void run() {
                    if (!display.isDisposed() && !Safari.this.browser.isDisposed()) {
                        listener.changed(progress);
                    }
                }
            });
            ++i;
        }
        int identifier = Cocoa.objc_msgSend(Cocoa.C_NSNumber, Cocoa.S_numberWithInt, this.resourceCount++);
        if (this.identifier == 0) {
            int webView = Cocoa.HIWebViewGetWebView(this.webViewHandle);
            int frame = Cocoa.objc_msgSend(dataSource, Cocoa.S_webFrame);
            if (frame == Cocoa.objc_msgSend(webView, Cocoa.S_mainFrame)) {
                this.identifier = identifier;
            }
        }
        return identifier;
    }

    int willSendRequest(int identifier, int request, int redirectResponse, int dataSource) {
        return request;
    }

    void handleNotification(int notification) {
    }

    int createWebViewWithRequest(int request) {
        WindowEvent newEvent = new WindowEvent(this.browser);
        newEvent.display = this.browser.getDisplay();
        newEvent.widget = this.browser;
        newEvent.required = true;
        if (this.openWindowListeners != null) {
            int i = 0;
            while (i < this.openWindowListeners.length) {
                this.openWindowListeners[i].open(newEvent);
                ++i;
            }
        }
        int webView = 0;
        Browser browser = newEvent.browser;
        if (browser != null && !browser.isDisposed()) {
            webView = Cocoa.HIWebViewGetWebView(((Safari)browser.webBrowser).webViewHandle);
            if (request != 0) {
                int mainFrame = Cocoa.objc_msgSend(webView, Cocoa.S_mainFrame);
                Cocoa.objc_msgSend(mainFrame, Cocoa.S_loadRequest, request);
            }
        }
        return webView;
    }

    void webViewShow(int sender) {
        Shell parent = this.browser.getShell();
        org.eclipse.swt.graphics.Point pt = parent.getSize();
        parent.setSize(pt.x + 1, pt.y);
        parent.setSize(pt.x, pt.y);
        WindowEvent newEvent = new WindowEvent(this.browser);
        newEvent.display = this.browser.getDisplay();
        newEvent.widget = this.browser;
        if (this.location != null) {
            newEvent.location = this.location;
        }
        if (this.size != null) {
            newEvent.size = this.size;
        }
        newEvent.addressBar = this.toolBar;
        newEvent.menuBar = true;
        newEvent.statusBar = this.statusBar;
        newEvent.toolBar = this.toolBar;
        int i = 0;
        while (i < this.visibilityWindowListeners.length) {
            this.visibilityWindowListeners[i].show(newEvent);
            ++i;
        }
        this.location = null;
        this.size = null;
    }

    void setFrame(int frame) {
        float[] dest = new float[4];
        OS.memmove(dest, frame, 16);
        Rectangle bounds = this.browser.getDisplay().getBounds();
        this.location = new org.eclipse.swt.graphics.Point((int)dest[0], bounds.height - (int)dest[1] - (int)dest[3]);
        this.size = new org.eclipse.swt.graphics.Point((int)dest[2], (int)dest[3]);
    }

    void webViewFocus() {
    }

    void webViewUnfocus() {
    }

    void runJavaScriptAlertPanelWithMessage(int message) {
        int length = OS.CFStringGetLength(message);
        char[] buffer = new char[length];
        CFRange range = new CFRange();
        range.length = length;
        OS.CFStringGetCharacters(message, range, buffer);
        String text = new String(buffer);
        MessageBox messageBox = new MessageBox(this.browser.getShell(), 40);
        messageBox.setText("Javascript");
        messageBox.setMessage(text);
        messageBox.open();
    }

    int runJavaScriptConfirmPanelWithMessage(int message) {
        int length = OS.CFStringGetLength(message);
        char[] buffer = new char[length];
        CFRange range = new CFRange();
        range.length = length;
        OS.CFStringGetCharacters(message, range, buffer);
        String text = new String(buffer);
        MessageBox messageBox = new MessageBox(this.browser.getShell(), 292);
        messageBox.setText("Javascript");
        messageBox.setMessage(text);
        return messageBox.open() == 32 ? 1 : 0;
    }

    void runOpenPanelForFileButtonWithResultListener(int resultListener) {
        FileDialog dialog = new FileDialog(this.browser.getShell(), 0);
        String result = dialog.open();
        if (result == null) {
            Cocoa.objc_msgSend(resultListener, Cocoa.S_cancel);
            return;
        }
        int length = result.length();
        char[] buffer = new char[length];
        result.getChars(0, length, buffer, 0);
        int filename = OS.CFStringCreateWithCharacters(0, buffer, length);
        Cocoa.objc_msgSend(resultListener, Cocoa.S_chooseFilename, filename);
        OS.CFRelease(filename);
    }

    void webViewClose() {
        Shell parent = this.browser.getShell();
        WindowEvent newEvent = new WindowEvent(this.browser);
        newEvent.display = this.browser.getDisplay();
        newEvent.widget = this.browser;
        int i = 0;
        while (i < this.closeWindowListeners.length) {
            this.closeWindowListeners[i].close(newEvent);
            ++i;
        }
        this.browser.dispose();
        if (parent.isDisposed()) {
            return;
        }
        org.eclipse.swt.graphics.Point pt = parent.getSize();
        parent.setSize(pt.x + 1, pt.y);
        parent.setSize(pt.x, pt.y);
    }

    int contextMenuItemsForElement(int element, int defaultMenuItems) {
        Point pt = new Point();
        OS.GetGlobalMouse(pt);
        Event event = new Event();
        event.x = pt.h;
        event.y = pt.v;
        this.browser.notifyListeners(35, event);
        Menu menu = this.browser.getMenu();
        if (!event.doit) {
            return 0;
        }
        if (menu != null && !menu.isDisposed()) {
            if (event.x != pt.h || event.y != pt.v) {
                menu.setLocation(event.x, event.y);
            }
            menu.setVisible(true);
            return 0;
        }
        return defaultMenuItems;
    }

    void setStatusBarVisible(int visible) {
        this.statusBar = visible != 0;
    }

    void setStatusText(int text) {
        int length = OS.CFStringGetLength(text);
        if (length == 0) {
            return;
        }
        char[] buffer = new char[length];
        CFRange range = new CFRange();
        range.length = length;
        OS.CFStringGetCharacters(text, range, buffer);
        StatusTextEvent statusText = new StatusTextEvent(this.browser);
        statusText.display = this.browser.getDisplay();
        statusText.widget = this.browser;
        statusText.text = new String(buffer);
        int i = 0;
        while (i < this.statusTextListeners.length) {
            this.statusTextListeners[i].changed(statusText);
            ++i;
        }
    }

    void setResizable(int visible) {
    }

    void setToolbarsVisible(int visible) {
        this.toolBar = visible != 0;
    }

    void mouseDidMoveOverElement(int elementInformation, int modifierFlags) {
        String urlString;
        if (elementInformation == 0) {
            return;
        }
        int length = WebElementLinkURLKey.length();
        char[] chars = new char[length];
        WebElementLinkURLKey.getChars(0, length, chars, 0);
        int key = OS.CFStringCreateWithCharacters(0, chars, length);
        int value = Cocoa.objc_msgSend(elementInformation, Cocoa.S_valueForKey, key);
        OS.CFRelease(key);
        if (value == 0) {
            if (this.lastHoveredLinkURL == null) {
                return;
            }
            this.lastHoveredLinkURL = null;
            StatusTextEvent statusText = new StatusTextEvent(this.browser);
            statusText.display = this.browser.getDisplay();
            statusText.widget = this.browser;
            statusText.text = "";
            int i = 0;
            while (i < this.statusTextListeners.length) {
                this.statusTextListeners[i].changed(statusText);
                ++i;
            }
            return;
        }
        int stringPtr = Cocoa.objc_msgSend(value, Cocoa.S_absoluteString);
        length = OS.CFStringGetLength(stringPtr);
        if (length == 0) {
            urlString = "";
        } else {
            chars = new char[length];
            CFRange range = new CFRange();
            range.length = length;
            OS.CFStringGetCharacters(stringPtr, range, chars);
            urlString = new String(chars);
        }
        if (urlString.equals(this.lastHoveredLinkURL)) {
            return;
        }
        this.lastHoveredLinkURL = urlString;
        StatusTextEvent statusText = new StatusTextEvent(this.browser);
        statusText.display = this.browser.getDisplay();
        statusText.widget = this.browser;
        statusText.text = urlString;
        int i = 0;
        while (i < this.statusTextListeners.length) {
            this.statusTextListeners[i].changed(statusText);
            ++i;
        }
    }

    void decidePolicyForMIMEType(int type, int request, int frame, int listener) {
        boolean canShow = Cocoa.objc_msgSend(Cocoa.C_WebView, Cocoa.S_canShowMIMEType, type) != 0;
        Cocoa.objc_msgSend(listener, canShow ? Cocoa.S_use : Cocoa.S_download);
    }

    void decidePolicyForNavigationAction(int actionInformation, int request, int frame, int listener) {
        int url = Cocoa.objc_msgSend(request, Cocoa.S_URL);
        if (url == 0) {
            Cocoa.objc_msgSend(listener, Cocoa.S_ignore);
            return;
        }
        int s = Cocoa.objc_msgSend(url, Cocoa.S_absoluteString);
        int length = OS.CFStringGetLength(s);
        char[] buffer = new char[length];
        CFRange range = new CFRange();
        range.length = length;
        OS.CFStringGetCharacters(s, range, buffer);
        String url2 = new String(buffer);
        if (url2.equals(URI_FROMMEMORY)) {
            url2 = ABOUT_BLANK;
        }
        LocationEvent newEvent = new LocationEvent(this.browser);
        newEvent.display = this.browser.getDisplay();
        newEvent.widget = this.browser;
        newEvent.location = url2;
        newEvent.doit = true;
        if (this.locationListeners != null) {
            this.changingLocation = true;
            int i = 0;
            while (i < this.locationListeners.length) {
                this.locationListeners[i].changing(newEvent);
                ++i;
            }
            this.changingLocation = false;
        }
        Cocoa.objc_msgSend(listener, newEvent.doit ? Cocoa.S_use : Cocoa.S_ignore);
        if (this.html != null && !this.browser.isDisposed()) {
            String html = this.html;
            this.html = null;
            this._setText(html);
        }
    }

    void decidePolicyForNewWindowAction(int actionInformation, int request, int frameName, int listener) {
        Cocoa.objc_msgSend(listener, Cocoa.S_use);
    }

    void unableToImplementPolicyWithError(int error, int frame) {
    }

    void decideDestinationWithSuggestedFilename(int download, int filename) {
        int length = OS.CFStringGetLength(filename);
        char[] buffer = new char[length];
        CFRange range = new CFRange();
        range.length = length;
        OS.CFStringGetCharacters(filename, range, buffer);
        String name = new String(buffer);
        FileDialog dialog = new FileDialog(this.browser.getShell(), 8192);
        dialog.setText(SWT.getMessage("SWT_FileDownload"));
        dialog.setFileName(name);
        String path = dialog.open();
        if (path == null) {
            Cocoa.objc_msgSend(download, Cocoa.S_release);
            return;
        }
        length = path.length();
        char[] chars = new char[length];
        path.getChars(0, length, chars, 0);
        int result = OS.CFStringCreateWithCharacters(0, chars, length);
        Cocoa.objc_msgSend(download, Cocoa.S_setDestinationAllowOverwrite, result, 1);
        OS.CFRelease(result);
    }
}

