/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.propertypages;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.SWTFactory;
import org.eclipse.jdt.internal.debug.ui.propertypages.PropertyPageMessages;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class JavaBreakpointPage
extends PropertyPage {
    protected JavaElementLabelProvider fJavaLabelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
    protected Button fEnabledButton;
    protected Button fHitCountButton;
    protected Text fHitCountText;
    protected Combo fSuspendPolicy;
    protected List fErrorMessages = new ArrayList();
    public static final String ATTR_DELETE_ON_CANCEL = String.valueOf(JDIDebugUIPlugin.getUniqueIdentifier()) + ".ATTR_DELETE_ON_CANCEL";
    protected static final String EMPTY_STRING = "";
    private static final String fgHitCountErrorMessage = PropertyPageMessages.JavaBreakpointPage_0;
    static /* synthetic */ Class class$0;

    public boolean performOk() {
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                boolean delOnCancel;
                IJavaBreakpoint breakpoint = JavaBreakpointPage.this.getBreakpoint();
                boolean bl = delOnCancel = breakpoint.getMarker().getAttribute(ATTR_DELETE_ON_CANCEL) != null;
                if (delOnCancel) {
                    breakpoint.getMarker().setAttribute(ATTR_DELETE_ON_CANCEL, null);
                    breakpoint.setRegistered(true);
                }
                JavaBreakpointPage.this.doStore();
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(wr, null, 0, null);
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.statusDialog(e.getStatus());
            JDIDebugUIPlugin.log(e);
        }
        return super.performOk();
    }

    protected void addErrorMessage(String message) {
        this.fErrorMessages.remove(message);
        this.fErrorMessages.add(message);
        this.setErrorMessage(message);
        this.setValid(message == null);
    }

    protected void removeErrorMessage(String message) {
        this.fErrorMessages.remove(message);
        if (this.fErrorMessages.isEmpty()) {
            this.addErrorMessage(null);
        } else {
            this.addErrorMessage((String)this.fErrorMessages.get(this.fErrorMessages.size() - 1));
        }
    }

    protected void doStore() throws CoreException {
        IJavaBreakpoint breakpoint = this.getBreakpoint();
        this.storeSuspendPolicy(breakpoint);
        this.storeHitCount(breakpoint);
        this.storeEnabled(breakpoint);
    }

    private void storeEnabled(IJavaBreakpoint breakpoint) throws CoreException {
        breakpoint.setEnabled(this.fEnabledButton.getSelection());
    }

    private void storeHitCount(IJavaBreakpoint breakpoint) throws CoreException {
        int hitCount = -1;
        if (this.fHitCountButton.getSelection()) {
            try {
                hitCount = Integer.parseInt(this.fHitCountText.getText());
            }
            catch (NumberFormatException e) {
                JDIDebugUIPlugin.log((IStatus)new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 4, MessageFormat.format((String)"JavaBreakpointPage allowed input of invalid string for hit count value: {0}.", (Object[])new String[]{this.fHitCountText.getText()}), (Throwable)e));
            }
        }
        breakpoint.setHitCount(hitCount);
    }

    private void storeSuspendPolicy(IJavaBreakpoint breakpoint) throws CoreException {
        int suspendPolicy = 1;
        if (this.fSuspendPolicy.getSelectionIndex() == 0) {
            suspendPolicy = 2;
        }
        breakpoint.setSuspendPolicy(suspendPolicy);
    }

    protected Control createContents(Composite parent) {
        this.setTitle(PropertyPageMessages.JavaBreakpointPage_11);
        this.noDefaultAndApplyButton();
        Composite mainComposite = this.createComposite(parent, 1);
        this.createLabels(mainComposite);
        try {
            this.createEnabledButton(mainComposite);
            this.createHitCountEditor(mainComposite);
            this.createTypeSpecificEditors(mainComposite);
            this.createSuspendPolicyEditor(mainComposite);
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log(e);
        }
        this.setValid(true);
        try {
            if (this.getBreakpoint().getMarker().getAttribute(ATTR_DELETE_ON_CANCEL) != null) {
                this.getShell().addShellListener(new ShellListener(){

                    public void shellActivated(ShellEvent e) {
                        Shell shell = (Shell)e.getSource();
                        shell.setText(MessageFormat.format((String)PropertyPageMessages.JavaBreakpointPage_10, (Object[])new String[]{JavaBreakpointPage.this.getName((IAdaptable)JavaBreakpointPage.this.getBreakpoint())}));
                        shell.removeShellListener((ShellListener)this);
                    }

                    public void shellClosed(ShellEvent e) {
                    }

                    public void shellDeactivated(ShellEvent e) {
                    }

                    public void shellDeiconified(ShellEvent e) {
                    }

                    public void shellIconified(ShellEvent e) {
                    }
                });
            }
        }
        catch (CoreException coreException) {}
        return mainComposite;
    }

    private String getName(IAdaptable element) {
        IWorkbenchAdapter adapter;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapter = (IWorkbenchAdapter)element.getAdapter((Class)clazz)) != null) {
            return adapter.getLabel((Object)element);
        }
        return EMPTY_STRING;
    }

    protected void createLabels(Composite parent) {
        Composite labelComposite = this.createComposite(parent, 2);
        try {
            String typeName = ((IJavaBreakpoint)this.getElement()).getTypeName();
            if (typeName != null) {
                this.createLabel(labelComposite, PropertyPageMessages.JavaBreakpointPage_3);
                Text text = SWTFactory.createText(labelComposite, 8, 1, typeName);
                text.setBackground(parent.getBackground());
            }
            this.createTypeSpecificLabels(labelComposite);
        }
        catch (CoreException ce) {
            JDIDebugUIPlugin.log(ce);
        }
    }

    private void createSuspendPolicyEditor(Composite parent) throws CoreException {
        Composite comp = this.createComposite(parent, 2);
        this.createLabel(comp, PropertyPageMessages.JavaBreakpointPage_6);
        boolean suspendThread = this.getBreakpoint().getSuspendPolicy() == 2;
        this.fSuspendPolicy = new Combo(comp, 2056);
        this.fSuspendPolicy.add(PropertyPageMessages.JavaBreakpointPage_7);
        this.fSuspendPolicy.add(PropertyPageMessages.JavaBreakpointPage_8);
        this.fSuspendPolicy.select(1);
        if (suspendThread) {
            this.fSuspendPolicy.select(0);
        }
    }

    private void createHitCountEditor(Composite parent) throws CoreException {
        Composite hitCountComposite = this.createComposite(parent, 2);
        this.fHitCountButton = this.createCheckButton(hitCountComposite, PropertyPageMessages.JavaBreakpointPage_4);
        this.fHitCountButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JavaBreakpointPage.this.fHitCountText.setEnabled(JavaBreakpointPage.this.fHitCountButton.getSelection());
                JavaBreakpointPage.this.hitCountChanged();
            }
        });
        int hitCount = this.getBreakpoint().getHitCount();
        String hitCountString = EMPTY_STRING;
        if (hitCount > 0) {
            hitCountString = new Integer(hitCount).toString();
            this.fHitCountButton.setSelection(true);
        } else {
            this.fHitCountButton.setSelection(false);
        }
        this.fHitCountText = this.createText(hitCountComposite, hitCountString);
        if (hitCount <= 0) {
            this.fHitCountText.setEnabled(false);
        }
        this.fHitCountText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JavaBreakpointPage.this.hitCountChanged();
            }
        });
    }

    private void hitCountChanged() {
        if (!this.fHitCountButton.getSelection()) {
            this.removeErrorMessage(fgHitCountErrorMessage);
            return;
        }
        String hitCountText = this.fHitCountText.getText();
        int hitCount = -1;
        try {
            hitCount = Integer.parseInt(hitCountText);
        }
        catch (NumberFormatException numberFormatException) {
            this.addErrorMessage(fgHitCountErrorMessage);
            return;
        }
        if (hitCount < 1) {
            this.addErrorMessage(fgHitCountErrorMessage);
        } else {
            this.removeErrorMessage(fgHitCountErrorMessage);
        }
    }

    protected void createEnabledButton(Composite parent) throws CoreException {
        this.fEnabledButton = this.createCheckButton(parent, PropertyPageMessages.JavaBreakpointPage_5);
        this.fEnabledButton.setSelection(this.getBreakpoint().isEnabled());
    }

    protected IJavaBreakpoint getBreakpoint() {
        return (IJavaBreakpoint)this.getElement();
    }

    protected void createTypeSpecificLabels(Composite parent) {
    }

    protected void createTypeSpecificEditors(Composite parent) throws CoreException {
    }

    protected Text createText(Composite parent, String initialValue) {
        return SWTFactory.createText(parent, 2052, 1, initialValue);
    }

    protected Composite createComposite(Composite parent, int numColumns) {
        return SWTFactory.createComposite(parent, parent.getFont(), numColumns, 1, 768, 0, 0);
    }

    protected Button createCheckButton(Composite parent, String text) {
        return SWTFactory.createCheckButton(parent, text, null, false, 1);
    }

    protected Label createLabel(Composite parent, String text) {
        return SWTFactory.createLabel(parent, text, 1);
    }

    protected Button createRadioButton(Composite parent, String text) {
        return SWTFactory.createRadioButton(parent, text, 1);
    }

    public boolean performCancel() {
        try {
            if (this.getBreakpoint().getMarker().getAttribute(ATTR_DELETE_ON_CANCEL) != null) {
                this.getBreakpoint().delete();
            }
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.statusDialog(PropertyPageMessages.JavaBreakpointPage_9, e.getStatus());
        }
        return super.performCancel();
    }
}

