/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.application.internal.operations;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.componentcore.util.EARArtifactEdit;
import org.eclipse.jst.j2ee.internal.common.classpath.J2EEComponentClasspathUpdater;
import org.eclipse.wst.common.componentcore.internal.operation.RemoveReferenceComponentOperation;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class RemoveComponentFromEnterpriseApplicationOperation
extends RemoveReferenceComponentOperation {
    public RemoveComponentFromEnterpriseApplicationOperation(IDataModel model) {
        super(model);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        try {
            J2EEComponentClasspathUpdater.getInstance().pauseUpdates();
            this.updateEARDD(monitor);
            super.execute(monitor, info);
            IStatus iStatus = OK_STATUS;
            return iStatus;
        }
        finally {
            J2EEComponentClasspathUpdater.getInstance().resumeUpdates();
        }
    }

    protected void updateEARDD(IProgressMonitor monitor) {
        EARArtifactEdit earEdit = null;
        try {
            IVirtualComponent comp = (IVirtualComponent)this.model.getProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT");
            if (!comp.getProject().isAccessible()) {
                return;
            }
            try {
                J2EEComponentClasspathUpdater.getInstance().queueUpdateEAR(comp.getProject());
                earEdit = EARArtifactEdit.getEARArtifactEditForWrite(comp.getProject());
                if (earEdit != null) {
                    Application application = earEdit.getApplication();
                    List list = (List)this.model.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT");
                    if (list != null && list.size() > 0) {
                        int i = 0;
                        while (i < list.size()) {
                            IVirtualComponent wc = (IVirtualComponent)list.get(i);
                            String moduleURI = this.getModuleURI(earEdit, wc);
                            this.removeModule(application, moduleURI);
                            IVirtualFile vFile = comp.getRootFolder().getFile(moduleURI);
                            IFile iFile = vFile.getUnderlyingFile();
                            if (iFile.exists()) {
                                iFile.delete(true, monitor);
                            }
                            ++i;
                        }
                    }
                }
                earEdit.saveIfNecessary(monitor);
            }
            catch (Exception e) {
                Logger.getLogger().logError((Throwable)e);
            }
        }
        finally {
            if (earEdit != null) {
                earEdit.dispose();
            }
        }
    }

    protected String getModuleURI(EARArtifactEdit earEdit, IVirtualComponent targetComponent) {
        return earEdit.getModuleURI(targetComponent);
    }

    protected void removeModule(Application application, String moduleURI) {
        Module module = application.getFirstModule(moduleURI);
        application.getModules().remove((Object)module);
    }
}

