/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.contenttype;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.internal.xml.XmlDocumentReader;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class J2EESpecFinder {
    /*
     * Loose catch block
     */
    public static String getFastSpecVersion(InputStream in) {
        InputSource source = null;
        DocumentType docType = null;
        source = new InputSource(in);
        XmlDocumentReader aReader = new XmlDocumentReader(source);
        aReader.setValidate(false);
        Document aDocument = aReader.parseDocument();
        if (aDocument != null) {
            docType = aDocument.getDoctype();
        }
        int version = -1;
        if (docType != null) {
            String publicID = docType.getPublicId();
            String systemID = docType.getSystemId();
            if (publicID != null && systemID != null) {
                version = J2EESpecFinder.lookupVersion(docType, publicID, systemID);
            }
        }
        if (version == -1) {
            NamedNodeMap map;
            String schemaName = null;
            String versionString = null;
            if (aDocument != null && docType == null && (map = aDocument.getDocumentElement().getAttributes()) != null) {
                Node versionNode;
                Node schemaNode = map.getNamedItem("xsi:schemaLocation");
                if (schemaNode != null) {
                    schemaName = schemaNode.getNodeValue().trim();
                }
                if ((versionNode = map.getNamedItem("version")) != null) {
                    versionString = versionNode.getNodeValue();
                }
            }
            if (schemaName != null) {
                version = J2EESpecFinder.lookupVersion(schemaName);
            }
            if (version == -1) {
                version = J2EESpecFinder.parseVersionString(schemaName, versionString);
            }
        }
        String string = J2EEVersionUtil.convertVersionIntToString(version);
        try {
            if (in != null) {
                in.reset();
            }
        }
        catch (IOException iOException) {}
        return string;
        catch (Exception exception) {
            try {}
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        in.reset();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (in != null) {
                    in.reset();
                }
            }
            catch (IOException iOException) {}
            return null;
        }
    }

    private static boolean isApplicationClientFile(String name) {
        return name.indexOf("application-client") != -1;
    }

    private static boolean isEARFile(String name) {
        if (name.indexOf("application-client") == -1) {
            return name.indexOf("application") != -1;
        }
        return false;
    }

    private static boolean isEJBJarFile(String name) {
        return name.indexOf("ejb-jar") != -1;
    }

    private static boolean isRARFile(String name) {
        return name.indexOf("connector") != -1;
    }

    private static boolean isWARFile(String name) {
        return name.indexOf("web-app") != -1;
    }

    private static int lookupVersion(String schemaName) {
        int version = -1;
        if (J2EESpecFinder.isEARFile(schemaName)) {
            if (schemaName.equals("http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/application_5.xsd")) {
                version = 50;
            } else if (schemaName.equals("http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/application_1_4.xsd")) {
                version = 14;
            }
        } else if (J2EESpecFinder.isEJBJarFile(schemaName)) {
            if (schemaName.indexOf("http://java.sun.com/xml/ns/javaee/ejb-jar_3_0.xsd") != -1) {
                version = 30;
            } else if (schemaName.indexOf("http://java.sun.com/xml/ns/j2ee/ejb-jar_2_1.xsd") != -1) {
                version = 21;
            }
        } else if (J2EESpecFinder.isApplicationClientFile(schemaName)) {
            if (schemaName.equals("http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/application-client_5.xsd")) {
                version = 50;
            } else if (schemaName.equals("http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/application-client_1_4.xsd")) {
                version = 14;
            }
        } else if (J2EESpecFinder.isWARFile(schemaName)) {
            if (schemaName.equals("http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/web-app_2_5.xsd")) {
                version = 25;
            } else if (schemaName.equals("http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd")) {
                version = 24;
            }
        } else if (J2EESpecFinder.isRARFile(schemaName) && schemaName.equals("http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/connector_1_5.xsd")) {
            version = 15;
        }
        return version;
    }

    private static int lookupVersion(DocumentType aType, String publicID, String systemID) {
        int version = -1;
        if (J2EESpecFinder.isEARFile(aType.getName())) {
            version = publicID.equals("-//Sun Microsystems, Inc.//DTD J2EE Application 1.3//EN") && (systemID.equals("http://java.sun.com/dtd/application_1_3.dtd") || systemID.equals("http://java.sun.com/dtd/application_1.3.dtd")) ? 13 : (publicID.equals("-//Sun Microsystems, Inc.//DTD J2EE Application 1.2//EN") && (systemID.equals("http://java.sun.com/j2ee/dtds/application_1_2.dtd") || systemID.equals("http://java.sun.com/j2ee/dtds/application_1.2.dtd")) ? 12 : 14);
        } else if (J2EESpecFinder.isEJBJarFile(aType.getName())) {
            version = publicID.equals("-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN") && (systemID.equals("http://java.sun.com/dtd/ejb-jar_2_0.dtd") || systemID.equals("http://java.sun.com/dtd/ejb-jar_2.0.dtd")) ? 20 : (publicID.equals("-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 1.1//EN") && (systemID.equals("http://java.sun.com/j2ee/dtds/ejb-jar_1_1.dtd") || systemID.equals("http://java.sun.com/j2ee/dtds/ejb-jar_1.1.dtd")) ? 11 : 21);
        } else if (J2EESpecFinder.isApplicationClientFile(aType.getName())) {
            version = publicID.equals("-//Sun Microsystems, Inc.//DTD J2EE Application Client 1.3//EN") && (systemID.equals("http://java.sun.com/dtd/application-client_1_3.dtd") || systemID.equals("http://java.sun.com/dtd/application-client_1.3.dtd")) ? 13 : (publicID.equals("-//Sun Microsystems, Inc.//DTD J2EE Application Client 1.2//EN") && (systemID.equals("http://java.sun.com/j2ee/dtds/application-client_1_2.dtd") || systemID.equals("http://java.sun.com/j2ee/dtds/application-client_1.2.dtd")) ? 12 : 14);
        } else if (J2EESpecFinder.isWARFile(aType.getName())) {
            version = publicID.equals("-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN") && (systemID.equals("http://java.sun.com/dtd/web-app_2_3.dtd") || systemID.equals("http://java.sun.com/dtd/web-app_2.3.dtd")) ? 23 : (publicID.equals("-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN") && (systemID.equals("http://java.sun.com/j2ee/dtds/web-app_2_2.dtd") || systemID.equals("http://java.sun.com/j2ee/dtds/web-app_2.2.dtd")) ? 22 : 24);
        } else if (J2EESpecFinder.isRARFile(aType.getName())) {
            version = publicID.equals("-//Sun Microsystems, Inc.//DTD Connector 1.0//EN") && (systemID.equals("http://java.sun.com/dtd/connector_1_0.dtd") || systemID.equals("http://java.sun.com/dtd/connector_1.0.dtd")) ? 10 : 15;
        }
        return version;
    }

    private static int parseVersionString(String schemaName, String versionAttr) {
        int version = -1;
        if (J2EESpecFinder.isEARFile(schemaName)) {
            if (versionAttr == null) {
                version = 14;
            } else if (versionAttr.equals("1.2")) {
                version = 12;
            } else if (versionAttr.equals("1.3")) {
                version = 13;
            } else if (versionAttr.equals("1.4")) {
                version = 14;
            } else if (versionAttr.equals("5.0")) {
                version = 50;
            }
        } else if (J2EESpecFinder.isEJBJarFile(schemaName)) {
            if (versionAttr == null) {
                version = 21;
            } else if (versionAttr.equals("1.1")) {
                version = 11;
            } else if (versionAttr.equals("2.0")) {
                version = 20;
            } else if (versionAttr.equals("2.1")) {
                version = 21;
            } else if (versionAttr.equals("3.0")) {
                version = 30;
            }
        } else if (J2EESpecFinder.isApplicationClientFile(schemaName)) {
            if (versionAttr == null) {
                version = 14;
            } else if (versionAttr.equals("1.2")) {
                version = 12;
            } else if (versionAttr.equals("1.3")) {
                version = 13;
            } else if (versionAttr.equals("1.4")) {
                version = 14;
            } else if (versionAttr.equals("5.0")) {
                version = 50;
            }
        } else if (J2EESpecFinder.isWARFile(schemaName)) {
            if (versionAttr == null) {
                version = 24;
            } else if (versionAttr.equals("2.2")) {
                version = 22;
            } else if (versionAttr.equals("2.3")) {
                version = 23;
            } else if (versionAttr.equals("2.4")) {
                version = 24;
            } else if (versionAttr.equals("2.5")) {
                version = 25;
            }
        } else if (J2EESpecFinder.isRARFile(schemaName)) {
            version = versionAttr == null ? 15 : (versionAttr.equals("1.0") ? 10 : 15);
        }
        return version;
    }
}

