/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.archive;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.internal.archive.AppClientComponentArchiveLoadAdapter;
import org.eclipse.jst.j2ee.internal.archive.ComponentArchiveLoadAdapter;
import org.eclipse.jst.j2ee.internal.archive.ConnectorComponentArchiveLoadAdapter;
import org.eclipse.jst.j2ee.internal.archive.EARComponentArchiveLoadAdapter;
import org.eclipse.jst.j2ee.internal.archive.EJBComponentArchiveLoadAdapter;
import org.eclipse.jst.j2ee.internal.archive.JavaComponentArchiveLoadAdapter;
import org.eclipse.jst.j2ee.internal.archive.WebComponentArchiveLoadAdapter;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.jee.archive.ArchiveOpenFailureException;
import org.eclipse.jst.jee.archive.ArchiveOptions;
import org.eclipse.jst.jee.archive.ArchiveSaveFailureException;
import org.eclipse.jst.jee.archive.IArchive;
import org.eclipse.jst.jee.archive.IArchiveFactory;
import org.eclipse.jst.jee.archive.IArchiveResource;
import org.eclipse.jst.jee.archive.internal.ArchiveUtil;
import org.eclipse.jst.jee.util.internal.JavaEEQuickPeek;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualArchiveComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class JavaEEArchiveUtilities
implements IArchiveFactory {
    public static JavaEEArchiveUtilities INSTANCE = new JavaEEArchiveUtilities();
    public static final String DOT_JAVA = ".java";
    public static final String DOT_CLASS = ".class";
    private Map<IArchive, JavaEEQuickPeek> archiveToJavaEEQuickPeek = new WeakHashMap<IArchive, JavaEEQuickPeek>();

    private JavaEEArchiveUtilities() {
    }

    public static boolean isJava(IFile iFile) {
        return JavaEEArchiveUtilities.hasExtension(iFile, DOT_JAVA);
    }

    public static boolean isClass(IFile iFile) {
        return JavaEEArchiveUtilities.hasExtension(iFile, DOT_CLASS);
    }

    public static boolean hasExtension(IFile iFile, String ext) {
        String name = iFile.getName();
        return JavaEEArchiveUtilities.hasExtension(name, ext);
    }

    public static boolean hasExtension(String name, String ext) {
        int offset = ext.length();
        return name.regionMatches(true, name.length() - offset, ext, 0, offset);
    }

    public IArchive openArchive(IVirtualComponent virtualComponent) throws ArchiveOpenFailureException {
        if (virtualComponent.isBinary()) {
            VirtualArchiveComponent archiveComponent = (VirtualArchiveComponent)virtualComponent;
            File diskFile = null;
            diskFile = archiveComponent.getUnderlyingDiskFile();
            if (!diskFile.exists()) {
                IFile wbFile = archiveComponent.getUnderlyingWorkbenchFile();
                diskFile = new File(wbFile.getLocation().toOSString());
            }
            Path path = new Path(diskFile.getAbsolutePath());
            return this.openArchive((IPath)path);
        }
        ComponentArchiveLoadAdapter archiveLoadAdapter = null;
        if (J2EEProjectUtilities.isEARProject(virtualComponent.getProject())) {
            archiveLoadAdapter = new EARComponentArchiveLoadAdapter(virtualComponent);
        } else if (J2EEProjectUtilities.isEJBComponent(virtualComponent)) {
            archiveLoadAdapter = new EJBComponentArchiveLoadAdapter(virtualComponent);
        } else if (J2EEProjectUtilities.isApplicationClientComponent(virtualComponent)) {
            archiveLoadAdapter = new AppClientComponentArchiveLoadAdapter(virtualComponent);
        } else if (J2EEProjectUtilities.isJCAComponent(virtualComponent)) {
            archiveLoadAdapter = new ConnectorComponentArchiveLoadAdapter(virtualComponent);
        } else if (J2EEProjectUtilities.isDynamicWebComponent(virtualComponent)) {
            archiveLoadAdapter = new WebComponentArchiveLoadAdapter(virtualComponent);
        } else if (J2EEProjectUtilities.isUtilityProject(virtualComponent.getProject())) {
            archiveLoadAdapter = new JavaComponentArchiveLoadAdapter(virtualComponent);
        }
        if (archiveLoadAdapter != null) {
            ArchiveOptions options = new ArchiveOptions();
            options.setOption((Object)"LOAD_ADAPTER", (Object)archiveLoadAdapter);
            return this.openArchive(options);
        }
        return null;
    }

    public void closeArchive(IArchive archive) {
        IArchiveFactory.INSTANCE.closeArchive(archive);
    }

    public JavaEEQuickPeek getJavaEEQuickPeek(IArchive archive) {
        if (this.archiveToJavaEEQuickPeek.containsKey(archive)) {
            return this.archiveToJavaEEQuickPeek.get(archive);
        }
        String[] deploymentDescriptorsToCheck = new String[]{"META-INF/application.xml", "META-INF/application-client.xml", "META-INF/ejb-jar.xml", "WEB-INF/web.xml", "META-INF/ra.xml"};
        int i = 0;
        while (i < deploymentDescriptorsToCheck.length) {
            Path deploymentDescriptorPath = new Path(deploymentDescriptorsToCheck[i]);
            if (archive.containsArchiveResource((IPath)deploymentDescriptorPath)) {
                InputStream in = null;
                try {
                    IArchiveResource dd = archive.getArchiveResource((IPath)deploymentDescriptorPath);
                    in = dd.getInputStream();
                    JavaEEQuickPeek quickPeek = new JavaEEQuickPeek(in);
                    this.archiveToJavaEEQuickPeek.put(archive, quickPeek);
                    return quickPeek;
                }
                catch (FileNotFoundException e) {
                    ArchiveUtil.warn((Throwable)e);
                }
                catch (IOException e) {
                    ArchiveUtil.warn((Throwable)e);
                }
            }
            ++i;
        }
        JavaEEQuickPeek quickPeek = new JavaEEQuickPeek(null);
        this.archiveToJavaEEQuickPeek.put(archive, null);
        return quickPeek;
    }

    /*
     * Exception decompiling
     */
    public IArchive openArchive(IPath archivePath) throws ArchiveOpenFailureException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[CATCHBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public IArchive openArchive(ArchiveOptions archiveOptions) throws ArchiveOpenFailureException {
        return IArchiveFactory.INSTANCE.openArchive(archiveOptions);
    }

    public void saveArchive(IArchive archive, IPath outputPath) throws ArchiveSaveFailureException {
        IArchiveFactory.INSTANCE.saveArchive(archive, outputPath);
    }

    public void saveArchive(IArchive archive, ArchiveOptions archiveOptions) throws ArchiveSaveFailureException {
        IArchiveFactory.INSTANCE.saveArchive(archive, archiveOptions);
    }
}

