/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.deltaddl;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.datatools.connectivity.sqm.core.rte.DDLGenerator;
import org.eclipse.datatools.enablement.sybase.ddl.ISybaseDdlGenerator;
import org.eclipse.datatools.enablement.sybase.ddl.SybaseDdlBuilder;
import org.eclipse.datatools.enablement.sybase.ddl.SybaseDdlGenerator;
import org.eclipse.datatools.enablement.sybase.ddl.SybaseDdlScript;
import org.eclipse.datatools.enablement.sybase.deltaddl.AbstractDeltaDdlGenProvider;
import org.eclipse.datatools.modelbase.sql.accesscontrol.Privilege;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class PrivilegeDeltaDdlGenProvider
extends AbstractDeltaDdlGenProvider {
    public void processCreateStatement(SQLObject element, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax, SybaseDdlScript script, ISybaseDdlGenerator generator, IProgressMonitor monitor) {
        if (!(element instanceof Privilege)) {
            return;
        }
        Privilege p = (Privilege)element;
        SybaseDdlBuilder ddlBuilder = ((SybaseDdlGenerator)generator).getSybaseDdlBuilder();
        String[] statement = ddlBuilder.grantPrivilege(p, quoteIdentifiers, qualifyNames, fullSyntax);
        int i = 0;
        while (i < statement.length) {
            this.addCreateStatement(script, statement[i]);
            ++i;
        }
    }

    public void processDropStatement(SQLObject element, boolean quoteIdentifiers, boolean qualifyNames, SybaseDdlScript script, DDLGenerator generator, IProgressMonitor monitor) {
        if (!(element instanceof Privilege)) {
            return;
        }
        Privilege p = (Privilege)element;
        SybaseDdlBuilder ddlBuilder = ((SybaseDdlGenerator)generator).getSybaseDdlBuilder();
        String statement = ddlBuilder.revokePrivilege(p, quoteIdentifiers, qualifyNames);
        this.addDropStatement(script, statement);
    }

    protected void addCreateStatement(SybaseDdlScript script, String statement) {
        script.addGrantPrivilegeStatement(statement);
    }

    protected void addDropStatement(SybaseDdlScript script, String statement) {
        script.addRevokePrivilegeStatement(statement);
    }

    protected void getModificationResult(SQLObject e, EStructuralFeature feature, Object oldValue, Object newValue, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax, SybaseDdlScript script) {
        if (!(e instanceof Privilege)) {
            return;
        }
        Privilege p = (Privilege)e;
        if (feature.getFeatureID() == 6) {
            Assert.isTrue((boolean)(oldValue instanceof Boolean));
            Assert.isTrue((boolean)(newValue instanceof Boolean));
            if (((Boolean)oldValue).booleanValue()) {
                script.addRevokePrivilegeStatement(this.generateRevokeGOStatement(p, quoteIdentifiers, qualifyNames, fullSyntax));
            } else if (!((Boolean)oldValue).booleanValue()) {
                String[] grantScripts = this.generateGrantGOStatement(p, quoteIdentifiers, qualifyNames, fullSyntax);
                int i = 0;
                while (i < grantScripts.length) {
                    script.addGrantPrivilegeStatement(grantScripts[i]);
                    ++i;
                }
            }
        }
    }

    protected String[] generateGrantGOStatement(Privilege p, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        return new String[]{""};
    }

    protected String generateRevokeGOStatement(Privilege p, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        return "";
    }
}

