/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.server;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.http.jetty.JettyConfigurator;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.server.SocketUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class WebappManager {
    private static String host;
    private static int port;

    static {
        port = -1;
    }

    public static void start(String webappName) throws CoreException {
        Hashtable<String, Object> d = new Hashtable<String, Object>();
        ((Dictionary)d).put("http.port", new Integer(WebappManager.getPort()));
        ((Dictionary)d).put("context.path", "/help");
        Logger.getLogger("org.mortbay").setLevel(Level.WARNING);
        try {
            JettyConfigurator.startServer((String)webappName, d);
            WebappManager.ensureBundleStarted("org.eclipse.equinox.http.registry");
        }
        catch (Exception e) {
            HelpBasePlugin.logError("An error occured while starting the help server", e);
        }
    }

    public static void stop(String webappName) throws CoreException {
        try {
            JettyConfigurator.stopServer((String)webappName);
        }
        catch (Exception e) {
            HelpBasePlugin.logError("An error occured while stopping the help server", e);
        }
    }

    public static int getPort() {
        if (port == -1) {
            String portCommandLineOverride = HelpBasePlugin.getBundleContext().getProperty("org.eclipse.help.server_port");
            if (portCommandLineOverride != null && portCommandLineOverride.trim().length() > 0) {
                try {
                    port = Integer.parseInt(portCommandLineOverride);
                }
                catch (NumberFormatException e) {
                    String msg = "Help server port specified in VM arguments is invalid (" + portCommandLineOverride + ")";
                    HelpBasePlugin.logError(msg, e);
                }
            }
            if (port == -1) {
                port = SocketUtil.findUnusedLocalPort();
            }
        }
        return port;
    }

    public static String getHost() {
        if (host == null) {
            String hostCommandLineOverride = HelpBasePlugin.getBundleContext().getProperty("org.eclipse.help.server_host");
            host = hostCommandLineOverride != null && hostCommandLineOverride.trim().length() > 0 ? hostCommandLineOverride : "127.0.0.1";
        }
        return host;
    }

    private WebappManager() {
    }

    private static void ensureBundleStarted(String symbolicName) throws BundleException {
        Bundle bundle = Platform.getBundle((String)symbolicName);
        if (bundle != null && bundle.getState() == 4) {
            bundle.start(1);
        }
    }
}

