/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ImportDeclaration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportManager {
    protected SortedSet<String> imports = new TreeSet<String>();
    protected HashMap<String, String> shortNameToImportMap = new HashMap();
    protected HashSet<String> javaLangImports = null;
    protected HashSet<String> importedPackages = new HashSet();

    public ImportManager(String compilationUnitPackage) {
        this.importedPackages.add(compilationUnitPackage);
    }

    public Collection<String> getImports() {
        return this.imports;
    }

    public String getImportedName(String qualifiedName) {
        String registeredName;
        String baseName;
        String shortName;
        int firstDollar;
        String indices = "";
        int firstBracket = qualifiedName.indexOf("[");
        if (firstBracket != -1) {
            indices = qualifiedName.substring(firstBracket);
            qualifiedName = qualifiedName.substring(0, firstBracket);
        }
        if ((firstDollar = (shortName = (baseName = qualifiedName.substring(qualifiedName.lastIndexOf(".") + 1))).indexOf("$")) != -1) {
            shortName = shortName.substring(0, firstDollar);
        }
        if ((registeredName = this.shortNameToImportMap.get(shortName)) == null) {
            registeredName = "java.lang." + shortName;
            if (qualifiedName.equals(registeredName)) {
                if (this.javaLangImports != null && this.javaLangImports.contains(shortName)) {
                    this.imports.add(qualifiedName);
                }
                return String.valueOf(shortName) + indices;
            }
            return String.valueOf(qualifiedName) + indices;
        }
        if (qualifiedName.startsWith(registeredName)) {
            if (qualifiedName.length() == registeredName.length()) {
                return String.valueOf(baseName.replace('$', '.')) + indices;
            }
            char character = qualifiedName.charAt(registeredName.length());
            if (character == '.' || character == '$') {
                return String.valueOf(baseName.replace('$', '.')) + indices;
            }
        }
        return String.valueOf(qualifiedName.replace('$', '.')) + indices;
    }

    public void addImport(String packageName, String shortName) {
        int firstBracket = shortName.indexOf("[");
        if (firstBracket != -1) {
            shortName = shortName.substring(0, firstBracket);
        }
        this.basicAdd(packageName, shortName, String.valueOf(packageName) + "." + shortName);
    }

    public void addImport(String qualifiedName) {
        int lastDot;
        String shortName;
        int firstDollar;
        int firstBracket = qualifiedName.indexOf("[");
        if (firstBracket != -1) {
            qualifiedName = qualifiedName.substring(0, firstBracket);
        }
        if ((firstDollar = (shortName = qualifiedName.substring((lastDot = qualifiedName.lastIndexOf(".")) + 1)).indexOf("$")) != -1) {
            shortName = shortName.substring(0, firstDollar);
        }
        String packageName = lastDot == -1 ? null : qualifiedName.substring(0, lastDot);
        this.basicAdd(packageName, shortName, qualifiedName);
    }

    public void addMasterImport(String packageName, String shortName) {
        this.shortNameToImportMap.put(shortName, String.valueOf(packageName) + "." + shortName);
    }

    public void addJavaLangImports(List<String> javaLangClassNames) {
        if (!javaLangClassNames.isEmpty()) {
            this.javaLangImports = new HashSet();
            this.javaLangImports.addAll(javaLangClassNames);
        }
    }

    public boolean hasImport(String shortName) {
        return this.shortNameToImportMap.containsKey(shortName);
    }

    public void addCompilationUnitImports(String compilationUnitContents) {
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            EclipseHelper.addCompilationUnitImports(this.importedPackages, this.shortNameToImportMap, compilationUnitContents);
        } else {
            Pattern importPattern = Pattern.compile("import\\s+([^\\s;]*);\\s*", 40);
            Matcher matcher = importPattern.matcher(compilationUnitContents);
            while (matcher.find()) {
                int lastDot;
                String qualifiedName = matcher.group(1);
                String shortName = qualifiedName.substring((lastDot = qualifiedName.lastIndexOf(".")) + 1);
                if (shortName.equals("*")) {
                    String packageName = qualifiedName.substring(0, lastDot);
                    this.importedPackages.add(packageName);
                    continue;
                }
                this.shortNameToImportMap.put(shortName, qualifiedName);
            }
        }
    }

    public void addPseudoImport(String qualifiedName) {
        int lastDot = qualifiedName.lastIndexOf(".");
        String shortName = qualifiedName.substring(lastDot + 1);
        if (shortName.equals("*")) {
            String packageName = qualifiedName.substring(0, lastDot);
            this.importedPackages.add(packageName);
        } else {
            this.shortNameToImportMap.put(shortName, qualifiedName);
        }
    }

    private void basicAdd(String packageName, String shortName, String qualifiedName) {
        if (shortName.equals("*")) {
            this.importedPackages.add(packageName);
            this.imports.add(qualifiedName);
        } else if (!this.shortNameToImportMap.containsKey(shortName) && !CodeGenUtil.isJavaDefaultType(shortName)) {
            this.shortNameToImportMap.put(shortName, qualifiedName);
            if (!this.importedPackages.contains(packageName)) {
                this.imports.add(qualifiedName);
            }
        }
    }

    public String computeSortedImports() {
        String NL = System.getProperties().getProperty("line.separator");
        StringBuffer imports = new StringBuffer();
        String previousPackageName = null;
        for (String importName : this.getImports()) {
            int index = importName.lastIndexOf(".");
            if (index != -1) {
                String packageName = importName.substring(0, index);
                if (previousPackageName != null && !previousPackageName.equals(packageName)) {
                    imports.append(NL);
                }
                previousPackageName = packageName;
            }
            imports.append(String.valueOf(NL) + "import " + importName + ";");
        }
        return imports.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EclipseHelper {
        private EclipseHelper() {
        }

        public static void addCompilationUnitImports(Set<String> importedPackages, Map<String, String> shortNameToImportMap, String compilationUnitContents) {
            ASTParser parser = ASTParser.newParser((int)3);
            parser.setSource(compilationUnitContents.toCharArray());
            CompilationUnit compilationUnit = (CompilationUnit)parser.createAST((IProgressMonitor)new NullProgressMonitor());
            for (ImportDeclaration importDeclaration : compilationUnit.imports()) {
                int lastDot;
                String qualifiedName = importDeclaration.getName().getFullyQualifiedName();
                String shortName = qualifiedName.substring((lastDot = qualifiedName.lastIndexOf(".")) + 1);
                if (shortName.equals("*")) {
                    String packageName = qualifiedName.substring(0, lastDot);
                    importedPackages.add(packageName);
                    continue;
                }
                shortNameToImportMap.put(shortName, qualifiedName);
            }
        }
    }
}

