/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.base.catalog;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.enablement.sybase.asa.JDBCASAPlugin;
import org.eclipse.datatools.enablement.sybase.asa.catalog.SybaseASACatalogUtils;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.AllowNullType;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.TypeOfDefault;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.impl.SybaseASABaseUserDefinedTypeImpl;
import org.eclipse.datatools.modelbase.sql.constraints.CheckConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.SQLConstraintsFactory;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.expressions.SQLExpressionsFactory;
import org.eclipse.datatools.modelbase.sql.expressions.SearchCondition;
import org.eclipse.datatools.modelbase.sql.expressions.SearchConditionDefault;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class SybaseASACatalogBaseUserDefinedDataType
extends SybaseASABaseUserDefinedTypeImpl
implements ICatalogObject {
    private static final long serialVersionUID = 1757200934996274093L;
    protected Boolean UDTInfoLoaded = Boolean.FALSE;

    public Database getCatalogDatabase() {
        return this.getSchema().getDatabase();
    }

    public Connection getConnection() {
        return ((ICatalogObject)this.getCatalogDatabase()).getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Boolean bl = this.UDTInfoLoaded;
        synchronized (bl) {
            if (this.UDTInfoLoaded.booleanValue()) {
                this.UDTInfoLoaded = Boolean.FALSE;
            }
        }
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 8: {
                this.getPredefinedRepresentation();
                break;
            }
            case 12: {
                this.getDefaultType();
                break;
            }
            case 10: {
                this.getDefaultValue();
                break;
            }
            case 11: {
                this.getNullable();
            }
        }
        return super.eIsSet(eFeature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PredefinedDataType getPredefinedRepresentation() {
        Boolean bl = this.UDTInfoLoaded;
        synchronized (bl) {
            if (!this.UDTInfoLoaded.booleanValue()) {
                this.loadUDTInfo();
                this.UDTInfoLoaded = Boolean.TRUE;
            }
        }
        return super.getPredefinedRepresentation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeOfDefault getDefaultType() {
        Boolean bl = this.UDTInfoLoaded;
        synchronized (bl) {
            if (!this.UDTInfoLoaded.booleanValue()) {
                this.loadUDTInfo();
                this.UDTInfoLoaded = Boolean.TRUE;
            }
        }
        return super.getDefaultType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AllowNullType getNullable() {
        Boolean bl = this.UDTInfoLoaded;
        synchronized (bl) {
            if (!this.UDTInfoLoaded.booleanValue()) {
                this.loadUDTInfo();
                this.UDTInfoLoaded = Boolean.TRUE;
            }
        }
        return super.getNullable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDefaultValue() {
        Boolean bl = this.UDTInfoLoaded;
        synchronized (bl) {
            if (!this.UDTInfoLoaded.booleanValue()) {
                this.loadUDTInfo();
                this.UDTInfoLoaded = Boolean.TRUE;
            }
        }
        return super.getDefaultValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getConstraint() {
        Boolean bl = this.UDTInfoLoaded;
        synchronized (bl) {
            if (!this.UDTInfoLoaded.booleanValue()) {
                this.loadUDTInfo();
                this.UDTInfoLoaded = Boolean.TRUE;
            }
        }
        return super.getConstraint();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void loadUDTInfo() {
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            try {
                rs = this.createUDTInfoResultSet(conn);
                stmt = rs.getStatement();
                while (rs.next()) {
                    this.processUDTInfoResultSet(rs);
                }
            }
            catch (SQLException e) {
                JDBCASAPlugin.getDefault().log(e);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
        this.eSetDeliver(deliver);
    }

    protected AllowNullType getNullType(char charNull) {
        switch (charNull) {
            case 'Y': {
                return AllowNullType.NULLABLE_LITERAL;
            }
            case 'N': {
                return AllowNullType.NOT_NULLABLE_LITERAL;
            }
        }
        return AllowNullType.DATABASE_DEFAULT_LITERAL;
    }

    protected ResultSet createUDTInfoResultSet(Connection conn) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement("SELECT TRIM(T.type_name) as type_name, TRIM(U.user_name) as user_name, TRIM(D.domain_name), T.width, T.scale, T.\"nulls\", T.\"default\", T.\"check\" FROM SYS.SYSUSERTYPE T JOIN SYS.SYSUSERPERMS U ON U.user_id = T.creator JOIN SYS.SYSDOMAIN D ON D.domain_id = T.domain_id WHERE D.domain_name <> 'java.lang.Object' AND T.type_name like ?");
        stmt.setString(1, this.getName());
        return stmt.executeQuery();
    }

    protected void processUDTInfoResultSet(ResultSet rs) throws SQLException {
        String domainName = rs.getString(3);
        int width = rs.getInt(4);
        int scale = rs.getInt(5);
        char nulls = SybaseASACatalogUtils.getCharValue(rs.getString(6));
        String defaultValue = rs.getString(7);
        String check = rs.getString(8);
        DatabaseDefinition dbDefn = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.getCatalogDatabase());
        PredefinedDataType pdt = SybaseASACatalogUtils.getASAPredefinedType(width, scale, domainName, dbDefn);
        AllowNullType nulltype = this.getNullType(nulls);
        TypeOfDefault td = null;
        if (defaultValue != null) {
            td = SybaseASACatalogUtils.isSystemDefault(defaultValue) ? TypeOfDefault.SYSTEM_DEFINED_LITERAL : TypeOfDefault.USER_DEFINED_LITERAL;
        }
        super.setPredefinedRepresentation(pdt);
        super.setNullable(nulltype);
        super.setDefaultValue(defaultValue);
        super.setDefaultType(td);
        super.getConstraint().clear();
        CheckConstraint checkContr = SQLConstraintsFactory.eINSTANCE.createCheckConstraint();
        SearchConditionDefault sc = SQLExpressionsFactory.eINSTANCE.createSearchConditionDefault();
        sc.setSQL(check);
        checkContr.setSearchCondition((SearchCondition)sc);
        super.getConstraint().add((Object)checkContr);
    }
}

