/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.deltaddl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.datatools.enablement.sybase.asa.ISybaseASADdlConstants;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasasqlmodel.SybaseASAIndex;
import org.eclipse.datatools.enablement.sybase.ddl.SybaseDdlScript;
import org.eclipse.datatools.enablement.sybase.deltaddl.AbstractDeltaDdlGenProvider;
import org.eclipse.datatools.enablement.sybase.deltaddl.IDeltaDdlGenProvider;
import org.eclipse.datatools.enablement.sybase.util.SQLUtil;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class SybaseASAIndexDeltaDdlGenProvider
extends AbstractDeltaDdlGenProvider
implements IDeltaDdlGenProvider,
ISybaseASADdlConstants {
    protected void addCreateStatement(SybaseDdlScript script, String statement) {
        script.addCreateIndexStatement(statement);
    }

    protected void addDropStatement(SybaseDdlScript script, String statement) {
        script.addDropIndexStatement(statement);
    }

    protected void getModificationResult(SQLObject e, EStructuralFeature feature, Object oldValue, Object newValue, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax, SybaseDdlScript script) {
        SybaseASAIndex index = (SybaseASAIndex)e;
        int featureId = feature.getFeatureID();
        Table table = index.getTable();
        String owner = table.getSchema().getName();
        String tableName = table.getName();
        StringBuffer statement = new StringBuffer(256);
        switch (featureId) {
            case 1: {
                statement.append("ALTER INDEX ");
                statement.append(SQLUtil.quote((String)oldValue.toString(), (String)"\""));
                statement.append(" ON ");
                statement.append(SQLUtil.quote((String)owner, (String)"\""));
                statement.append(".");
                statement.append(SQLUtil.quote((String)tableName, (String)"\""));
                statement.append(" RENAME AS ");
                statement.append(SQLUtil.quote((String)newValue.toString(), (String)"\""));
                break;
            }
            case 7: {
                statement.append("ALTER INDEX ");
                statement.append(SQLUtil.quote((String)((SybaseASAIndex)oldValue).getName(), (String)"\""));
                statement.append(" ON ");
                statement.append(SQLUtil.quote((String)owner, (String)"\""));
                statement.append(".");
                statement.append(SQLUtil.quote((String)tableName, (String)"\""));
                if (newValue instanceof Boolean && ((Boolean)newValue).booleanValue()) {
                    statement.append(" CLUSTERED");
                    break;
                }
                statement.append(" NONCLUSTERED");
                break;
            }
            default: {
                return;
            }
        }
        script.addAlterOtherStatements(statement.toString());
    }

    protected void analyze(Map changeMap) {
        LinkedList elements = new LinkedList();
        elements.addAll(changeMap.keySet());
        Iterator it = elements.iterator();
        while (it.hasNext()) {
            int flag;
            EObject e = (EObject)it.next();
            if (!this.needRecreate(e, flag = ((Integer)changeMap.get(e)).intValue())) continue;
            changeMap = new HashMap<EObject, Integer>();
            changeMap.put(e.eContainer(), new Integer(3));
            break;
        }
    }

    protected boolean needRecreate(EObject e, int flag) {
        if (e == null) {
            return false;
        }
        switch (e.eContainingFeature().getFeatureID()) {
            case 1: {
                return true;
            }
            case 7: {
                return true;
            }
        }
        return false;
    }
}

