/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.providers;

import java.util.Collection;
import org.eclipse.datatools.connectivity.sqm.core.containment.ContainmentService;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.providers.content.virtual.DependencyNode;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.providers.content.virtual.SchemaNode;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.providers.content.virtual.StoredProcedureNode;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.providers.content.virtual.TableNode;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.providers.content.virtual.UDFNode;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.providers.content.virtual.UDTNode;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.providers.content.virtual.ViewNode;
import org.eclipse.datatools.connectivity.sqm.core.ui.explorer.virtual.IVirtualNode;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.explorer.ServerExplorerViewer;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.explorer.providers.content.impl.ServerExplorerContentProviderNav;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.util.resources.ResourceLoader;
import org.eclipse.datatools.enablement.sybase.asa.JDBCASAProfileMessages;
import org.eclipse.datatools.enablement.sybase.asa.base.catalog.SybaseASACatalogBaseEvent;
import org.eclipse.datatools.enablement.sybase.asa.base.catalog.SybaseASACatalogBasePreDefinedType;
import org.eclipse.datatools.enablement.sybase.asa.base.catalog.SybaseASACatalogBaseWebService;
import org.eclipse.datatools.enablement.sybase.asa.catalog.SybaseASACatalogDatabase;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseDatabase;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseSchema;
import org.eclipse.datatools.enablement.sybase.asa.providers.IDBEventsFolder;
import org.eclipse.datatools.enablement.sybase.asa.providers.IDataTypesFolder;
import org.eclipse.datatools.enablement.sybase.asa.providers.IVirtualNodeServiceFactory;
import org.eclipse.datatools.enablement.sybase.asa.providers.IWebServicesFolder;
import org.eclipse.datatools.enablement.sybase.asa.virtual.DBEventsFolder;
import org.eclipse.datatools.enablement.sybase.asa.virtual.DataTypesFolder;
import org.eclipse.datatools.enablement.sybase.asa.virtual.ProxyTableNode;
import org.eclipse.datatools.enablement.sybase.asa.virtual.WebServicesFolder;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;

public class SybaseASAContentProvider
extends ServerExplorerContentProviderNav
implements ICommonContentProvider {
    private static final ContainmentService containmentService = RDBCorePlugin.getDefault().getContainmentService();
    private static final IVirtualNodeServiceFactory factory = IVirtualNodeServiceFactory.INSTANCE;
    private static final String EVENTS_FOLDER = JDBCASAProfileMessages.getString("events.folder.name");
    private static final String WEB_SERVICES_FOLDER = JDBCASAProfileMessages.getString("webservices.folder.name");
    private static final String DATA_TYPES_FOLDER = JDBCASAProfileMessages.getString("datatypes.folder.name");
    private static final String SCHEMA = ResourceLoader.INSTANCE.queryString("DATATOOLS.SERVER.UI.EXPLORER.SCHEMA");
    private static final String TABLE = ResourceLoader.INSTANCE.queryString("DATATOOLS.SERVER.UI.EXPLORER.TABLE");
    private static final String UDT = ResourceLoader.INSTANCE.queryString("DATATOOLS.SERVER.UI.EXPLORER.UDT");
    private static final String DEPENDENCY = ResourceLoader.INSTANCE.queryString("DATATOOLS.SERVER.UI.EXPLORER.DEPENDENCY");
    private static final String STORED_PROCEDURE = ResourceLoader.INSTANCE.queryString("DATATOOLS.SERVER.UI.EXPLORER.STORED_PROCEDURE");
    private static final String UDF = ResourceLoader.INSTANCE.queryString("DATATOOLS.SERVER.UI.EXPLORER.UDF");
    private static final String VIEW = ResourceLoader.INSTANCE.queryString("DATATOOLS.SERVER.UI.EXPLORER.VIEW");
    private static final String PROXY_TABLE_FOLDER = JDBCASAProfileMessages.getString("ProxyTable.folder.name");
    private ServerExplorerViewer viewer;

    public Object[] getChildren(Object parentElement) {
        if (parentElement != null) {
            if (parentElement instanceof Schema) {
                return new Object[]{new TableNode(TABLE, TABLE, parentElement), new ViewNode(VIEW, VIEW, parentElement), new ProxyTableNode(PROXY_TABLE_FOLDER, PROXY_TABLE_FOLDER, parentElement), new StoredProcedureNode(STORED_PROCEDURE, STORED_PROCEDURE, parentElement), new UDFNode(UDF, UDF, parentElement), new UDTNode(UDT, UDT, parentElement), new DependencyNode(DEPENDENCY, DEPENDENCY, parentElement)};
            }
            if (parentElement instanceof SybaseASABaseDatabase) {
                return new Object[]{new SchemaNode(SCHEMA, SCHEMA, parentElement), this.loadWebServices((SybaseASABaseDatabase)parentElement), this.loadDataTypes((SybaseASABaseDatabase)parentElement), this.loadEvents((SybaseASABaseDatabase)parentElement)};
            }
            if (parentElement instanceof SchemaNode) {
                SchemaNode sn = (SchemaNode)parentElement;
                SybaseASABaseDatabase sac = (SybaseASABaseDatabase)sn.getParent();
                if (sn.getChildrenArray().length == 0) {
                    sn.addChildren((Collection)sac.getSchemas());
                }
                return sn.getChildrenArray();
            }
            if (parentElement instanceof DataTypesFolder) {
                DataTypesFolder dtf = (DataTypesFolder)parentElement;
                SybaseASABaseDatabase sad = (SybaseASABaseDatabase)dtf.getParent();
                if (dtf.getChildrenArray().length == 0) {
                    dtf.addChildren((Collection)sad.getDataTypes());
                }
                return dtf.getChildrenArray();
            }
            if (parentElement instanceof TableNode) {
                TableNode tableNode = (TableNode)parentElement;
                SybaseASABaseSchema schema = (SybaseASABaseSchema)tableNode.getParent();
                return schema.getNormalTables().toArray();
            }
            if (parentElement instanceof ProxyTableNode) {
                ProxyTableNode tableNode = (ProxyTableNode)((Object)parentElement);
                SybaseASABaseSchema schema = (SybaseASABaseSchema)tableNode.getParent();
                return schema.getProxyTables().toArray();
            }
            if (parentElement instanceof ViewNode) {
                ViewNode tableNode = (ViewNode)parentElement;
                SybaseASABaseSchema schema = (SybaseASABaseSchema)tableNode.getParent();
                return schema.getViewTables(true).toArray();
            }
            if (parentElement instanceof WebServicesFolder) {
                WebServicesFolder wsf = (WebServicesFolder)parentElement;
                SybaseASABaseDatabase sad = (SybaseASABaseDatabase)wsf.getParent();
                if (wsf.getChildrenArray().length == 0) {
                    wsf.addChildren((Collection)sad.getWebServices());
                }
                return wsf.getChildrenArray();
            }
            if (parentElement instanceof DBEventsFolder) {
                DBEventsFolder dbef = (DBEventsFolder)parentElement;
                SybaseASABaseDatabase sad = (SybaseASABaseDatabase)dbef.getParent();
                if (dbef.getChildrenArray().length == 0) {
                    dbef.addChildren((Collection)sad.getEvents());
                }
                return dbef.getChildrenArray();
            }
        }
        return super.getChildren(parentElement);
    }

    private IWebServicesFolder loadWebServices(SybaseASABaseDatabase db) {
        IWebServicesFolder folder = factory.makeWebServicesFolder(WEB_SERVICES_FOLDER, WEB_SERVICES_FOLDER, db);
        if (db instanceof SybaseASACatalogDatabase) {
            SybaseASACatalogDatabase asaDatabase = (SybaseASACatalogDatabase)db;
            EList list = asaDatabase.getWebServices();
            int i = 0;
            int n = list.size();
            while (i < n) {
                String id;
                Object current = list.get(i);
                if (current instanceof SybaseASACatalogBaseWebService && (id = containmentService.getGroupId((EObject)current)) != null && id.equals(folder.getGroupID())) {
                    folder.addChildren(current);
                }
                ++i;
            }
        } else {
            EList list = db.getWebServices();
            int i = 0;
            int n = list.size();
            while (i < n) {
                String id;
                Object current = list.get(i);
                if (current instanceof SybaseASACatalogBaseWebService && (id = containmentService.getGroupId((EObject)current)) != null && id.equals(folder.getGroupID())) {
                    folder.addChildren(current);
                }
                ++i;
            }
        }
        return folder;
    }

    private IDataTypesFolder loadDataTypes(SybaseASABaseDatabase db) {
        IDataTypesFolder folder = factory.makeDataTypesFolder(DATA_TYPES_FOLDER, DATA_TYPES_FOLDER, db);
        if (db instanceof SybaseASACatalogDatabase) {
            SybaseASABaseDatabase asaDatabase = db;
            EList list = asaDatabase.getDataTypes();
            int i = 0;
            int n = list.size();
            while (i < n) {
                String id;
                Object current = list.get(i);
                if (current instanceof SybaseASACatalogBasePreDefinedType && (id = containmentService.getGroupId((EObject)current)) != null && id.equals(folder.getGroupID())) {
                    folder.addChildren(current);
                }
                ++i;
            }
        } else {
            EList list = db.getDataTypes();
            int i = 0;
            int n = list.size();
            while (i < n) {
                String id;
                Object current = list.get(i);
                if (current instanceof SybaseASACatalogBasePreDefinedType && (id = containmentService.getGroupId((EObject)current)) != null && id.equals(folder.getGroupID())) {
                    folder.addChildren(current);
                }
                ++i;
            }
        }
        return folder;
    }

    private IDBEventsFolder loadEvents(SybaseASABaseDatabase db) {
        IDBEventsFolder folder = factory.makeDBEventsFolder(EVENTS_FOLDER, EVENTS_FOLDER, db);
        if (db instanceof SybaseASACatalogDatabase) {
            SybaseASABaseDatabase asaDB = db;
            EList list = asaDB.getEvents();
            int i = 0;
            int n = list.size();
            while (i < n) {
                String id;
                Object current = list.get(i);
                if (current instanceof SybaseASACatalogBaseEvent && (id = containmentService.getGroupId((EObject)current)) != null && id.equals(folder.getGroupID())) {
                    folder.addChildren(current);
                }
                ++i;
            }
        } else {
            EList list = db.getEvents();
            int i = 0;
            int n = list.size();
            while (i < n) {
                String id;
                Object current = list.get(i);
                if (current instanceof SybaseASACatalogBaseEvent && (id = containmentService.getGroupId((EObject)current)) != null && id.equals(folder.getGroupID())) {
                    folder.addChildren(current);
                }
                ++i;
            }
        }
        return folder;
    }

    public Object getParent(Object element) {
        if (element instanceof IVirtualNode) {
            return ((IVirtualNode)element).getParent();
        }
        return null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (viewer instanceof ServerExplorerViewer && this.viewer == null) {
            this.viewer = (ServerExplorerViewer)viewer;
        }
    }

    public boolean hasChildren(Object element) {
        return true;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }
}

