/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.ws.impl;

import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Properties;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IParameterMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.IResultSet;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.SortSpec;
import org.eclipse.datatools.enablement.oda.ws.impl.ParameterMetaData;
import org.eclipse.datatools.enablement.oda.ws.soap.SOAPRequest;
import org.eclipse.datatools.enablement.oda.ws.soap.SOAPResponse;
import org.eclipse.datatools.enablement.oda.ws.util.Java2SOAPManager;
import org.eclipse.datatools.enablement.oda.ws.util.RawMessageSender;
import org.eclipse.datatools.enablement.oda.ws.util.WSDLAdvisor;
import org.eclipse.datatools.enablement.oda.ws.util.WSUtil;
import org.eclipse.datatools.enablement.oda.xml.impl.Driver;

public class Query
implements IQuery {
    private SOAPRequest soapRequest;
    private RawMessageSender rawMessageSender;
    private Java2SOAPManager java2SOAPManager;
    private IQuery xmlQuery;
    private int m_maxRows;
    private boolean isCustom = false;
    private String xmlQueryText = "";
    private String soapEndPoint = "";
    private String operationTrace = "";
    private String wsdlURI = "";

    public Query(RawMessageSender rawMessageSender, Properties connProperties) {
        this.rawMessageSender = rawMessageSender;
        this.wsdlURI = connProperties.getProperty("wsdlURI");
        this.soapEndPoint = connProperties.getProperty("soapEndPoint");
        this.m_maxRows = 0;
    }

    public Query(Java2SOAPManager java2SOAPManager) {
        this.java2SOAPManager = java2SOAPManager;
        this.isCustom = true;
        this.m_maxRows = 0;
    }

    public void prepare(String queryText) throws OdaException {
        if (this.isCustom) {
            this.java2SOAPManager.setQueryText(queryText);
        } else {
            this.soapRequest = new SOAPRequest(queryText);
        }
    }

    public void setAppContext(Object context) throws OdaException {
    }

    public void close() throws OdaException {
    }

    public IResultSetMetaData getMetaData() throws OdaException {
        if (this.xmlQuery == null) {
            this.xmlQuery = this.initXMLQuery();
        }
        return this.xmlQuery.getMetaData();
    }

    public IResultSet executeQuery() throws OdaException {
        if (this.xmlQuery == null) {
            this.xmlQuery = this.initXMLQuery();
        }
        return this.xmlQuery.executeQuery();
    }

    private IQuery initXMLQuery() throws OdaException {
        InputStream inputStream = this.getInputStream();
        if (WSUtil.isNull(inputStream)) {
            throw new OdaException();
        }
        Driver xmlDriver = new Driver();
        IConnection conn = xmlDriver.getConnection(null);
        HashMap<String, InputStream> map = new HashMap<String, InputStream>();
        map.put("org.eclipse.birt.report.data.oda.xml.inputStream", inputStream);
        conn.setAppContext(map);
        conn.open(new Properties());
        IQuery query = conn.newQuery(null);
        query.setMaxRows(this.getMaxRows());
        query.prepare(this.xmlQueryText);
        return query;
    }

    private InputStream getInputStream() throws OdaException {
        if (this.isCustom) {
            return this.byCustom();
        }
        this.rawMessageSender.setMessage(this.soapRequest.toXML());
        if (WSUtil.isNull(this.soapEndPoint)) {
            this.soapEndPoint = WSDLAdvisor.getLocationURI(this.wsdlURI, this.operationTrace);
        }
        this.rawMessageSender.setSpec(WSUtil.getNonNullString(this.soapEndPoint));
        this.rawMessageSender.setSoapAction(WSUtil.getNonNullString(WSDLAdvisor.getSOAPActionURI(this.wsdlURI, this.operationTrace)));
        SOAPResponse soapResponse = this.rawMessageSender.getSOAPResponse();
        if (WSUtil.isNull(soapResponse)) {
            return null;
        }
        return soapResponse.getInputStream();
    }

    private InputStream byCustom() throws OdaException {
        try {
            return (InputStream)this.java2SOAPManager.executeQuery();
        }
        catch (Exception e) {
            throw new OdaException((Throwable)e);
        }
    }

    public void setProperty(String name, String value) throws OdaException {
        if ("xmlQueryText".equals(name)) {
            this.xmlQueryText = value;
        } else if ("operationTrace".equals(name)) {
            this.operationTrace = value;
        }
    }

    public void setMaxRows(int max) throws OdaException {
        this.m_maxRows = max;
    }

    public int getMaxRows() throws OdaException {
        return this.m_maxRows;
    }

    public void clearInParameters() throws OdaException {
    }

    public void setInt(String parameterName, int value) throws OdaException {
    }

    public void setInt(int parameterId, int value) throws OdaException {
        this.setString(parameterId, String.valueOf(value));
    }

    public void setDouble(String parameterName, double value) throws OdaException {
    }

    public void setDouble(int parameterId, double value) throws OdaException {
        this.setString(parameterId, String.valueOf(value));
    }

    public void setBigDecimal(String parameterName, BigDecimal value) throws OdaException {
    }

    public void setBigDecimal(int parameterId, BigDecimal value) throws OdaException {
        this.setString(parameterId, String.valueOf(value));
    }

    public void setString(String parameterName, String value) throws OdaException {
    }

    public void setString(int parameterId, String value) throws OdaException {
        if (WSUtil.isNull(this.soapRequest)) {
            return;
        }
        this.soapRequest.setParameterValue(parameterId, value);
    }

    public void setDate(String parameterName, Date value) throws OdaException {
    }

    public void setDate(int parameterId, Date value) throws OdaException {
        this.setString(parameterId, String.valueOf(value));
    }

    public void setTime(String parameterName, Time value) throws OdaException {
    }

    public void setTime(int parameterId, Time value) throws OdaException {
    }

    public void setTimestamp(String parameterName, Timestamp value) throws OdaException {
    }

    public void setTimestamp(int parameterId, Timestamp value) throws OdaException {
    }

    public int findInParameter(String parameterName) throws OdaException {
        return 0;
    }

    public IParameterMetaData getParameterMetaData() throws OdaException {
        if (WSUtil.isNull(this.soapRequest)) {
            return null;
        }
        return new ParameterMetaData(this.soapRequest.getParameters());
    }

    public void setSortSpec(SortSpec sortBy) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public SortSpec getSortSpec() throws OdaException {
        return null;
    }

    public void setBoolean(String parameterName, boolean value) throws OdaException {
    }

    public void setBoolean(int parameterId, boolean value) throws OdaException {
        this.setString(parameterId, String.valueOf(value));
    }

    public void setNull(String parameterName) throws OdaException {
    }

    public void setNull(int parameterId) throws OdaException {
    }
}

