/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring;

import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CreateChangeOperation;
import org.eclipse.ltk.core.refactoring.IUndoManager;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.internal.core.refactoring.NotCancelableProgressMonitor;

public class PerformChangeOperation
implements IWorkspaceRunnable {
    private Change fChange;
    private CreateChangeOperation fCreateChangeOperation;
    private RefactoringStatus fValidationStatus;
    private Change fUndoChange;
    private String fUndoName;
    private IUndoManager fUndoManager;
    private boolean fChangeExecuted;
    private boolean fChangeExecutionFailed;
    private ISchedulingRule fSchedulingRule;

    public PerformChangeOperation(Change change) {
        Assert.isNotNull((Object)change);
        this.fChange = change;
        this.fSchedulingRule = ResourcesPlugin.getWorkspace().getRoot();
    }

    public PerformChangeOperation(CreateChangeOperation op) {
        Assert.isNotNull((Object)op);
        this.fCreateChangeOperation = op;
        this.fSchedulingRule = ResourcesPlugin.getWorkspace().getRoot();
    }

    public boolean changeExecutionFailed() {
        return this.fChangeExecutionFailed;
    }

    public boolean changeExecuted() {
        return this.fChangeExecuted;
    }

    public RefactoringStatus getConditionCheckingStatus() {
        if (this.fCreateChangeOperation != null) {
            return this.fCreateChangeOperation.getConditionCheckingStatus();
        }
        return null;
    }

    public Change getChange() {
        return this.fChange;
    }

    public Change getUndoChange() {
        return this.fUndoChange;
    }

    public RefactoringStatus getValidationStatus() {
        return this.fValidationStatus;
    }

    public void setUndoManager(IUndoManager manager, String undoName) {
        if (manager != null) {
            Assert.isNotNull((Object)undoName);
        }
        this.fUndoManager = manager;
        this.fUndoName = undoName;
    }

    public void setSchedulingRule(ISchedulingRule rule) {
        Assert.isNotNull((Object)rule);
        this.fSchedulingRule = rule;
    }

    public void run(IProgressMonitor pm) throws CoreException {
        if (pm == null) {
            pm = new NullProgressMonitor();
        }
        try {
            this.fChangeExecuted = false;
            if (this.createChange()) {
                pm.beginTask("", 4);
                pm.subTask("");
                this.fCreateChangeOperation.run((IProgressMonitor)new SubProgressMonitor(pm, 3));
                this.fChange = this.fCreateChangeOperation.getChange();
                if (this.fChange != null) {
                    this.executeChange((IProgressMonitor)new SubProgressMonitor(pm, 1));
                } else {
                    pm.worked(1);
                }
            } else {
                this.executeChange(pm);
            }
        }
        finally {
            pm.done();
        }
    }

    protected void executeChange(IProgressMonitor pm) throws CoreException {
        this.fChangeExecuted = false;
        if (!this.fChange.isEnabled()) {
            return;
        }
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                boolean undoInitialized = false;
                try {
                    monitor.beginTask("", 10);
                    PerformChangeOperation.this.fValidationStatus = PerformChangeOperation.this.fChange.isValid((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    if (PerformChangeOperation.this.fValidationStatus.hasFatalError()) {
                        return;
                    }
                    try {
                        boolean aboutToPerformChangeCalled = false;
                        try {
                            if (PerformChangeOperation.this.fUndoManager != null) {
                                ResourcesPlugin.getWorkspace().checkpoint(false);
                                PerformChangeOperation.this.fUndoManager.aboutToPerformChange(PerformChangeOperation.this.fChange);
                                aboutToPerformChangeCalled = true;
                            }
                            PerformChangeOperation.this.fChangeExecutionFailed = true;
                            PerformChangeOperation.this.fUndoChange = PerformChangeOperation.this.fChange.perform((IProgressMonitor)new SubProgressMonitor(monitor, 9));
                            PerformChangeOperation.this.fChangeExecutionFailed = false;
                            PerformChangeOperation.this.fChangeExecuted = true;
                        }
                        catch (Throwable throwable) {
                            if (PerformChangeOperation.this.fUndoManager != null) {
                                ResourcesPlugin.getWorkspace().checkpoint(false);
                                if (aboutToPerformChangeCalled) {
                                    PerformChangeOperation.this.fUndoManager.changePerformed(PerformChangeOperation.this.fChange, !PerformChangeOperation.this.fChangeExecutionFailed);
                                }
                            }
                            throw throwable;
                        }
                        if (PerformChangeOperation.this.fUndoManager != null) {
                            ResourcesPlugin.getWorkspace().checkpoint(false);
                            if (aboutToPerformChangeCalled) {
                                PerformChangeOperation.this.fUndoManager.changePerformed(PerformChangeOperation.this.fChange, !PerformChangeOperation.this.fChangeExecutionFailed);
                            }
                        }
                        PerformChangeOperation.this.fChange.dispose();
                        if (PerformChangeOperation.this.fUndoChange != null) {
                            PerformChangeOperation.this.fUndoChange.initializeValidationData((IProgressMonitor)new NotCancelableProgressMonitor((IProgressMonitor)new SubProgressMonitor(monitor, 1)));
                            undoInitialized = true;
                        }
                        if (PerformChangeOperation.this.fUndoManager != null) {
                            if (PerformChangeOperation.this.fUndoChange != null) {
                                PerformChangeOperation.this.fUndoManager.addUndo(PerformChangeOperation.this.fUndoName, PerformChangeOperation.this.fUndoChange);
                            } else {
                                PerformChangeOperation.this.fUndoManager.flush();
                            }
                        }
                    }
                    catch (CoreException e) {
                        if (PerformChangeOperation.this.fUndoManager != null) {
                            PerformChangeOperation.this.fUndoManager.flush();
                        }
                        if (PerformChangeOperation.this.fUndoChange != null && undoInitialized) {
                            Change ch = PerformChangeOperation.this.fUndoChange;
                            PerformChangeOperation.this.fUndoChange = null;
                            ch.dispose();
                        }
                        PerformChangeOperation.this.fUndoChange = null;
                        throw e;
                    }
                    catch (RuntimeException e) {
                        if (PerformChangeOperation.this.fUndoManager != null) {
                            PerformChangeOperation.this.fUndoManager.flush();
                        }
                        if (PerformChangeOperation.this.fUndoChange != null && undoInitialized) {
                            Change ch = PerformChangeOperation.this.fUndoChange;
                            PerformChangeOperation.this.fUndoChange = null;
                            ch.dispose();
                        }
                        PerformChangeOperation.this.fUndoChange = null;
                        throw e;
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, this.fSchedulingRule, 1, pm);
    }

    private boolean createChange() {
        return this.fCreateChangeOperation != null;
    }
}

