/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.internal.adaptor;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.internal.adaptor.EclipseAdaptorMsg;
import org.eclipse.core.runtime.internal.adaptor.LocationHelper;
import org.eclipse.core.runtime.internal.adaptor.Locker;
import org.eclipse.core.runtime.internal.adaptor.Locker_JavaIo;
import org.eclipse.core.runtime.internal.adaptor.Locker_JavaNio;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.service.datalocation.Location;

public class BasicLocation
implements Location {
    private boolean isReadOnly;
    private URL location = null;
    private Location parent;
    private URL defaultValue;
    private String property;
    private File lockFile;
    private Locker locker;
    public static final String PROP_OSGI_LOCKING = "osgi.locking";
    private static String LOCK_FILENAME = ".metadata/.lock";
    public static boolean DEBUG;

    private static boolean isRunningWithNio() {
        try {
            Class.forName("java.nio.channels.FileLock");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        return true;
    }

    public static Locker createLocker(File lock, String lockMode) {
        if (lockMode == null) {
            lockMode = FrameworkProperties.getProperty(PROP_OSGI_LOCKING);
        }
        if ("none".equals(lockMode)) {
            return new MockLocker();
        }
        if ("java.io".equals(lockMode)) {
            return new Locker_JavaIo(lock);
        }
        if ("java.nio".equals(lockMode)) {
            if (BasicLocation.isRunningWithNio()) {
                return new Locker_JavaNio(lock);
            }
            return new Locker_JavaIo(lock);
        }
        if (BasicLocation.isRunningWithNio()) {
            return new Locker_JavaNio(lock);
        }
        return new Locker_JavaIo(lock);
    }

    public BasicLocation(String property, URL defaultValue, boolean isReadOnly) {
        this.property = property;
        this.defaultValue = defaultValue;
        this.isReadOnly = isReadOnly;
    }

    public boolean allowsDefault() {
        return this.defaultValue != null;
    }

    public URL getDefault() {
        return this.defaultValue;
    }

    public Location getParentLocation() {
        return this.parent;
    }

    public synchronized URL getURL() {
        if (this.location == null && this.defaultValue != null) {
            this.setURL(this.defaultValue, false);
        }
        return this.location;
    }

    public synchronized boolean isSet() {
        return this.location != null;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public synchronized boolean setURL(URL value, boolean lock) throws IllegalStateException {
        if (this.location != null) {
            throw new IllegalStateException(EclipseAdaptorMsg.ECLIPSE_CANNOT_CHANGE_LOCATION);
        }
        File file = null;
        if (value.getProtocol().equalsIgnoreCase("file")) {
            try {
                String basePath = new File(value.getFile()).getCanonicalPath();
                value = new URL("file:" + basePath);
            }
            catch (IOException iOException) {}
            file = new File(value.getFile(), LOCK_FILENAME);
        }
        boolean bl = lock = lock && !this.isReadOnly;
        if (lock) {
            try {
                if (!this.lock(file)) {
                    return false;
                }
            }
            catch (IOException iOException) {
                return false;
            }
        }
        this.lockFile = file;
        this.location = LocationHelper.buildURL(value.toExternalForm(), true);
        if (this.property != null) {
            FrameworkProperties.setProperty(this.property, this.location.toExternalForm());
        }
        return lock;
    }

    public synchronized void setParent(Location value) {
        this.parent = value;
    }

    public synchronized boolean lock() throws IOException {
        if (!this.isSet()) {
            return false;
        }
        return this.lock(this.lockFile);
    }

    private boolean lock(File lock) throws IOException {
        if (lock == null || this.isReadOnly) {
            return false;
        }
        File parentFile = new File(lock.getParent());
        if (!parentFile.exists() && !parentFile.mkdirs()) {
            return false;
        }
        this.setLocker(lock);
        if (this.locker == null) {
            return true;
        }
        boolean locked = false;
        try {
            boolean bl = locked = this.locker.lock();
            return bl;
        }
        finally {
            if (!locked) {
                this.locker = null;
            }
        }
    }

    private void setLocker(File lock) {
        if (this.locker != null) {
            return;
        }
        String lockMode = FrameworkProperties.getProperty(PROP_OSGI_LOCKING);
        this.locker = BasicLocation.createLocker(lock, lockMode);
    }

    public synchronized void release() {
        if (this.locker != null) {
            this.locker.release();
        }
    }

    private static class MockLocker
    implements Locker {
        private MockLocker() {
        }

        public boolean lock() throws IOException {
            return true;
        }

        public void release() {
        }
    }
}

