/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.keys;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.CommandManager;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NamedHandleObject;
import org.eclipse.core.commands.common.NamedHandleObjectComparator;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.commands.contexts.Context;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.core.commands.util.Tracing;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.StaleEvent;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.databinding.observable.set.ObservableSet;
import org.eclipse.core.databinding.observable.set.SetChangeEvent;
import org.eclipse.core.databinding.observable.set.UnionSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.BindingManager;
import org.eclipse.jface.bindings.Scheme;
import org.eclipse.jface.bindings.keys.KeyBinding;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeySequenceText;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.internal.databinding.provisional.swt.ControlUpdater;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.AbstractListViewer;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.NamedHandleObjectLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.commands.ICommandImageService;
import org.eclipse.ui.internal.keys.CategoryPatternFilter;
import org.eclipse.ui.internal.keys.ImageFactory;
import org.eclipse.ui.internal.keys.KeysPreferenceFiltersDialog;
import org.eclipse.ui.internal.keys.NewKeysPreferenceMessages;
import org.eclipse.ui.internal.misc.Policy;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.util.BundleUtility;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.keys.IBindingService;

public final class NewKeysPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static boolean DEBUG = Policy.DEBUG_KEY_BINDINGS;
    private static final String TRACING_COMPONENT = "NewKeysPref";
    private static final int GROUPING_CATEGORY = 0;
    private static final int GROUPING_CONTEXT = 1;
    private static final int GROUPING_NONE = 2;
    private static final String ICON_GROUP_OF_BINDINGS = "$nl$/icons/full/obj16/keygroups_obj.gif";
    private static final String CONTEXT_ID_ACTION_SETS = "org.eclipse.ui.contexts.actionSet";
    private static final String CONTEXT_ID_INTERNAL = ".internal.";
    private static final int ITEMS_TO_SHOW = 7;
    private static final NamedHandleObjectComparator NAMED_HANDLE_OBJECT_COMPARATOR = new NamedHandleObjectComparator();
    public static final String TAG_DIALOG_SECTION = "org.eclipse.ui.preferences.keysPreferencePage";
    private final String TAG_FIELD = "showAllField";
    private static final String TAG_FILTER_ACTION_SETS = "actionSetFilter";
    private static final String TAG_FILTER_INTERNAL = "internalFilter";
    private static final String TAG_FILTER_UNCAT = "uncategorizedFilter";
    private IBindingService bindingService;
    private Text bindingText;
    private ICommandImageService commandImageService;
    private Label commandNameValueLabel;
    private ICommandService commandService;
    private IContextService contextService;
    private Text descriptionValueText;
    private CategoryFilterTree filteredTree;
    private CategoryPatternFilter patternFilter;
    private int grouping = 2;
    private KeySequenceText keySequenceText;
    private BindingManager localChangeManager;
    private String markedContextId = null;
    private ParameterizedCommand markedParameterizedCommand = null;
    private ComboViewer schemeCombo = null;
    private Button showAllCheckBox = null;
    private boolean filterActionSetContexts = true;
    private boolean filterInternalContexts = true;
    private IObservableSet commandModel;
    private IObservableSet bindingModel;
    private UnionSet model;
    private ComboViewer whenCombo = null;
    private String locale = Locale.getDefault().toString();
    private String platform = SWT.getPlatform();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    private static final NamedHandleObject[] sortByName(NamedHandleObject[] objects) {
        Arrays.sort(objects, NAMED_HANDLE_OBJECT_COMPARATOR);
        return objects;
    }

    private final void bindingAdd(Binding binding) {
        if (!binding.getParameterizedCommand().getCommand().isDefined()) {
            return;
        }
        this.markedParameterizedCommand = binding.getParameterizedCommand();
        this.markedContextId = binding.getContextId();
        this.update();
        this.filteredTree.getViewer().setSelection((ISelection)new StructuredSelection((Object)binding.getParameterizedCommand()), true);
        this.bindingText.setFocus();
        this.bindingText.selectAll();
    }

    private final void bindingRemove(KeyBinding binding) {
        ArrayList<Binding> extraSystemDeletes = new ArrayList<Binding>();
        String contextId = binding.getContextId();
        String schemeId = binding.getSchemeId();
        KeySequence triggerSequence = binding.getKeySequence();
        if (binding.getType() == 1) {
            this.localChangeManager.removeBinding((Binding)binding);
        } else {
            Collection previousConflictMatches = (Collection)this.localChangeManager.getActiveBindingsDisregardingContext().get(binding.getTriggerSequence());
            KeyBinding deleteBinding = new KeyBinding(triggerSequence, null, schemeId, contextId, null, null, null, 1);
            this.localChangeManager.addBinding((Binding)deleteBinding);
            if (previousConflictMatches != null) {
                Iterator i = previousConflictMatches.iterator();
                while (i.hasNext()) {
                    Binding b = (Binding)i.next();
                    if (b == binding || !NewKeysPreferencePage.deletes((Binding)deleteBinding, b)) continue;
                    extraSystemDeletes.add(b);
                }
            }
        }
        this.bindingModel.remove((Object)binding);
        this.bindingAdd((Binding)binding);
        if (!extraSystemDeletes.isEmpty()) {
            Iterator i = extraSystemDeletes.iterator();
            while (i.hasNext()) {
                KeyBinding b = (KeyBinding)i.next();
                KeyBinding newBinding = new KeyBinding(b.getKeySequence(), b.getParameterizedCommand(), b.getSchemeId(), b.getContextId(), null, null, null, 1);
                this.localChangeManager.addBinding((Binding)newBinding);
                this.bindingModel.remove((Object)b);
                this.bindingModel.add((Object)newBinding);
            }
        }
        this.updateConflicts((Binding)binding);
    }

    private final void updateConflicts(Collection bindings) {
        Iterator i = bindings.iterator();
        while (i.hasNext()) {
            Binding b = (Binding)i.next();
            if (b.getParameterizedCommand() == null) continue;
            this.updateConflicts(b);
        }
    }

    private final void updateConflicts(Binding binding) {
        Collection matches = (Collection)this.localChangeManager.getActiveBindingsDisregardingContext().get(binding.getTriggerSequence());
        if (matches != null) {
            Iterator i = matches.iterator();
            while (i.hasNext()) {
                Binding b = (Binding)i.next();
                if (binding == b || !b.getContextId().equals(binding.getContextId())) continue;
                this.filteredTree.getViewer().update((Object)b, null);
            }
        }
    }

    private final void bindingRestore(KeyBinding binding) {
        ParameterizedCommand cmd = binding.getParameterizedCommand();
        this.bindingRestore(cmd, false);
    }

    private boolean localMatches(String l) {
        if (l == null) {
            return true;
        }
        return Util.equals(this.locale, l);
    }

    private boolean platformMatches(String p) {
        if (p == null) {
            return true;
        }
        return Util.equals(this.platform, p);
    }

    private final void bindingRestore(ParameterizedCommand cmd, boolean removeCmd) {
        HashSet<Binding> addSystemAll = new HashSet<Binding>();
        ArrayList<Binding> removeUser = new ArrayList<Binding>();
        ArrayList<Binding> removeBinding = new ArrayList<Binding>();
        Binding[] bindings = this.localChangeManager.getBindings();
        int i = 0;
        while (i < bindings.length) {
            Binding b = bindings[i];
            if (b.getParameterizedCommand() == null && this.localMatches(b.getLocale()) && this.platformMatches(b.getPlatform())) {
                removeBinding.add(b);
            } else if (cmd.equals((Object)b.getParameterizedCommand())) {
                if (b.getType() == 0 && this.localMatches(b.getLocale()) && this.platformMatches(b.getPlatform())) {
                    addSystemAll.add(b);
                } else if (b.getType() == 1) {
                    removeUser.add(b);
                    this.localChangeManager.removeBinding(b);
                }
            }
            ++i;
        }
        if (!addSystemAll.isEmpty()) {
            Binding[] sysArray = addSystemAll.toArray(new Binding[addSystemAll.size()]);
            Iterator i2 = removeBinding.iterator();
            while (i2.hasNext()) {
                Binding del = (Binding)i2.next();
                int k = 0;
                while (k < sysArray.length) {
                    Binding sys = sysArray[k];
                    if (NewKeysPreferencePage.deletes(del, sys)) {
                        if (del.getType() == 1) {
                            removeUser.add(del);
                            this.localChangeManager.removeBinding(del);
                        } else {
                            addSystemAll.remove(sys);
                        }
                    }
                    ++k;
                }
            }
        }
        this.bindingModel.addAll(addSystemAll);
        this.bindingModel.removeAll(removeUser);
        this.updateConflicts(addSystemAll);
        this.updateConflicts(removeUser);
        if (addSystemAll.isEmpty()) {
            this.commandModel.add((Object)cmd);
            this.filteredTree.getViewer().setSelection((ISelection)new StructuredSelection((Object)cmd), true);
        } else if (removeCmd) {
            this.commandModel.remove((Object)cmd);
        }
        if (!addSystemAll.isEmpty()) {
            this.filteredTree.getViewer().setSelection((ISelection)new StructuredSelection(addSystemAll.iterator().next()), true);
        }
        this.update();
    }

    static final boolean deletes(Binding del, Binding binding) {
        boolean deletes = true;
        deletes &= Util.equals(del.getContextId(), binding.getContextId());
        deletes &= Util.equals(del.getTriggerSequence(), binding.getTriggerSequence());
        if (del.getLocale() != null) {
            deletes &= Util.equals(del.getLocale(), binding.getLocale());
        }
        if (del.getPlatform() != null) {
            deletes &= Util.equals(del.getPlatform(), binding.getPlatform());
        }
        deletes &= binding.getType() == 0;
        return deletes &= Util.equals(del.getParameterizedCommand(), null);
    }

    private final Control createButtonBar(Composite parent) {
        Composite buttonBar = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        buttonBar.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 0x1000008;
        buttonBar.setLayoutData((Object)gridData);
        Button advancedButton = new Button(buttonBar, 8);
        gridData = new GridData();
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        advancedButton.setText(NewKeysPreferenceMessages.AdvancedButton_Text);
        gridData.widthHint = Math.max(widthHint, advancedButton.computeSize((int)-1, (int)-1, (boolean)true).x) + 5;
        advancedButton.setLayoutData((Object)gridData);
        advancedButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                KeysPreferenceFiltersDialog dialog = new KeysPreferenceFiltersDialog(NewKeysPreferencePage.this.getShell());
                dialog.setFilterActionSet(NewKeysPreferencePage.this.filterActionSetContexts);
                dialog.setFilterInternal(NewKeysPreferencePage.this.filterInternalContexts);
                dialog.setFilterUncategorized(NewKeysPreferencePage.this.filteredTree.isFilteringCategories());
                if (dialog.open() == 0) {
                    NewKeysPreferencePage.this.filterActionSetContexts = dialog.getFilterActionSet();
                    NewKeysPreferencePage.this.filterInternalContexts = dialog.getFilterInternal();
                    NewKeysPreferencePage.this.filteredTree.filterCategories(dialog.getFilterUncategorized());
                    NewKeysPreferencePage.this.whenCombo.setInput((Object)NewKeysPreferencePage.this.getContexts());
                    NewKeysPreferencePage.this.updateDataControls();
                }
            }
        });
        return buttonBar;
    }

    protected final Control createContents(Composite parent) {
        IDialogSettings settings;
        GridLayout layout = null;
        long startTime = 0L;
        if (DEBUG) {
            startTime = System.currentTimeMillis();
        }
        if ((settings = this.getDialogSettings()).get(TAG_FILTER_ACTION_SETS) != null) {
            this.filterActionSetContexts = settings.getBoolean(TAG_FILTER_ACTION_SETS);
        }
        if (settings.get(TAG_FILTER_INTERNAL) != null) {
            this.filterInternalContexts = settings.getBoolean(TAG_FILTER_INTERNAL);
        }
        this.patternFilter = new CategoryPatternFilter(true, this.commandService.getCategory(null));
        if (settings.get(TAG_FILTER_UNCAT) != null) {
            this.patternFilter.filterCategories(settings.getBoolean(TAG_FILTER_UNCAT));
        }
        Composite page = new Composite(parent, 0);
        layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        page.setLayout((Layout)layout);
        this.createSchemeControls(page);
        this.createTree(page);
        this.createTreeControls(page);
        this.createDataControls(page);
        this.createButtonBar(page);
        this.fill();
        this.update();
        this.applyDialogFont(page);
        if (DEBUG) {
            long elapsedTime = System.currentTimeMillis() - startTime;
            Tracing.printTrace((String)TRACING_COMPONENT, (String)("Created page in " + elapsedTime + "ms"));
        }
        return page;
    }

    private final Control createDataControls(Composite parent) {
        final Composite dataArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, true);
        layout.marginWidth = 0;
        dataArea.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        dataArea.setLayoutData((Object)gridData);
        Composite leftDataArea = new Composite(dataArea, 0);
        layout = new GridLayout(3, false);
        leftDataArea.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 128;
        gridData.horizontalAlignment = 4;
        leftDataArea.setLayoutData((Object)gridData);
        Label commandNameLabel = new Label(leftDataArea, 0);
        commandNameLabel.setText(NewKeysPreferenceMessages.CommandNameLabel_Text);
        this.commandNameValueLabel = new Label(leftDataArea, 0);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        this.commandNameValueLabel.setLayoutData((Object)gridData);
        Label bindingLabel = new Label(leftDataArea, 0);
        bindingLabel.setText(NewKeysPreferenceMessages.BindingLabel_Text);
        this.bindingText = new Text(leftDataArea, 2048);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.widthHint = 200;
        this.bindingText.setLayoutData((Object)gridData);
        this.bindingText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                NewKeysPreferencePage.this.bindingService.setKeyFilterEnabled(false);
            }

            public void focusLost(FocusEvent e) {
                NewKeysPreferencePage.this.bindingService.setKeyFilterEnabled(true);
            }
        });
        this.bindingText.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (!NewKeysPreferencePage.this.bindingService.isKeyFilterEnabled()) {
                    NewKeysPreferencePage.this.bindingService.setKeyFilterEnabled(true);
                }
            }
        });
        this.keySequenceText = new KeySequenceText(this.bindingText);
        this.keySequenceText.setKeyStrokeLimit(4);
        this.keySequenceText.addPropertyChangeListener(new IPropertyChangeListener(){

            public final void propertyChange(PropertyChangeEvent event) {
                if (!event.getOldValue().equals(event.getNewValue())) {
                    NewKeysPreferencePage.this.keySequenceChanged();
                }
            }
        });
        final Button addKeyButton = new Button(leftDataArea, 16388);
        addKeyButton.setToolTipText(NewKeysPreferenceMessages.AddKeyButton_ToolTipText);
        gridData = new GridData();
        gridData.heightHint = this.schemeCombo.getCombo().getTextHeight();
        addKeyButton.setLayoutData((Object)gridData);
        Control[] tabStops = dataArea.getTabList();
        ArrayList<Object> newTabStops = new ArrayList<Object>();
        int i = 0;
        while (i < tabStops.length) {
            Control tabStop = tabStops[i];
            newTabStops.add(tabStop);
            if (this.bindingText.equals(tabStop)) {
                newTabStops.add(addKeyButton);
            }
            ++i;
        }
        Control[] newTabStopArray = newTabStops.toArray(new Control[newTabStops.size()]);
        dataArea.setTabList(newTabStopArray);
        final Menu addKeyMenu = new Menu((Control)addKeyButton);
        Iterator trappedKeyItr = KeySequenceText.TRAPPED_KEYS.iterator();
        while (trappedKeyItr.hasNext()) {
            final KeyStroke trappedKey = (KeyStroke)trappedKeyItr.next();
            MenuItem menuItem = new MenuItem(addKeyMenu, 8);
            menuItem.setText(trappedKey.format());
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    NewKeysPreferencePage.this.keySequenceText.insert(trappedKey);
                    NewKeysPreferencePage.this.bindingText.setFocus();
                    NewKeysPreferencePage.this.bindingText.setSelection(NewKeysPreferencePage.this.bindingText.getTextLimit());
                }
            });
        }
        addKeyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Point buttonLocation = addKeyButton.getLocation();
                buttonLocation = dataArea.toDisplay(buttonLocation.x, buttonLocation.y);
                Point buttonSize = addKeyButton.getSize();
                addKeyMenu.setLocation(buttonLocation.x, buttonLocation.y + buttonSize.y);
                addKeyMenu.setVisible(true);
            }
        });
        final IObservableValue selection = ViewersObservables.observeSingleSelection((ISelectionProvider)this.filteredTree.getViewer());
        final Label whenLabel = new Label(leftDataArea, 0);
        whenLabel.setText(NewKeysPreferenceMessages.WhenLabel_Text);
        this.whenCombo = new ComboViewer(leftDataArea);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 2;
        this.whenCombo.getCombo().setLayoutData((Object)gridData);
        this.whenCombo.setLabelProvider((IBaseLabelProvider)new NamedHandleObjectLabelProvider());
        this.whenCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.whenCombo.setComparator(new ViewerComparator());
        this.whenCombo.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                NewKeysPreferencePage.this.updateWhenCombo();
            }
        });
        this.whenCombo.getCombo().setVisibleItemCount(20);
        this.whenCombo.getCombo().setVisible(false);
        whenLabel.setVisible(false);
        selection.addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                Combo combo;
                boolean visible = false;
                if (selection.getValue() instanceof KeyBinding) {
                    visible = true;
                }
                if (!(combo = NewKeysPreferencePage.this.whenCombo.getCombo()).isDisposed()) {
                    combo.setVisible(visible);
                }
                if (!whenLabel.isDisposed()) {
                    whenLabel.setVisible(visible);
                }
            }
        });
        Label asterisk = new Label(leftDataArea, 0);
        asterisk.setText(NewKeysPreferenceMessages.Asterisk_Text);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        asterisk.setLayoutData((Object)gridData);
        Composite rightDataArea = new Composite(dataArea, 0);
        layout = new GridLayout(1, false);
        rightDataArea.setLayout((Layout)layout);
        gridData = new GridData(4, 4, true, true);
        rightDataArea.setLayoutData((Object)gridData);
        Label descriptionLabel = new Label(rightDataArea, 0);
        descriptionLabel.setText(NewKeysPreferenceMessages.DescriptionLabel_Text);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        descriptionLabel.setLayoutData((Object)gridData);
        this.descriptionValueText = new Text(rightDataArea, 2890);
        gridData = new GridData(4, 4, true, true);
        gridData.horizontalIndent = 20;
        this.descriptionValueText.setLayoutData((Object)gridData);
        return dataArea;
    }

    private final Control createSchemeControls(Composite parent) {
        Composite schemeControls = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        schemeControls.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        schemeControls.setLayoutData((Object)gridData);
        Label schemeLabel = new Label(schemeControls, 0);
        schemeLabel.setText(NewKeysPreferenceMessages.SchemeLabel_Text);
        this.schemeCombo = new ComboViewer(schemeControls);
        this.schemeCombo.setLabelProvider((IBaseLabelProvider)new NamedHandleObjectLabelProvider());
        this.schemeCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        gridData = new GridData();
        gridData.widthHint = 150;
        gridData.horizontalAlignment = 4;
        this.schemeCombo.getCombo().setLayoutData((Object)gridData);
        this.schemeCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public final void selectionChanged(SelectionChangedEvent event) {
                NewKeysPreferencePage.this.selectSchemeCombo(event);
            }
        });
        return schemeControls;
    }

    private final Control createTree(Composite parent) {
        this.filteredTree = new CategoryFilterTree(parent, 67588, this.patternFilter);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        this.filteredTree.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.filteredTree.setLayoutData(gridData);
        Tree tree = this.filteredTree.getViewer().getTree();
        tree.setHeaderVisible(true);
        Object layoutData = tree.getLayoutData();
        if (layoutData instanceof GridData) {
            gridData = (GridData)layoutData;
            int itemHeight = tree.getItemHeight();
            if (itemHeight > 1) {
                gridData.heightHint = 7 * itemHeight;
            }
        }
        BindingComparator comparator = new BindingComparator();
        comparator.setSortColumn(0);
        TreeColumn commandNameColumn = new TreeColumn(tree, 16384, 0);
        commandNameColumn.setText(NewKeysPreferenceMessages.CommandNameColumn_Text);
        tree.setSortColumn(commandNameColumn);
        tree.setSortDirection(comparator.isAscending() ? 128 : 1024);
        commandNameColumn.addSelectionListener((SelectionListener)new ResortColumn(comparator, commandNameColumn, tree, 0));
        TreeColumn triggerSequenceColumn = new TreeColumn(tree, 16384, 1);
        triggerSequenceColumn.setText(NewKeysPreferenceMessages.TriggerSequenceColumn_Text);
        triggerSequenceColumn.addSelectionListener((SelectionListener)new ResortColumn(comparator, triggerSequenceColumn, tree, 1));
        TreeColumn whenColumn = new TreeColumn(tree, 16384, 2);
        whenColumn.setText(NewKeysPreferenceMessages.WhenColumn_Text);
        whenColumn.addSelectionListener((SelectionListener)new ResortColumn(comparator, whenColumn, tree, 2));
        TreeColumn categoryColumn = new TreeColumn(tree, 16384, 3);
        categoryColumn.setText(NewKeysPreferenceMessages.CategoryColumn_Text);
        categoryColumn.addSelectionListener((SelectionListener)new ResortColumn(comparator, categoryColumn, tree, 3));
        TreeColumn userMarker = new TreeColumn(tree, 16384, 4);
        userMarker.setText(NewKeysPreferenceMessages.UserColumn_Text);
        TreeViewer viewer = this.filteredTree.getViewer();
        viewer.setLabelProvider((IBaseLabelProvider)new BindingLabelProvider());
        viewer.setContentProvider((IContentProvider)new ObservableSetContentProvider());
        viewer.setComparator((ViewerComparator)comparator);
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public final void selectionChanged(SelectionChangedEvent event) {
                NewKeysPreferencePage.this.selectTreeRow(event);
            }
        });
        this.filteredTree.getPatternFilter().setIncludeLeadingWildcard(true);
        return this.filteredTree;
    }

    private final Control createTreeControls(Composite parent) {
        Composite treeControls = new Composite(parent, 0);
        GridLayout layout = new GridLayout(4, false);
        layout.marginWidth = 0;
        treeControls.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        treeControls.setLayoutData((Object)gridData);
        this.showAllCheckBox = new Button(treeControls, 32);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 128;
        this.showAllCheckBox.setLayoutData((Object)gridData);
        this.showAllCheckBox.setText(NewKeysPreferenceMessages.ShowAllCheckBox_Text);
        IDialogSettings settings = this.getDialogSettings();
        this.showAllCheckBox.setSelection(settings.getBoolean("showAllField"));
        this.showAllCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewKeysPreferencePage.this.updateShowAll();
            }
        });
        final IObservableValue selection = ViewersObservables.observeSingleSelection((ISelectionProvider)this.filteredTree.getViewer());
        final Button addBindingButton = new Button(treeControls, 8);
        gridData = new GridData();
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        addBindingButton.setText(NewKeysPreferenceMessages.AddBindingButton_Text);
        gridData.widthHint = Math.max(widthHint, addBindingButton.computeSize((int)-1, (int)-1, (boolean)true).x) + 5;
        addBindingButton.setLayoutData((Object)gridData);
        addBindingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public final void widgetSelected(SelectionEvent event) {
                NewKeysPreferencePage.this.selectAddBindingButton(event);
            }
        });
        new ControlUpdater((Control)addBindingButton){

            protected void updateControl() {
                Object selectedObject = selection.getValue();
                addBindingButton.setEnabled(selectedObject instanceof KeyBinding);
            }
        };
        final Button removeBindingButton = new Button(treeControls, 8);
        gridData = new GridData();
        widthHint = this.convertHorizontalDLUsToPixels(61);
        removeBindingButton.setText(NewKeysPreferenceMessages.RemoveBindingButton_Text);
        gridData.widthHint = Math.max(widthHint, removeBindingButton.computeSize((int)-1, (int)-1, (boolean)true).x) + 5;
        removeBindingButton.setLayoutData((Object)gridData);
        removeBindingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public final void widgetSelected(SelectionEvent event) {
                NewKeysPreferencePage.this.selectRemoveBindingButton(event);
            }
        });
        new ControlUpdater((Control)removeBindingButton){

            protected void updateControl() {
                Object selectedObject = selection.getValue();
                removeBindingButton.setEnabled(selectedObject instanceof KeyBinding);
            }
        };
        Button restore = new Button(treeControls, 8);
        gridData = new GridData();
        widthHint = this.convertHorizontalDLUsToPixels(61);
        restore.setText(NewKeysPreferenceMessages.RestoreBindingButton_Text);
        gridData.widthHint = Math.max(widthHint, restore.computeSize((int)-1, (int)-1, (boolean)true).x) + 5;
        restore.setLayoutData((Object)gridData);
        restore.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public final void widgetSelected(SelectionEvent event) {
                NewKeysPreferencePage.this.selectRestoreBindingButton(event);
            }
        });
        return treeControls;
    }

    private void updateShowAll() {
        BusyIndicator.showWhile((Display)this.filteredTree.getViewer().getTree().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                try {
                    NewKeysPreferencePage.this.filteredTree.getViewer().getTree().setRedraw(false);
                    NewKeysPreferencePage.this.fillInCommands();
                }
                finally {
                    NewKeysPreferencePage.this.filteredTree.getViewer().getTree().setRedraw(true);
                }
            }
        });
    }

    private final void fill() {
        this.localChangeManager = new BindingManager(new ContextManager(), new CommandManager());
        Scheme[] definedSchemes = this.bindingService.getDefinedSchemes();
        try {
            int i = 0;
            while (i < definedSchemes.length) {
                Scheme scheme = definedSchemes[i];
                Scheme copy = this.localChangeManager.getScheme(scheme.getId());
                copy.define(scheme.getName(), scheme.getDescription(), scheme.getParentId());
                ++i;
            }
            this.localChangeManager.setActiveScheme(this.bindingService.getActiveScheme());
        }
        catch (NotDefinedException notDefinedException) {
            throw new Error("There is a programmer error in the keys preference page");
        }
        this.localChangeManager.setLocale(this.bindingService.getLocale());
        this.localChangeManager.setPlatform(this.bindingService.getPlatform());
        this.localChangeManager.setBindings(this.bindingService.getBindings());
        this.schemeCombo.setInput((Object)NewKeysPreferencePage.sortByName((NamedHandleObject[])this.localChangeManager.getDefinedSchemes()));
        this.setScheme(this.localChangeManager.getActiveScheme());
        this.whenCombo.setInput((Object)this.getContexts());
        this.commandModel = new WritableSet();
        this.bindingModel = new WritableSet();
        this.model = new UnionSet(new IObservableSet[]{this.bindingModel, this.commandModel});
        this.bindingModel.addAll(this.localChangeManager.getActiveBindingsDisregardingContextFlat());
        this.fillInCommands();
        if (DEBUG) {
            Tracing.printTrace((String)TRACING_COMPONENT, (String)("fill in size: " + this.model.size()));
        }
        this.filteredTree.getViewer().setInput((Object)this.model);
    }

    private void fillInCommands() {
        long startTime = 0L;
        if (DEBUG) {
            startTime = System.currentTimeMillis();
        }
        if (this.showAllCheckBox.getSelection()) {
            Collection commandIds = this.commandService.getDefinedCommandIds();
            HashSet commands = new HashSet();
            Iterator commandIdItr = commandIds.iterator();
            while (commandIdItr.hasNext()) {
                String currentCommandId = (String)commandIdItr.next();
                Command currentCommand = this.commandService.getCommand(currentCommandId);
                try {
                    commands.addAll(ParameterizedCommand.generateCombinations((Command)currentCommand));
                }
                catch (NotDefinedException notDefinedException) {}
            }
            Iterator i = this.bindingModel.iterator();
            while (i.hasNext()) {
                commands.remove(((Binding)i.next()).getParameterizedCommand());
            }
            this.commandModel.addAll(commands);
        } else {
            this.commandModel.clear();
        }
        if (DEBUG) {
            long elapsedTime = System.currentTimeMillis() - startTime;
            Tracing.printTrace((String)TRACING_COMPONENT, (String)("fillInCommands in " + elapsedTime + "ms"));
        }
    }

    public final void init(IWorkbench workbench) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.keys.IBindingService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.bindingService = (IBindingService)workbench.getService(clazz);
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.eclipse.ui.internal.commands.ICommandImageService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.commandImageService = (ICommandImageService)workbench.getService(clazz2);
        Class<?> clazz3 = class$3;
        if (clazz3 == null) {
            try {
                clazz3 = class$3 = Class.forName("org.eclipse.ui.commands.ICommandService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.commandService = (ICommandService)workbench.getService(clazz3);
        Class<?> clazz4 = class$4;
        if (clazz4 == null) {
            try {
                clazz4 = class$4 = Class.forName("org.eclipse.ui.contexts.IContextService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.contextService = (IContextService)workbench.getService(clazz4);
    }

    private final void keySequenceChanged() {
        IStructuredSelection structuredSelection;
        Object node;
        KeySequence keySequence;
        long startTime = 0L;
        if (DEBUG) {
            startTime = System.currentTimeMillis();
        }
        if (!(keySequence = this.keySequenceText.getKeySequence()).isComplete()) {
            return;
        }
        if (keySequence == null || keySequence.isEmpty()) {
            IStructuredSelection structuredSelection2;
            Object node2;
            ISelection selection = this.filteredTree.getViewer().getSelection();
            if (selection instanceof IStructuredSelection && (node2 = (structuredSelection2 = (IStructuredSelection)selection).getFirstElement()) instanceof KeyBinding) {
                this.bindingRemove((KeyBinding)node2);
            }
            return;
        }
        ISelection selection = this.filteredTree.getViewer().getSelection();
        if (selection instanceof IStructuredSelection && (node = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) != null) {
            Object firstElement;
            Object object = node;
            selection = this.whenCombo.getSelection();
            String contextId = selection instanceof IStructuredSelection ? ((firstElement = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) == null ? "org.eclipse.ui.contexts.window" : ((Context)firstElement).getId()) : "org.eclipse.ui.contexts.window";
            if (object instanceof KeyBinding) {
                KeyBinding keyBinding = (KeyBinding)object;
                if (!keyBinding.getContextId().equals(contextId) || !keyBinding.getKeySequence().equals((Object)keySequence)) {
                    KeyBinding binding = new KeyBinding(keySequence, keyBinding.getParameterizedCommand(), "org.eclipse.ui.defaultAcceleratorConfiguration", contextId, null, null, null, 1);
                    ArrayList<Binding> extraSystemDeletes = new ArrayList<Binding>();
                    if (keyBinding.getType() == 1) {
                        this.localChangeManager.removeBinding((Binding)keyBinding);
                    } else {
                        Collection previousConflictMatches = (Collection)this.localChangeManager.getActiveBindingsDisregardingContext().get(keyBinding.getTriggerSequence());
                        KeyBinding deleteBinding = new KeyBinding(keyBinding.getKeySequence(), null, keyBinding.getSchemeId(), keyBinding.getContextId(), null, null, null, 1);
                        this.localChangeManager.addBinding((Binding)deleteBinding);
                        if (previousConflictMatches != null) {
                            Iterator i = previousConflictMatches.iterator();
                            while (i.hasNext()) {
                                Binding b = (Binding)i.next();
                                if (b == keyBinding || !NewKeysPreferencePage.deletes((Binding)deleteBinding, b)) continue;
                                extraSystemDeletes.add(b);
                            }
                        }
                    }
                    this.localChangeManager.addBinding((Binding)binding);
                    this.bindingModel.remove((Object)keyBinding);
                    this.bindingModel.add((Object)binding);
                    if (!extraSystemDeletes.isEmpty()) {
                        Iterator i = extraSystemDeletes.iterator();
                        while (i.hasNext()) {
                            KeyBinding b = (KeyBinding)i.next();
                            KeyBinding newBinding = new KeyBinding(b.getKeySequence(), b.getParameterizedCommand(), b.getSchemeId(), b.getContextId(), null, null, null, 1);
                            this.localChangeManager.addBinding((Binding)newBinding);
                            this.bindingModel.remove((Object)b);
                            this.bindingModel.add((Object)newBinding);
                        }
                    }
                    this.updateConflicts((Binding)keyBinding);
                    this.updateConflicts((Binding)binding);
                    this.update();
                    this.filteredTree.getViewer().setSelection((ISelection)new StructuredSelection((Object)binding), true);
                }
            } else if (object instanceof ParameterizedCommand) {
                KeyBinding binding = new KeyBinding(keySequence, (ParameterizedCommand)object, "org.eclipse.ui.defaultAcceleratorConfiguration", contextId, null, null, null, 1);
                this.localChangeManager.addBinding((Binding)binding);
                this.bindingModel.add((Object)binding);
                this.commandModel.remove(object);
                this.updateConflicts((Binding)binding);
                this.update();
                this.filteredTree.getViewer().setSelection((ISelection)new StructuredSelection((Object)binding), true);
            }
        }
        if (DEBUG) {
            long elapsedTime = System.currentTimeMillis() - startTime;
            Tracing.printTrace((String)TRACING_COMPONENT, (String)("keySequenceChanged in " + elapsedTime + "ms"));
        }
    }

    private final void logPreferenceStoreException(Throwable exception) {
        String message = NewKeysPreferenceMessages.PreferenceStoreError_Message;
        String exceptionMessage = exception.getMessage();
        if (exceptionMessage == null) {
            exceptionMessage = message;
        }
        Status status = new Status(4, WorkbenchPlugin.PI_WORKBENCH, 0, exceptionMessage, exception);
        WorkbenchPlugin.log(message, (IStatus)status);
        StatusUtil.handleStatus(message, exception, 2);
    }

    protected final void performDefaults() {
        String title = NewKeysPreferenceMessages.RestoreDefaultsMessageBoxText;
        String message = NewKeysPreferenceMessages.RestoreDefaultsMessageBoxMessage;
        boolean confirmed = MessageDialog.openConfirm((Shell)this.getShell(), (String)title, (String)message);
        if (confirmed) {
            String defaultSchemeId = this.bindingService.getDefaultSchemeId();
            Scheme defaultScheme = this.localChangeManager.getScheme(defaultSchemeId);
            try {
                this.localChangeManager.setActiveScheme(defaultScheme);
            }
            catch (NotDefinedException notDefinedException) {}
            Binding[] currentBindings = this.localChangeManager.getBindings();
            int currentBindingsLength = currentBindings.length;
            HashSet<Binding> trimmedBindings = new HashSet<Binding>();
            int i = 0;
            while (i < currentBindingsLength) {
                Binding binding = currentBindings[i];
                if (binding.getType() != 1) {
                    trimmedBindings.add(binding);
                }
                ++i;
            }
            Binding[] trimmedBindingArray = trimmedBindings.toArray(new Binding[trimmedBindings.size()]);
            this.localChangeManager.setBindings(trimmedBindingArray);
            try {
                this.bindingService.savePreferences(defaultScheme, trimmedBindingArray);
            }
            catch (IOException e) {
                this.logPreferenceStoreException(e);
            }
            long startTime = 0L;
            if (DEBUG) {
                startTime = System.currentTimeMillis();
            }
            BusyIndicator.showWhile((Display)this.filteredTree.getViewer().getTree().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    try {
                        NewKeysPreferencePage.this.filteredTree.getViewer().getTree().setRedraw(false);
                        NewKeysPreferencePage.this.bindingModel.clear();
                        NewKeysPreferencePage.this.commandModel.clear();
                        Collection comeBack = NewKeysPreferencePage.this.localChangeManager.getActiveBindingsDisregardingContextFlat();
                        NewKeysPreferencePage.this.bindingModel.addAll(comeBack);
                        NewKeysPreferencePage.this.fillInCommands();
                    }
                    finally {
                        NewKeysPreferencePage.this.filteredTree.getViewer().getTree().setRedraw(true);
                    }
                }
            });
            if (DEBUG) {
                long elapsedTime = System.currentTimeMillis() - startTime;
                Tracing.printTrace((String)TRACING_COMPONENT, (String)("performDefaults:model in " + elapsedTime + "ms"));
            }
        }
        this.setScheme(this.localChangeManager.getActiveScheme());
        super.performDefaults();
    }

    public final boolean performOk() {
        try {
            this.bindingService.savePreferences(this.localChangeManager.getActiveScheme(), this.localChangeManager.getBindings());
        }
        catch (IOException e) {
            this.logPreferenceStoreException(e);
        }
        this.saveState(this.getDialogSettings());
        return super.performOk();
    }

    private final void selectAddBindingButton(SelectionEvent event) {
        TreeViewer viewer;
        ISelection selection;
        long startTime = 0L;
        if (DEBUG) {
            startTime = System.currentTimeMillis();
        }
        if (!((selection = (viewer = this.filteredTree.getViewer()).getSelection()) instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        Object firstElement = structuredSelection.getFirstElement();
        Object value = firstElement;
        if (value instanceof KeyBinding) {
            this.bindingAdd((Binding)((KeyBinding)value));
        } else if (value instanceof ParameterizedCommand) {
            this.bindingText.setFocus();
        }
        if (DEBUG) {
            long elapsedTime = System.currentTimeMillis() - startTime;
            Tracing.printTrace((String)TRACING_COMPONENT, (String)("selectAddBindingButton in " + elapsedTime + "ms"));
        }
    }

    private final void selectRemoveBindingButton(SelectionEvent event) {
        TreeViewer viewer;
        ISelection selection;
        long startTime = 0L;
        if (DEBUG) {
            startTime = System.currentTimeMillis();
        }
        if (!((selection = (viewer = this.filteredTree.getViewer()).getSelection()) instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        Object firstElement = structuredSelection.getFirstElement();
        Object value = firstElement;
        if (value instanceof KeyBinding) {
            this.bindingRemove((KeyBinding)value);
        } else if (value == this.markedParameterizedCommand) {
            this.commandModel.remove((Object)this.markedParameterizedCommand);
            this.markedParameterizedCommand = null;
            this.markedContextId = null;
            this.update();
        }
        if (DEBUG) {
            long elapsedTime = System.currentTimeMillis() - startTime;
            Tracing.printTrace((String)TRACING_COMPONENT, (String)("selectRemoveBindingButton in " + elapsedTime + "ms"));
        }
    }

    private final void selectRestoreBindingButton(SelectionEvent event) {
        TreeViewer viewer;
        ISelection selection;
        long startTime = 0L;
        if (DEBUG) {
            startTime = System.currentTimeMillis();
        }
        if (!((selection = (viewer = this.filteredTree.getViewer()).getSelection()) instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        Object firstElement = structuredSelection.getFirstElement();
        Object value = firstElement;
        if (value instanceof KeyBinding) {
            this.bindingRestore((KeyBinding)value);
        } else if (value instanceof ParameterizedCommand) {
            this.bindingRestore((ParameterizedCommand)value, true);
        }
        if (DEBUG) {
            long elapsedTime = System.currentTimeMillis() - startTime;
            Tracing.printTrace((String)TRACING_COMPONENT, (String)("selectRestoreBindingButton in " + elapsedTime + "ms"));
        }
    }

    private final void selectSchemeCombo(SelectionChangedEvent event) {
        Scheme newScheme;
        Object firstElement;
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection && (firstElement = ((IStructuredSelection)selection).getFirstElement()) instanceof Scheme && (newScheme = (Scheme)firstElement) != this.localChangeManager.getActiveScheme()) {
            try {
                this.localChangeManager.setActiveScheme(newScheme);
                this.update();
            }
            catch (NotDefinedException notDefinedException) {}
        }
    }

    private final void selectTreeRow(SelectionChangedEvent event) {
        this.updateDataControls();
    }

    private final void setScheme(Scheme scheme) {
        this.schemeCombo.setSelection((ISelection)new StructuredSelection((Object)scheme));
    }

    private final void update() {
        this.updateTree();
        this.updateDataControls();
    }

    private final void updateDataControls() {
        ISelection selection = this.filteredTree.getViewer().getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Object node = structuredSelection.getFirstElement();
            if (node != null) {
                Object object = node;
                if (object instanceof KeyBinding) {
                    KeyBinding binding = (KeyBinding)object;
                    try {
                        this.commandNameValueLabel.setText(binding.getParameterizedCommand().getName());
                        String description = binding.getParameterizedCommand().getCommand().getDescription();
                        if (description == null) {
                            description = "";
                        }
                        this.descriptionValueText.setText(description);
                    }
                    catch (NotDefinedException notDefinedException) {}
                    this.whenCombo.setSelection((ISelection)new StructuredSelection((Object)this.contextService.getContext(binding.getContextId())));
                    this.keySequenceText.setKeySequence(binding.getKeySequence());
                } else if (object instanceof ParameterizedCommand) {
                    ParameterizedCommand command = (ParameterizedCommand)object;
                    try {
                        this.commandNameValueLabel.setText(command.getName());
                        String description = command.getCommand().getDescription();
                        if (description == null) {
                            description = "";
                        }
                        this.descriptionValueText.setText(description);
                    }
                    catch (NotDefinedException notDefinedException) {}
                    this.keySequenceText.clear();
                    if (command == this.markedParameterizedCommand) {
                        this.whenCombo.setSelection((ISelection)new StructuredSelection((Object)this.contextService.getContext(this.markedContextId)));
                    } else {
                        this.whenCombo.setSelection((ISelection)new StructuredSelection((Object)this.contextService.getContext("org.eclipse.ui.contexts.window")));
                    }
                }
            } else {
                this.commandNameValueLabel.setText("");
                this.descriptionValueText.setText("");
                this.keySequenceText.clear();
                this.whenCombo.setSelection(null);
            }
        }
    }

    private final void updateTree() {
        long startTime = 0L;
        if (DEBUG) {
            startTime = System.currentTimeMillis();
        }
        TreeViewer viewer = this.filteredTree.getViewer();
        if (this.markedParameterizedCommand != null) {
            this.commandModel.add((Object)this.markedParameterizedCommand);
            this.markedParameterizedCommand = null;
        }
        Tree tree = viewer.getTree();
        TreeColumn[] columns = tree.getColumns();
        columns[0].setWidth(240);
        columns[1].setWidth(130);
        columns[2].setWidth(130);
        columns[3].setWidth(130);
        columns[4].setWidth(50);
        if (DEBUG) {
            long elapsedTime = System.currentTimeMillis() - startTime;
            Tracing.printTrace((String)TRACING_COMPONENT, (String)("Refreshed page in " + elapsedTime + "ms"));
        }
    }

    public void saveState(IDialogSettings dialogSettings) {
        if (dialogSettings == null) {
            return;
        }
        dialogSettings.put("showAllField", this.showAllCheckBox.getSelection());
        dialogSettings.put(TAG_FILTER_ACTION_SETS, this.filterActionSetContexts);
        dialogSettings.put(TAG_FILTER_INTERNAL, this.filterInternalContexts);
        dialogSettings.put(TAG_FILTER_UNCAT, this.filteredTree.isFilteringCategories());
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings workbenchSettings = WorkbenchPlugin.getDefault().getDialogSettings();
        IDialogSettings settings = workbenchSettings.getSection(TAG_DIALOG_SECTION);
        if (settings == null) {
            settings = workbenchSettings.addNewSection(TAG_DIALOG_SECTION);
        }
        return settings;
    }

    protected Object[] getContexts() {
        Object[] contexts = this.contextService.getDefinedContexts();
        ArrayList<Object> filteredContexts = new ArrayList<Object>();
        try {
            int i;
            if (this.filterActionSetContexts) {
                i = 0;
                while (i < contexts.length) {
                    String parentId = contexts[i].getParentId();
                    boolean check = false;
                    if (contexts[i].getId().equalsIgnoreCase(CONTEXT_ID_ACTION_SETS)) {
                        check = true;
                    }
                    while (parentId != null) {
                        if (parentId.equalsIgnoreCase(CONTEXT_ID_ACTION_SETS)) {
                            check = true;
                        }
                        parentId = this.contextService.getContext(parentId).getParentId();
                    }
                    if (!check) {
                        filteredContexts.add(contexts[i]);
                    }
                    ++i;
                }
            } else {
                filteredContexts.addAll(Arrays.asList(contexts));
            }
            if (this.filterInternalContexts) {
                i = 0;
                while (i < filteredContexts.size()) {
                    if (((Context)filteredContexts.get(i)).getId().indexOf(CONTEXT_ID_INTERNAL) != -1) {
                        filteredContexts.remove(i);
                    }
                    ++i;
                }
            }
        }
        catch (NotDefinedException notDefinedException) {
            return contexts;
        }
        return filteredContexts.toArray();
    }

    private void updateWhenCombo() {
        IStructuredSelection structuredSelection;
        Object node;
        ISelection selection = this.filteredTree.getViewer().getSelection();
        if (selection instanceof IStructuredSelection && (node = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) != null) {
            KeyBinding keyBinding;
            Object firstElement;
            Object object = node;
            selection = this.whenCombo.getSelection();
            String contextId = selection instanceof IStructuredSelection ? ((firstElement = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) == null ? "org.eclipse.ui.contexts.window" : ((Context)firstElement).getId()) : "org.eclipse.ui.contexts.window";
            if (object instanceof KeyBinding && !(keyBinding = (KeyBinding)object).getContextId().equals(contextId)) {
                KeyBinding binding = new KeyBinding(keyBinding.getKeySequence(), keyBinding.getParameterizedCommand(), "org.eclipse.ui.defaultAcceleratorConfiguration", contextId, null, null, null, 1);
                if (keyBinding.getType() == 1) {
                    this.localChangeManager.removeBinding((Binding)keyBinding);
                } else {
                    this.localChangeManager.addBinding((Binding)new KeyBinding(keyBinding.getKeySequence(), null, keyBinding.getSchemeId(), keyBinding.getContextId(), null, null, null, 1));
                }
                this.localChangeManager.addBinding((Binding)binding);
                this.bindingModel.remove((Object)keyBinding);
                this.bindingModel.add((Object)binding);
                this.updateConflicts((Binding)keyBinding);
                this.updateConflicts((Binding)binding);
                this.update();
                this.filteredTree.getViewer().setSelection((ISelection)new StructuredSelection((Object)binding), true);
            }
        }
    }

    public void applyData(Object data) {
        if (data instanceof Binding && this.filteredTree != null) {
            this.filteredTree.getViewer().setSelection((ISelection)new StructuredSelection(data), true);
        }
    }

    private final class BindingComparator
    extends ViewerComparator {
        private int sortColumn = 0;
        private int lastSortColumn = 0;
        private boolean ascending = true;

        private BindingComparator() {
        }

        public final int category(Object element) {
            switch (NewKeysPreferencePage.this.grouping) {
                case 0: {
                    try {
                        ParameterizedCommand command = element instanceof ParameterizedCommand ? (ParameterizedCommand)element : ((Binding)element).getParameterizedCommand();
                        return command.getCommand().getCategory().hashCode();
                    }
                    catch (NotDefinedException notDefinedException) {
                        return 0;
                    }
                }
                case 1: {
                    if (!(element instanceof Binding)) break;
                    return ((Binding)element).getContextId().hashCode();
                }
            }
            return 0;
        }

        public final int compare(Viewer viewer, Object a, Object b) {
            IBaseLabelProvider baseLabel = NewKeysPreferencePage.this.filteredTree.getViewer().getLabelProvider();
            if (baseLabel instanceof ITableLabelProvider) {
                ITableLabelProvider tableProvider = (ITableLabelProvider)baseLabel;
                String e1p = tableProvider.getColumnText(a, this.sortColumn);
                String e2p = tableProvider.getColumnText(b, this.sortColumn);
                if (e1p != null && e2p != null) {
                    int result = this.getComparator().compare(e1p, e2p);
                    if (result == 0 && this.sortColumn != this.lastSortColumn) {
                        result = this.secondaryCompare(tableProvider, a, b);
                    }
                    return this.ascending ? result : -1 * result;
                }
            }
            return super.compare(viewer, a, b);
        }

        private final int secondaryCompare(ITableLabelProvider tableProvider, Object a, Object b) {
            int result = 0;
            String e1p = tableProvider.getColumnText(a, this.lastSortColumn);
            String e2p = tableProvider.getColumnText(b, this.lastSortColumn);
            if (e1p != null && e2p != null) {
                result = this.getComparator().compare(e1p, e2p);
            }
            return result;
        }

        public int getSortColumn() {
            return this.sortColumn;
        }

        public void setSortColumn(int sortColumn) {
            this.lastSortColumn = this.sortColumn;
            if (this.lastSortColumn != sortColumn) {
                this.ascending = true;
            }
            this.sortColumn = sortColumn;
        }

        public boolean isAscending() {
            return this.ascending;
        }

        public void setAscending(boolean ascending) {
            this.ascending = ascending;
        }
    }

    private final class BindingLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private static final int COLUMN_COMMAND = 0;
        private static final int COLUMN_TRIGGER_SEQUENCE = 1;
        private static final int COLUMN_WHEN = 2;
        private static final int COLUMN_CATEGORY = 3;
        private static final int COLUMN_USER = 4;
        private final LocalResourceManager localResourceManager = new LocalResourceManager(JFaceResources.getResources());

        private BindingLabelProvider() {
        }

        public final void dispose() {
            super.dispose();
            this.localResourceManager.dispose();
        }

        public final Image getColumnImage(Object element, int columnIndex) {
            Object value = element;
            if (value instanceof Binding) {
                switch (columnIndex) {
                    case 0: {
                        ParameterizedCommand parameterizedCommand = ((Binding)value).getParameterizedCommand();
                        if (parameterizedCommand != null) {
                            String commandId = parameterizedCommand.getId();
                            ImageDescriptor imageDescriptor = NewKeysPreferencePage.this.commandImageService.getImageDescriptor(commandId);
                            if (imageDescriptor == null) {
                                return null;
                            }
                            try {
                                return this.localResourceManager.createImage(imageDescriptor);
                            }
                            catch (DeviceResourceException e) {
                                String message = "Problem retrieving image for a command '" + commandId + '\'';
                                Status status = new Status(4, WorkbenchPlugin.PI_WORKBENCH, 0, message, (Throwable)e);
                                WorkbenchPlugin.log(message, (IStatus)status);
                            }
                        }
                        return null;
                    }
                    case 4: {
                        if (((Binding)value).getType() == 1) {
                            return ImageFactory.getImage("change");
                        }
                        return ImageFactory.getImage("blank");
                    }
                }
            } else if (value instanceof ParameterizedCommand) {
                switch (columnIndex) {
                    case 0: {
                        ParameterizedCommand parameterizedCommand = (ParameterizedCommand)value;
                        String commandId = parameterizedCommand.getId();
                        ImageDescriptor imageDescriptor = NewKeysPreferencePage.this.commandImageService.getImageDescriptor(commandId);
                        if (imageDescriptor == null) {
                            return null;
                        }
                        try {
                            return this.localResourceManager.createImage(imageDescriptor);
                        }
                        catch (DeviceResourceException e) {
                            String message = "Problem retrieving image for a command '" + commandId + '\'';
                            Status status = new Status(4, WorkbenchPlugin.PI_WORKBENCH, 0, message, (Throwable)e);
                            WorkbenchPlugin.log(message, (IStatus)status);
                            return null;
                        }
                    }
                    case 4: {
                        return ImageFactory.getImage("blank");
                    }
                }
            } else if (value instanceof Category || value instanceof String) {
                switch (columnIndex) {
                    case 0: {
                        URL url = BundleUtility.find("org.eclipse.ui", NewKeysPreferencePage.ICON_GROUP_OF_BINDINGS);
                        ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)url);
                        try {
                            return this.localResourceManager.createImage(imageDescriptor);
                        }
                        catch (DeviceResourceException e) {
                            Status status = new Status(4, WorkbenchPlugin.PI_WORKBENCH, 0, "Problem retrieving image for groups of bindings: '$nl$/icons/full/obj16/keygroups_obj.gif'", (Throwable)e);
                            WorkbenchPlugin.log("Problem retrieving image for groups of bindings: '$nl$/icons/full/obj16/keygroups_obj.gif'", (IStatus)status);
                        }
                    }
                }
            }
            return null;
        }

        private boolean checkConflict(Binding binding) {
            Collection matches = (Collection)NewKeysPreferencePage.this.localChangeManager.getActiveBindingsDisregardingContext().get(binding.getTriggerSequence());
            if (matches != null) {
                Iterator i = matches.iterator();
                while (i.hasNext()) {
                    Binding b = (Binding)i.next();
                    if (binding == b || !b.getContextId().equals(binding.getContextId())) continue;
                    return true;
                }
            }
            return false;
        }

        public final String getColumnText(Object element, int columnIndex) {
            Object value = element;
            if (value instanceof Binding) {
                Binding binding = (Binding)value;
                switch (columnIndex) {
                    case 0: {
                        try {
                            return binding.getParameterizedCommand().getName();
                        }
                        catch (NotDefinedException notDefinedException) {
                            return NewKeysPreferenceMessages.Undefined_Command;
                        }
                    }
                    case 1: {
                        if (this.checkConflict(binding)) {
                            return "*" + binding.getTriggerSequence().format();
                        }
                        return binding.getTriggerSequence().format();
                    }
                    case 2: {
                        try {
                            return NewKeysPreferencePage.this.contextService.getContext(binding.getContextId()).getName();
                        }
                        catch (NotDefinedException notDefinedException) {
                            return NewKeysPreferenceMessages.Undefined_Context;
                        }
                    }
                    case 3: {
                        try {
                            return binding.getParameterizedCommand().getCommand().getCategory().getName();
                        }
                        catch (NotDefinedException notDefinedException) {
                            return NewKeysPreferenceMessages.Unavailable_Category;
                        }
                    }
                }
                return null;
            }
            if (value instanceof Category) {
                if (columnIndex == 0) {
                    try {
                        return ((Category)value).getName();
                    }
                    catch (NotDefinedException notDefinedException) {
                        return NewKeysPreferenceMessages.Unavailable_Category;
                    }
                }
                return null;
            }
            if (value instanceof String) {
                if (columnIndex == 0) {
                    try {
                        return NewKeysPreferencePage.this.contextService.getContext((String)value).getName();
                    }
                    catch (NotDefinedException notDefinedException) {
                        return NewKeysPreferenceMessages.Undefined_Context;
                    }
                }
                return null;
            }
            if (value instanceof ParameterizedCommand) {
                if (columnIndex == 0) {
                    try {
                        return ((ParameterizedCommand)value).getName();
                    }
                    catch (NotDefinedException notDefinedException) {
                        return NewKeysPreferenceMessages.Undefined_Command;
                    }
                }
                if (columnIndex == 1) {
                    return "";
                }
                if (columnIndex == 2) {
                    return "";
                }
                if (columnIndex == 3) {
                    try {
                        return ((ParameterizedCommand)value).getCommand().getCategory().getName();
                    }
                    catch (NotDefinedException notDefinedException) {
                        return NewKeysPreferenceMessages.Unavailable_Category;
                    }
                }
                return null;
            }
            return null;
        }

        public String getText(Object element) {
            String rc = this.getColumnText(element, 0);
            if (rc == null) {
                super.getText(element);
            }
            StringBuffer buf = new StringBuffer(rc);
            int i = 1;
            while (i < 4) {
                String text = this.getColumnText(element, i);
                if (text != null) {
                    buf.append(' ');
                    buf.append(text);
                }
                ++i;
            }
            return buf.toString();
        }
    }

    protected class CategoryFilterTree
    extends FilteredTree {
        private CategoryPatternFilter filter;

        protected CategoryFilterTree(Composite parent, int treeStyle, CategoryPatternFilter filter) {
            super(parent, treeStyle, filter);
            this.filter = filter;
        }

        public void filterCategories(boolean b) {
            this.filter.filterCategories(b);
            this.textChanged();
        }

        public boolean isFilteringCategories() {
            return this.filter.isFilteringCategories();
        }
    }

    private class ObservableSetContentProvider
    implements ITreeContentProvider {
        private IObservableSet readableSet;
        private Viewer viewer;
        private KnownElementsSet knownElements;
        private ISetChangeListener listener = new ISetChangeListener(this){
            final /* synthetic */ ObservableSetContentProvider this$1;
            {
                this.this$1 = observableSetContentProvider;
            }

            public void handleSetChange(SetChangeEvent event) {
                boolean wasStale = ObservableSetContentProvider.access$0(this.this$1).isStale();
                if (ObservableSetContentProvider.access$1(this.this$1)) {
                    return;
                }
                ObservableSetContentProvider.access$2(this.this$1, event.diff.getAdditions(), event.diff.getRemovals(), true);
                if (!wasStale && event.getObservableSet().isStale()) {
                    ObservableSetContentProvider.access$0(this.this$1).doFireStale(true);
                }
            }
        };
        private IStaleListener staleListener = new IStaleListener(this){
            final /* synthetic */ ObservableSetContentProvider this$1;
            {
                this.this$1 = observableSetContentProvider;
            }

            public void handleStale(StaleEvent event) {
                ObservableSetContentProvider.access$0(this.this$1).doFireStale(event.getObservable().isStale());
            }
        };

        public ObservableSetContentProvider() {
            Realm realm = SWTObservables.getRealm((Display)Display.getDefault());
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.readableSet = new ObservableSet(this, realm, Collections.EMPTY_SET, clazz){
                final /* synthetic */ ObservableSetContentProvider this$1;
                {
                    this.this$1 = observableSetContentProvider;
                }
            };
            this.knownElements = new KnownElementsSet(this, (Set)this.readableSet);
        }

        public void dispose() {
            this.setInput(null);
        }

        private void doDiff(Set added, Set removed, boolean updateViewer) {
            this.knownElements.doFireDiff(added, Collections.EMPTY_SET);
            if (updateViewer) {
                if (added.size() > 20 || removed.size() > 20) {
                    this.viewer.refresh();
                } else {
                    Object[] toAdd = added.toArray();
                    if (this.viewer instanceof TreeViewer) {
                        TreeViewer tv = (TreeViewer)this.viewer;
                        tv.add((Object)NewKeysPreferencePage.this.model, toAdd);
                    } else if (this.viewer instanceof AbstractListViewer) {
                        AbstractListViewer lv = (AbstractListViewer)this.viewer;
                        lv.add(toAdd);
                    }
                    Object[] toRemove = removed.toArray();
                    if (this.viewer instanceof TreeViewer) {
                        TreeViewer tv = (TreeViewer)this.viewer;
                        tv.remove(toRemove);
                    } else if (this.viewer instanceof AbstractListViewer) {
                        AbstractListViewer lv = (AbstractListViewer)this.viewer;
                        lv.remove(toRemove);
                    }
                }
            }
            this.knownElements.doFireDiff(Collections.EMPTY_SET, removed);
        }

        public Object[] getElements(Object inputElement) {
            return this.readableSet.toArray();
        }

        public IObservableSet getKnownElements() {
            return this.knownElements;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.viewer = viewer;
            if (newInput != null && !(newInput instanceof IObservableSet)) {
                throw new IllegalArgumentException("This content provider only works with input of type IReadableSet");
            }
            this.setInput((IObservableSet)newInput);
        }

        private boolean isDisposed() {
            return this.viewer.getControl() == null || this.viewer.getControl().isDisposed();
        }

        private void setInput(IObservableSet newSet) {
            boolean isStale;
            boolean updateViewer = true;
            if (newSet == null) {
                Realm realm = SWTObservables.getRealm((Display)Display.getDefault());
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.Object");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                newSet = new ObservableSet(this, realm, Collections.EMPTY_SET, clazz){
                    final /* synthetic */ ObservableSetContentProvider this$1;
                    {
                        this.this$1 = observableSetContentProvider;
                    }
                };
                updateViewer = false;
            }
            boolean wasStale = false;
            if (this.readableSet != null) {
                wasStale = this.readableSet.isStale();
                this.readableSet.removeSetChangeListener(this.listener);
                this.readableSet.removeStaleListener(this.staleListener);
            }
            HashSet additions = new HashSet();
            HashSet removals = new HashSet();
            additions.addAll(newSet);
            additions.removeAll((Collection<?>)this.readableSet);
            removals.addAll(this.readableSet);
            removals.removeAll((Collection<?>)newSet);
            this.readableSet = newSet;
            this.doDiff(additions, removals, updateViewer);
            if (this.readableSet != null) {
                this.readableSet.addSetChangeListener(this.listener);
                this.readableSet.addStaleListener(this.staleListener);
            }
            boolean bl = isStale = this.readableSet != null && this.readableSet.isStale();
            if (isStale != wasStale) {
                this.knownElements.doFireStale(isStale);
            }
        }

        public Object[] getChildren(Object parentElement) {
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }

        static /* synthetic */ KnownElementsSet access$0(ObservableSetContentProvider observableSetContentProvider) {
            return observableSetContentProvider.knownElements;
        }

        static /* synthetic */ boolean access$1(ObservableSetContentProvider observableSetContentProvider) {
            return observableSetContentProvider.isDisposed();
        }

        static /* synthetic */ void access$2(ObservableSetContentProvider observableSetContentProvider, Set set, Set set2, boolean bl) {
            observableSetContentProvider.doDiff(set, set2, bl);
        }

        private class KnownElementsSet
        extends ObservableSet {
            final /* synthetic */ ObservableSetContentProvider this$1;

            KnownElementsSet(ObservableSetContentProvider observableSetContentProvider, Set wrappedSet) {
                Realm realm = SWTObservables.getRealm((Display)Display.getDefault());
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.Object");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                super(realm, wrappedSet, (Object)clazz);
                this.this$1 = observableSetContentProvider;
            }

            void doFireDiff(Set added, Set removed) {
                this.fireSetChange(Diffs.createSetDiff((Set)added, (Set)removed));
            }

            void doFireStale(boolean isStale) {
                if (isStale) {
                    this.fireStale();
                } else {
                    this.fireChange();
                }
            }
        }
    }

    private final class ResortColumn
    extends SelectionAdapter {
        private final BindingComparator comparator;
        private final TreeColumn treeColumn;
        private final Tree tree;
        private final int column;

        private ResortColumn(BindingComparator comparator, TreeColumn treeColumn, Tree tree, int column) {
            this.comparator = comparator;
            this.treeColumn = treeColumn;
            this.tree = tree;
            this.column = column;
        }

        public void widgetSelected(SelectionEvent e) {
            if (this.comparator.getSortColumn() == this.column) {
                this.comparator.setAscending(!this.comparator.isAscending());
            }
            this.tree.setSortColumn(this.treeColumn);
            this.tree.setSortDirection(this.comparator.isAscending() ? 128 : 1024);
            this.comparator.setSortColumn(this.column);
            try {
                NewKeysPreferencePage.this.filteredTree.getViewer().getTree().setRedraw(false);
                NewKeysPreferencePage.this.filteredTree.getViewer().refresh();
            }
            finally {
                NewKeysPreferencePage.this.filteredTree.getViewer().getTree().setRedraw(true);
            }
        }
    }
}

