/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.ui.wizards;

import java.util.Map;
import java.util.Properties;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.Property;
import org.eclipse.datatools.enablement.oda.xml.ui.utils.XMLRelationInfoUtil;

public class XMLInformationHolder {
    private static Properties prop;

    public static void saveProperties(Properties newProp) {
        if (prop == null) {
            prop = new Properties();
        }
        prop.putAll((Map<?, ?>)newProp);
    }

    public static Properties getProperties() {
        return prop;
    }

    public static String getPropertyValue(String key) {
        if (prop == null) {
            return null;
        }
        return prop.getProperty(key);
    }

    public static void setPropertyValue(String key, String value) {
        if (prop == null) {
            prop = new Properties();
        }
        if (value != null) {
            prop.setProperty(key, value);
        }
    }

    public static void start(DataSetDesign dataSetDesign) {
        Property maxRow;
        Property xmlEncoding;
        Property xmlFile;
        if (dataSetDesign == null) {
            return;
        }
        if (dataSetDesign.getDataSourceDesign().getOdaExtensionId().equals("org.eclipse.datatools.enablement.oda.ws")) {
            XMLInformationHolder.wsStart(dataSetDesign);
            return;
        }
        String queryText = dataSetDesign.getQueryText();
        if (queryText != null && queryText.trim().length() > 0) {
            XMLInformationHolder.setPropertyValue("RELATIONINFORMATION", queryText);
            String tableName = XMLRelationInfoUtil.getTableName(queryText);
            XMLInformationHolder.setPropertyValue("TABLENAME", tableName);
            String xpath = XMLRelationInfoUtil.getXPathExpression(queryText, tableName);
            XMLInformationHolder.setPropertyValue("XPATHTEXT", xpath);
        }
        if (dataSetDesign.getPrivateProperties() != null) {
            xmlFile = dataSetDesign.getPrivateProperties().findProperty("XML_FILE");
            XMLInformationHolder.setPropertyValue("XML_FILE", xmlFile == null ? "" : xmlFile.getValue());
            xmlEncoding = dataSetDesign.getPrivateProperties().findProperty("XML_ENCODING");
            XMLInformationHolder.setPropertyValue("XML_ENCODING", xmlEncoding == null ? "" : xmlEncoding.getValue());
            maxRow = dataSetDesign.getPrivateProperties().findProperty("MAX_ROW");
            XMLInformationHolder.setPropertyValue("MAX_ROW", maxRow != null ? maxRow.getValue() : "-1");
        } else if (dataSetDesign.getPublicProperties() != null) {
            xmlFile = dataSetDesign.getPublicProperties().findProperty("XML_FILE");
            XMLInformationHolder.setPropertyValue("XML_FILE", xmlFile == null ? "" : xmlFile.getValue());
            xmlEncoding = dataSetDesign.getPublicProperties().findProperty("XML_ENCODING");
            XMLInformationHolder.setPropertyValue("XML_ENCODING", xmlEncoding == null ? "" : xmlEncoding.getValue());
            maxRow = dataSetDesign.getPublicProperties().findProperty("MAX_ROW");
            XMLInformationHolder.setPropertyValue("MAX_ROW", maxRow != null ? maxRow.getValue() : "-1");
            dataSetDesign.getPublicProperties().unsetProperty("MAX_ROW");
            dataSetDesign.getPublicProperties().unsetProperty("XML_FILE");
        }
        if (dataSetDesign.getDataSourceDesign() != null) {
            DataSourceDesign dataSourceDesign = dataSetDesign.getDataSourceDesign();
            Property schema = dataSourceDesign.getPublicProperties().findProperty("SCHEMAFILELIST");
            XMLInformationHolder.setPropertyValue("SCHEMAFILELIST", schema == null ? "" : schema.getValue());
            Property xmlFile2 = dataSourceDesign.getPublicProperties().findProperty("FILELIST");
            XMLInformationHolder.setPropertyValue("FILELIST", xmlFile2 == null ? "" : xmlFile2.getValue());
            Property xmlEncoding2 = dataSourceDesign.getPublicProperties().findProperty("ENCODINGLIST");
            XMLInformationHolder.setPropertyValue("ENCODINGLIST", xmlEncoding2 == null ? "" : xmlEncoding2.getValue());
        }
    }

    private static void wsStart(DataSetDesign dataSetDesign) {
        String queryText;
        if (dataSetDesign.getPrivateProperties() != null && (queryText = dataSetDesign.getPrivateProperties().findProperty("xmlQueryText").getValue()) != null && queryText.trim().length() > 0) {
            XMLInformationHolder.setPropertyValue("RELATIONINFORMATION", queryText);
            String tableName = XMLRelationInfoUtil.getTableName(queryText);
            XMLInformationHolder.setPropertyValue("TABLENAME", tableName);
            String xpath = XMLRelationInfoUtil.getXPathExpression(queryText, tableName);
            XMLInformationHolder.setPropertyValue("XPATHTEXT", xpath);
        }
        if (dataSetDesign.getPublicProperties() != null) {
            Property xmlFile = dataSetDesign.getPublicProperties().findProperty("xmlFileURI");
            XMLInformationHolder.setPropertyValue("XML_FILE", xmlFile == null ? "" : xmlFile.getValue());
            XMLInformationHolder.setPropertyValue("FILELIST", xmlFile == null ? "" : xmlFile.getValue());
            Property schema = dataSetDesign.getPublicProperties().findProperty("xsdFileURI");
            XMLInformationHolder.setPropertyValue("SCHEMAFILELIST", schema == null ? "" : schema.getValue());
            Property maxRow = dataSetDesign.getPublicProperties().findProperty("MAX_ROW");
            XMLInformationHolder.setPropertyValue("MAX_ROW", maxRow != null ? maxRow.getValue() : "-1");
        }
    }

    public static void destory() {
        prop = null;
    }

    public static boolean hasDestroyed() {
        return prop == null;
    }
}

