/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.web.project.facet;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.common.project.facet.WtpUtils;
import org.eclipse.jst.common.project.facet.core.ClasspathHelper;
import org.eclipse.jst.jee.project.facet.JEEFacetInstallDelegate;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.project.facet.ProductManager;

public final class WebFacetInstallDelegate
extends JEEFacetInstallDelegate
implements IDelegate {
    public void execute(IProject project, IProjectFacetVersion fv, Object cfg, IProgressMonitor monitor) throws CoreException {
        if (monitor != null) {
            monitor.beginTask("", 1);
        }
        try {
            IFile webxmlFile;
            IDataModel model = (IDataModel)cfg;
            IJavaProject jproj = JavaCore.create((IProject)project);
            WtpUtils.addNatures((IProject)project);
            IWorkspace ws = ResourcesPlugin.getWorkspace();
            IPath pjpath = project.getFullPath();
            IPath contentdir = this.setContentPropertyIfNeeded(model, pjpath, project);
            WebFacetInstallDelegate.mkdirs(ws.getRoot().getFolder(contentdir));
            IPath webinf = contentdir.append("WEB-INF");
            IFolder webinfFolder = ws.getRoot().getFolder(webinf);
            WebFacetInstallDelegate.mkdirs(webinfFolder);
            IPath webinflib = webinf.append("lib");
            WebFacetInstallDelegate.mkdirs(ws.getRoot().getFolder(webinflib));
            IVirtualComponent c = ComponentCore.createComponent((IProject)project);
            c.create(0, null);
            String contextRoot = model.getStringProperty("IWebFacetInstallDataModelProperties.CONTEXT_ROOT");
            this.setContextRootPropertyIfNeeded(c, contextRoot);
            this.setJavaOutputPropertyIfNeeded(model, c);
            IVirtualFolder webroot = c.getRootFolder();
            if (webroot.getProjectRelativePath().equals((Object)new Path("/"))) {
                webroot.createLink((IPath)new Path("/" + model.getStringProperty("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER")), 0, null);
            }
            if (model.getBooleanProperty("IJ2EEFacetInstallDataModelProperties.GENERATE_DD") && !(webxmlFile = webinfFolder.getFile("web.xml")).exists()) {
                try {
                    webxmlFile.create((InputStream)new ByteArrayInputStream("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<web-app id=\"WebApp_ID\" version=\"2.5\" xmlns=\"http://java.sun.com/xml/ns/javaee\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/web-app_2_5.xsd\">\n</web-app>".getBytes("UTF-8")), true, monitor);
                }
                catch (UnsupportedEncodingException e) {
                    Logger.getLogger().logError((Throwable)e);
                }
            }
            IVirtualFolder jsrc = c.getRootFolder().getFolder("/WEB-INF/classes");
            IClasspathEntry[] cp = jproj.getRawClasspath();
            int i = 0;
            while (i < cp.length) {
                IClasspathEntry cpe = cp[i];
                if (cpe.getEntryKind() == 3 && cpe.getPath().removeFirstSegments(1).segmentCount() > 0) {
                    jsrc.createLink(cpe.getPath().removeFirstSegments(1), 0, null);
                }
                ++i;
            }
            IVirtualFile vf = c.getRootFolder().getFile((IPath)new Path("META-INF/MANIFEST.MF"));
            IFile manifestmf = vf.getUnderlyingFile();
            if (manifestmf == null || !manifestmf.exists()) {
                try {
                    this.createManifest(project, c.getRootFolder().getUnderlyingFolder(), monitor);
                }
                catch (InvocationTargetException e) {
                    Logger.getLogger().logError((Throwable)e);
                }
                catch (InterruptedException e) {
                    Logger.getLogger().logError((Throwable)e);
                }
            }
            ClasspathHelper.removeClasspathEntries((IProject)project, (IProjectFacetVersion)fv);
            ClasspathHelper.addClasspathEntries((IProject)project, (IProjectFacetVersion)fv);
            Path webLibContainer = new Path("org.eclipse.jst.j2ee.internal.web.container");
            WebFacetInstallDelegate.addToClasspath((IJavaProject)jproj, (IClasspathEntry)JavaCore.newContainerEntry((IPath)webLibContainer));
            try {
                ((IDataModelOperation)model.getProperty("FacetDataModelProvider.NOTIFICATION_OPERATION")).execute(monitor, null);
            }
            catch (ExecutionException e) {
                Logger.getLogger().logError((Throwable)e);
            }
            if (monitor != null) {
                monitor.worked(1);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private void setJavaOutputPropertyIfNeeded(IDataModel model, IVirtualComponent c) {
        String existing = c.getMetaProperties().getProperty("java-output-path");
        if (existing == null) {
            this.setOutputFolder(model, c);
        }
    }

    protected void setOutputFolder(IDataModel model, IVirtualComponent component) {
        String outputFolder = null;
        outputFolder = ProductManager.shouldUseSingleRootStructure() ? String.valueOf(model.getStringProperty("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER")) + "/" + "WEB-INF/classes" : ProductManager.getProperty((String)"outputFolder");
        component.setMetaProperty("java-output-path", outputFolder);
    }

    private void setContextRootPropertyIfNeeded(IVirtualComponent c, String contextRoot) {
        String existing = c.getMetaProperties().getProperty("context-root");
        if (existing == null) {
            c.setMetaProperty("context-root", contextRoot);
        }
    }

    private IPath setContentPropertyIfNeeded(IDataModel model, IPath pjpath, IProject project) {
        IVirtualComponent c = ComponentCore.createComponent((IProject)project);
        if (c.exists() && !c.getRootFolder().getProjectRelativePath().isRoot()) {
            return c.getRootFolder().getUnderlyingResource().getFullPath();
        }
        return pjpath.append(model.getStringProperty("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER"));
    }

    private static void mkdirs(IFolder folder) throws CoreException {
        if (!folder.exists()) {
            if (folder.getParent() instanceof IFolder) {
                WebFacetInstallDelegate.mkdirs((IFolder)folder.getParent());
            }
            folder.create(true, true, null);
        }
    }
}

