/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.server.core.manager;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.php.internal.core.util.preferences.IXMLPreferencesStorable;
import org.eclipse.php.internal.core.util.preferences.XMLPreferencesReader;
import org.eclipse.php.internal.core.util.preferences.XMLPreferencesWriter;
import org.eclipse.php.internal.server.core.Activator;
import org.eclipse.php.internal.server.core.Logger;
import org.eclipse.php.internal.server.core.Server;
import org.eclipse.php.internal.server.core.manager.IServersManagerListener;
import org.eclipse.php.internal.server.core.manager.ServerManagerEvent;
import org.osgi.service.prefs.BackingStoreException;

public class ServersManager
implements PropertyChangeListener {
    public static final String SERVERS_PREFERENCES_KEY = "phpServers";
    public static final String DEFAULT_SERVER_PREFERENCES_KEY = "defaultPHPServer";
    private HashMap defaultServersMap = new HashMap();
    private HashMap servers = new HashMap();
    private ArrayList listeners = new ArrayList();
    private static ServersManager instance;
    private static final String NODE_QUALIFIER = "org.eclipse.php.server.core.phpServersPrefs";
    private static final String BASE_URL = "http://localhost";
    public static final String Default_Server_Name = "Default PHP Web Server";

    public static ServersManager getInstance() {
        if (instance == null) {
            instance = new ServersManager();
        }
        return instance;
    }

    private ServersManager() {
        this.loadServers();
    }

    public static void addManagerListener(IServersManagerListener iServersManagerListener) {
        ArrayList arrayList = ServersManager.getInstance().listeners;
        if (!arrayList.contains(iServersManagerListener)) {
            arrayList.add(iServersManagerListener);
        }
    }

    public static void removeManagerListener(IServersManagerListener iServersManagerListener) {
        ServersManager.getInstance().listeners.remove(iServersManagerListener);
    }

    public static void addServer(Server server) {
        ServerManagerEvent serverManagerEvent;
        if (server == null) {
            return;
        }
        ServersManager serversManager = ServersManager.getInstance();
        Server server2 = serversManager.servers.put(server.getName(), server);
        if (server2 != null) {
            server2.removePropertyChangeListener(serversManager);
            serverManagerEvent = new ServerManagerEvent(2, server2);
            serversManager.fireEvent(serverManagerEvent);
        }
        serverManagerEvent = new ServerManagerEvent(0, server);
        serversManager.fireEvent(serverManagerEvent);
        server.addPropertyChangeListener(serversManager);
    }

    public static Server removeServer(String string) {
        Object[] objectArray;
        ServersManager serversManager = ServersManager.getInstance();
        Server server = (Server)serversManager.servers.remove(string);
        Object object = ServersManager.getDefaultServer(null);
        if (object == null) {
            Logger.log(4, "There is no defined default server for the workspace.");
            return null;
        }
        if (server == null) {
            Logger.log(4, "The requested server could not be found, thus, will not be removed.");
            return null;
        }
        if (object == server && (objectArray = ServersManager.getServers()).length > 0) {
            object = objectArray[0];
            ServersManager.setDefaultServer(null, (Server)object);
        }
        objectArray = serversManager.defaultServersMap.keySet().toArray();
        int n = 0;
        while (n < objectArray.length) {
            if (server == serversManager.defaultServersMap.get(objectArray[n])) {
                ServersManager.setDefaultServer((IProject)objectArray[n], (Server)object);
            }
            ++n;
        }
        if (server != null) {
            server.removePropertyChangeListener(serversManager);
            ServerManagerEvent serverManagerEvent = new ServerManagerEvent(2, server);
            serversManager.fireEvent(serverManagerEvent);
        }
        return server;
    }

    public static Server getServer(String string) {
        ServersManager serversManager = ServersManager.getInstance();
        return (Server)serversManager.servers.get(string);
    }

    public static Server[] getServers() {
        ServersManager serversManager = ServersManager.getInstance();
        Collection collection = serversManager.servers.values();
        Server[] serverArray = new Server[collection.size()];
        collection.toArray(serverArray);
        return serverArray;
    }

    public static Server getDefaultServer(IProject iProject) {
        Object object;
        Object object2;
        ServersManager serversManager = ServersManager.getInstance();
        Server server = (Server)serversManager.defaultServersMap.get(iProject);
        if (iProject != null && (object2 = (object = ServersManager.createPreferenceScopes(iProject))[0].getNode(NODE_QUALIFIER).get(DEFAULT_SERVER_PREFERENCES_KEY, null)) == null) {
            serversManager.defaultServersMap.put(iProject, serversManager.defaultServersMap.get(null));
            server = (Server)serversManager.defaultServersMap.get(null);
        }
        if (server == null) {
            object = null;
            if (iProject == null) {
                object2 = Activator.getDefault().getPluginPreferences();
                object = object2.getString(DEFAULT_SERVER_PREFERENCES_KEY);
            } else {
                object2 = ServersManager.createPreferenceScopes(iProject);
                object = object2[0].getNode(NODE_QUALIFIER).get(DEFAULT_SERVER_PREFERENCES_KEY, null);
                if (object == null) {
                    Preferences preferences = Activator.getDefault().getPluginPreferences();
                    object = preferences.getString(DEFAULT_SERVER_PREFERENCES_KEY);
                }
            }
            if (object != null && !"".equals(object)) {
                server = (Server)serversManager.servers.get(object);
                serversManager.defaultServersMap.put(iProject, server);
            } else {
                server = ServersManager.createServer(Default_Server_Name, BASE_URL);
                serversManager.defaultServersMap.put(null, server);
                serversManager.defaultServersMap.put(iProject, server);
                serversManager.innerSaveDefaultServer(iProject, server);
                ServersManager.save();
            }
        }
        return server;
    }

    private static IScopeContext[] createPreferenceScopes(IProject iProject) {
        if (iProject != null) {
            return new IScopeContext[]{new ProjectScope(iProject), new InstanceScope(), new DefaultScope()};
        }
        return new IScopeContext[]{new InstanceScope(), new DefaultScope()};
    }

    public static void setDefaultServer(IProject iProject, Server server) {
        ServersManager serversManager = ServersManager.getInstance();
        Server server2 = (Server)serversManager.defaultServersMap.get(iProject);
        if (server != server2) {
            serversManager.defaultServersMap.put(iProject, server);
            serversManager.innerSaveDefaultServer(iProject, server);
        }
    }

    public static void setDefaultServer(IProject iProject, String string) {
        ServersManager serversManager = ServersManager.getInstance();
        Server server = (Server)serversManager.servers.get(string);
        ServersManager.setDefaultServer(iProject, server);
    }

    public static Server createServer(String string, String string2) {
        Server server = new Server(string, "localhost", string2, "", false);
        ServersManager.addServer(server);
        return server;
    }

    public static void save() {
        IXMLPreferencesStorable[] iXMLPreferencesStorableArray = ServersManager.getServers();
        XMLPreferencesWriter.write((Preferences)Activator.getDefault().getPluginPreferences(), (String)SERVERS_PREFERENCES_KEY, (IXMLPreferencesStorable[])iXMLPreferencesStorableArray);
        Activator.getDefault().savePluginPreferences();
    }

    private void innerSaveDefaultServer(IProject iProject, Server server) {
        Preferences preferences = Activator.getDefault().getPluginPreferences();
        if (iProject == null && server != null) {
            preferences.setValue(DEFAULT_SERVER_PREFERENCES_KEY, server.getName());
            Activator.getDefault().savePluginPreferences();
        } else if (iProject != null) {
            String string = preferences.getString(DEFAULT_SERVER_PREFERENCES_KEY);
            IScopeContext[] iScopeContextArray = ServersManager.createPreferenceScopes(iProject);
            IEclipsePreferences iEclipsePreferences = iScopeContextArray[0].getNode(NODE_QUALIFIER);
            if (server != null && !string.equals(server.getName())) {
                iEclipsePreferences.put(DEFAULT_SERVER_PREFERENCES_KEY, server.getName());
            } else {
                iEclipsePreferences.remove(DEFAULT_SERVER_PREFERENCES_KEY);
            }
            try {
                iEclipsePreferences.flush();
            }
            catch (BackingStoreException backingStoreException) {
                Logger.logException(backingStoreException);
            }
        }
    }

    private void loadServers() {
        HashMap[] hashMapArray = XMLPreferencesReader.read((Preferences)Activator.getDefault().getPluginPreferences(), (String)SERVERS_PREFERENCES_KEY);
        int n = 0;
        while (n < hashMapArray.length) {
            HashMap hashMap = hashMapArray[n];
            Server server = new Server();
            server.restoreFromMap(hashMap);
            String string = server.getName();
            this.servers.put(string, server);
            server.addPropertyChangeListener(this);
            ++n;
        }
    }

    public void fireEvent(ServerManagerEvent serverManagerEvent) {
        IServersManagerListener[] iServersManagerListenerArray = new IServersManagerListener[this.listeners.size()];
        this.listeners.toArray(iServersManagerListenerArray);
        if (serverManagerEvent.getType() == 0) {
            this.fireAddEvent(serverManagerEvent, iServersManagerListenerArray);
        } else if (serverManagerEvent.getType() == 2) {
            this.fireRemoveEvent(serverManagerEvent, iServersManagerListenerArray);
        } else if (serverManagerEvent.getType() == 4) {
            this.fireModifiedEvent(serverManagerEvent, iServersManagerListenerArray);
        }
    }

    private void fireAddEvent(ServerManagerEvent serverManagerEvent, IServersManagerListener[] iServersManagerListenerArray) {
        int n = 0;
        while (n < iServersManagerListenerArray.length) {
            iServersManagerListenerArray[n].serverAdded(serverManagerEvent);
            ++n;
        }
    }

    private void fireRemoveEvent(ServerManagerEvent serverManagerEvent, IServersManagerListener[] iServersManagerListenerArray) {
        int n = 0;
        while (n < iServersManagerListenerArray.length) {
            iServersManagerListenerArray[n].serverRemoved(serverManagerEvent);
            ++n;
        }
    }

    private void fireModifiedEvent(ServerManagerEvent serverManagerEvent, IServersManagerListener[] iServersManagerListenerArray) {
        int n = 0;
        while (n < iServersManagerListenerArray.length) {
            iServersManagerListenerArray[n].serverModified(serverManagerEvent);
            ++n;
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Server server = (Server)propertyChangeEvent.getSource();
        String string = (String)propertyChangeEvent.getOldValue();
        String string2 = (String)propertyChangeEvent.getNewValue();
        ServerManagerEvent serverManagerEvent = new ServerManagerEvent(4, server, propertyChangeEvent.getPropertyName(), string, string2);
        this.fireEvent(serverManagerEvent);
    }
}

