/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.core.rte.fe;

import com.ibm.icu.util.StringTokenizer;
import java.util.Iterator;
import org.eclipse.datatools.connectivity.sqm.core.containment.ContainmentServiceImpl;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.internal.core.definition.DatabaseDefinitionRegistryImpl;
import org.eclipse.datatools.modelbase.sql.accesscontrol.AuthorizationIdentifier;
import org.eclipse.datatools.modelbase.sql.constraints.Assertion;
import org.eclipse.datatools.modelbase.sql.constraints.CheckConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.Constraint;
import org.eclipse.datatools.modelbase.sql.constraints.ForeignKey;
import org.eclipse.datatools.modelbase.sql.constraints.Index;
import org.eclipse.datatools.modelbase.sql.constraints.IndexMember;
import org.eclipse.datatools.modelbase.sql.constraints.PrimaryKey;
import org.eclipse.datatools.modelbase.sql.constraints.ReferenceConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.TableConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.UniqueConstraint;
import org.eclipse.datatools.modelbase.sql.datatypes.AttributeDefinition;
import org.eclipse.datatools.modelbase.sql.datatypes.DistinctUserDefinedType;
import org.eclipse.datatools.modelbase.sql.datatypes.Domain;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.SQLDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.StructuredUserDefinedType;
import org.eclipse.datatools.modelbase.sql.datatypes.UserDefinedType;
import org.eclipse.datatools.modelbase.sql.routines.Function;
import org.eclipse.datatools.modelbase.sql.routines.Method;
import org.eclipse.datatools.modelbase.sql.routines.Parameter;
import org.eclipse.datatools.modelbase.sql.routines.ParameterMode;
import org.eclipse.datatools.modelbase.sql.routines.Procedure;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.routines.UserDefinedFunction;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.ReferentialActionType;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.schema.Sequence;
import org.eclipse.datatools.modelbase.sql.schema.TypedElement;
import org.eclipse.datatools.modelbase.sql.statements.SQLStatement;
import org.eclipse.datatools.modelbase.sql.tables.ActionGranularityType;
import org.eclipse.datatools.modelbase.sql.tables.ActionTimeType;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.datatools.modelbase.sql.tables.CheckType;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.modelbase.sql.tables.TemporaryTable;
import org.eclipse.datatools.modelbase.sql.tables.Trigger;
import org.eclipse.datatools.modelbase.sql.tables.ViewTable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class GenericDdlBuilder {
    protected static final String NEWLINE = System.getProperty("line.separator");
    protected static final String EMPTY_STRING = "";
    protected static final String DOT = ".";
    protected static final String SPACE = " ";
    protected static final String COMMA = ",";
    protected static final String SINGLE_QUOTE = "'";
    protected static final String DOUBLE_QUOTE = "\"";
    protected static final String TAB = "\t";
    protected static final String LEFT_PARENTHESIS = "(";
    protected static final String RIGHT_PARENTHESIS = ")";
    protected static final String DROP = "DROP";
    protected static final String CREATE = "CREATE";
    protected static final String ALTER = "ALTER";
    protected static final String ADD = "ADD";
    protected static final String DELETE = "DELETE";
    protected static final String UPDATE = "UPDATE";
    protected static final String CASCADE = "CASCADE";
    protected static final String CASCADED = "CASCADED";
    protected static final String LOCAL = "LOCAL";
    protected static final String OPTION = "OPTION";
    protected static final String RESTRICT = "RESTRICT";
    protected static final String NULL = "NULL";
    protected static final String NOT = "NOT";
    protected static final String DEFAULT = "DEFAULT";
    protected static final String SET = "SET";
    protected static final String TRIGGER = "TRIGGER";
    protected static final String TABLE = "TABLE";
    protected static final String VIEW = "VIEW";
    protected static final String INDEX = "INDEX";
    protected static final String PROCEDURE = "PROCEDURE";
    protected static final String FUNCTION = "FUNCTION";
    protected static final String CONSTRAINT = "CONSTRAINT";
    protected static final String UNIQUE = "UNIQUE";
    protected static final String CHECK = "CHECK";
    protected static final String TYPE = "TYPE";
    protected static final String ON = "ON";
    protected static final String FOREIGN_KEY = "FOREIGN KEY";
    protected static final String REFERENCES = "REFERENCES";
    protected static final String PRIMARY_KEY = "PRIMARY KEY";
    protected static final String DEFERRABLE = "DEFERRABLE";
    protected static final String DEFERRED = "DEFERRED";
    protected static final String INITIALLY = "INITIALLY";
    protected static final String ALIAS = "ALIAS";
    protected static final String AS = "AS";
    protected static final String FOR = "FOR";
    protected static final String LONG = "LONG";
    protected static final String BLOB = "BLOB";
    protected static final String DBCLOB = "DBCLOB";
    protected static final String CLOB = "CLOB";
    protected static final String VARCHAR = "VARCHAR";
    protected static final String WITH = "WITH";
    protected static final String COMPARISONS = "COMPARISONS";
    protected static final String DATALINK = "DATALINK";
    protected static final String VARGRAPHIC = "VARGRAPHIC";
    protected static final String AFTER = "AFTER";
    protected static final String BEFORE = "BEFORE";
    protected static final String INSTEAD_OF = "INSTEAD OF";
    protected static final String INSERT = "INSERT";
    protected static final String NO = "NO";
    protected static final String OF = "OF";
    protected static final String REFERENCING = "REFERENCING";
    protected static final String NEW = "NEW";
    protected static final String OLD = "OLD";
    protected static final String NEW_TABLE = "NEW TABLE";
    protected static final String OLD_TABLE = "OLD TABLE";
    protected static final String EACH = "EACH";
    protected static final String ROW = "ROW";
    protected static final String STATEMENT = "STATEMENT";
    protected static final String WHEN = "WHEN";
    protected static final String LANGUAGE = "LANGUAGE";
    protected static final String PARAMETER_STYLE = "PARAMETER STYLE";
    protected static final String DETERMINISTIC = "DETERMINISTIC";
    protected static final String NOT_DETERMINISTIC = "NOT DETERMINISTIC";
    protected static final String DYNAMIC_RESULT_SETS = "DYNAMIC RESULT SETS";
    protected static final String RETURNS = "RETURNS";
    protected static final String CAST_FROM = "CAST FROM";
    protected static final String RETURNS_NULL_ON_NULL_INPUT = "RETURNS NULL ON NULL INPUT";
    protected static final String CALLED_ON_NULL_INPUT = "CALLED ON NULL INPUT";
    protected static final String TRANSFORM_GROUP = "TRANSFORM GROUP";
    protected static final String STATIC_DISPATCH = "STATIC DISPATCH";
    protected static final String SCHEMA = "SCHEMA";
    protected static final String AUTHORIZATION = "AUTHORIZATION";
    protected static final String GLOBAL = "GLOBAL";
    protected static final String TEMPORARY = "TEMPORARY";
    protected static final String ON_COMMIT = "ON COMMIT";
    protected static final String PRESERVE = "PRESERVE";
    protected static final String ROWS = "ROWS";
    protected static final String UNDER = "UNDER";
    protected static final String INSTANTIABLE = "INSTANTIABLE";
    protected static final String NOT_INSTANTIABLE = "NOT INSTANTIABLE";
    protected static final String FINAL = "FINAL";
    protected static final String NOT_FINAL = "NOT FINAL";
    protected static final String OVERRIDING = "OVERRIDING";
    protected static final String STATIC = "STATIC";
    protected static final String INSTANCE = "INSTANCE";
    protected static final String SPECIFIC = "SPECIFIC";
    protected static final String DOMAIN = "DOMAIN";
    protected static final String REFERENCES_ARE_CHECKED = "REFERENCES ARE CHECKED";
    protected static final String REFERENCES_ARE_NOT_CHECKED = "REFERENCES ARE NOT CHECKED";
    protected static final String ASSERTION = "ASSERTION";

    public String dropTrigger(Trigger trigger, boolean quoteIdentifiers, boolean qualifyNames) {
        return "DROP TRIGGER " + this.getName(trigger, quoteIdentifiers, qualifyNames);
    }

    public String dropView(ViewTable view, boolean quoteIdentifiers, boolean qualifyNames) {
        return "DROP VIEW " + this.getName((Table)view, quoteIdentifiers, qualifyNames);
    }

    public String dropTableConstraint(TableConstraint constraint, boolean quoteIdentifiers, boolean qualifyNames) {
        return "ALTER TABLE " + this.getName((Table)constraint.getBaseTable(), quoteIdentifiers, qualifyNames) + " DROP CONSTRAINT " + this.getName(constraint, quoteIdentifiers);
    }

    public String dropIndex(Index index, boolean quoteIdentifiers, boolean qualifyNames) {
        return "DROP INDEX " + this.getName(index, quoteIdentifiers, qualifyNames);
    }

    public String dropTable(BaseTable table, boolean quoteIdentifiers, boolean qualifyNames) {
        return "DROP TABLE " + this.getName((Table)table, quoteIdentifiers, qualifyNames);
    }

    public String dropProcedure(Procedure procedure, boolean quoteIdentifiers, boolean qualifyNames) {
        return "DROP PROCEDURE " + this.getName((Routine)procedure, quoteIdentifiers, qualifyNames);
    }

    public String dropFunction(UserDefinedFunction function, boolean quoteIdentifiers, boolean qualifyNames) {
        return "DROP FUNCTION " + this.getName((Routine)function, quoteIdentifiers, qualifyNames);
    }

    public String dropSchema(Schema schema, boolean quoteIdentifiers, boolean qualifyNames) {
        return "DROP SCHEMA " + this.getName(schema, quoteIdentifiers, qualifyNames);
    }

    public String dropUserDefinedType(UserDefinedType type, boolean quoteIdentifiers, boolean qualifyNames) {
        if (type instanceof Domain) {
            return "DROP DOMAIN " + this.getName(type, quoteIdentifiers, qualifyNames);
        }
        return "DROP TYPE " + this.getName(type, quoteIdentifiers, qualifyNames);
    }

    public String dropAssertion(Assertion assertion, boolean quoteIdentifiers, boolean qualifyNames) {
        return "DROP ASSERTION " + this.getName(assertion, quoteIdentifiers, qualifyNames);
    }

    public String createTable(BaseTable table, boolean quoteIdentifiers, boolean qualifyNames) {
        StringBuffer statement = new StringBuffer();
        boolean isTemp = table instanceof TemporaryTable;
        statement.append(CREATE).append(SPACE);
        if (isTemp) {
            if (((TemporaryTable)table).isLocal()) {
                statement.append(LOCAL).append(SPACE);
            } else {
                statement.append(GLOBAL).append(SPACE);
            }
            statement.append(TEMPORARY).append(SPACE);
        }
        statement.append(TABLE).append(SPACE).append(this.getName((Table)table, quoteIdentifiers, qualifyNames)).append(SPACE);
        statement.append(LEFT_PARENTHESIS).append(NEWLINE);
        Iterator it = table.getColumns().iterator();
        while (it.hasNext()) {
            Column column = (Column)it.next();
            statement.append(TAB).append(TAB).append(this.getColumnString(column, quoteIdentifiers));
            if (it.hasNext()) {
                statement.append(COMMA);
            }
            statement.append(NEWLINE);
        }
        statement.append(TAB).append(RIGHT_PARENTHESIS);
        if (isTemp) {
            statement.append(NEWLINE).append(TAB).append(ON_COMMIT).append(SPACE);
            if (((TemporaryTable)table).isDeleteOnCommit()) {
                statement.append(DELETE).append(SPACE);
            } else {
                statement.append(PRESERVE).append(SPACE);
            }
            statement.append(ROWS);
        }
        return statement.toString();
    }

    public String alterTableAddColumn(Column column, boolean quoteIdentifiers, boolean qualifyNames) {
        Table table = column.getTable();
        if (table instanceof BaseTable) {
            String statement = "ALTER TABLE " + this.getName(table, quoteIdentifiers, qualifyNames) + " ADD COLUMN " + this.getColumnString(column, quoteIdentifiers);
            return statement;
        }
        return null;
    }

    public String createView(ViewTable view, boolean quoteIdentifiers, boolean qualifyNames) {
        String viewDefinition = "CREATE ";
        viewDefinition = viewDefinition + "VIEW " + this.getName((Table)view, quoteIdentifiers, qualifyNames) + SPACE;
        String columns = this.getViewColumnList(view);
        if (columns != null) {
            viewDefinition = viewDefinition + LEFT_PARENTHESIS + columns + RIGHT_PARENTHESIS + SPACE;
        }
        viewDefinition = viewDefinition + AS + NEWLINE;
        viewDefinition = viewDefinition + view.getQueryExpression().getSQL();
        CheckType checkType = view.getCheckType();
        if (checkType == CheckType.CASCADED_LITERAL) {
            viewDefinition = viewDefinition + NEWLINE + WITH + SPACE + CASCADED + SPACE + CHECK + SPACE + OPTION;
        } else if (checkType == CheckType.LOCAL_LITERAL) {
            viewDefinition = viewDefinition + NEWLINE + WITH + SPACE + LOCAL + SPACE + CHECK + SPACE + OPTION;
        }
        return viewDefinition;
    }

    public String createIndex(Index index, boolean quoteIdentifiers, boolean qualifyNames) {
        String statement = "CREATE ";
        if (index.isUnique()) {
            statement = statement + "UNIQUE ";
        }
        statement = statement + "INDEX " + this.getName(index, quoteIdentifiers, qualifyNames) + SPACE + ON + SPACE + this.getName(index.getTable(), quoteIdentifiers, qualifyNames) + SPACE + LEFT_PARENTHESIS + this.getIndexKeyColumns(index, quoteIdentifiers) + RIGHT_PARENTHESIS;
        return statement;
    }

    public String createTrigger(Trigger trigger, boolean quoteIdentifiers, boolean qualifyNames) {
        String statement = "CREATE TRIGGER " + this.getName(trigger, quoteIdentifiers, qualifyNames) + SPACE;
        ActionTimeType actionTime = trigger.getActionTime();
        if (actionTime == ActionTimeType.AFTER_LITERAL) {
            statement = statement + AFTER;
        } else if (actionTime == ActionTimeType.BEFORE_LITERAL) {
            statement = statement + BEFORE;
        } else if (actionTime == ActionTimeType.INSTEADOF_LITERAL) {
            statement = statement + INSTEAD_OF;
        }
        statement = statement + SPACE;
        if (trigger.isDeleteType()) {
            statement = statement + DELETE;
        } else if (trigger.isInsertType()) {
            statement = statement + INSERT;
        } else if (trigger.isUpdateType()) {
            statement = statement + UPDATE;
            EList updateColumns = trigger.getTriggerColumn();
            if (!updateColumns.isEmpty()) {
                statement = statement + " OF ";
                Iterator it = updateColumns.iterator();
                while (it.hasNext()) {
                    Column column = (Column)it.next();
                    statement = statement + column.getName();
                    if (!it.hasNext()) continue;
                    statement = statement + ", ";
                }
            }
        }
        statement = statement + " ON " + this.getName(trigger.getSubjectTable(), quoteIdentifiers, qualifyNames) + NEWLINE;
        String newRow = trigger.getNewRow();
        String oldRow = trigger.getOldRow();
        String newTable = trigger.getNewTable();
        String oldTable = trigger.getOldTable();
        if (newRow != null && newRow.length() != 0) {
            statement = statement + "REFERENCING NEW ROW AS " + newRow + NEWLINE;
        }
        if (oldRow != null && oldRow.length() != 0) {
            statement = statement + "REFERENCING OLD ROW AS " + oldRow + NEWLINE;
        }
        if (newTable != null && newTable.length() != 0) {
            statement = statement + "REFERENCING NEW TABLE AS " + newTable + NEWLINE;
        }
        if (oldTable != null && oldTable.length() != 0) {
            statement = statement + "REFERENCING OLD TABLE AS " + oldTable + NEWLINE;
        }
        statement = trigger.getActionGranularity() == ActionGranularityType.ROW_LITERAL ? statement + "FOR EACH ROW" + NEWLINE : statement + "FOR EACH STATEMENT" + NEWLINE;
        Iterator it = trigger.getActionStatement().iterator();
        while (it.hasNext()) {
            SQLStatement s = (SQLStatement)it.next();
            statement = statement + s.getSQL();
        }
        return statement;
    }

    public String createProcedure(Procedure procedure, boolean quoteIdentifiers, boolean qualifyNames) {
        String body;
        StringBuffer statement = new StringBuffer();
        statement.append(CREATE).append(SPACE).append(PROCEDURE).append(SPACE).append(this.getName((Routine)procedure, quoteIdentifiers, qualifyNames)).append(SPACE);
        statement.append(this.getParameterListClause((Routine)procedure, quoteIdentifiers));
        if (procedure.getLanguage() != null && procedure.getLanguage().length() > 0) {
            statement.append(TAB).append(LANGUAGE).append(SPACE).append(procedure.getLanguage()).append(NEWLINE);
        }
        if (procedure.getParameterStyle() != null && procedure.getParameterStyle().length() > 0) {
            statement.append(TAB).append(PARAMETER_STYLE).append(SPACE).append(procedure.getParameterStyle()).append(NEWLINE);
        }
        if (procedure.isDeterministic()) {
            statement.append(TAB).append(DETERMINISTIC).append(NEWLINE);
        } else {
            statement.append(TAB).append(NOT_DETERMINISTIC).append(NEWLINE);
        }
        if (procedure.getSqlDataAccess() != null) {
            statement.append(TAB).append(procedure.getSqlDataAccess().toString()).append(NEWLINE);
        }
        if (procedure.getMaxResultSets() > 0) {
            statement.append(TAB).append(DYNAMIC_RESULT_SETS).append(SPACE).append(procedure.getMaxResultSets()).append(NEWLINE);
        }
        if (procedure.getSource() != null && (body = procedure.getSource().getBody()) != null && body.length() > 0) {
            statement.append(body).append(NEWLINE);
        }
        return statement.toString();
    }

    public String createUserDefinedFunction(UserDefinedFunction function, boolean quoteIdentifiers, boolean qualifyNames) {
        String body;
        StringBuffer statement = new StringBuffer();
        statement.append(CREATE).append(SPACE).append(FUNCTION).append(SPACE).append(this.getName((Routine)function, quoteIdentifiers, qualifyNames)).append(SPACE);
        statement.append(this.getParameterListClause((Routine)function, quoteIdentifiers));
        statement.append(this.getReturnsClause((Function)function, quoteIdentifiers));
        if (function.getLanguage() != null && function.getLanguage().length() > 0) {
            statement.append(TAB).append(LANGUAGE).append(SPACE).append(function.getLanguage()).append(NEWLINE);
        }
        if (function.getParameterStyle() != null && function.getParameterStyle().length() > 0) {
            statement.append(TAB).append(PARAMETER_STYLE).append(SPACE).append(function.getParameterStyle()).append(NEWLINE);
        }
        if (function.isDeterministic()) {
            statement.append(TAB).append(DETERMINISTIC).append(NEWLINE);
        } else {
            statement.append(TAB).append(NOT_DETERMINISTIC).append(NEWLINE);
        }
        if (function.getSqlDataAccess() != null) {
            statement.append(TAB).append(function.getSqlDataAccess().toString()).append(NEWLINE);
        }
        if (function.isNullCall()) {
            statement.append(TAB).append(RETURNS_NULL_ON_NULL_INPUT).append(NEWLINE);
        } else {
            statement.append(TAB).append(CALLED_ON_NULL_INPUT).append(NEWLINE);
        }
        if (function.getTransformGroup() != null && function.getTransformGroup().length() > 0) {
            statement.append(TAB).append(TRANSFORM_GROUP).append(SPACE).append(function.getTransformGroup()).append(NEWLINE);
        }
        if (function.isStatic()) {
            statement.append(TAB).append(STATIC_DISPATCH).append(NEWLINE);
        }
        if (function.getSource() != null && (body = function.getSource().getBody()) != null && body.length() > 0) {
            statement.append(body).append(NEWLINE);
        }
        return statement.toString();
    }

    protected String getParameterListClause(Routine routine, boolean quoteIdentifiers) {
        StringBuffer statement = new StringBuffer();
        statement.append(LEFT_PARENTHESIS).append(NEWLINE);
        Iterator it = routine.getParameters().iterator();
        while (it.hasNext()) {
            Parameter param = (Parameter)it.next();
            String name = param.getName();
            ParameterMode mode = param.getMode();
            statement.append(TAB).append(TAB);
            if (mode != null) {
                statement.append(mode.toString()).append(SPACE);
            }
            if (name != null && name.length() > 0) {
                statement.append(quoteIdentifiers ? this.getQuotedIdentifierString((SQLObject)param) : name).append(SPACE);
            }
            statement.append(this.getDataTypeString((TypedElement)param, routine.getSchema()));
            if (!it.hasNext()) continue;
            statement.append(COMMA);
            statement.append(NEWLINE);
        }
        statement.append(RIGHT_PARENTHESIS).append(NEWLINE);
        return statement.toString();
    }

    protected String getReturnsClause(Function function, boolean quoteIdentifiers) {
        StringBuffer statement = new StringBuffer();
        statement.append(TAB).append(RETURNS).append(SPACE);
        if (function.getReturnScalar() != null) {
            statement.append(this.getDataTypeString((TypedElement)function.getReturnScalar(), function.getSchema()));
            if (function.getReturnCast() != null) {
                statement.append(SPACE).append(CAST_FROM).append(this.getDataTypeString((TypedElement)function.getReturnCast(), function.getSchema()));
            }
        } else if (function.getReturnTable() != null) {
            statement.append(ROW).append(SPACE).append(LEFT_PARENTHESIS).append(NEWLINE);
            Iterator it = function.getReturnTable().getColumns().iterator();
            while (it.hasNext()) {
                Column col = (Column)it.next();
                String name = col.getName();
                statement.append(TAB).append(TAB);
                if (name != null && name.length() > 0) {
                    statement.append(quoteIdentifiers ? this.getQuotedIdentifierString((SQLObject)col) : name).append(SPACE);
                }
                statement.append(this.getDataTypeString((TypedElement)col, function.getSchema()));
                if (!it.hasNext()) continue;
                statement.append(COMMA);
                statement.append(NEWLINE);
            }
            statement.append(TAB).append(RIGHT_PARENTHESIS);
        }
        statement.append(NEWLINE);
        return statement.toString();
    }

    public String createSchema(Schema schema, boolean quoteIdentifiers, boolean qualifyNames) {
        StringBuffer statement = new StringBuffer();
        statement.append(CREATE).append(SPACE).append(SCHEMA).append(SPACE).append(this.getName(schema, quoteIdentifiers, qualifyNames));
        if (schema.getOwner() != null) {
            statement.append(SPACE).append(AUTHORIZATION).append(SPACE).append(this.getName(schema.getOwner(), quoteIdentifiers));
        }
        return statement.toString();
    }

    public String createUserDefinedType(UserDefinedType type, boolean quoteIdentifiers, boolean qualifyNames) {
        if (type instanceof StructuredUserDefinedType) {
            return this.createStructuredUserDefinedType((StructuredUserDefinedType)type, quoteIdentifiers, qualifyNames);
        }
        if (type instanceof Domain) {
            return this.createDomain((Domain)type, quoteIdentifiers, qualifyNames);
        }
        if (type instanceof DistinctUserDefinedType) {
            return this.createDistinctUserDefinedType((DistinctUserDefinedType)type, quoteIdentifiers, qualifyNames);
        }
        StringBuffer statement = new StringBuffer();
        statement.append(CREATE).append(SPACE).append(TYPE).append(SPACE).append(this.getName(type, quoteIdentifiers, qualifyNames));
        return statement.toString();
    }

    protected String createStructuredUserDefinedType(StructuredUserDefinedType type, boolean quoteIdentifiers, boolean qualifyNames) {
        StringBuffer statement = new StringBuffer();
        statement.append(CREATE).append(SPACE).append(TYPE).append(SPACE).append(this.getName((UserDefinedType)type, quoteIdentifiers, qualifyNames)).append(NEWLINE);
        if (type.getSuper() != null) {
            statement.append(TAB).append(UNDER).append(SPACE).append(this.getName((UserDefinedType)type.getSuper(), quoteIdentifiers, qualifyNames)).append(NEWLINE);
        }
        statement.append(TAB).append(AS).append(SPACE).append(LEFT_PARENTHESIS).append(NEWLINE);
        Iterator it = type.getAttributes().iterator();
        while (it.hasNext()) {
            AttributeDefinition attr = (AttributeDefinition)it.next();
            statement.append(TAB).append(TAB).append(this.getAttributeString(attr, quoteIdentifiers));
        }
        statement.append(TAB).append(RIGHT_PARENTHESIS).append(NEWLINE);
        if (type.isInstantiable()) {
            statement.append(TAB).append(INSTANTIABLE).append(NEWLINE);
        } else {
            statement.append(TAB).append(NOT_INSTANTIABLE).append(NEWLINE);
        }
        if (type.isFinal()) {
            statement.append(TAB).append(FINAL).append(NEWLINE);
        } else {
            statement.append(TAB).append(NOT_FINAL).append(NEWLINE);
        }
        Iterator methodIt = type.getMethods().iterator();
        while (methodIt.hasNext()) {
            Method method = (Method)methodIt.next();
            if (method.isOverriding()) {
                statement.append(OVERRIDING).append(SPACE);
            }
            if (method.isStatic()) {
                statement.append(STATIC);
            } else {
                statement.append(INSTANCE);
            }
            statement.append(SPACE).append(this.getName((Routine)method, quoteIdentifiers, qualifyNames)).append(SPACE);
            statement.append(this.getParameterListClause((Routine)method, quoteIdentifiers));
            statement.append(this.getReturnsClause((Function)method, quoteIdentifiers));
            if (method.getSpecificName() != null && method.getSpecificName().length() > 0) {
                statement.append(TAB).append(SPECIFIC).append(SPACE).append(this.getSpecificName(method, quoteIdentifiers, qualifyNames)).append(NEWLINE);
            }
            if (method.getLanguage() != null && method.getLanguage().length() > 0) {
                statement.append(TAB).append(LANGUAGE).append(SPACE).append(method.getLanguage()).append(NEWLINE);
            }
            if (method.getParameterStyle() != null && method.getParameterStyle().length() > 0) {
                statement.append(TAB).append(PARAMETER_STYLE).append(SPACE).append(method.getParameterStyle()).append(NEWLINE);
            }
            if (method.isDeterministic()) {
                statement.append(TAB).append(DETERMINISTIC).append(NEWLINE);
            } else {
                statement.append(TAB).append(NOT_DETERMINISTIC).append(NEWLINE);
            }
            if (method.getSqlDataAccess() != null) {
                statement.append(TAB).append(method.getSqlDataAccess().toString()).append(NEWLINE);
            }
            if (method.isNullCall()) {
                statement.append(TAB).append(RETURNS_NULL_ON_NULL_INPUT).append(NEWLINE);
            } else {
                statement.append(TAB).append(CALLED_ON_NULL_INPUT).append(NEWLINE);
            }
            if (method.getTransformGroup() != null && method.getTransformGroup().length() > 0) {
                statement.append(TAB).append(TRANSFORM_GROUP).append(SPACE).append(method.getTransformGroup()).append(NEWLINE);
            }
            if (!methodIt.hasNext()) continue;
            statement.append(COMMA);
            statement.append(NEWLINE);
        }
        return statement.toString();
    }

    protected String createDomain(Domain type, boolean quoteIdentifiers, boolean qualifyNames) {
        StringBuffer statement = new StringBuffer();
        statement.append(CREATE).append(SPACE).append(DOMAIN).append(SPACE).append(this.getName((UserDefinedType)type, quoteIdentifiers, qualifyNames)).append(SPACE).append(AS).append(SPACE).append(this.getDataTypeString((DistinctUserDefinedType)type));
        if (type.getDefaultValue() != null) {
            statement.append(SPACE).append(DEFAULT).append(SPACE).append(type.getDefaultValue());
        }
        Iterator it = type.getConstraint().iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (!(obj instanceof CheckConstraint)) continue;
            statement.append(NEWLINE).append(this.getCheckConstraintClause((CheckConstraint)obj, quoteIdentifiers));
        }
        return statement.toString();
    }

    protected String createDistinctUserDefinedType(DistinctUserDefinedType type, boolean quoteIdentifiers, boolean qualifyNames) {
        StringBuffer statement = new StringBuffer();
        statement.append(CREATE).append(SPACE).append(TYPE).append(SPACE).append(this.getName((UserDefinedType)type, quoteIdentifiers, qualifyNames)).append(SPACE).append(AS).append(SPACE).append(this.getDataTypeString(type)).append(SPACE).append(FINAL);
        return statement.toString();
    }

    public String createAssertion(Assertion assertion, boolean quoteIdentifiers, boolean qualifyNames) {
        String text = "CREATE ASSERTION " + this.getName(assertion, quoteIdentifiers, qualifyNames) + SPACE + CHECK + SPACE + LEFT_PARENTHESIS + assertion.getSearchCondition().getSQL() + RIGHT_PARENTHESIS;
        if (assertion.isDeferrable()) {
            text = text + SPACE + this.getDeferrableClause((Constraint)assertion);
        }
        return text;
    }

    public String addCheckConstraint(CheckConstraint constraint, boolean quoteIdentifiers, boolean qualifyNames) {
        BaseTable table = constraint.getBaseTable();
        String tableName = table.getName();
        String schemaName = table.getSchema().getName();
        if (quoteIdentifiers) {
            tableName = this.getQuotedIdentifierString((SQLObject)table);
            schemaName = this.getQuotedIdentifierString((SQLObject)table.getSchema());
        }
        if (qualifyNames) {
            tableName = schemaName + DOT + tableName;
        }
        return "ALTER TABLE " + this.getName((Table)constraint.getBaseTable(), quoteIdentifiers, qualifyNames) + SPACE + this.getAddCheckConstraintClause(constraint, quoteIdentifiers);
    }

    public String addUniqueConstraint(UniqueConstraint constraint, boolean quoteIdentifiers, boolean qualifyNames) {
        String statement = "ALTER TABLE " + this.getName((Table)constraint.getBaseTable(), quoteIdentifiers, qualifyNames) + SPACE;
        statement = statement + this.getAddUniqueConstraintClause(constraint, quoteIdentifiers);
        return statement;
    }

    public String addForeignKey(ForeignKey foreignKey, boolean quoteIdentifiers, boolean qualifyNames) {
        UniqueConstraint uniqueConstraint = foreignKey.getUniqueConstraint();
        Index index = foreignKey.getUniqueIndex();
        BaseTable parentTable = null;
        String parentKey = null;
        if (uniqueConstraint != null) {
            parentTable = uniqueConstraint.getBaseTable();
            parentKey = this.getKeyColumns((ReferenceConstraint)uniqueConstraint);
        } else if (index != null) {
            parentTable = index.getTable();
            parentKey = this.getParentKeyColumns(index, quoteIdentifiers);
        }
        if (parentTable == null) {
            return null;
        }
        String statement = "ALTER TABLE " + this.getName((Table)foreignKey.getBaseTable(), quoteIdentifiers, qualifyNames) + SPACE + ADD + SPACE + CONSTRAINT + SPACE + this.getName((TableConstraint)foreignKey, quoteIdentifiers) + SPACE + FOREIGN_KEY + SPACE + LEFT_PARENTHESIS + this.getKeyColumns((ReferenceConstraint)foreignKey) + RIGHT_PARENTHESIS + NEWLINE;
        statement = statement + "\tREFERENCES " + this.getName((Table)parentTable, quoteIdentifiers, qualifyNames) + SPACE + LEFT_PARENTHESIS + parentKey + RIGHT_PARENTHESIS;
        ReferentialActionType action = foreignKey.getOnDelete();
        if (action != ReferentialActionType.NO_ACTION_LITERAL) {
            statement = statement + NEWLINE + TAB + ON + SPACE + DELETE + SPACE;
        }
        statement = statement + this.getReferentialAction(action);
        action = foreignKey.getOnUpdate();
        if (action != ReferentialActionType.NO_ACTION_LITERAL) {
            statement = statement + NEWLINE + TAB + ON + SPACE + UPDATE + SPACE;
        }
        statement = statement + this.getReferentialAction(action);
        if (foreignKey.isDeferrable()) {
            statement = statement + NEWLINE + TAB + this.getDeferrableClause((Constraint)foreignKey);
        }
        return statement;
    }

    protected String getDeferrableClause(Constraint constraint) {
        String clause = null;
        if (constraint.isDeferrable()) {
            clause = DEFERRABLE;
            if (constraint.isInitiallyDeferred()) {
                clause = clause + " INITIALLY DEFERRED";
            }
        }
        return clause;
    }

    protected String getReferentialAction(ReferentialActionType action) {
        if (action == ReferentialActionType.CASCADE_LITERAL) {
            return CASCADE;
        }
        if (action == ReferentialActionType.RESTRICT_LITERAL) {
            return RESTRICT;
        }
        if (action == ReferentialActionType.SET_DEFAULT_LITERAL) {
            return "SET DEFAULT";
        }
        if (action == ReferentialActionType.SET_NULL_LITERAL) {
            return "SET NULL";
        }
        return EMPTY_STRING;
    }

    protected String getViewColumnList(ViewTable view) {
        Column c;
        String columns = null;
        Iterator it = view.getColumns().iterator();
        if (it.hasNext()) {
            c = (Column)it.next();
            columns = c.getName();
        } else {
            return null;
        }
        while (it.hasNext()) {
            c = (Column)it.next();
            columns = columns + ", " + c.getName();
        }
        return columns;
    }

    protected String getColumnString(Column column, boolean quoteIdentifiers) {
        String columnName = column.getName();
        if (quoteIdentifiers) {
            columnName = this.getQuotedIdentifierString((SQLObject)column);
        }
        String columnString = columnName + SPACE + this.getDataTypeString((TypedElement)column, column.getTable().getSchema());
        String defaultValue = column.getDefaultValue();
        if (defaultValue != null) {
            columnString = columnString + SPACE + DEFAULT + SPACE + defaultValue;
        }
        if (!column.isNullable()) {
            columnString = columnString + SPACE + NOT + SPACE + NULL;
        }
        return columnString;
    }

    protected String getAttributeString(AttributeDefinition attr, boolean quoteIdentifiers) {
        String attrName = attr.getName();
        if (quoteIdentifiers) {
            attrName = this.getQuotedIdentifierString((SQLObject)attr);
        }
        StringBuffer attrString = new StringBuffer();
        attrString.append(attrName).append(SPACE);
        attrString.append(this.getDataTypeString((TypedElement)attr, ((UserDefinedType)attr.eContainer()).getSchema())).append(SPACE);
        if (attr.isScopeChecked()) {
            attrString.append(REFERENCES_ARE_CHECKED);
        } else {
            attrString.append(REFERENCES_ARE_NOT_CHECKED);
        }
        if (attr.getScopeCheck() != null && attr.getScopeCheck() != ReferentialActionType.NO_ACTION_LITERAL) {
            attrString.append(SPACE).append(ON).append(SPACE).append(DELETE).append(SPACE);
            switch (attr.getScopeCheck().getValue()) {
                case 2: {
                    attrString.append(CASCADE);
                    break;
                }
                case 1: {
                    attrString.append(RESTRICT);
                    break;
                }
                case 3: {
                    attrString.append(SET).append(SPACE).append(NULL);
                    break;
                }
                case 4: {
                    attrString.append(SET).append(SPACE).append(DEFAULT);
                }
            }
        }
        if (attr.getDefaultValue() != null) {
            attrString.append(SPACE).append(DEFAULT).append(SPACE).append(attr.getDefaultValue());
        }
        return attrString.toString();
    }

    protected String getAddUniqueConstraintClause(UniqueConstraint constraint, boolean quoteIdentifiers) {
        String constraintName = this.getName((TableConstraint)constraint, quoteIdentifiers);
        String text = "ADD CONSTRAINT " + constraintName + SPACE + this.getUniqueConstraintType(constraint) + SPACE + LEFT_PARENTHESIS + this.getKeyColumns((ReferenceConstraint)constraint) + RIGHT_PARENTHESIS;
        if (constraint.isDeferrable()) {
            text = text + SPACE + this.getDeferrableClause((Constraint)constraint);
        }
        return text;
    }

    protected String getUniqueConstraintType(UniqueConstraint constraint) {
        if (constraint instanceof PrimaryKey) {
            return PRIMARY_KEY;
        }
        return UNIQUE;
    }

    protected String getAddCheckConstraintClause(CheckConstraint constraint, boolean quoteIdentifiers) {
        return "ADD " + this.getCheckConstraintClause(constraint, quoteIdentifiers);
    }

    protected String getCheckConstraintClause(CheckConstraint constraint, boolean quoteIdentifiers) {
        String constraintName = this.getName((TableConstraint)constraint, quoteIdentifiers);
        String text = "CONSTRAINT " + constraintName + SPACE + CHECK + SPACE + LEFT_PARENTHESIS + constraint.getSearchCondition().getSQL() + RIGHT_PARENTHESIS;
        if (constraint.isDeferrable()) {
            text = text + SPACE + this.getDeferrableClause((Constraint)constraint);
        }
        return text;
    }

    protected String getKeyColumns(ReferenceConstraint constraint) {
        Column c;
        String columns = null;
        Iterator it = constraint.getMembers().iterator();
        if (it.hasNext()) {
            c = (Column)it.next();
            columns = c.getName();
        } else {
            return null;
        }
        while (it.hasNext()) {
            c = (Column)it.next();
            columns = columns + ", " + c.getName();
        }
        return columns;
    }

    /*
     * WARNING - void declaration
     */
    protected String getIndexKeyColumns(Index index, boolean quoteIdentifiers) {
        void var3_6;
        String columns;
        String columnName;
        IndexMember m;
        Iterator it = index.getMembers().iterator();
        if (it.hasNext()) {
            m = (IndexMember)it.next();
            columnName = m.getColumn().getName();
            if (quoteIdentifiers) {
                columnName = this.getQuotedIdentifierString((SQLObject)m.getColumn());
            }
            columns = columnName + SPACE + m.getIncrementType().getName();
        } else {
            return null;
        }
        while (it.hasNext()) {
            m = (IndexMember)it.next();
            columnName = m.getColumn().getName();
            if (quoteIdentifiers) {
                columnName = this.getQuotedIdentifierString((SQLObject)m.getColumn());
            }
            columns = columns + ", ";
            columns = columns + columnName + SPACE + m.getIncrementType().getName();
        }
        return var3_6;
    }

    /*
     * WARNING - void declaration
     */
    protected String getParentKeyColumns(Index index, boolean quoteIdentifiers) {
        void var3_6;
        String columns;
        String columnName;
        IndexMember m;
        Iterator it = index.getMembers().iterator();
        if (it.hasNext()) {
            m = (IndexMember)it.next();
            columnName = m.getColumn().getName();
            if (quoteIdentifiers) {
                columnName = this.getQuotedIdentifierString((SQLObject)m.getColumn());
            }
            columns = columnName;
        } else {
            return null;
        }
        while (it.hasNext()) {
            m = (IndexMember)it.next();
            columnName = m.getColumn().getName();
            if (quoteIdentifiers) {
                columnName = this.getQuotedIdentifierString((SQLObject)m.getColumn());
            }
            columns = columns + ", " + columnName;
        }
        return var3_6;
    }

    protected String getDataTypeString(TypedElement typedElement, Schema schema) {
        SQLDataType containedType = typedElement.getContainedType();
        if (containedType != null) {
            EObject root;
            if (containedType instanceof PredefinedDataType && (root = ContainmentServiceImpl.INSTANCE.getRootElement((EObject)typedElement)) instanceof Database) {
                DatabaseDefinition def = DatabaseDefinitionRegistryImpl.INSTANCE.getDefinition((Database)root);
                return def.getPredefinedDataTypeFormattedName((PredefinedDataType)containedType);
            }
        } else {
            UserDefinedType referencedType = typedElement.getReferencedType();
            if (referencedType != null) {
                if (referencedType.getSchema() != schema) {
                    return this.getName(referencedType, false, true);
                }
                return referencedType.getName();
            }
        }
        return null;
    }

    protected String getDataTypeString(DistinctUserDefinedType typedElement) {
        EObject root;
        PredefinedDataType containedType = typedElement.getPredefinedRepresentation();
        if (containedType != null && (root = ContainmentServiceImpl.INSTANCE.getRootElement((EObject)typedElement)) instanceof Database) {
            DatabaseDefinition def = DatabaseDefinitionRegistryImpl.INSTANCE.getDefinition((Database)root);
            return def.getPredefinedDataTypeFormattedName(containedType);
        }
        return null;
    }

    protected String getName(TableConstraint constraint, boolean quoteIdentifiers) {
        String name = constraint.getName();
        if (quoteIdentifiers) {
            name = this.getQuotedIdentifierString((SQLObject)constraint);
        }
        return name;
    }

    protected String getName(Assertion assertion, boolean quoteIdentifiers, boolean qualifyNames) {
        String name = assertion.getName();
        String schemaName = assertion.getSchema().getName();
        if (quoteIdentifiers) {
            name = this.getQuotedIdentifierString((SQLObject)assertion);
            schemaName = this.getQuotedIdentifierString((SQLObject)assertion.getSchema());
        }
        if (qualifyNames) {
            name = schemaName + DOT + name;
        }
        return name;
    }

    protected String getName(Trigger trigger, boolean quoteIdentifiers, boolean qualifyNames) {
        String name = trigger.getName();
        String schemaName = trigger.getSchema().getName();
        if (quoteIdentifiers) {
            name = this.getQuotedIdentifierString((SQLObject)trigger);
            schemaName = this.getQuotedIdentifierString((SQLObject)trigger.getSchema());
        }
        if (qualifyNames) {
            name = schemaName + DOT + name;
        }
        return name;
    }

    protected String getName(Routine routine, boolean quoteIdentifiers, boolean qualifyNames) {
        String name = routine.getName();
        String schemaName = routine.getSchema().getName();
        if (quoteIdentifiers) {
            name = this.getQuotedIdentifierString((SQLObject)routine);
            schemaName = this.getQuotedIdentifierString((SQLObject)routine.getSchema());
        }
        if (qualifyNames) {
            name = schemaName + DOT + name;
        }
        return name;
    }

    protected String getSpecificName(Method method, boolean quoteIdentifiers, boolean qualifyNames) {
        String name = method.getSpecificName();
        if (quoteIdentifiers) {
            name = this.getQuotedIdentifierString((SQLObject)method);
        }
        return name;
    }

    protected String getName(Index index, boolean quoteIdentifiers, boolean qualifyNames) {
        String indexName = index.getName();
        String schemaName = index.getSchema().getName();
        if (quoteIdentifiers) {
            indexName = this.getQuotedIdentifierString((SQLObject)index);
            schemaName = this.getQuotedIdentifierString((SQLObject)index.getSchema());
        }
        if (qualifyNames) {
            indexName = schemaName + DOT + indexName;
        }
        return indexName;
    }

    protected String getName(Table table, boolean quoteIdentifiers, boolean qualifyNames) {
        String tableName = table.getName();
        String schemaName = table.getSchema().getName();
        if (quoteIdentifiers) {
            tableName = this.getQuotedIdentifierString((SQLObject)table);
            schemaName = this.getQuotedIdentifierString((SQLObject)table.getSchema());
        }
        if (qualifyNames) {
            tableName = schemaName + DOT + tableName;
        }
        return tableName;
    }

    protected String getName(Sequence sequence, boolean quoteIdentifiers, boolean qualifyNames) {
        String sequenceName = sequence.getName();
        String schemaName = sequence.getSchema().getName();
        if (quoteIdentifiers) {
            sequenceName = this.getQuotedIdentifierString((SQLObject)sequence);
            schemaName = this.getQuotedIdentifierString((SQLObject)sequence.getSchema());
        }
        if (qualifyNames) {
            sequenceName = schemaName + DOT + sequenceName;
        }
        return sequenceName;
    }

    protected String getName(UserDefinedType type, boolean quoteIdentifiers, boolean qualifyNames) {
        String typeName = type.getName();
        String schemaName = type.getSchema().getName();
        if (quoteIdentifiers) {
            typeName = this.getQuotedIdentifierString((SQLObject)type);
            schemaName = this.getQuotedIdentifierString((SQLObject)type.getSchema());
        }
        if (qualifyNames) {
            typeName = schemaName + DOT + typeName;
        }
        return typeName;
    }

    protected String getName(Schema schema, boolean quoteIdentifiers, boolean qualifyNames) {
        String schemaName = schema.getName();
        if (quoteIdentifiers) {
            schemaName = this.getQuotedIdentifierString((SQLObject)schema);
        }
        if (qualifyNames) {
            // empty if block
        }
        return schemaName;
    }

    protected String getName(AuthorizationIdentifier authID, boolean quoteIdentifiers) {
        String authIDName = authID.getName();
        if (quoteIdentifiers) {
            authIDName = this.getQuotedIdentifierString((SQLObject)authID);
        }
        return authIDName;
    }

    protected DatabaseDefinition getDatabaseDefinition(EObject object) {
        EObject root = ContainmentServiceImpl.INSTANCE.getRootElement(object);
        if (root instanceof Database) {
            return DatabaseDefinitionRegistryImpl.INSTANCE.getDefinition((Database)root);
        }
        return null;
    }

    protected String getQuotedIdentifierString(SQLObject object) {
        DatabaseDefinition dbDef = this.getDatabaseDefinition((EObject)object);
        if (dbDef == null) {
            return this.getDoubleQuotedString(object.getName());
        }
        String quote = dbDef.getIdentifierQuoteString();
        StringTokenizer tokenizer = new StringTokenizer(object.getName(), quote);
        String result = null;
        if (tokenizer.countTokens() > 1) {
            if (tokenizer.hasMoreTokens()) {
                result = tokenizer.nextToken();
            }
            while (tokenizer.hasMoreTokens()) {
                result = result + quote + quote + tokenizer.nextToken();
            }
        } else if (tokenizer.hasMoreTokens()) {
            result = tokenizer.nextToken();
        }
        return quote + result + quote;
    }

    protected String getSingleQuotedString(String orignal) {
        StringTokenizer tokenizer = new StringTokenizer(orignal, SINGLE_QUOTE);
        String result = tokenizer.nextToken();
        while (tokenizer.hasMoreTokens()) {
            result = result + SINGLE_QUOTE + SINGLE_QUOTE + tokenizer.nextToken();
        }
        return SINGLE_QUOTE + result + SINGLE_QUOTE;
    }

    protected String getDoubleQuotedString(String orignal) {
        StringTokenizer tokenizer = new StringTokenizer(orignal, DOUBLE_QUOTE);
        String result = null;
        if (tokenizer.countTokens() > 1) {
            if (tokenizer.hasMoreTokens()) {
                result = tokenizer.nextToken();
            }
            while (tokenizer.hasMoreTokens()) {
                result = result + DOUBLE_QUOTE + DOUBLE_QUOTE + tokenizer.nextToken();
            }
        } else if (tokenizer.hasMoreTokens()) {
            result = tokenizer.nextToken();
        }
        return DOUBLE_QUOTE + result + DOUBLE_QUOTE;
    }
}

