/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.converter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.converter.ConverterPlugin;
import org.eclipse.emf.converter.util.ConverterUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModelConverter {
    protected GenModel genModel;
    protected List<EPackage> ePackages;
    protected Map<EPackage, EPackageConvertInfo> ePackageToInfoMap;
    protected List<GenPackage> referencedGenPackages;
    protected Map<GenPackage, ReferencedGenPackageConvertInfo> referencedGenPackageToInfoMap;
    protected ResourceSet externalGenModelResourceSet;
    protected List<GenModel> externalGenModelList;
    protected ReferencedEPackageFilter referencedEPackageFilter;
    protected ReferencedEPackageFilter referencedEPackageFilterToConvert;

    public void dispose() {
        this.clearEPackagesCollections();
        if (this.referencedGenPackages != null) {
            this.referencedGenPackages.clear();
            this.referencedGenPackages = null;
        }
        if (this.referencedGenPackageToInfoMap != null) {
            this.referencedGenPackageToInfoMap.clear();
            this.referencedGenPackageToInfoMap = null;
        }
        this.genModel = null;
        this.referencedEPackageFilter = null;
        this.referencedEPackageFilterToConvert = null;
    }

    public abstract String getID();

    protected String getConverterGenAnnotationSource() {
        return "http://www.eclipse.org/emf/2002/GenModel" + this.getID();
    }

    public GenModel getGenModel() {
        return this.genModel;
    }

    public List<EPackage> getEPackages() {
        if (this.ePackages == null) {
            this.ePackages = this.createEPackagesList();
        }
        return this.ePackages;
    }

    protected List<EPackage> createEPackagesList() {
        return new ConverterUtil.EPackageList();
    }

    public List<GenPackage> getReferencedGenPackages() {
        if (this.referencedGenPackages == null) {
            this.referencedGenPackages = this.createReferencedGenPackagesList();
        }
        return this.referencedGenPackages;
    }

    protected List<GenPackage> createReferencedGenPackagesList() {
        return new ConverterUtil.GenPackageList();
    }

    public void clearEPackagesCollections() {
        if (this.ePackages != null) {
            this.ePackages.clear();
            this.ePackages = null;
        }
        if (this.ePackageToInfoMap != null) {
            this.ePackageToInfoMap.clear();
            this.ePackageToInfoMap = null;
        }
        if (this.externalGenModelList != null) {
            this.externalGenModelList.clear();
            this.externalGenModelList = null;
        }
    }

    public ResourceSet createResourceSet() {
        return ConverterUtil.createResourceSet();
    }

    protected Map<EPackage, EPackageConvertInfo> getEPackageToInfoMap() {
        if (this.ePackageToInfoMap == null) {
            this.ePackageToInfoMap = new HashMap<EPackage, EPackageConvertInfo>();
        }
        return this.ePackageToInfoMap;
    }

    public EPackageConvertInfo getEPackageConvertInfo(EPackage ePackage) {
        EPackageConvertInfo ePackageInfo = this.getEPackageToInfoMap().get(ePackage);
        if (ePackageInfo == null) {
            ePackageInfo = this.createEPackageInfo(ePackage);
            this.getEPackageToInfoMap().put(ePackage, ePackageInfo);
        }
        return ePackageInfo;
    }

    public void clearEPackageConvertInfoCache() {
        this.getEPackageToInfoMap().clear();
    }

    protected EPackageConvertInfo createEPackageInfo(EPackage ePackage) {
        return new EPackageConvertInfo();
    }

    protected Map<GenPackage, ReferencedGenPackageConvertInfo> getReferencedGenPackageToInfoMap() {
        if (this.referencedGenPackageToInfoMap == null) {
            this.referencedGenPackageToInfoMap = new HashMap<GenPackage, ReferencedGenPackageConvertInfo>();
        }
        return this.referencedGenPackageToInfoMap;
    }

    public ReferencedGenPackageConvertInfo getReferenceGenPackageConvertInfo(GenPackage genPackage) {
        ReferencedGenPackageConvertInfo genPackageConvertInfo = this.getReferencedGenPackageToInfoMap().get(genPackage);
        if (genPackageConvertInfo == null) {
            genPackageConvertInfo = this.createGenPackageConvertInfo(genPackage);
            this.getReferencedGenPackageToInfoMap().put(genPackage, genPackageConvertInfo);
        }
        return genPackageConvertInfo;
    }

    public void clearReferenceGenPackageConvertInfoCache() {
        this.getReferencedGenPackageToInfoMap().clear();
    }

    protected ReferencedGenPackageConvertInfo createGenPackageConvertInfo(GenPackage genPackage) {
        return new ReferencedGenPackageConvertInfo();
    }

    public List<EPackage> filterReferencedEPackages(Collection<EPackage> ePackages, List<GenPackage> referencedGenPackages) {
        if (this.referencedEPackageFilter == null) {
            this.referencedEPackageFilter = this.createReferencedEPackageFilter();
        }
        return this.referencedEPackageFilter.filterReferencedEPackages(ePackages, referencedGenPackages);
    }

    protected ReferencedEPackageFilter createReferencedEPackageFilter() {
        return new ReferencedEPackageFilter();
    }

    protected List<EPackage> computeEPackagesToConvert() {
        ConverterUtil.EPackageList ePackages = new ConverterUtil.EPackageList();
        for (EPackage ePackage : this.getEPackages()) {
            if (!this.canConvert(ePackage)) continue;
            ePackages.add(ePackage);
        }
        return this.filterReferencedEPackagesToConvert((Collection<EPackage>)((Object)ePackages), null);
    }

    protected List<EPackage> filterReferencedEPackagesToConvert(Collection<EPackage> ePackages, List<GenPackage> referencedGenPackages) {
        if (this.referencedEPackageFilterToConvert == null) {
            this.referencedEPackageFilterToConvert = this.createReferencedEPackageFilterToConvert();
        }
        return this.referencedEPackageFilterToConvert.filterReferencedEPackages(ePackages, referencedGenPackages);
    }

    protected List<GenPackage> computeValidReferencedGenPackages() {
        if (this.referencedEPackageFilterToConvert == null) {
            this.referencedEPackageFilterToConvert = this.createReferencedEPackageFilterToConvert();
        }
        return this.referencedEPackageFilterToConvert.computeValidReferencedGenPackages();
    }

    protected ReferencedEPackageFilter createReferencedEPackageFilterToConvert() {
        return new ReferencedEPackageFilter();
    }

    protected boolean canConvert(EPackage ePackage) {
        return this.getEPackageConvertInfo(ePackage).isConvert();
    }

    public EPackage getReferredEPackage(GenPackage genPackage) {
        String nsURI = genPackage.getEcorePackage().getNsURI();
        if (nsURI != null) {
            for (EPackage ePackage : this.getEPackages()) {
                if (!nsURI.equals(ePackage.getNsURI())) continue;
                return ePackage;
            }
        }
        return null;
    }

    public List<GenModel> getExternalGenModels() {
        if (this.externalGenModelList == null) {
            this.externalGenModelList = new UniqueEList.FastCompare();
            if (this.externalGenModelResourceSet == null) {
                this.externalGenModelResourceSet = this.createExternalGenModelResourceSet();
            }
            Map ePackageToGenModelMap = EcorePlugin.getEPackageNsURIToGenModelLocationMap();
            EcoreUtil.ContentTreeIterator<EPackage> i = new EcoreUtil.ContentTreeIterator<EPackage>(this.getEPackages()){
                private static final long serialVersionUID = 1L;

                protected Iterator<? extends EObject> getEObjectChildren(EObject eObject) {
                    return ((EPackage)eObject).getESubpackages().iterator();
                }
            };
            while (i.hasNext()) {
                EPackage ePackage = (EPackage)i.next();
                URI genModelURI = (URI)ePackageToGenModelMap.get(ePackage.getNsURI());
                if (genModelURI == null) continue;
                try {
                    Resource genModelResource = this.externalGenModelResourceSet.getResource(genModelURI, false);
                    if (genModelResource == null) {
                        genModelResource = this.externalGenModelResourceSet.getResource(genModelURI, true);
                        this.externalGenModelList.add((GenModel)genModelResource.getContents().get(0));
                    }
                }
                catch (Exception exception) {
                    ConverterPlugin.INSTANCE.log(exception);
                }
                i.prune();
            }
        }
        return this.externalGenModelList;
    }

    protected ResourceSet createExternalGenModelResourceSet() {
        return this.createResourceSet();
    }

    @Deprecated
    protected Map<?, ?> getGenmodelSaveOptions() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        return result;
    }

    protected Map<?, ?> getGenModelSaveOptions() {
        return this.getGenmodelSaveOptions();
    }

    public void makeEPackageConvertDataUnique() {
        if (!this.getEPackageToInfoMap().isEmpty()) {
            HashMap<String, Integer> dataToCounter = new HashMap<String, Integer>();
            List<EPackage> ePackages = this.filterReferencedEPackages((Collection<EPackage>)this.getEPackageToInfoMap().keySet(), null);
            if (!ePackages.isEmpty()) {
                ArrayList<EPackageConvertInfo> packageInfos = new ArrayList<EPackageConvertInfo>(ePackages.size());
                for (EPackage ePackage : ePackages) {
                    if (ePackage.getESuperPackage() != null && ePackages.contains(ePackage.getESuperPackage())) continue;
                    EPackageConvertInfo packageInfo = this.getEPackageToInfoMap().get(ePackage);
                    if (packageInfo.isConvert()) {
                        packageInfos.add(0, packageInfo);
                    } else {
                        packageInfos.add(packageInfo);
                    }
                    String data = packageInfo.getConvertData();
                    if (data == null) continue;
                    dataToCounter.put(data, null);
                }
                for (EPackageConvertInfo packageInfo : packageInfos) {
                    String data = packageInfo.getConvertData();
                    if (data == null) continue;
                    Integer counterObject = (Integer)dataToCounter.get(data);
                    if (counterObject != null) {
                        int counter = counterObject;
                        int index = data.lastIndexOf(".");
                        StringBuffer newValue = null;
                        while (dataToCounter.containsKey((newValue = new StringBuffer(data).insert(index, counter++)).toString())) {
                        }
                        packageInfo.setConvertData(newValue.toString());
                        counterObject = new Integer(counter);
                        dataToCounter.put(newValue.toString(), new Integer(1));
                    } else {
                        counterObject = new Integer(1);
                    }
                    dataToCounter.put(data, counterObject);
                }
            }
        }
    }

    public static class EPackageConvertInfo {
        protected boolean convert = false;
        protected String convertData;

        public boolean isConvert() {
            return this.convert;
        }

        public void setConvert(boolean convert) {
            this.convert = convert;
        }

        public String getConvertData() {
            return this.convertData;
        }

        public void setConvertData(String convertData) {
            this.convertData = convertData;
        }
    }

    public static class ReferencedGenPackageConvertInfo {
        protected boolean validReference = true;

        public boolean isValidReference() {
            return this.validReference;
        }

        public void setValidReference(boolean validReference) {
            this.validReference = validReference;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ReferencedEPackageFilter {
        protected ReferencedEPackageFilter() {
        }

        public List<GenPackage> computeValidReferencedGenPackages() {
            ConverterUtil.GenPackageList genPackages = new ConverterUtil.GenPackageList();
            for (GenPackage genPackage : ModelConverter.this.getReferencedGenPackages()) {
                EPackage ePackage = this.getReferredEPackage(genPackage);
                if (ePackage == null) continue;
                genPackages.add(genPackage);
            }
            return genPackages;
        }

        public List<EPackage> filterReferencedEPackages(Collection<EPackage> ePackages, List<GenPackage> referencedGenPackages) {
            if (referencedGenPackages == null) {
                referencedGenPackages = ModelConverter.this.getReferencedGenPackages();
            }
            if (ePackages.isEmpty()) {
                return Collections.emptyList();
            }
            if (referencedGenPackages.isEmpty()) {
                return new ArrayList<EPackage>(ePackages);
            }
            ConverterUtil.EPackageList filteredEPackages = new ConverterUtil.EPackageList(ePackages);
            for (GenPackage genPackage : referencedGenPackages) {
                EPackage ePackage = this.getReferredEPackage(genPackage);
                if (ePackage == null) continue;
                filteredEPackages.remove(ePackage);
            }
            return filteredEPackages;
        }

        protected EPackage getReferredEPackage(GenPackage genPackage) {
            return this.isValidReference(genPackage) ? ModelConverter.this.getReferredEPackage(genPackage) : null;
        }

        protected boolean isValidReference(GenPackage genPackage) {
            return ModelConverter.this.getReferenceGenPackageConvertInfo(genPackage).isValidReference();
        }
    }
}

