/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.presentation;

import java.util.Collections;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDPackage;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.presentation.XSDEditorPlugin;

public class XSDModelWizard
extends Wizard
implements INewWizard {
    protected XSDPackage xsdPackage = XSDPackage.eINSTANCE;
    protected XSDFactory xsdFactory = this.xsdPackage.getXSDFactory();
    protected XSDModelWizardNewFileCreationPage newFileCreationPage;
    protected XSDModelWizardInitialObjectCreationPage initialObjectCreationPage;
    protected IStructuredSelection selection;
    protected IWorkbench workbench;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setDefaultPageImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(XSDEditorPlugin.INSTANCE.getImage("full/wizban/NewXSD")));
    }

    protected EObject createInitialModel() {
        return this.initialObjectCreationPage.createInitialModel();
    }

    public boolean performFinish() {
        try {
            final IFile modelFile = this.getModelFile();
            WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor progressMonitor) {
                    try {
                        try {
                            ResourceSetImpl resourceSet = new ResourceSetImpl();
                            URI fileURI = URI.createPlatformResourceURI((String)modelFile.getFullPath().toString(), (boolean)true);
                            Resource resource = resourceSet.createResource(fileURI);
                            EObject rootObject = XSDModelWizard.this.createInitialModel();
                            if (rootObject != null) {
                                resource.getContents().add((Object)rootObject);
                            }
                            resource.save(Collections.EMPTY_MAP);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    finally {
                        progressMonitor.done();
                    }
                }
            };
            this.getContainer().run(false, false, (IRunnableWithProgress)operation);
            IWorkbenchWindow workbenchWindow = this.workbench.getActiveWorkbenchWindow();
            IWorkbenchPage page = workbenchWindow.getActivePage();
            final IWorkbenchPart activePart = page.getActivePart();
            if (activePart instanceof ISetSelectionTarget) {
                StructuredSelection targetSelection = new StructuredSelection((Object)modelFile);
                this.getShell().getDisplay().asyncExec(new Runnable((ISelection)targetSelection){
                    private final /* synthetic */ ISelection val$targetSelection;
                    {
                        this.val$targetSelection = iSelection;
                    }

                    public void run() {
                        ((ISetSelectionTarget)activePart).selectReveal(this.val$targetSelection);
                    }
                });
            }
            try {
                page.openEditor((IEditorInput)new FileEditorInput(modelFile), this.workbench.getEditorRegistry().getDefaultEditor(modelFile.getFullPath().toString()).getId());
            }
            catch (PartInitException exception) {
                MessageDialog.openError((Shell)workbenchWindow.getShell(), (String)XSDEditorPlugin.INSTANCE.getString("_UI_OpenEditorError_label"), (String)exception.getMessage());
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public void addPages() {
        Object selectedElement;
        this.newFileCreationPage = new XSDModelWizardNewFileCreationPage("Whatever", this.selection);
        this.newFileCreationPage.setTitle(XSDEditorPlugin.INSTANCE.getString("_UI_XSDModelWizard_label"));
        this.newFileCreationPage.setDescription(XSDEditorPlugin.INSTANCE.getString("_UI_XSDModelWizard_description"));
        this.newFileCreationPage.setFileName(String.valueOf(XSDEditorPlugin.INSTANCE.getString("_UI_XSDEditorFilenameDefaultBase")) + "." + XSDEditorPlugin.INSTANCE.getString("_UI_XSDEditorFilenameExtension"));
        this.addPage((IWizardPage)this.newFileCreationPage);
        if (this.selection != null && !this.selection.isEmpty() && (selectedElement = this.selection.iterator().next()) instanceof IResource) {
            IResource selectedResource = (IResource)selectedElement;
            if (selectedResource.getType() == 1) {
                selectedResource = selectedResource.getParent();
            }
            if (selectedResource instanceof IFolder || selectedResource instanceof IProject) {
                this.newFileCreationPage.setContainerFullPath(selectedResource.getFullPath());
                String defaultModelBaseFilename = XSDEditorPlugin.INSTANCE.getString("_UI_XSDEditorFilenameDefaultBase");
                String defaultModelFilenameExtension = XSDEditorPlugin.INSTANCE.getString("_UI_XSDEditorFilenameExtension");
                String modelFilename = String.valueOf(defaultModelBaseFilename) + "." + defaultModelFilenameExtension;
                int i = 1;
                while (((IContainer)selectedResource).findMember(modelFilename) != null) {
                    modelFilename = String.valueOf(defaultModelBaseFilename) + i + "." + defaultModelFilenameExtension;
                    ++i;
                }
                this.newFileCreationPage.setFileName(modelFilename);
            }
        }
        this.initialObjectCreationPage = new XSDModelWizardInitialObjectCreationPage("Whatever2");
        this.initialObjectCreationPage.setTitle(XSDEditorPlugin.INSTANCE.getString("_UI_XSDModelWizard_label"));
        this.initialObjectCreationPage.setDescription(XSDEditorPlugin.INSTANCE.getString("_UI_Wizard_initial_object_description"));
        this.addPage((IWizardPage)this.initialObjectCreationPage);
    }

    public IFile getModelFile() {
        return this.newFileCreationPage.getModelFile();
    }

    public class XSDModelWizardNewFileCreationPage
    extends WizardNewFileCreationPage {
        protected IFile modelFile;

        public XSDModelWizardNewFileCreationPage(String pageId, IStructuredSelection selection) {
            super(pageId, selection);
        }

        protected boolean validatePage() {
            if (super.validatePage()) {
                String requiredExt = XSDEditorPlugin.INSTANCE.getString("_UI_XSDEditorFilenameExtension");
                String enteredExt = new Path(this.getFileName()).getFileExtension();
                if (enteredExt == null || !enteredExt.equals(requiredExt)) {
                    this.setErrorMessage(XSDEditorPlugin.INSTANCE.getString("_WARN_FilenameExtension", new Object[]{requiredExt}));
                    return false;
                }
                return true;
            }
            return false;
        }

        public boolean performFinish() {
            this.modelFile = this.getModelFile();
            return true;
        }

        public IFile getModelFile() {
            return this.modelFile == null ? ResourcesPlugin.getWorkspace().getRoot().getFile(this.getContainerFullPath().append(this.getFileName())) : this.modelFile;
        }
    }

    public class XSDModelWizardInitialObjectCreationPage
    extends WizardPage {
        protected Text schemaForSchemaPrefixText;
        protected Text schemaForSchemaNamespaceText;
        protected Text schemaPrefixText;
        protected Text schemaNamespaceText;
        protected boolean isCustomSchemaNamespace;

        public XSDModelWizardInitialObjectCreationPage(String pageId) {
            super(pageId);
            this.isCustomSchemaNamespace = false;
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            layout.verticalSpacing = 12;
            composite.setLayout((Layout)layout);
            GridData data = new GridData();
            data.verticalAlignment = 4;
            data.grabExcessVerticalSpace = true;
            data.horizontalAlignment = 4;
            composite.setLayoutData((Object)data);
            Label schemaPrefixLabel = new Label(composite, 16384);
            schemaPrefixLabel.setText(XSDEditorPlugin.INSTANCE.getString("_UI_SchemaPrefix_label"));
            data = new GridData();
            data.horizontalAlignment = 4;
            schemaPrefixLabel.setLayoutData((Object)data);
            this.schemaPrefixText = new Text(composite, 2052);
            data = new GridData();
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            this.schemaPrefixText.setLayoutData((Object)data);
            this.schemaPrefixText.setText("this");
            Label schemaNamespaceLabel = new Label(composite, 16384);
            schemaNamespaceLabel.setText(XSDEditorPlugin.INSTANCE.getString("_UI_SchemaNamespaceURI_label"));
            GridData data2 = new GridData();
            data2.horizontalAlignment = 4;
            schemaNamespaceLabel.setLayoutData((Object)data2);
            this.schemaNamespaceText = new Text(composite, 2052);
            data2 = new GridData();
            data2.horizontalAlignment = 4;
            data2.grabExcessHorizontalSpace = true;
            this.schemaNamespaceText.setLayoutData((Object)data2);
            this.schemaNamespaceText.addKeyListener(new KeyListener(){

                public void keyReleased(KeyEvent e) {
                    XSDModelWizardInitialObjectCreationPage.this.isCustomSchemaNamespace = true;
                }

                public void keyPressed(KeyEvent e) {
                }
            });
            Label schemaForSchemaPrefixLabel = new Label(composite, 16384);
            schemaForSchemaPrefixLabel.setText(XSDEditorPlugin.INSTANCE.getString("_UI_SchemaForSchemaPrefix_label"));
            GridData data3 = new GridData();
            data3.horizontalAlignment = 4;
            schemaForSchemaPrefixLabel.setLayoutData((Object)data3);
            this.schemaForSchemaPrefixText = new Text(composite, 2052);
            data3 = new GridData();
            data3.horizontalAlignment = 4;
            data3.grabExcessHorizontalSpace = true;
            this.schemaForSchemaPrefixText.setLayoutData((Object)data3);
            this.schemaForSchemaPrefixText.setText("xsd");
            Label schemaForSchemaNamespaceLabel = new Label(composite, 16384);
            schemaForSchemaNamespaceLabel.setText(XSDEditorPlugin.INSTANCE.getString("_UI_SchemaForSchemaNamespaceURI_label"));
            GridData data4 = new GridData();
            data4.horizontalAlignment = 4;
            schemaForSchemaNamespaceLabel.setLayoutData((Object)data4);
            this.schemaForSchemaNamespaceText = new Text(composite, 2052);
            data4 = new GridData();
            data4.horizontalAlignment = 4;
            data4.grabExcessHorizontalSpace = true;
            this.schemaForSchemaNamespaceText.setLayoutData((Object)data4);
            this.schemaForSchemaNamespaceText.setText("http://www.w3.org/2001/XMLSchema");
            this.setControl((Control)composite);
        }

        public boolean performFinish() {
            return true;
        }

        public EObject createInitialModel() {
            XSDSchema xsdSchema = XSDFactory.eINSTANCE.createXSDSchema();
            Map map = xsdSchema.getQNamePrefixToNamespaceMap();
            map.put(this.schemaForSchemaPrefixText.getText(), this.schemaForSchemaNamespaceText.getText());
            xsdSchema.setSchemaForSchemaQNamePrefix(this.schemaForSchemaPrefixText.getText());
            if (this.schemaNamespaceText.getText() != null && this.schemaNamespaceText.getText().trim().length() != 0) {
                xsdSchema.setTargetNamespace(this.schemaNamespaceText.getText());
                map.put(this.schemaPrefixText.getText(), this.schemaNamespaceText.getText());
            }
            return xsdSchema;
        }

        public void setVisible(boolean visible) {
            if (visible && !this.isCustomSchemaNamespace) {
                this.schemaNamespaceText.setText("http://" + XSDModelWizard.this.getModelFile().getFullPath());
            }
            super.setVisible(visible);
        }
    }
}

