/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.db.internal;

import java.text.Collator;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObjectListener;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.jpt.db.internal.DTPTools;
import org.eclipse.jpt.db.internal.DTPWrapper;
import org.eclipse.jpt.db.internal.Table;
import org.eclipse.jpt.utility.internal.JavaType;
import org.eclipse.jpt.utility.internal.NameTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Column
extends DTPWrapper
implements Comparable<Column> {
    private final Table table;
    private final org.eclipse.datatools.modelbase.sql.tables.Column dtpColumn;
    private ICatalogObjectListener columnListener;
    private static final JavaType DEFAULT_JAVA_TYPE = new JavaType(Object.class);

    Column(Table table, org.eclipse.datatools.modelbase.sql.tables.Column dtpColumn) {
        this.table = table;
        this.dtpColumn = dtpColumn;
        this.initialize();
    }

    private void initialize() {
        if (this.connectionIsOnline()) {
            this.columnListener = this.buildColumnListener();
            this.addCatalogObjectListener((ICatalogObject)this.dtpColumn, this.columnListener);
        }
    }

    @Override
    protected boolean connectionIsOnline() {
        return this.table.connectionIsOnline();
    }

    private ICatalogObjectListener buildColumnListener() {
        return new ICatalogObjectListener(){

            public void notifyChanged(ICatalogObject column, int eventType) {
            }
        };
    }

    @Override
    protected void dispose() {
        this.removeCatalogObjectListener((ICatalogObject)this.dtpColumn, this.columnListener);
    }

    @Override
    public String getName() {
        return this.dtpColumn.getName();
    }

    boolean isCaseSensitive() {
        return this.table.isCaseSensitive();
    }

    public String dataTypeName() {
        DataType dataType = this.dtpColumn.getDataType();
        return dataType == null ? null : dataType.getName();
    }

    public String javaFieldName() {
        String jName = this.getName();
        if (!this.isCaseSensitive()) {
            jName = jName.toLowerCase();
        }
        return NameTools.convertToJavaIdentifier((String)jName);
    }

    public boolean matchesJavaFieldName(String javaFieldName) {
        return this.isCaseSensitive() ? this.getName().equals(javaFieldName) : this.getName().equalsIgnoreCase(javaFieldName);
    }

    public String javaTypeDeclaration() {
        return this.javaType().declaration();
    }

    public JavaType javaType() {
        DataType dataType = this.dtpColumn.getDataType();
        return dataType instanceof PredefinedDataType ? DTPTools.javaTypeFor(((PredefinedDataType)dataType).getPrimitiveType()) : DEFAULT_JAVA_TYPE;
    }

    boolean wraps(org.eclipse.datatools.modelbase.sql.tables.Column column) {
        return this.dtpColumn == column;
    }

    @Override
    public int compareTo(Column column) {
        return Collator.getInstance().compare(this.getName(), column.getName());
    }
}

