/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.core.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jst.server.core.IJavaRuntime;
import org.eclipse.jst.server.core.internal.RuntimeComponentProviderDelegate;
import org.eclipse.jst.server.core.internal.Trace;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentVersion;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.internal.Runtime;

public class JRERuntimeComponentProvider
extends RuntimeComponentProviderDelegate {
    public static final String CLASSPATH = "classpath";
    protected int timestamp = -1;
    protected IVMInstall vmInstall;
    protected String jvmver;
    static /* synthetic */ Class class$0;

    public List getRuntimeComponents(IRuntime runtime) {
        IJavaRuntime javaRuntime;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.server.core.IJavaRuntime");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((javaRuntime = (IJavaRuntime)runtime.loadAdapter((Class)clazz, null)) != null) {
            IVMInstall2 vmInstall2;
            if (this.timestamp != ((Runtime)runtime).getTimestamp()) {
                this.vmInstall = null;
                this.jvmver = null;
                this.timestamp = ((Runtime)runtime).getTimestamp();
            }
            if (this.vmInstall == null) {
                this.vmInstall = javaRuntime.getVMInstall();
            }
            if (this.jvmver == null && (vmInstall2 = (IVMInstall2)this.vmInstall) != null) {
                this.jvmver = vmInstall2.getJavaVersion();
            }
            String vmInstallName = this.vmInstall != null ? this.vmInstall.getName() : "Unknown";
            IRuntimeComponentVersion rcv = null;
            if (this.vmInstall == null) {
                rcv = RuntimeManager.getRuntimeComponentType((String)"standard.jre").getVersion("6.0");
            } else if (this.jvmver == null) {
                Trace.trace((byte)1, "Could not determine VM version for: " + vmInstallName);
                rcv = RuntimeManager.getRuntimeComponentType((String)"standard.jre").getVersion("6.0");
            } else if (this.jvmver.startsWith("1.3")) {
                rcv = RuntimeManager.getRuntimeComponentType((String)"standard.jre").getVersion("1.3");
            } else if (this.jvmver.startsWith("1.4")) {
                rcv = RuntimeManager.getRuntimeComponentType((String)"standard.jre").getVersion("1.4");
            } else if (this.jvmver.startsWith("1.5") || this.jvmver.startsWith("5.0")) {
                rcv = RuntimeManager.getRuntimeComponentType((String)"standard.jre").getVersion("5.0");
            } else if (this.jvmver.startsWith("1.6") || this.jvmver.startsWith("6.0")) {
                rcv = RuntimeManager.getRuntimeComponentType((String)"standard.jre").getVersion("6.0");
            } else {
                Trace.trace((byte)1, "Invalid Java version: " + vmInstallName + ", " + this.jvmver);
                rcv = RuntimeManager.getRuntimeComponentType((String)"standard.jre").getVersion("6.0");
            }
            if (rcv != null) {
                HashMap<String, String> properties = new HashMap<String, String>(3);
                String name = "-";
                if (vmInstallName != null) {
                    name = vmInstallName;
                }
                properties.put("name", name);
                StringBuffer buf = new StringBuffer();
                buf.append("JRE ");
                buf.append(rcv.getVersionString());
                buf.append(": ");
                buf.append(name);
                properties.put("type", buf.toString());
                if (this.vmInstall != null) {
                    if (this.vmInstall == null || javaRuntime.isUsingDefaultJRE()) {
                        properties.put(CLASSPATH, new Path(JavaRuntime.JRE_CONTAINER).toPortableString());
                    } else {
                        properties.put(CLASSPATH, JavaRuntime.newJREContainerPath((IVMInstall)this.vmInstall).toPortableString());
                    }
                }
                ArrayList<IRuntimeComponent> list = new ArrayList<IRuntimeComponent>();
                list.add(RuntimeManager.createRuntimeComponent((IRuntimeComponentVersion)rcv, properties));
                return list;
            }
        }
        return null;
    }
}

