/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.content.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.AccessType;
import org.eclipse.jpt.core.internal.IJpaContentNode;
import org.eclipse.jpt.core.internal.IPersistentAttribute;
import org.eclipse.jpt.core.internal.IPersistentType;
import org.eclipse.jpt.core.internal.ITextRange;
import org.eclipse.jpt.core.internal.content.java.IJavaTypeMapping;
import org.eclipse.jpt.core.internal.content.java.IJavaTypeMappingProvider;
import org.eclipse.jpt.core.internal.content.java.JavaEObject;
import org.eclipse.jpt.core.internal.content.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.internal.content.java.JpaJavaFactory;
import org.eclipse.jpt.core.internal.content.java.JpaJavaPackage;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaAssociationOverride;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaAttributeOverride;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaBasic;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaColumn;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaEmbeddableProvider;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaEmbedded;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaEmbeddedId;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaEntityProvider;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaGeneratedValue;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaId;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaJoinColumn;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaJoinTable;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaManyToMany;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaManyToOne;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaMappedSuperclassProvider;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaMultiRelationshipMapping;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaNullTypeMappingProvider;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaOneToMany;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaOneToOne;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaOrderBy;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaPrimaryKeyJoinColumn;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaSequenceGenerator;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaTableGenerator;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaTransient;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaVersion;
import org.eclipse.jpt.core.internal.jdtutility.Attribute;
import org.eclipse.jpt.core.internal.jdtutility.AttributeAnnotationTools;
import org.eclipse.jpt.core.internal.jdtutility.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.FieldAttribute;
import org.eclipse.jpt.core.internal.jdtutility.JDTTools;
import org.eclipse.jpt.core.internal.jdtutility.MethodAttribute;
import org.eclipse.jpt.core.internal.jdtutility.Type;
import org.eclipse.jpt.core.internal.platform.DefaultsContext;
import org.eclipse.jpt.utility.internal.Filter;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.utility.internal.iterators.ChainIterator;
import org.eclipse.jpt.utility.internal.iterators.CloneIterator;
import org.eclipse.jpt.utility.internal.iterators.CompositeIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaPersistentType
extends JavaEObject
implements IPersistentType {
    protected static final String MAPPING_KEY_EDEFAULT = null;
    protected String mappingKey = MAPPING_KEY_EDEFAULT;
    protected IJavaTypeMapping mapping;
    protected EList<JavaPersistentAttribute> attributes;
    protected static final AccessType ACCESS_EDEFAULT = AccessType.DEFAULT;
    protected AccessType access = ACCESS_EDEFAULT;
    private Type type;
    private IJavaTypeMappingProvider[] typeMappingProviders = this.buildTypeMappingProviders();
    private DeclarationAnnotationAdapter[] attributeMappingAnnotationAdapters = this.buildAttributeMappingAnnotationAdapters();
    private IPersistentType parentPersistentType;

    protected JavaPersistentType() {
    }

    private IJavaTypeMappingProvider[] buildTypeMappingProviders() {
        ArrayList<IJavaTypeMappingProvider> providers = new ArrayList<IJavaTypeMappingProvider>();
        this.addTypeMappingProvidersTo(providers);
        return providers.toArray(new IJavaTypeMappingProvider[providers.size()]);
    }

    protected void addTypeMappingProvidersTo(Collection<IJavaTypeMappingProvider> providers) {
        providers.add(JavaNullTypeMappingProvider.instance());
        providers.add(JavaEntityProvider.instance());
        providers.add(JavaMappedSuperclassProvider.instance());
        providers.add(JavaEmbeddableProvider.instance());
    }

    private DeclarationAnnotationAdapter[] buildAttributeMappingAnnotationAdapters() {
        ArrayList<DeclarationAnnotationAdapter> adapters = new ArrayList<DeclarationAnnotationAdapter>();
        this.addAttributeMappingAnnotationAdaptersTo(adapters);
        return adapters.toArray(new DeclarationAnnotationAdapter[adapters.size()]);
    }

    protected void addAttributeMappingAnnotationAdaptersTo(Collection<DeclarationAnnotationAdapter> adapters) {
        adapters.add(JavaAssociationOverride.SINGLE_DECLARATION_ANNOTATION_ADAPTER);
        adapters.add(JavaAssociationOverride.MULTIPLE_DECLARATION_ANNOTATION_ADAPTER);
        adapters.add(JavaAttributeOverride.SINGLE_DECLARATION_ANNOTATION_ADAPTER);
        adapters.add(JavaAttributeOverride.MULTIPLE_DECLARATION_ANNOTATION_ADAPTER);
        adapters.add(JavaBasic.DECLARATION_ANNOTATION_ADAPTER);
        adapters.add(JavaColumn.MAPPING_DECLARATION_ANNOTATION_ADAPTER);
        adapters.add(JavaEmbedded.DECLARATION_ANNOTATION_ADAPTER);
        adapters.add(JavaEmbeddedId.DECLARATION_ANNOTATION_ADAPTER);
        adapters.add(JavaBasic.ENUMERATED_ADAPTER);
        adapters.add(JavaGeneratedValue.DECLARATION_ANNOTATION_ADAPTER);
        adapters.add(JavaId.DECLARATION_ANNOTATION_ADAPTER);
        adapters.add(JavaJoinColumn.SINGLE_DECLARATION_ANNOTATION_ADAPTER);
        adapters.add(JavaJoinColumn.MULTIPLE_DECLARATION_ANNOTATION_ADAPTER);
        adapters.add(JavaJoinTable.DECLARATION_ANNOTATION_ADAPTER);
        adapters.add(JavaBasic.LOB_ADAPTER);
        adapters.add(JavaManyToMany.DECLARATION_ANNOTATION_ADAPTER);
        adapters.add(JavaManyToOne.DECLARATION_ANNOTATION_ADAPTER);
        adapters.add(JavaMultiRelationshipMapping.MAP_KEY_ADAPTER);
        adapters.add(JavaOneToMany.DECLARATION_ANNOTATION_ADAPTER);
        adapters.add(JavaOneToOne.DECLARATION_ANNOTATION_ADAPTER);
        adapters.add(JavaOrderBy.DECLARATION_ANNOTATION_ADAPTER);
        adapters.add(JavaPrimaryKeyJoinColumn.MULTIPLE_DECLARATION_ANNOTATION_ADAPTER);
        adapters.add(JavaPrimaryKeyJoinColumn.SINGLE_DECLARATION_ANNOTATION_ADAPTER);
        adapters.add(JavaSequenceGenerator.DECLARATION_ANNOTATION_ADAPTER);
        adapters.add(JavaTableGenerator.DECLARATION_ANNOTATION_ADAPTER);
        adapters.add(JavaBasic.TEMPORAL_ADAPTER);
        adapters.add(JavaTransient.DECLARATION_ANNOTATION_ADAPTER);
        adapters.add(JavaVersion.DECLARATION_ANNOTATION_ADAPTER);
    }

    @Override
    protected EClass eStaticClass() {
        return JpaJavaPackage.Literals.JAVA_PERSISTENT_TYPE;
    }

    @Override
    public String getMappingKey() {
        return this.mappingKey;
    }

    public void setMappingKeyGen(String newMappingKey) {
        String oldMappingKey = this.mappingKey;
        this.mappingKey = newMappingKey;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldMappingKey, (Object)this.mappingKey));
        }
    }

    @Override
    public void setMappingKey(String newMappingKey) {
        if (newMappingKey == this.mappingKey) {
            return;
        }
        this.setMapping(this.buildJavaTypeMapping(newMappingKey));
        this.setMappingKeyGen(newMappingKey);
    }

    @Override
    public IJavaTypeMapping getMapping() {
        return this.mapping;
    }

    public NotificationChain basicSetMapping(IJavaTypeMapping newMapping, NotificationChain msgs) {
        IJavaTypeMapping oldMapping = this.mapping;
        this.mapping = newMapping;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldMapping, (Object)newMapping);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public void setMappingGen(IJavaTypeMapping newMapping) {
        if (newMapping != this.mapping) {
            NotificationChain msgs = null;
            if (this.mapping != null) {
                msgs = ((InternalEObject)this.mapping).eInverseRemove((InternalEObject)this, -2, null, msgs);
            }
            if (newMapping != null) {
                msgs = ((InternalEObject)newMapping).eInverseAdd((InternalEObject)this, -2, null, msgs);
            }
            if ((msgs = this.basicSetMapping(newMapping, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)newMapping, (Object)newMapping));
        }
    }

    public void setMapping(IJavaTypeMapping newMapping) {
        this.type.removeAnnotation(this.annotationAdapterForTypeMappingKey(this.mapping.getKey()));
        this.type.newMarkerAnnotation(this.annotationAdapterForTypeMappingKey(newMapping.getKey()));
        this.setMappingGen(newMapping);
    }

    private DeclarationAnnotationAdapter annotationAdapterForTypeMappingKey(String typeMappingKey) {
        return this.typeMappingProviderFor(typeMappingKey).declarationAnnotationAdapter();
    }

    private IJavaTypeMappingProvider typeMappingProviderFor(String typeMappingKey) {
        IJavaTypeMappingProvider[] iJavaTypeMappingProviderArray = this.typeMappingProviders;
        int n = this.typeMappingProviders.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaTypeMappingProvider provider = iJavaTypeMappingProviderArray[n2];
            if (provider.key() == typeMappingKey) {
                return provider;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Unsupported type mapping key: " + typeMappingKey);
    }

    public EList<JavaPersistentAttribute> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new EObjectContainmentEList(JavaPersistentAttribute.class, (InternalEObject)this, 2);
        }
        return this.attributes;
    }

    public AccessType getAccess() {
        return this.access;
    }

    private void setAccess(AccessType newAccess) {
        AccessType oldAccess = this.access;
        AccessType accessType = this.access = newAccess == null ? ACCESS_EDEFAULT : newAccess;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldAccess, (Object)this.access));
        }
    }

    @Override
    public Object getId() {
        return "org.eclipse.jpt.core.java.persistentType";
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                return this.basicSetMapping(null, msgs);
            }
            case 2: {
                return ((InternalEList)this.getAttributes()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getMappingKey();
            }
            case 1: {
                return this.getMapping();
            }
            case 2: {
                return this.getAttributes();
            }
            case 3: {
                return this.getAccess();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setMappingKey((String)newValue);
                return;
            }
            case 1: {
                this.setMapping((IJavaTypeMapping)newValue);
                return;
            }
            case 2: {
                this.getAttributes().clear();
                this.getAttributes().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setMappingKey(MAPPING_KEY_EDEFAULT);
                return;
            }
            case 1: {
                this.setMapping(null);
                return;
            }
            case 2: {
                this.getAttributes().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return MAPPING_KEY_EDEFAULT == null ? this.mappingKey != null : !MAPPING_KEY_EDEFAULT.equals(this.mappingKey);
            }
            case 1: {
                return this.mapping != null;
            }
            case 2: {
                return this.attributes != null && !this.attributes.isEmpty();
            }
            case 3: {
                return this.access != ACCESS_EDEFAULT;
            }
        }
        return super.eIsSet(featureID);
    }

    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == IJpaContentNode.class) {
            return -1;
        }
        if (baseClass == IPersistentType.class) {
            switch (derivedFeatureID) {
                case 0: {
                    return 0;
                }
            }
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == IJpaContentNode.class) {
            return -1;
        }
        if (baseClass == IPersistentType.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 0;
                }
            }
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (mappingKey: ");
        result.append(this.mappingKey);
        result.append(", access: ");
        result.append((Object)this.access);
        result.append(')');
        return result.toString();
    }

    public void setJdtType(IType iType, CompilationUnit astRoot) {
        this.type = new Type(iType);
        this.setAccess(this.javaAccessType(astRoot));
        this.createAndSetPersistentTypeMappingFromJava(this.javaTypeMappingKey(astRoot));
    }

    public JavaPersistentAttribute addJavaPersistentAttribute(IMember jdtMember) {
        JavaPersistentAttribute persistentAttribute = this.createJavaPersistentAttribute(jdtMember);
        this.getAttributes().add((Object)persistentAttribute);
        return persistentAttribute;
    }

    public JavaPersistentAttribute createJavaPersistentAttribute(IMember member) {
        Attribute attribute = null;
        if (member instanceof IField) {
            attribute = new FieldAttribute((IField)member);
        } else if (member instanceof IMethod) {
            attribute = new MethodAttribute((IMethod)member);
        } else {
            throw new IllegalArgumentException();
        }
        return JpaJavaFactory.eINSTANCE.createJavaPersistentAttribute(attribute);
    }

    private void createAndSetPersistentTypeMappingFromJava(String key) {
        this.setMappingGen(this.buildJavaTypeMapping(key));
        this.setMappingKeyGen(key);
    }

    private IJavaTypeMapping buildJavaTypeMapping(String key) {
        return this.typeMappingProviderFor(key).buildMapping(this.type);
    }

    public Type getType() {
        return this.type;
    }

    public String fullyQualifiedTypeName() {
        return this.jdtType().getFullyQualifiedName();
    }

    public IType jdtType() {
        return this.getType().getJdtMember();
    }

    @Override
    public IType findJdtType() {
        return this.jdtType();
    }

    public boolean isFor(IType member) {
        return this.type.wraps((IMember)member);
    }

    protected void updateFromJava(CompilationUnit astRoot) {
        this.setAccess(this.javaAccessType(astRoot));
        String jpaKey = this.getMapping().getKey();
        String javaKey = this.javaTypeMappingKey(astRoot);
        if (jpaKey != javaKey) {
            this.createAndSetPersistentTypeMappingFromJava(javaKey);
        }
        this.getMapping().updateFromJava(astRoot);
        this.updatePersistentAttributes(astRoot);
    }

    private void updatePersistentAttributes(CompilationUnit astRoot) {
        ArrayList<JavaPersistentAttribute> persistentAttributesToRemove = new ArrayList<JavaPersistentAttribute>((Collection<JavaPersistentAttribute>)this.getAttributes());
        if (this.getAccess() == AccessType.FIELD) {
            this.updatePersistentFields(astRoot, persistentAttributesToRemove);
        } else if (this.getAccess() == AccessType.PROPERTY) {
            this.updatePersistentProperties(astRoot, persistentAttributesToRemove);
        }
        this.getAttributes().removeAll(persistentAttributesToRemove);
    }

    private void updatePersistentFields(CompilationUnit astRoot, List<JavaPersistentAttribute> persistentAttributesToRemove) {
        IField[] iFieldArray = this.jdtPersistableFields();
        int n = iFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            IField field = iFieldArray[n2];
            JavaPersistentAttribute persistentAttribute = this.persistentAttributeFor((IMember)field);
            if (persistentAttribute == null) {
                persistentAttribute = this.addJavaPersistentAttribute((IMember)field);
            } else {
                persistentAttributesToRemove.remove(persistentAttribute);
            }
            persistentAttribute.updateFromJava(astRoot);
            ++n2;
        }
    }

    private void updatePersistentProperties(CompilationUnit astRoot, List<JavaPersistentAttribute> persistentAttributesToRemove) {
        IMethod[] iMethodArray = this.jdtPersistableProperties();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            JavaPersistentAttribute persistentAttribute = this.persistentAttributeFor((IMember)method);
            if (persistentAttribute == null) {
                this.addJavaPersistentAttribute((IMember)method);
            } else {
                persistentAttributesToRemove.remove(persistentAttribute);
                persistentAttribute.updateFromJava(astRoot);
            }
            ++n2;
        }
    }

    private IField[] jdtPersistableFields() {
        return AttributeAnnotationTools.persistableFields(this.jdtType());
    }

    private IMethod[] jdtPersistableProperties() {
        return AttributeAnnotationTools.persistablePropertyGetters(this.jdtType());
    }

    private String javaTypeMappingKey(CompilationUnit astRoot) {
        IJavaTypeMappingProvider[] iJavaTypeMappingProviderArray = this.typeMappingProviders;
        int n = this.typeMappingProviders.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaTypeMappingProvider provider = iJavaTypeMappingProviderArray[n2];
            if (this.type.containsAnnotation(provider.declarationAnnotationAdapter(), astRoot)) {
                return provider.key();
            }
            ++n2;
        }
        return null;
    }

    @Override
    public Iterator<String> candidateMappingKeys() {
        return new TransformationIterator<IJavaTypeMappingProvider, String>((Iterator)new ArrayIterator((Object[])this.typeMappingProviders)){

            protected String transform(IJavaTypeMappingProvider p) {
                return p.key();
            }
        };
    }

    protected Iterator<JavaPersistentAttribute> attributesNamed(final String attributeName) {
        return new FilteringIterator<JavaPersistentAttribute>(this.attributes()){

            protected boolean accept(Object o) {
                return attributeName.equals(((JavaPersistentAttribute)o).getName());
            }
        };
    }

    @Override
    public JavaPersistentAttribute attributeNamed(String attributeName) {
        Iterator<JavaPersistentAttribute> stream = this.attributesNamed(attributeName);
        return stream.hasNext() ? stream.next() : null;
    }

    @Override
    public IPersistentAttribute resolveAttribute(String attributeName) {
        Iterator<JavaPersistentAttribute> stream = this.attributesNamed(attributeName);
        if (stream.hasNext()) {
            JavaPersistentAttribute attribute = stream.next();
            return stream.hasNext() ? null : attribute;
        }
        return this.parentPersistentType() == null ? null : this.parentPersistentType().resolveAttribute(attributeName);
    }

    @Override
    public Iterator<String> candidateValuesFor(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator<String> result = super.candidateValuesFor(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        Iterator<String> values = this.mapping.candidateValuesFor(pos, filter, astRoot);
        if (values != null) {
            return values;
        }
        Iterator<JavaPersistentAttribute> stream = this.attributes();
        while (stream.hasNext()) {
            values = stream.next().candidateValuesFor(pos, filter, astRoot);
            if (values == null) continue;
            return values;
        }
        return null;
    }

    public IJpaContentNode contentNodeAt(int offset) {
        Iterator<JavaPersistentAttribute> i = this.attributes();
        while (i.hasNext()) {
            JavaPersistentAttribute persistentAttribute = i.next();
            if (!persistentAttribute.includes(offset)) continue;
            return persistentAttribute;
        }
        return null;
    }

    public boolean includes(int offset) {
        return this.fullTextRange().includes(offset);
    }

    @Override
    public ITextRange fullTextRange() {
        return this.type.textRange();
    }

    @Override
    public ITextRange validationTextRange() {
        return this.selectionTextRange();
    }

    @Override
    public ITextRange selectionTextRange() {
        return this.type.nameTextRange();
    }

    public ITextRange getTextRange() {
        return this.type.textRange();
    }

    private JavaPersistentAttribute persistentAttributeFor(IMember member) {
        Iterator<JavaPersistentAttribute> i = this.attributes();
        while (i.hasNext()) {
            JavaPersistentAttribute attribute = i.next();
            if (!attribute.isFor(member)) continue;
            return attribute;
        }
        return null;
    }

    public Iterator<JavaPersistentAttribute> attributes() {
        return new CloneIterator(this.getAttributes());
    }

    @Override
    public Iterator<String> attributeNames() {
        return this.attributeNames(this.attributes());
    }

    private Iterator<String> attributeNames(Iterator<? extends IPersistentAttribute> attrs) {
        return new TransformationIterator<IPersistentAttribute, String>(attrs){

            protected String transform(IPersistentAttribute attribute) {
                return attribute.getName();
            }
        };
    }

    @Override
    public Iterator<IPersistentAttribute> allAttributes() {
        return new CompositeIterator((Iterator)new TransformationIterator<IPersistentType, Iterator<IPersistentAttribute>>(this.inheritanceHierarchy()){

            protected Iterator<IPersistentAttribute> transform(IPersistentType pt) {
                return pt.attributes();
            }
        });
    }

    @Override
    public Iterator<String> allAttributeNames() {
        return this.attributeNames(this.allAttributes());
    }

    @Override
    public Iterator<IPersistentType> inheritanceHierarchy() {
        return new ChainIterator<IPersistentType>((IPersistentType)this){

            protected IPersistentType nextLink(IPersistentType pt) {
                return pt.parentPersistentType();
            }
        };
    }

    @Override
    public IPersistentType parentPersistentType() {
        return this.parentPersistentType;
    }

    private String superclassTypeSignature() {
        try {
            return this.jdtType().getSuperclassTypeSignature();
        }
        catch (JavaModelException ex) {
            throw new RuntimeException(ex);
        }
    }

    private AccessType javaAccessType(CompilationUnit astRoot) {
        IType jdtType = this.jdtType();
        boolean hasPersistableFields = false;
        boolean hasPersistableProperties = false;
        IField[] iFieldArray = AttributeAnnotationTools.persistableFields(jdtType);
        int n = iFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            IField field = iFieldArray[n2];
            hasPersistableFields = true;
            FieldAttribute fa = new FieldAttribute(field);
            if (fa.containsAnyAnnotation(this.attributeMappingAnnotationAdapters, astRoot)) {
                return AccessType.FIELD;
            }
            ++n2;
        }
        iFieldArray = AttributeAnnotationTools.persistablePropertyGetters(jdtType);
        n = iFieldArray.length;
        n2 = 0;
        while (n2 < n) {
            IField method = iFieldArray[n2];
            hasPersistableProperties = true;
            MethodAttribute ma = new MethodAttribute((IMethod)method);
            if (ma.containsAnyAnnotation(this.attributeMappingAnnotationAdapters, astRoot)) {
                return AccessType.PROPERTY;
            }
            ++n2;
        }
        if (hasPersistableProperties && !hasPersistableFields) {
            return AccessType.PROPERTY;
        }
        return AccessType.FIELD;
    }

    public void refreshDefaults(DefaultsContext context) {
        this.refreshParentPersistentType(context);
    }

    private void refreshParentPersistentType(DefaultsContext context) {
        String superclassTypeSignature = this.superclassTypeSignature();
        if (superclassTypeSignature == null) {
            this.parentPersistentType = null;
            return;
        }
        String fullyQualifiedTypeName = JDTTools.resolveSignature(superclassTypeSignature, this.jdtType());
        if (fullyQualifiedTypeName == null) {
            this.parentPersistentType = null;
            return;
        }
        IPersistentType possibleParent = context.persistentType(fullyQualifiedTypeName);
        if (possibleParent == null) {
            this.parentPersistentType = null;
            return;
        }
        this.parentPersistentType = possibleParent.getMappingKey() != null ? possibleParent : possibleParent.parentPersistentType();
    }
}

